

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNodesForConfigurationPolicyAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetNodesForConfigurationPolicyAssociation')
BEGIN
	print '>>> Drop Stored Procedure: AppGetNodesForConfigurationPolicyAssociation <<<'
	drop procedure AppGetNodesForConfigurationPolicyAssociation
END
IF EXISTS (select * from GxQscripts where name='AppGetNodesForConfigurationPolicyAssociation')
	delete from GxQscripts where name = 'AppGetNodesForConfigurationPolicyAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNodesForConfigurationPolicyAssociation')
	delete from GXDBVersions where aliasname = 'AppGetNodesForConfigurationPolicyAssociation'
GO
print '... Creating Procedure: AppGetNodesForConfigurationPolicyAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNodesForConfigurationPolicyAssociation
  @i_xmlString XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
	-- Output xml string.
	DECLARE	@o_xmlString	XML
	-- Error handlers.
	DECLARE	@errorCode	INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = N''
	-- Reading from xml.
	DECLARE	@policyType		INT = 0
	DECLARE	@policyDetailType	INT = 0
	DECLARE @policyId INT = 0
	DECLARE @appGroupId	INT = 0
	DECLARE @entityType	INT = 0
	DECLARE @clientId	INT = 0
	DECLARE @appTypeId	INT = 0
	DECLARE @instanceId	INT = 0
	DECLARE @backupsetId	INT = 0
	DECLARE @attrName	NVARCHAR(1024) = N''
	DECLARE @initialClients TABLE (clientId INT, clientName NVARCHAR(2048))
	DECLARE @idaList TABLE (applicationId INT, appName NVARCHAR(2048))
	DECLARE @backupsetList TABLE (backupsetId INT, backupsetName NVARCHAR(2048))
	DECLARE @subclientList TABLE (subclientId INT, subclientName NVARCHAR(2048))
	SELECT 	@policyType = ISNULL(ref.value('@policyType', 'INT'), 0),
			@policyDetailType = ISNULL(ref.value('@policyDetailType', 'INT'), 0)
		FROM @i_xmlString.nodes('Ida_GetNodesForConfigurationPolicyAssociationReq') R (ref)
	SELECT  @policyId = ISNULL(ref.value('@policyId', 'INT'), 0)
		FROM @i_xmlString.nodes('Ida_GetNodesForConfigurationPolicyAssociationReq/policyEntity') R (ref)
	SELECT  @appGroupId = ISNULL(ref.value('@appGroupId', 'INT'), 0)
		FROM @i_xmlString.nodes('Ida_GetNodesForConfigurationPolicyAssociationReq/appGroupEntity') R (ref)
	SELECT 	@entityType = ISNULL(ref.value('@_type_', 'INT'), 0),
			@clientId = ISNULL(ref.value('@clientId', 'INT'), 0),
			@appTypeId = ISNULL(ref.value('@applicationId', 'INT'), 0),
			@instanceId = ISNULL(ref.value('@instanceId', 'INT'), 0),
			@backupsetId = ISNULL(ref.value('@backupsetId', 'INT'), 0)
		FROM @i_xmlString.nodes('Ida_GetNodesForConfigurationPolicyAssociationReq/expansionEntity') R (ref)
	IF @policyType = 0 or @policyDetailType = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please provide policy type and policy detail type.'
		GOTO ERROR_EXIT
	END
	IF @appGroupId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please provide ida type.'
		GOTO ERROR_EXIT
	END
	IF @clientId <> 0 or @appTypeId <> 0 or @instanceId <> 0 or @backupsetId <> 0
	BEGIN
		IF @entityType = 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Please provide entity type for the expansion entity.'
			GOTO ERROR_EXIT
		END
	END
	IF @policyType = 2 and @appGroupId = 35-- File policy and APPGRP_FileSystemIDA
	BEGIN
		IF @policyDetailType = 5 -- Content indexing policy
		BEGIN
			SET @attrName = 'Content Indexing Policy ID'
		END
		ELSE IF @policyDetailType = 3 -- Retention policy
		BEGIN
			SET @attrName = 'Fs Retention Policy ID'
		END
	END
	IF @appGroupId = 35 and @entityType = 0
	-- APPGRP_FileSystemIDA and no expansion criteria
	BEGIN
		SET @entityType = 3 -- ClientEntity
		INSERT INTO @initialClients
		SELECT CLIENT.Id, CLIENT.name
		FROM APP_Client CLIENT
		INNER JOIN APP_IDAName IDA
		ON CLIENT.id = IDA.clientId
		AND (CLIENT.status & 0x10000000) = 0 -- Exclude edge drive clients.
		AND IDA.appTypeId NOT IN (64, 13) -- Exclude distributed IDA and NAS IDA.
		INNER JOIN APP_AppTypeGroupAssoc AppGrp
		ON IDA.appTypeId = AppGrp.appTypeId
		WHERE AppGrp.appGroupId = @appGroupId
		AND dbo.IsDistributedPseudoClient(CLIENT.id) = 0
		GROUP BY CLIENT.Id, CLIENT.name
		DELETE @initialClients
			FROM @initialClients Client
			INNER JOIN APP_ClientProp ClientProp
			ON Client.clientId = ClientProp.componentNameId
			WHERE ClientProp.attrName like 'PlatformDeleted 4'
			AND ClientProp.attrVal = '1'
			AND ClientProp.modified = 0
		DECLARE @version10	NVARCHAR(1024) = '10'
		DELETE @initialClients
			FROM @initialClients Client
			WHERE @version10 = (SELECT SUBSTRING(attrVal, 1, 3)
				FROM APP_ClientProp
				WHERE componentNameId = Client.clientId
				AND attrName = 'SP Version Info'
				AND modified = 0)
		-- Output xml.
		SET @o_xmlString =
			(SELECT Client.clientId as '@clientId',
				Client.clientName as '@clientName',
				@entityType as '@_type_'
				FROM @initialClients Client
				INNER JOIN APP_ClientProp ClientProp
				ON Client.clientId = ClientProp.componentNameId
				WHERE ClientProp.attrName like 'IndexingV2'
				AND ClientProp.attrVal = '1'
				AND ClientProp.modified = 0
				FOR XML PATH('associationNodes'),
				ROOT('Ida_GetNodesForConfigurationPolicyAssociationResp'))
	END
	ELSE IF @appGroupId = 35 and @entityType <> 0
	-- APPGRP_FileSystemIDA with expansion criteria
	BEGIN
		IF @entityType = 3 -- ClientEntity
		BEGIN
			IF @clientId = 0
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Please provide client id.'
				GOTO ERROR_EXIT
			END
			DECLARE @idaCount INT
			SELECT @idaCount = COUNT(*)
			FROM APP_IDAName
			WHERE clientId = @clientId
			AND status & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
AND appTypeId IN ((33), 29)
			DECLARE @windowsIdaName NVARCHAR(2048) = 'Windows File System'
			DECLARE @unixIdaName NVARCHAR(2048) = 'Unix File System'
			DECLARE @fileSystemIdaName NVARCHAR(2048) = 'File System'
			INSERT INTO @idaList
			SELECT IDA.appTypeId, @fileSystemIdaName
			FROM APP_IDAName IDA
			INNER JOIN APP_AppTypeGroupAssoc AppGrp
			ON IDA.appTypeId = AppGrp.appTypeId
			AND AppGrp.appGroupId = @appGroupId
			AND IDA.clientId = @clientId
			AND IDA.status & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
			AND IDA.appTypeId <> 13 -- Exclude NAS IDA.
			IF @idaCount = 2
			BEGIN
				UPDATE @idaList
				SET appName = @windowsIdaName
WHERE applicationId = (33)
				UPDATE @idaList
				SET appName = @unixIdaName
				WHERE applicationId = 29
			END
			SET @entityType = 4
			-- Output xml.
			SET @o_xmlString =
				(SELECT applicationId as '@applicationId',
					appName as '@appName',
					@entityType as '@_type_'
					FROM @idaList
					FOR XML PATH('associationNodes'),
					ROOT('Ida_GetNodesForConfigurationPolicyAssociationResp'))
		END
		ELSE IF @entityType = 4 -- AppTypeEntity
		BEGIN
			IF @clientId = 0 or @appTypeId = 0
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Please provide client id and application id.'
				GOTO ERROR_EXIT
			END
			INSERT INTO @backupsetList
			SELECT APP.backupSet, BackupSet.name
			FROM APP_Application APP
			INNER JOIN APP_BackupSetName BackupSet
			ON APP.backupSet = BackupSet.id
			WHERE APP.clientId = @clientId
			AND APP.appTypeId = @appTypeId
			AND BackupSet.status IN (0, 8)
			GROUP BY APP.backupSet, BackupSet.name
			SET @entityType = 6
			-- Output xml.
			SET @o_xmlString =
				(SELECT backupsetId as '@backupsetId',
					backupsetName as '@backupsetName',
					@entityType as '@_type_'
					FROM @backupsetList
					ORDER BY backupsetName asc
					FOR XML PATH('associationNodes'),
					ROOT('Ida_GetNodesForConfigurationPolicyAssociationResp'))
		END
		ELSE IF @entityType = 5 -- InstanceEntity
		BEGIN
			SET @entityType = 6 -- included as dummy code TODO: include support for instance loading
		END
		ELSE IF @entityType = 6 -- BackupsetEntity
		BEGIN
			IF @clientId = 0 or @appTypeId = 0 or @backupsetId = 0
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Please provide client id, application id and backupset id.'
				GOTO ERROR_EXIT
			END
			DECLARE @subclientWithSubclientPolicy TABLE (subclientId INT, subclientName NVARCHAR(2048), subclientPolicyId INT)
			INSERT INTO @subclientList
			SELECT id, subclientName
			FROM APP_Application
			WHERE subclientStatus & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
			AND clientId = @clientId
			AND appTypeId = @appTypeId
			AND backupSet = @backupsetId
			DELETE @subclientList
			FROM @subclientList SC
			INNER JOIN APP_SubClientProp SCProp
			ON SC.subclientId = SCProp.componentNameId
			WHERE SCProp.attrName in (N'DDB Backup', N'Use block level backup', N'Enable Snap Backups', N'Reference Copy Flag', N'Turbo Mode Enable Stubbing')
			AND SCProp.attrVal = '1'
			AND SCProp.modified = 0
 			-- Handle if subclient policy is associated.
			INSERT INTO @subclientWithSubclientPolicy
			SELECT SC.subclientId, SC.subclientName, SCProp.attrVal
			FROM @subclientList SC
			INNER JOIN APP_SubClientProp SCProp
			ON SC.subclientId = SCProp.componentNameId
			WHERE SCProp.attrName = 'Associated subclient Policy'
			AND SCProp.attrVal > '0'
			AND SCProp.modified = 0
			DELETE @subclientList
			FROM @subclientList SC
			INNER JOIN @subclientWithSubclientPolicy SCP
			ON SC.subclientId = SCP.subclientId
			DELETE @subclientWithSubclientPolicy
			FROM @subclientWithSubclientPolicy SCP
			INNER JOIN APP_SubClientProp SCProp
			ON SCP.subclientPolicyId = SCProp.componentNameId
			WHERE SCProp.attrName in (N'DDB Backup', N'Use block level backup', N'Enable Snap Backups', N'Reference Copy Flag', N'Turbo Mode Enable Stubbing')
			AND SCProp.attrVal = '1'
			AND SCProp.modified = 0
			INSERT INTO @subclientList
			SELECT SCP.subclientId, SCP.subclientName
			FROM @subclientWithSubclientPolicy SCP
			DECLARE @subclientWithCIPolicy TABLE (subclientId INT, subclientName NVARCHAR(2048))
			IF @policyId <> 0
			BEGIN
				INSERT INTO @subclientWithCIPolicy
				SELECT APP.id, APP.subclientName
				FROM APP_Application APP
				INNER JOIN APP_SubclientProp SCProp
				ON APP.id = SCProp.componentNameId
				WHERE subclientStatus & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
				AND APP.clientId = @clientId
				AND APP.appTypeId = @appTypeId
				AND APP.backupSet = @backupsetId
				AND SCProp.attrName = @attrName
				AND SCProp.attrVal > '0'
				AND SCProp.modified = 0
				DELETE @subclientWithCIPolicy
				FROM @subclientWithCIPolicy SCCI
				INNER JOIN APP_SubClientProp SCProp
				ON SCCI.subclientId = SCProp.componentNameId
				WHERE SCProp.attrName = @attrName
				AND SCProp.attrVal = CAST(@policyId AS NVARCHAR(15))
				AND SCProp.modified = 0
				DELETE @subclientList
				FROM @subclientList SC
				INNER JOIN @subclientWithCIPolicy SCCI
				ON SC.subclientId = SCCI.subclientId
				WHERE SC.subclientId = SCCI.subclientId
			END
			ELSE IF @policyId = 0
			BEGIN
				INSERT INTO @subclientWithCIPolicy
				SELECT APP.id, APP.subclientName
				FROM APP_Application APP
				INNER JOIN APP_SubclientProp SCProp
				ON APP.id = SCProp.componentNameId
				WHERE subclientStatus & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
				AND APP.clientId = @clientId
				AND APP.appTypeId = @appTypeId
				AND APP.backupSet = @backupsetId
				AND SCProp.attrName = @attrName
				AND SCProp.attrVal > '0'
				AND SCProp.modified = 0
				DELETE @subclientList
				FROM @subclientList SC
				INNER JOIN @subclientWithCIPolicy SCCI
				ON SC.subclientId = SCCI.subclientId
				WHERE SC.subclientId = SCCI.subclientId
			END
			SET @entityType = 7
			-- Output xml.
			SET @o_xmlString =
				(SELECT subclientId as '@subclientId',
					subclientName as '@subclientName',
					@entityType as '@_type_'
					FROM @subclientList
					ORDER BY subclientName asc
					FOR XML PATH('associationNodes'),
					ROOT('Ida_GetNodesForConfigurationPolicyAssociationResp'))
		END
	END
	ERROR_EXIT:
		IF @errorCode <> 0
			SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
								FOR XML PATH('Ida_GenericResp'), Type)
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<Ida_GetNodesForConfigurationPolicyAssociationResp/>'
		SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNodesForConfigurationPolicyAssociation')
	delete from GxQscripts where name = 'AppGetNodesForConfigurationPolicyAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNodesForConfigurationPolicyAssociation')
	delete from GXDBVersions where aliasname = 'AppGetNodesForConfigurationPolicyAssociation'
GO

insert into GXDBVersions values(2, 'AppGetNodesForConfigurationPolicyAssociation',  '00000000000000000000', 'AppGetNodesForConfigurationPolicyAssociation', '00000000000000000000')
GO

