

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNodesEligibleForConfigurationPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetNodesEligibleForConfigurationPolicy')
BEGIN
	print '>>> Drop Stored Procedure: AppGetNodesEligibleForConfigurationPolicy <<<'
	drop procedure AppGetNodesEligibleForConfigurationPolicy
END
IF EXISTS (select * from GxQscripts where name='AppGetNodesEligibleForConfigurationPolicy')
	delete from GxQscripts where name = 'AppGetNodesEligibleForConfigurationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNodesEligibleForConfigurationPolicy')
	delete from GXDBVersions where aliasname = 'AppGetNodesEligibleForConfigurationPolicy'
GO
print '... Creating Procedure: AppGetNodesEligibleForConfigurationPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNodesEligibleForConfigurationPolicy
  @i_xmlString XML
AS
SET NOCOUNT ON
BEGIN
	-- Output xml string.
	DECLARE	@o_xmlString	XML
	-- Error handlers.
	DECLARE	@errorCode	INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = N''
	-- Reading from xml.
	DECLARE	@policyType		INT = 0
	DECLARE	@policyDetailType	INT = 0
	-- Sim package id to check.
	DECLARE	@webServerSimPackageID	INT = 0
	DECLARE	@indexGatewaySimPackageID	INT = 0
	-- Table for clients which are not marked for deletion.
	DECLARE @ActiveClients TABLE(clientId INT, clientName NVARCHAR(2048))
	SELECT 	@policyType = ISNULL(ref.value('@policyType', 'INT'), 0),
			@policyDetailType = ISNULL(ref.value('@policyDetailType', 'INT'), 0)
		FROM @i_xmlString.nodes('Ida_GetNodesEligibleForConfigurationPolicyReq') R (ref)
	-- Check if the policy type and policy detail type are missing.
	IF @policyType = 0 or @policyDetailType = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please provide policy type and policy detail type.'
		GOTO ERROR_EXIT
	END
	-- Set the correct simpackage id to check.
	IF @policyType = 2 and @policyDetailType = 5 -- Content Indexing File Policy
	BEGIN
SET @webServerSimPackageID = 252 -- Check for web servers
SET @indexGatewaySimPackageID = 263 -- Check for index servers
	END
	-- Check if sim package id could be fetched from given information.
	IF @webServerSimPackageID = 0 or @webServerSimPackageID IS NULL or @indexGatewaySimPackageID = 0 or @indexGatewaySimPackageID IS NULL
	BEGIN
		SET @errorCode = 2
		SET @errorCode = 'Unknown policy and policy detail type.'
		GOTO ERROR_EXIT
	END
	IF @policyType <> 0 and @policyDetailType <> 0 and @webServerSimPackageID <> 0 and @indexGatewaySimPackageID <> 0
	BEGIN
		-- Get all the clients which are index servers.
		INSERT INTO @ActiveClients
		SELECT Client.id, Client.name
			FROM App_Client Client (NOLOCK)
			LEFT JOIN SimInstalledPackages Package (NOLOCK)
			ON Package.ClientId = Client.id
			WHERE Package.simPackageID = @webServerSimPackageID
			OR Package.simPackageID = @indexGatewaySimPackageID
			GROUP BY Client.id, Client.name
		-- Delete all the clients which are marked for deletion.
		DELETE @ActiveClients
		FROM @ActiveClients AC
		LEFT OUTER JOIN APP_ClientProp ClientProp
		ON AC.clientId = ClientProp.componentNameId
		WHERE ClientProp.attrName like 'PlatformDeleted 4'
		AND ClientProp.attrVal = '1'
		AND ClientProp.modified = 0
	END
	-- Output xml.
	SET @o_xmlString =
	(SELECT AC.clientId as '@clientId',
		AC.ClientName as '@clientName'
		FROM @ActiveClients AC
		FOR XML PATH('eligibleNodes'),
		ROOT('Ida_GetNodesEligibleForConfigurationPolicyResp'))
	ERROR_EXIT:
		IF @errorCode <> 0
			SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
								FOR XML PATH('Ida_GenericResp'), Type)
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<Ida_GetNodesEligibleForConfigurationPolicyResp/>'
		SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNodesEligibleForConfigurationPolicy')
	delete from GxQscripts where name = 'AppGetNodesEligibleForConfigurationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNodesEligibleForConfigurationPolicy')
	delete from GXDBVersions where aliasname = 'AppGetNodesEligibleForConfigurationPolicy'
GO

insert into GXDBVersions values(2, 'AppGetNodesEligibleForConfigurationPolicy',  '00000000000000000000', 'AppGetNodesEligibleForConfigurationPolicy', '00000000000000000000')
GO

