

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNodesAssociatedForConfigurationPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetNodesAssociatedForConfigurationPolicy')
BEGIN
	print '>>> Drop Stored Procedure: AppGetNodesAssociatedForConfigurationPolicy <<<'
	drop procedure AppGetNodesAssociatedForConfigurationPolicy
END
IF EXISTS (select * from GxQscripts where name='AppGetNodesAssociatedForConfigurationPolicy')
	delete from GxQscripts where name = 'AppGetNodesAssociatedForConfigurationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNodesAssociatedForConfigurationPolicy')
	delete from GXDBVersions where aliasname = 'AppGetNodesAssociatedForConfigurationPolicy'
GO
print '... Creating Procedure: AppGetNodesAssociatedForConfigurationPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNodesAssociatedForConfigurationPolicy
  @i_xmlString XML
AS
SET NOCOUNT ON
BEGIN
	-- Output xml string.
	DECLARE	@o_xmlString	XML
	-- Error handlers.
	DECLARE	@errorCode	INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = N''
	-- Reading from xml.
	DECLARE	@policyType		INT = 0
	DECLARE	@policyDetailType	INT = 0
	DECLARE	@policyId	INT = 0
	-- Sim package id to check.
	DECLARE @webServerSimPackageID	INT = 0
	DECLARE @indexGatewaySimPackageID INT = 0
	-- Policy deatil xml to read.
	DECLARE @policyDetail 	XML
	-- Table for all the clients and clientgroups in data access nodes xml.
	DECLARE @inClients TABLE (id INT IDENTITY, clientId INT, clientGroupId INT)
	-- Table for final expanded clientgroups in to client nodes.
	DECLARE @ExpandedClients TABLE(id INT, clientId INT, clientName NVARCHAR(2048))
	SELECT 	@policyId = ISNULL(ref.value('@policyId', 'INT'), 0),
			@policyType = ISNULL(ref.value('@policyType', 'INT'), 0),
			@policyDetailType = ISNULL(ref.value('@policyDetailType', 'INT'), 0)
		FROM @i_xmlString.nodes('Ida_GetNodesAssociatedForConfigurationPolicyReq') R (ref)
	-- Check if the policy type or policy detail or policy id type are missing.
	IF @policyType = 0 or @policyDetailType = 0 or @policyId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please provide policy type, policy detail type and policy id.'
		GOTO ERROR_EXIT
	END
	IF @policyType <> 0 and @policyDetailType <> 0 and @policyId <> 0
	BEGIN
		SET @policyDetail = ISNULL((SELECT PolicyDetail.policyDetails
			FROM APP_ConfigurationPolicyDetails PolicyDetail (NOLOCK)
			INNER JOIN APP_ConfigurationPolicy Policy (NOLOCK)
			ON Policy.policyId = PolicyDetail.componentNameId
			WHERE Policy.policyType = @policyType
			AND PolicyDetail.detailType = @policyDetailType
			AND Policy.policyId = @policyId
			AND PolicyDetail.modified = 0), '')
		-- Set the correct simpackage id to check.
		IF @policyType = 2 and @policyDetailType = 5 -- Content Indexing File Policy
		BEGIN
SET @webServerSimPackageID = 252 -- Check for web servers
SET @indexGatewaySimPackageID = 263 -- Check for index servers
		END
	END
	IF @policyDetail IS NULL or @webServerSimPackageID = 0 or @webServerSimPackageID IS NULL or @indexGatewaySimPackageID = 0 or @indexGatewaySimpackageID IS NULL
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Incorrect policy type, policy detail type and policy id.'
		GOTO ERROR_EXIT
	END
	ELSE
	BEGIN
		INSERT INTO @inClients
		SELECT 	ISNULL(DNA.nodes.value('@clientId', 'INT'), 0),
				ISNULL(DNA.nodes.value('@clientGroupId', 'INT'), 0)
		FROM @policyDetail.nodes('/filePolicy/contentIndexingPolicy/dataAccessNodes/dataAccessNodes') DNA(nodes)
	END
	-- Expand clientgroups and remove duplicates and do not sort.
	INSERT INTO @ExpandedClients
	SELECT MIN(CL.id), CL.clientId, CL.name
	FROM
	(SELECT I.id, C.id AS clientId, C.name
	FROM   @inClients I
	       LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON CGA.clientGroupId = I.clientGroupId
	       INNER JOIN APP_Client C ON (I.clientId = C.id OR CGA.clientId = C.id)) CL
	       INNER JOIN SimInstalledPackages Package (NOLOCK)
	       ON Package.ClientId = CL.clientId
	       WHERE Package.simPackageID = @webServerSimPackageID
	       OR Package.simPackageID = @indexGatewaySimPackageID
	GROUP BY CL.clientId, CL.name
	ORDER BY MIN(CL.id)
	-- Remove clients marked for deletion.
	DELETE @ExpandedClients
		FROM @ExpandedClients EC
		INNER JOIN APP_ClientProp ClientProp
		ON EC.clientId = ClientProp.componentNameId
		WHERE ClientProp.attrName like 'PlatformDeleted 4'
		AND ClientProp.attrVal = '1'
		AND ClientProp.modified = 0
	-- Output xml.
	SET @o_xmlString =
		(SELECT Client.clientId as '@clientId',
			Client.clientName as '@clientName'
			FROM @ExpandedClients Client
			FOR XML PATH('association'),
			ROOT('Ida_GetNodesAssociatedForConfigurationPolicyResp'))
	ERROR_EXIT:
		IF @errorCode <> 0
			SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
								FOR XML PATH('Ida_GenericResp'), Type)
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<Ida_GetNodesAssociatedForConfigurationPolicyResp/>'
		SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNodesAssociatedForConfigurationPolicy')
	delete from GxQscripts where name = 'AppGetNodesAssociatedForConfigurationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNodesAssociatedForConfigurationPolicy')
	delete from GXDBVersions where aliasname = 'AppGetNodesAssociatedForConfigurationPolicy'
GO

insert into GXDBVersions values(2, 'AppGetNodesAssociatedForConfigurationPolicy',  '00000000000000000000', 'AppGetNodesAssociatedForConfigurationPolicy', '00000000000000000000')
GO

