

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNodeMetaProp.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetNodeMetaProp
--  | Description:   get node meta properties like jvm memory
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNodeMetaProp.sp,v $ $Id: AppGetNodeMetaProp.sp,v 1.1.4.8 2020/05/05 17:33:45 pankajkumar Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetNodeMetaProp')
BEGIN
	print '>>> Drop Stored Procedure: AppGetNodeMetaProp <<<'
	drop procedure AppGetNodeMetaProp
END
IF EXISTS (select * from GxQscripts where name='AppGetNodeMetaProp')
	delete from GxQscripts where name = 'AppGetNodeMetaProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNodeMetaProp')
	delete from GXDBVersions where aliasname = 'AppGetNodeMetaProp'
GO
print '... Creating Procedure: AppGetNodeMetaProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNodeMetaProp
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
	DECLARE @i_clientId INT
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
                            FROM @i_xmlText.nodes('App_CloudInfo/cloudNodes/nodeClientEntity') R ( ref ) ), 0)
	IF @i_clientId <= 0
	GOTO PROC_EXIT
	DECLARE @nodePropXml XML
	DECLARE @status INT
	DECLARE @i_serverType INT
	SET @i_serverType = ISNULL(( SELECT ref.value('@type', 'int')
                            FROM @i_xmlText.nodes('App_CloudInfo') R ( ref ) ), 0)
	DECLARE @nodeProps TABLE (name NVARCHAR(256), value nvarchar(1024))
IF (@i_serverType IN (1, 5))
	BEGIN
			DECLARE @portNo INT
			DECLARE @cloudId INT
			SELECT @nodePropXml = nodeProps, @status = status, @portNo= Portno, @cloudId = cloudId FROM DM2SearchServerCoreInfo (NOLOCK) WHERE clientId = @i_clientId AND cloudType = @i_serverType AND ISNULL(nodeProps,'') <> ''
            IF(@nodePropXml IS NOT NULL)
            BEGIN
                    INSERT INTO @nodeProps
                    SELECT  ref.value('@name', 'NVARCHAR(1024)'),ref.value('@value', 'NVARCHAR(1024)')
                    FROM @nodePropXml.nodes ('NodeMetaProp/nodeMetaInfos') R(ref)
					DELETE FROM @nodeProps WHERE name IN ( 'ISENABLED' , 'URL', 'INDEXLOCATION')
					INSERT INTO @nodeProps
					SELECT 'INDEXLOCATION', dbo.SEGetIndexLocation(@cloudId, 0)
IF (@i_serverType  =1)
					BEGIN
						INSERT INTO @nodeProps
						VALUES ('analyticsStopPort', @portNo+10)
						INSERT INTO @nodeProps
						VALUES ('analyticsEnabled', @status)
						DECLARE @installedRoles VARCHAR(100)
						SELECT @installedRoles = COALESCE( @installedRoles + ',', '') + CONVERT(VARCHAR(10),RoleId)
						FROM DM2CloudCoreRole (NOLOCK)
						WHERE CloudId = @cloudId
						INSERT INTO @nodeProps
						VALUES ('analyticsInstalledRoles', @installedRoles)
					END
					UPDATE @nodeProps
					SET name = 'analyticsMaxJvm'
					WHERE name = 'JVMMAXMEMORY'
					UPDATE @nodeProps
					SET name = 'analyticsDataDir'
					WHERE name = 'INDEXLOCATION'
					UPDATE @nodeProps
					SET name = 'analyticsPort'
					WHERE name = 'PORTNO'
            END
    END
ELSE IF (@i_serverType = 6)  -- Zookeeper
	BEGIN
		SELECT @nodePropXml = nodeProps, @status = status  FROM DM2SearchServerCoreInfo (NOLOCK) WHERE clientId = @i_clientId AND cloudType = @i_serverType AND ISNULL(nodeProps,'') <> ''
        IF(@nodePropXml IS NOT NULL)
        BEGIN
                INSERT INTO @nodeProps
                SELECT  ref.value('@name', 'NVARCHAR(1024)'),ref.value('@value', 'NVARCHAR(1024)')
                FROM @nodePropXml.nodes ('NodeMetaProp/nodeMetaInfos') R(ref)
				--HAC cluster configuration status
				INSERT INTO @nodeProps (name, value)
VALUES ('HACClusterEnabled', @status)
				DELETE FROM @nodeProps WHERE name IN ( 'ISENABLED')
		END
	END
	  SET @o_xmlText = (SELECT name as '@name', value AS '@value'
				FROM @nodeProps P
				FOR XML PATH('nodeMetaInfos'), ROOT('App_CloudNodeInfo'))
PROC_EXIT:
	IF @o_xmlText IS NULL
		SET @o_xmlText = '<App_CloudNodeInfo/>'
SELECT @o_xmlText AS [o_xmlText]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNodeMetaProp')
	delete from GxQscripts where name = 'AppGetNodeMetaProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNodeMetaProp')
	delete from GXDBVersions where aliasname = 'AppGetNodeMetaProp'
GO

insert into GXDBVersions values(2, 'AppGetNodeMetaProp',  '00010001000400080000', 'AppGetNodeMetaProp', '00010001000400080000')
GO

