

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNewDataFilesAfterJob.sp] ---------- 

--  +========================================================================+
--  | Name        :  AppGetNewDataFilesAfterJob()                                |
--  | Description :  Get the running jobs given a client                     |
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetNewDataFilesAfterJob <<<'

IF EXISTS (select * from sysobjects where name='AppGetNewDataFilesAfterJob')
	drop procedure AppGetNewDataFilesAfterJob
IF EXISTS (select * from GxQscripts where name='AppGetNewDataFilesAfterJob')
	delete from GxQscripts where name = 'AppGetNewDataFilesAfterJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNewDataFilesAfterJob')
	delete from GXDBVersions where aliasname = 'AppGetNewDataFilesAfterJob'
GO
print '... Creating Procedure: AppGetNewDataFilesAfterJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNewDataFilesAfterJob
  @i_xmlText XML
AS
  DECLARE @o_ErrorCode integer=0
  DECLARE @o_ErrorString NVARCHAR(1024)
  DECLARE @o_xmlText XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @i_fromFullJobId 	INT
	DECLARE @i_toFullJobId		INT = 0
	DECLARE @instanceID			INT
	DECLARE @refTime INT
	DECLARE @endTime INT = 0
	SET     @o_ErrorCode  = 0
	SET     @o_xmlText    = '<Ida_GetNewDataFilesAfterJobResp />'
	SET     @i_fromFullJobId   = ISNULL((SELECT ref.value('@fromFullJobId','int')
									FROM @i_xmlText.nodes('Ida_GetNewDataFilesAfterJobReq') R ( ref )), 0)
	SET     @i_toFullJobId   = ISNULL((SELECT ref.value('@toFullJobId','int')
									FROM @i_xmlText.nodes('Ida_GetNewDataFilesAfterJobReq') R ( ref )), 0)
	IF @i_fromFullJobId = 0
	BEGIN
		SET @o_ErrorCode   = 1
		SET @o_ErrorString = 'Job ID not found. Invalid request.'
		GOTO EXIT_PROC
	END
	SET @instanceId = (
						SELECT	TOP 1 instance
						FROM	JMBkpStats J
								INNER JOIN APP_Application A ON J.appId = A.id
						WHERE J.jobId = @i_fromFullJobId
					  )
	SELECT @refTime = servEndDate FROM JMBkpStats WHERE jobId = @i_fromFullJobId
	IF ISNULL(@instanceId, 0) = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'Failed to find instance id for job: ' + CAST(@i_fromFullJobId AS VARCHAR(16))
		GOTO EXIT_PROC
	END
	IF ISNULL(@refTime, 0) = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'Failed to find end time for job: ' + CAST(@i_fromFullJobId AS VARCHAR(16))
		GOTO EXIT_PROC
	END
	IF @i_toFullJobId <> 0
	BEGIN
		SELECT @endTime = servEndDate FROM JMBkpStats WHERE jobId = @i_toFullJobId
	END
	SET @o_xmlText =
	(
		SELECT
			(
				SELECT distinct T.id as '@tsId', T.name as '@tsName', D.contType as '@dfId', T.created - @refTime as '@reserved1'
					FROM oracleDatafiles D
						INNER JOIN oracleTableSpaces T
							ON D.tblId = T.id
					WHERE	D.instId = @instanceId
						AND	D.created > @refTime
						AND (@endTime = 0 OR D.created <= @endTime)
					FOR XML PATH('tsList'), TYPE
			)
			FOR XML PATH(''), ROOT('Ida_GetNewDataFilesAfterJobResp'), TYPE
	)
	EXIT_PROC:
    IF @o_ErrorCode > 0
    BEGIN
        SET @o_xmlText =
        (
            SELECT @o_ErrorCode '@errorCode',
                    @o_ErrorString '@errorMessage'
            FOR XML PATH ('error'), ROOT('Ida_GetNewDataFilesAfterJobResp')
        )
    END
    SELECT @o_xmlText
END
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNewDataFilesAfterJob')
	delete from GxQscripts where name = 'AppGetNewDataFilesAfterJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNewDataFilesAfterJob')
	delete from GXDBVersions where aliasname = 'AppGetNewDataFilesAfterJob'
GO

insert into GXDBVersions values(2, 'AppGetNewDataFilesAfterJob',  '00000000000000000000', 'AppGetNewDataFilesAfterJob', '00000000000000000000')
GO

