

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNetworkPropertiesForClientGroups.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNetworkPropertiesForClientGroups.sp,v $ $Id: AppGetNetworkPropertiesForClientGroups.sp,v 1.1.2.1 2020/08/13 22:29:30 sneralla Exp $";
-- This SP fetches network properties of client groups
-- PARAM : i_clientGroupId => Client group ID whose network properties are to be fetched
--			If input is not provided or is 0, network properties of all groups are returned
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetNetworkPropertiesForClientGroups')
BEGIN
	print '>>> Drop Stored Procedure: AppGetNetworkPropertiesForClientGroups <<<'
	drop procedure AppGetNetworkPropertiesForClientGroups
END
IF EXISTS (select * from GxQscripts where name='AppGetNetworkPropertiesForClientGroups')
	delete from GxQscripts where name = 'AppGetNetworkPropertiesForClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNetworkPropertiesForClientGroups')
	delete from GXDBVersions where aliasname = 'AppGetNetworkPropertiesForClientGroups'
GO
print '... Creating Procedure: AppGetNetworkPropertiesForClientGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNetworkPropertiesForClientGroups
  @i_clientGroupId INTEGER = 0
AS
  DECLARE @networkPropsXML XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE  @outputXML XML
IF @i_clientGroupId=0
BEGIN
-- Fetch for all client groups
	SET @outputXML = (
		SELECT
			(SELECT
				( SELECT CG.ID AS '@clientGroupId', CG.name AS '@clientGroupName' FOR XML PATH('group'), TYPE)
				, (SELECT FO.tunnelconnectionPort AS '@tunnelConnectionPort', FO.keepAliveSeconds AS '@keepAliveSeconds', ISNULL(EX.Props.value('@configureAutomatically', 'int'), 1) AS '@configureAutomatically' FOR XML PATH('options'), TYPE)
				FOR XML PATH('groupNetworkProperties'), TYPE)
		FROM App_FirewallOptions FO
		INNER JOIN APP_ClientGroup CG
		ON FO.clientGroupId = CG.id
		CROSS APPLY FO.extendedProperties.nodes('App_FirewallExtendedProperties') AS EX(Props)
		FOR XML PATH (''), ROOT('App_GetNetworkPropertiesForClientGroupsResp')
	)
END
ELSE
BEGIN
-- Fetch for the specified client group
	SET @outputXML = (
		SELECT
		(SELECT
			( SELECT CG.ID AS '@clientGroupId', CG.name AS '@clientGroupName' FOR XML PATH('group'), TYPE)
			, (SELECT FO.tunnelconnectionPort AS '@tunnelConnectionPort', FO.keepAliveSeconds AS '@keepAliveSeconds', ISNULL(EX.Props.value('@configureAutomatically', 'int'), 1) AS '@configureAutomatically' FOR XML PATH('options'), TYPE)
			FOR XML PATH('groupNetworkProperties'), TYPE)
		FROM App_FirewallOptions FO
		INNER JOIN APP_ClientGroup CG
		ON FO.clientGroupId = CG.id
		CROSS APPLY FO.extendedProperties.nodes('App_FirewallExtendedProperties') AS EX(Props)
		WHERE FO.clientGroupId = @i_clientgroupId
		FOR XML PATH (''), ROOT('App_GetNetworkPropertiesForClientGroupsResp')
	)
END
IF @outputXML IS NULL
	SET @outputXML = '<App_GetNetworkPropertiesForClientGroupsResp/>'
SELECT @outputXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNetworkPropertiesForClientGroups')
	delete from GxQscripts where name = 'AppGetNetworkPropertiesForClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNetworkPropertiesForClientGroups')
	delete from GXDBVersions where aliasname = 'AppGetNetworkPropertiesForClientGroups'
GO

insert into GXDBVersions values(2, 'AppGetNetworkPropertiesForClientGroups',  '00010001000200010000', 'AppGetNetworkPropertiesForClientGroups', '00010001000200010000')
GO

