

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNasVServerList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNasVServerList.sp,v $ $Id: AppGetNasVServerList.sp,v 1.3.88.7.4.1 2021/02/24 11:51:07 mmani Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetNasVServerList"
--	|	This Procedure is used to get all vServers associated with a NAS cluster client
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetNasVServerList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetNasVServerList <<<'
	drop procedure AppGetNasVServerList
END
IF EXISTS (select * from GxQscripts where name='AppGetNasVServerList')
	delete from GxQscripts where name = 'AppGetNasVServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNasVServerList')
	delete from GXDBVersions where aliasname = 'AppGetNasVServerList'
GO
print '... Creating Procedure: AppGetNasVServerList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetNasVServerList
  @xmlText XML
AS
SET NOCOUNT ON
DECLARE @x_clientId				INTEGER -- input clientid
DECLARE @x_clientNetHostName	NVARCHAR(1024) -- input nethostname
DECLARE	@x_clientIPSpace		NVARCHAR(1024) --input which will be set when Multisite is on
DECLARE @ClientList TABLE			( clientId INT,
									vServerId INT,
									clientName NVARCHAR(1024),
									vServerName NVARCHAR(1024),
									isSnapEnabled INT,-- list of vServerClients in DB
									flag INT, --to indicate when the clientList was updated as there are multiple update scenarios
									regionId INT)
DECLARE @ClientListNotInEng TABLE	( clientId INT, -- list of vServer clients that are in DB but not on cluster
									clientName NVARCHAR(1024),
									clientHostName NVARCHAR(1024),
									isSnapEnabled INT )
DECLARE @VServersFromEng TABLE		( vServerId INT,
									vUniqueIdentifier NVARCHAR(1024),
									vServerName NVARCHAR(1024),
									vServerHostName NVARCHAR(1024),
									vServerAliasName NVARCHAR(1024),
									protocol NVARCHAR(1024),
									vServerIPSpace	NVARCHAR(1024))
DECLARE @FinalVServerList TABLE		(ClientId INT,
									VServerId INT,
									ClientName NVARCHAR(1024),
									VServerName NVARCHAR(1024),
									isSnapEnabled INT)
DECLARE @FinalVServerAliases TABLE (VServerHostName NVARCHAR(1024),
									VServerAlias NVARCHAR(1024),
									protocol NVARCHAR(1024))
DECLARE @errCode						INTEGER = 0
DECLARE @errMsg							NVARCHAR(1024) = N''
DECLARE	@INTELLISNAP_ENABLED_FLAG		INTEGER = 1		-- IntelliSnap enabled
DECLARE	@INTELLISNAP_DISABLED_FLAG		INTEGER = 0		-- IntelliSnap disabled
DECLARE @isMultiTenantSite 				INTEGER = 0
DECLARE	@clusterType					INTEGER	= 0		--Indicates if it is 7mode/cmode (1=MO_CLUSTER_INTERFACE 4=MO_PHYSICAL_FILER_INTERFACE)
	-- XML Structure for AppGetNasVServerList
	/*
	<AppGetNasVServerList>
		<ClusterClient ClientId = "8" NetHostName = "name" IPSpace = "Default"/>
		<VServerList>
			<VServer>
				<Id>xxx</Id>
				<Name>xxx</Name>
				<NetHostName>xxx</NetHostName>
				<CtrlHostName>xxx></CtrlHostName>
				<AliasList>
					<Alias name = "x" protocol="yyy"/>
					<Alias name = "x" protocol="yyyy"/>
					<Alias name = "x" protocol="yyyyyy"/>
					<Alias name = "x" protocol="yyyyyy"/>
				</AliasList>
				<UniqueIdentifier>xxx</UniqueIdentifier>
				<IPSpace>Default</IPSpace>
			</VServer>
		</VServerList>
	</AppGetNasVServerList>
	*/
	SET @x_clientId = ISNULL(( SELECT R.ref.value('@ClientId', 'nvarchar(1024)') FROM @xmlText.nodes('/AppGetNasVServerList/ClusterClient') R(ref)), 0)
	SET @x_clientNetHostName = ISNULL(( SELECT R.ref.value('@NetHostName', 'nvarchar(1024)') FROM @xmlText.nodes('/AppGetNasVServerList/ClusterClient') R(ref)), N'')
	SET @x_clientIPSpace = ISNULL(( SELECT R.ref.value('@IPSpace', 'nvarchar(1024)') FROM @xmlText.nodes('/AppGetNasVServerList/ClusterClient') R(ref)), N'')
	SET @clusterType =  ISNULL(( SELECT R.ref.value('@Type', 'nvarchar(1024)') FROM @xmlText.nodes('/AppGetNasVServerList/ClusterClient') R(ref)), N'')
	--Consider the MultiSite related checks for only C-mode cluster
	IF @clusterType = 1  /*MO_CLUSTER_INTERFACE*/
		SET @isMultiTenantSite = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_SNAP_MULTI_TENANT_SITE'), 0)
	INSERT	INTO @VServersFromEng
	SELECT	R.ref.value('../../Id[1]', 'int') as vServerId,
			ISNULL( R.ref.value('../../UniqueIdentifier[1]', 'nvarchar(1024)'), '') as vUniqueIdentifer,
			R.ref.value('../../Name[1]', 'nvarchar(1024)') as vServerName,
			R.ref.value('../../Name[1]', 'nvarchar(1024)') as vServerHostName,
			R.ref.value('@name', 'nvarchar(1024)') as vServerAliasName,
			R.ref.value('@protocol', 'nvarchar(1024)') as protocol,
			R.ref.value('../../IPSpace[1]', 'nvarchar(1024)') as vServerIPSpace
	FROM	@xmlText.nodes('/AppGetNasVServerList/VServerList/VServer/AliasList/Alias') R(ref)
	-- Include list of vServer clients in the DB associated with the Cluster
	-- but not present in the vServerList from the engine (basically deconfigured vServers of that Cluster)
	INSERT	INTO @ClientListNotInEng
	SELECT	DISTINCT CLIENT.id, CLIENT.name, CLIENT.net_hostname, @INTELLISNAP_ENABLED_FLAG
	FROM	APP_VMToPMMap MAP WITH(NOLOCK) JOIN APP_Client CLIENT WITH(NOLOCK)
			ON MAP.PMClientId = @x_clientId AND MAP.VMClientId = CLIENT.id
			JOIN SMControlHost HOST WITH(NOLOCK) ON (CLIENT.id = HOST.ClientId)
			JOIN SMHostAlias ALIAS WITH(NOLOCK) ON ( HOST.ControlHostId = ALIAS.RefId)
			LEFT OUTER JOIN @VServersFromEng VSERVER ON (VSERVER.vServerAliasName = ALIAS.AliasName)
	WHERE	VSERVER.vServerHostName IS NULL
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errMsg = N'Error in checking deconfigured virtual filers.'
		GOTO ERR_EXIT
	END
	-- If vServer has been added as client already, but not associated with Cluster
	-- For a multi-tenant site, check whether the unique ids are different
	-- Check against SMHostAlias
	INSERT	INTO @ClientList
	SELECT	DISTINCT CLIENT.id, VSERVER.vServerId, CLIENT.name, VSERVER.vServerHostName, @INTELLISNAP_ENABLED_FLAG, 0, 0
	FROM	@VServersFromEng VSERVER JOIN SMHostAlias ALIAS WITH(NOLOCK) ON VSERVER.vServerAliasName = ALIAS.AliasName
			JOIN SMControlHost HOST WITH(NOLOCK) ON ( HOST.ControlHostId = ALIAS.RefId)
			JOIN APP_Client CLIENT WITH(NOLOCK) ON (CLIENT.id = HOST.ClientId) AND CLIENT.Id NOT IN (SELECT clientId FROM @ClientList)
	WHERE	(@isMultiTenantSite = 0
	OR 		( HOST.UniqueIdentifier = VSERVER.vUniqueIdentifier AND HOST.UniqueIdentifier <> '' ) )
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errMsg = N'Error in checking vServer aliases against existing array aliases.'
		GOTO ERR_EXIT
	END
	INSERT	INTO @FinalVServerAliases
	SELECT	vServerHostName, vServerAliasName, protocol
	FROM	@VServersFromEng
	WHERE	vServerHostName IN (SELECT vServerName FROM @ClientList)
	DELETE	@VServersFromEng WHERE vServerHostName IN (SELECT vServerName FROM @ClientList)
	-- Check by client netHost name
	-- In MultiSite scenarios, if there is any failure in client creation due to name conflict, we create NAS clients with arrayName_UUID. Hence leverage the UUID check, if present
	INSERT	INTO @ClientList
	SELECT	DISTINCT CLIENT.id, VSERVER.vServerId, CLIENT.name, VSERVER.vServerHostName, @INTELLISNAP_ENABLED_FLAG, 1, 0
	FROM	@VServersFromEng VSERVER JOIN APP_Client CLIENT WITH(NOLOCK)
			ON ((VSERVER.vUniqueIdentifier = SUBSTRING(CLIENT.name, (LEN(CLIENT.name) - CHARINDEX('_',REVERSE(CLIENT.name)))+2, LEN(CLIENT.name)) AND VSERVER.vUniqueIdentifier <> '')
			OR (VSERVER.vServerAliasName = CLIENT.net_hostname))
	WHERE   CLIENT.id NOT IN (SELECT clientId FROM @ClientList)
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errMsg = N'Error in checking vServer aliases against existing clients.'
		GOTO ERR_EXIT
	END
	--Get the vserverID for which the IPSpace does not match with that of the cluster
	IF @isMultiTenantSite = 1
	BEGIN
		DECLARE	@tblIPSpaceMisMatch TABLE (vServerId INT)
		DECLARE @clusterRegionID INT
		--Get the vserverID for which the IPSpace does not match with that of the cluster
		INSERT INTO @tblIPSpaceMisMatch
		SELECT vServerId FROM @VServersFromEng WHERE vServerIPSpace <> @x_clientIPSpace
		--Get the regionID of the cluster
SELECT @clusterRegionID = CONVERT(INT, CONVERT(NVARCHAR(MAX), value)) FROM APP_AdvanceSettings WHERE entityId = @x_clientId AND enabled = 1 AND deleted = 0 AND keyName  = 'Region Id' /*CV_PROP_REGION_ID_DB*/
		--If the IPSPaces of the cluster and Vserver are different, then we need to create a deconfigured NAS client.
		--Delete those client information from the @ClientList. When those clients are deleted, we tend to delete the vserver details too.
		--Hence, keep one copy of the vserver information and set the client values to -1, so the client details does not appear for those vservers who IPSpace is different than that of the cluster
		IF EXISTS (SELECT 1 FROM @ClientList WHERE flag = 1)
		BEGIN
			DELETE FROM @ClientList
			WHERE ClientId in (
						SELECT clientID
						FROM (
						SELECT clientId,flag,vServerId,isSnapEnabled, ROW_NUMBER() OVER (PARTITION BY vServerId ORDER BY regionId)  PART1 FROM @ClientList) TMP1
			WHERE PART1 > 1 AND TMP1.flag = 1 AND  TMP1.isSnapEnabled <> @INTELLISNAP_ENABLED_FLAG AND TMP1.vServerId IN (SELECT vServerId FROM @tblIPSpaceMisMatch));
			UPDATE @ClientList SET clientId = -1 , clientName = '', isSnapEnabled = @INTELLISNAP_DISABLED_FLAG WHERE flag = 1 AND vServerId IN (SELECT vServerId FROM @tblIPSpaceMisMatch)
		END
	END
	-- Get Aliases for the matching client to be sent in the response
	INSERT	INTO @FinalVServerAliases
	SELECT	vServerHostName, vServerAliasName, protocol
	FROM	@VServersFromEng
	WHERE	vServerHostName IN (SELECT vServerName FROM @ClientList)
	-- Remove existing vServer clients from engine list
	-- if a match was found by nethostname
	DELETE	@VServersFromEng WHERE vServerHostName IN (SELECT vServerName FROM @ClientList)
	-- If vServer is added just as Client but doesnt have array configured,
	-- GUI should be allowed to select
	UPDATE	@ClientList
	SET		isSnapEnabled = @INTELLISNAP_DISABLED_FLAG
	FROM	@ClientList CLIST JOIN APP_Client CLIENT WITH(NOLOCK) ON ( CLIST.clientId = CLIENT.id )
			LEFT OUTER JOIN SMControlHost HOST WITH(NOLOCK) ON (CLIENT.id = HOST.ClientId)
	WHERE	HOST.ClientId IS NULL
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errMsg = N'Error in checking if existing vServer clients are associated with arrays.'
		GOTO ERR_EXIT
	END
	-- If both Client and ControlHost entries exist for the vServer,
	-- but is not associated with the current cluster,
	-- GUI should be allowed to select.
	UPDATE	@ClientList
	SET		isSnapEnabled = @INTELLISNAP_DISABLED_FLAG
	FROM	@ClientList CLIST JOIN APP_Client CLIENT WITH(NOLOCK) ON ( CLIST.clientId = CLIENT.id )
			JOIN SMControlHost HOST WITH(NOLOCK) ON (CLIENT.id = HOST.ClientId)
			LEFT OUTER JOIN APP_VMToPMMap MAP WITH(NOLOCK) ON (MAP.VMClientId = CLIENT.id AND MAP.PMClientId = @x_clientId)
	WHERE	MAP.VMClientId IS NULL
	SET @errCode = @@ERROR
	IF @errCode <> 0
	BEGIN
		SET @errMsg = N'Error in checking if existing vServer clients are associated with the cluster.'
		GOTO ERR_EXIT
	END
	/* Not required as we do not mandate NAS client to any REGION , for MultiSite
	--If IpSpace of the VServer and SVM are different, we do not take into account the REGION the entities belong to.
	--If The cluster and vserver belong to the same IPSpace, then we should select only those NAS clients that belong to the same region as that of the cluster client
	--For those clients, that does not belong to the same region as that of the cluster, do not select them
	IF @isMultiTenantSite = 1
	BEGIN
		--Update the @ClientList with the REGION information
		UPDATE @ClientList
		SET regionId = ISNULL(CONVERT(INT,CONVERT(VARCHAR(MAX), APPSETTING.value)),0)
		FROM @ClientList CLIST LEFT OUTER JOIN APP_AdvanceSettings APPSETTING ON CLIST.clientId = APPSETTING.entityId
WHERE APPSETTING.enabled = 1 AND APPSETTING.deleted = 0 AND APPSETTING.keyName = 'Region Id' /*CV_PROP_REGION_ID_DB*/
		--Temp table to hold the client information that matches with the region as that of the vserver.
		DECLARE @tblClientWithRegionMatch TABLE			( clientId INT,
										vServerId INT,
										clientName NVARCHAR(1024),
										vServerName NVARCHAR(1024),
										isSnapEnabled INT, -- list of vServerClients in DB
										flag INT,
										regionId INT)
		--Populate the table with the client information whose region+IPSpace matches with the cluster
		INSERT INTO @tblClientWithRegionMatch
		SELECT * FROM @ClientList
		WHERE regionId = @clusterRegionID AND flag = 1 AND vServerId NOT IN (SELECT vServerId FROM @tblIPSpaceMisMatch)
		--Delete those clients from the @ClientList as we have already made a copy of the matching NAS clients in the step above
		IF EXISTS (SELECT 1 FROM @tblClientWithRegionMatch)
		DELETE  @ClientList WHERE vServerId IN (SELECT vServerId FROM @tblClientWithRegionMatch)
		--Now keep only one copy of the data for those vservers whose region does not match with that of the cluster
		--So we do not show the client details for those vservers
		DELETE FROM @ClientList
		WHERE ClientId in (
							SELECT clientID
							FROM (
							SELECT clientId, ROW_NUMBER() OVER (PARTITION BY vServerId ORDER BY regionId)  PART1 FROM @ClientList) TMP1
		WHERE PART1 > 1);
		--Copy the NAS clients whose region+IPspace match with the cluster
		INSERT INTO @ClientList SELECT * FROM @tblClientWithRegionMatch
		--Update the client details to 0 for those clients whose region does not match with that of the cluster
		UPDATE @ClientList
		SET clientId=-1 , clientName = ''
		WHERE (regionId = 0 OR regionId <> @clusterRegionID) AND flag = 1 AND vServerId NOT IN (SELECT vServerId FROM @tblIPSpaceMisMatch)
	END
	*/
	-- vServers with no match
	INSERT	INTO @FinalVServerList
	SELECT	DISTINCT -1, vServerId, '', vServerName, @INTELLISNAP_DISABLED_FLAG
	FROM	@VServersFromEng
	-- Matching clients were found
	INSERT	INTO @FinalVServerList
	SELECT	DISTINCT ClientId, vServerId, ClientName, vServerName, isSnapEnabled
	FROM	@ClientList
	-- vServers that don't exist anymore on the cluster
	INSERT	INTO @FinalVServerList
	SELECT	DISTINCT ClientId, 0, ClientName, '', isSnapEnabled
	FROM	@ClientListNotInEng
	INSERT	INTO @FinalVServerAliases
	SELECT	vServerHostName, vServerAliasName, protocol
	FROM	@VServersFromEng
	SELECT	0 AS '@errorCode',
			'Detected NAS vServers successfully' AS '@errorMessage',
			@x_clientId as 'clientId/@id',
			@x_clientNetHostName as 'clientId/@name',
			(
				SELECT	A.isSnapEnabled as '@isIntelliSnapEnabled',
						(CASE WHEN A.ClientId > -1 THEN A.ClientID ELSE 0 END) AS 'clientId/@id',
						(CASE WHEN A.ClientName <> '' THEN A.clientName ELSE '' END) AS 'clientId/@name',
						(CASE WHEN A.VServerId <> 0 THEN A.VServerId ELSE 0 END) AS 'vServerId/@id',
						(CASE WHEN A.vServerName <> '' THEN A.vServerName ELSE A.ClientName END) AS 'vServerId/@name',
						(
							SELECT	VServerAlias AS '@arrayInterface',
									protocol AS '@interfaceType'
							FROM	@FinalVServerAliases aliases
							WHERE	(A.VServerName = aliases.VServerHostName OR
									A.ClientName = aliases.VServerHostName)
							FOR XML PATH ('aliasList'),
							TYPE
						) --AS 'aliasList'
				FROM	@FinalVServerList A
				ORDER BY A.VServerName
				FOR XML PATH ('vServerList'),
				TYPE
			) --AS 'vServerList'
	FOR XML PATH ('App_DetectVServerResp')
	RETURN
ERR_EXIT:
	SELECT	@errCode AS '@errorCode',
			@errMsg AS '@errorMessage'
	FOR XML PATH ('App_DetectVServerResp')
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNasVServerList')
	delete from GxQscripts where name = 'AppGetNasVServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNasVServerList')
	delete from GXDBVersions where aliasname = 'AppGetNasVServerList'
GO

insert into GXDBVersions values(2, 'AppGetNasVServerList',  'v1.3.88.7.4.1', 'AppGetNasVServerList', 'v1.3.88.7.4.1')
GO

