

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNasClusterProperties.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNasClusterProperties.sp,v $ $Id: AppGetNasClusterProperties.sp,v 1.3.86.1 2018/03/22 01:50:53 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetNasClusterProperties"
--	|	This Procedure is used to get NAS cluster properties for a NAS client
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetNasClusterProperties <<<'

IF EXISTS (select * from sysobjects where name='AppGetNasClusterProperties')
	drop procedure AppGetNasClusterProperties
IF EXISTS (select * from GxQscripts where name='AppGetNasClusterProperties')
	delete from GxQscripts where name = 'AppGetNasClusterProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNasClusterProperties')
	delete from GXDBVersions where aliasname = 'AppGetNasClusterProperties'
GO
print '... Creating Procedure: AppGetNasClusterProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNasClusterProperties
  @i_clientId INT,
  @xmlText XML OUTPUT
AS
DECLARE @clientType INTEGER = 0
DECLARE @assocClusterId INT = 0
DECLARE @assocClusterName NVARCHAR(1024) = N''
DECLARE @vServerName NVARCHAR(1024) = N''
DECLARE @ClusterList TABLE ( clientId INT,
							 clientName NVARCHAR(1024) )
DECLARE @VServerList TABLE ( clientId INT,
							 clientName NVARCHAR(1024),
							 vServerName NVARCHAR(1024),
							 arrayName NVARCHAR(1024),
							 isIntelliSnapEnabled INT )
-- Constants
DECLARE	@CLIENT_PROP_NAS_TYPE			VARCHAR(32) = 'NAS Client Type'
DECLARE	@CLIENT_PROP_VSERVER_NAME		VARCHAR(32) = 'NAS vServer Name'
DECLARE	@NAS_CLIENT_TYPE_CLUSTER		INTEGER = 1		-- Cluster NAS Client
DECLARE	@NAS_CLIENT_TYPE_VSERVER		INTEGER = 2		-- vServer NAS Client
DECLARE	@NAS_CLIENT_TYPE_FILER			INTEGER = 3		-- Physical filer NAS Client
DECLARE	@NAS_CLIENT_TYPE_VFILER			INTEGER = 4		-- vFiler NAS Client
DECLARE	@INTELLISNAP_ENABLED_FLAG		INTEGER = 1		-- IntelliSnap enabled
DECLARE	@INTELLISNAP_DISABLED_FLAG		INTEGER = 0		-- IntelliSnap disabled
	SELECT	@clientType = (SELECT attrVal FROM APP_ClientProp WITH (NOLOCK)
								WHERE componentNameId = @i_clientId AND attrName = @CLIENT_PROP_NAS_TYPE)
	INSERT	INTO @ClusterList
	SELECT	CLIENT.Id, CLIENT.name
	FROM	App_client CLIENT WITH (NOLOCK) JOIN App_ClientProp PROP WITH (NOLOCK)
			ON (CLIENT.Id = PROP.ComponentNameId AND PROP.attrName = @CLIENT_PROP_NAS_TYPE AND (PROP.attrVal = @NAS_CLIENT_TYPE_CLUSTER OR PROP.attrVal = @NAS_CLIENT_TYPE_FILER))
	IF (@clientType = @NAS_CLIENT_TYPE_CLUSTER OR @clientType = @NAS_CLIENT_TYPE_FILER) -- Cluster/Physical Filer
	BEGIN
		INSERT	INTO @VServerList
		SELECT	CLIENT.Id, CLIENT.name, CLIENT.name, '', @INTELLISNAP_ENABLED_FLAG
		FROM	App_VMToPMMap MAP WITH (NOLOCK) JOIN App_client CLIENT WITH (NOLOCK)
				ON (MAP.PMClientId = @i_clientId AND MAP.VMClientId = CLIENT.id)
		UPDATE	@VServerList
		SET		vServerName = PROP.attrVal
		FROM	@VServerList VSERVER JOIN APP_ClientProp PROP WITH (NOLOCK)
				ON (VSERVER.clientId = PROP.componentNameId AND PROP.attrName = @CLIENT_PROP_VSERVER_NAME)
		UPDATE	@VServerList
		SET		isIntelliSnapEnabled = @INTELLISNAP_DISABLED_FLAG
		FROM	@VServerList VSERVER LEFT OUTER JOIN SMControlHost HOST WITH (NOLOCK) ON VSERVER.clientId = HOST.ClientId
		WHERE	HOST.ControlHostId IS NULL
		UPDATE	@VServerList
		SET		arrayName = HOST.SMArrayId
		FROM	@VServerList VSERVER INNER JOIN SMControlHost HOST WITH (NOLOCK) ON VSERVER.clientId = HOST.ClientId
		SET @xmlText = (SELECT @clientType AS '@clusterSetting',
		(
			SELECT isIntelliSnapEnabled AS '@isIntelliSnapEnabled',
			arrayName AS '@zapiHostName',
			0 AS 'vServerId/@id',
			vServerName AS 'vServerId/@name',
			clientId AS 'clientId/@id',
			clientName AS 'clientId/@name'
			FROM @VServerList
			WHERE isIntelliSnapEnabled > 0
			FOR XML PATH ('vServerList'),
			TYPE
		),-- AS 'vServerList',
		(
			SELECT clientId AS '@id',
			clientName AS '@name'
			FROM @ClusterList
			FOR XML PATH ('clusterList'),
			TYPE
		)
		FOR XML PATH ('nasClusterProperties'))
	END
	ELSE IF ( @clientType = @NAS_CLIENT_TYPE_VSERVER OR @clientType = @NAS_CLIENT_TYPE_VFILER) -- Vserver/vFiler
	BEGIN
		SELECT	@assocClusterId = Id, @assocClusterName = name
		FROM	App_VMToPMMap MAP WITH (NOLOCK) JOIN App_Client CLIENT WITH (NOLOCK)
				ON (MAP.VMClientId = @i_clientId AND MAP.PMClientId = CLIENT.Id)
		SELECT	@vServerName = PROP.attrVal
		FROM	APP_ClientProp PROP
		WHERE	PROP.componentNameId = @i_clientId AND PROP.attrName = @CLIENT_PROP_VSERVER_NAME
		SET @xmlText =
		(SELECT @clientType AS '@clusterSetting',
				@vServerName AS '@vServerName',
		(SELECT
			@assocClusterId AS '@id',
			(CASE WHEN @assocClusterName <> '' THEN @assocClusterName ELSE '' END) AS '@name'
			FOR XML PATH('selectedCluster'),
			TYPE
		),
		(
			SELECT clientId AS '@id',
			clientName AS '@name'
			FROM @ClusterList
			FOR XML PATH ('clusterList'),
			TYPE
		) --AS 'clusterList'
		FOR XML PATH ('nasClusterProperties'))
	END
	ELSE
	BEGIN
			SET @xmlText =
			(SELECT 0 AS '@clusterSetting',
			(
				SELECT clientId AS '@id',
				clientName AS '@name'
				FROM @ClusterList
				FOR XML PATH ('clusterList'),
				TYPE
			)
			FOR XML PATH('nasClusterProperties'))
	END
	--	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNasClusterProperties')
	delete from GxQscripts where name = 'AppGetNasClusterProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNasClusterProperties')
	delete from GXDBVersions where aliasname = 'AppGetNasClusterProperties'
GO

insert into GXDBVersions values(2, 'AppGetNasClusterProperties',  '00010003008600010000', 'AppGetNasClusterProperties', '00010003008600010000')
GO

