

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNFSSubClientForWQ.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNFSSubClientForWQ.sp,v $ $Id: AppGetNFSSubClientForWQ.sp,v 1.1.2.1 2017/03/23 10:47:44 jrobert Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetNFSSubClientForWQ <<<'

IF EXISTS (select * from sysobjects where name='AppGetNFSSubClientForWQ')
	drop procedure AppGetNFSSubClientForWQ
IF EXISTS (select * from GxQscripts where name='AppGetNFSSubClientForWQ')
	delete from GxQscripts where name = 'AppGetNFSSubClientForWQ'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNFSSubClientForWQ')
	delete from GXDBVersions where aliasname = 'AppGetNFSSubClientForWQ'
GO
print '... Creating Procedure: AppGetNFSSubClientForWQ'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNFSSubClientForWQ
  @i_clientId INT,
  @i_subClientId INT
AS
  DECLARE @subclientXML XML
DECLARE @NFSSubclientId INT = 0
DECLARE @subclientEntityXML XML = ''
IF (@i_clientId IS NOT null AND @i_clientId <> 0)
BEGIN
	SET @NFSSubclientId = ISNULL((SELECT TOP 1 AP.id FROM APP_Application AS AP WITH(NOLOCK)
														INNER JOIN APP_SubClientProp AS SCP WITH(NOLOCK) ON AP.id = SCP.componentNameId
WHERE SCP.attrName = '3dfs Is NFS Share Enabled' AND SCP.attrVal = '1' AND SCP.modified = 0 AND AP.clientId = @i_clientId), 0)
END
ELSE IF(@i_subClientId IS NOT null AND @i_subClientId <> 0)
BEGIN
	SET @NFSSubclientId = ISNULL((SELECT TOP 1 AP.id FROM APP_Application as AP WITH(NOLOCK)
														INNER JOIN APP_SubClientProp AS SCP WITH(NOLOCK) ON AP.id = SCP.componentNameId
														INNER JOIN APP_SubClientProp AS SCP1 WITH(NOLOCK) ON SCP.componentNameId = SCP1.componentNameId
WHERE SCP.attrName = 'Associated subclient Policy' AND CAST(SCP.attrVal AS INT) = @i_subClientId AND SCP1.attrName = '3dfs Is NFS Share Enabled' AND SCP1.attrVal = '1'
														AND SCP.modified = 0 AND SCP1.modified = 0), 0)
														--Get subclient ids from subclient policy's subclient association and join it with App_Application
END
IF @NFSSubclientId <> 0
BEGIN
	SET @subclientEntityXML = (SELECT 7 as '@_type_',
								client.id as '@clientId',
								client.name as '@clientName',
								ida.type as '@applicationId',
								ida.name as '@appName',
								instance.id as '@instanceId',
								instance.name as '@instanceName',
								backupset.id as '@backupsetId',
								backupset.name as '@backupsetName',
								subclient.id as '@subclientId',
								subclient.subclientName as '@subclientName'
								FROM APP_Application AS subclient WITH(NOLOCK)
									INNER JOIN APP_BackupSetName AS backupset WITH(NOLOCK)
										ON subclient.id = @NFSSubclientId AND subclient.backupSet = backupset.id
									INNER JOIN APP_InstanceName AS instance WITH(NOLOCK)
										ON subclient.instance = instance.id
									INNER JOIN APP_IDAType AS ida WITH(NOLOCK)
										ON subclient.appTypeId = ida.type
									INNER JOIN APP_Client AS client WITH(NOLOCK)
										ON subclient.clientId = client.id
								FOR XML PATH('CvEntities_SubClientEntity'))
END
SELECT @subclientEntityXML
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNFSSubClientForWQ')
	delete from GxQscripts where name = 'AppGetNFSSubClientForWQ'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNFSSubClientForWQ')
	delete from GXDBVersions where aliasname = 'AppGetNFSSubClientForWQ'
GO

insert into GXDBVersions values(2, 'AppGetNFSSubClientForWQ',  '00010001000200010000', 'AppGetNFSSubClientForWQ', '00010001000200010000')
GO

