

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNFSStoreInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNFSStoreInfo.sp,v $ $Id: AppGetNFSStoreInfo.sp,v 1.1.2.1 2018/08/01 21:17:49 bhegde Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetNFSStoreInfo()
--  |
--  | Description:
--  |
--  |       Input:
--  |      Output: List of nfs servers with index server and
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetNFSStoreInfo <<<'

IF EXISTS (select * from sysobjects where name='AppGetNFSStoreInfo')
	drop procedure AppGetNFSStoreInfo
IF EXISTS (select * from GxQscripts where name='AppGetNFSStoreInfo')
	delete from GxQscripts where name = 'AppGetNFSStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNFSStoreInfo')
	delete from GXDBVersions where aliasname = 'AppGetNFSStoreInfo'
GO
print '... Creating Procedure: AppGetNFSStoreInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNFSStoreInfo
  @i_xml XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @xmlResult XML
DECLARE @nfsShares XML
DECLARE @NFSSharesXML TABLE(shares XML)
DECLARE @GetNFSShareInput XML
DECLARE @userId INT =ISNULL((SELECT @i_xml.value('(App_GetNfsObjectStoreInfoReq/processinginstructioninfo/user/@userId)[1]','INT')),0)
IF OBJECT_ID('temp.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
IF OBJECT_ID('temp.dbo.#userSPs') IS NOT NULL DROP TABLE #userSPs
CREATE TABLE #userClients
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
CREATE TABLE #userSPs(storagePolicyId INT)
IF(@userID<>0)
BEGIN
	EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
	EXEC sec_getNonIdaObjectsForThisUser @userId, 17 /*STORAGE_POLICY_ENTITY*/ , 0, '#userSPs'
END
SET @GetNFSShareInput =
	(SELECT
		(SELECT
			(SELECT @userID as '@userId'
			FOR XML PATH('user'), TYPE)
		FOR XML PATH('processinginstructioninfo'), TYPE)
	FOR XML PATH('App_GetNFSShareReq'), TYPE)
INSERT INTO @NFSSharesXML
EXEC AppGetNFSShare @GetNFSShareInput
SELECT TOP 1 @nfsShares = shares FROM @NFSSharesXML
SET	@xmlResult =
		(SELECT
			(SELECT
				nfsShares.share.value('@isInProcess', 'integer') as '@status',
				(SELECT
					nfsShares.share.value('@clientId', 'integer') as '@clientId',
					nfsShares.share.value('@clientName', 'varchar(1024)') as '@clientName'
				FOR XML PATH('nfsObjStoreClient'), TYPE),
				(SELECT
					userIdxC.t_clientId as '@clientId',
					appIdxC.name as '@clientName'
				FOR XML PATH('indexServer'), TYPE),
				(SELECT
					appServC.id as '@mediaAgentId',
					nfsShares.share.value('@nfsServerName', 'varchar(1024)') as '@mediaAgentName'
				FOR XML PATH('nfsServer'), TYPE),
				(SELECT
					nfsShares.share.value('@subclientId', 'integer') as '@subclientId',
					nfsShares.share.value('@subclientName', 'varchar(1024)') as '@subclientName'
				FOR XML PATH('nfsObjectStore'), TYPE),
				(SELECT
					appA.subclientName as '@subclientPolicyName',
					nfsShares.share.value('@nfsSCPolicyId', 'integer') as '@subclientPolicyId'
				FOR XML PATH('scpEntity'), TYPE),
				(SELECT
					uSPs.storagePolicyId as '@storagePolicyId',
					archG.name as '@storagePolicyName'
				FOR XML PATH('dataSP'), TYPE)
			FROM @nfsShares.nodes('/App_GetNFSShareResp/nfsShares') as nfsShares(share)
				LEFT JOIN APP_Client appServC ON appServC.name = nfsShares.share.value('@nfsServerName', 'varchar(1024)') -- For nfs server client id
				INNER JOIN App_EdgeDriveAssociation appE ON appE.clientId =  nfsShares.share.value('@clientId', 'integer') -- For getting index server associated to object store
				LEFT JOIN #userClients userIdxC ON appE.entityId =  userIdxC.t_clientId -- For security, we just dont want user to see index server
				LEFT JOIN APP_Client appIdxC ON appIdxC.id = userIdxC.t_clientId -- For Index server name
				INNER JOIN APP_Application appA ON appA.id = nfsShares.share.value('@nfsSCPolicyId', 'integer')  -- For getting subclient policy name
				LEFT JOIN #userSPs uSPs ON uSPs.storagePolicyId = appA.dataArchGrpID -- For security, we just dont want user to see storage policy
				LEFT JOIN archGroup archG ON archG.id = uSPs.storagePolicyId -- For getting storage policy associated with subclient policy
			WHERE
				appE.entityType = 3 -- Index Server Entity type
			FOR XML PATH('nfsObjectStoreInfoList'), TYPE)
		FOR XML PATH('App_GetNfsObjectStoreInfoResp'), TYPE)
SELECT @xmlResult
IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
IF OBJECT_ID('tempdb.dbo.#userSPs') IS NOT NULL DROP TABLE #userSPs
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNFSStoreInfo')
	delete from GxQscripts where name = 'AppGetNFSStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNFSStoreInfo')
	delete from GXDBVersions where aliasname = 'AppGetNFSStoreInfo'
GO

insert into GXDBVersions values(2, 'AppGetNFSStoreInfo',  '00010001000200010000', 'AppGetNFSStoreInfo', '00010001000200010000')
GO

