

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNFSShare.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNFSShare.sp,v $ $Id: AppGetNFSShare.sp,v 1.1.2.12 2018/08/01 21:17:41 bhegde Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetNFSShare()
--  |
--  | Description:
--  |
--  |       Input:
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetNFSShare <<<'

IF EXISTS (select * from sysobjects where name='AppGetNFSShare')
	drop procedure AppGetNFSShare
IF EXISTS (select * from GxQscripts where name='AppGetNFSShare')
	delete from GxQscripts where name = 'AppGetNFSShare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNFSShare')
	delete from GXDBVersions where aliasname = 'AppGetNFSShare'
GO
print '... Creating Procedure: AppGetNFSShare'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetNFSShare
  @xmlRequest XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('temp.dbo.#NFSObjectStores') IS NOT null DROP TABLE #NFSObjectStores
IF OBJECT_ID('temp.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
CREATE TABLE #userClients
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
DECLARE @xmlResult XML
DECLARE @operationType INT = ISNULL((SELECT @xmlRequest.value('(/App_GetNFSShareReq/@operation)[1]','INT')), 0)
DECLARE @clientId INT = ISNULL((SELECT @xmlRequest.value('(/App_GetNFSShareReq/@clientId)[1]','INT')), 0)
DECLARE @clientName NVARCHAR(MAX) = (SELECT name FROM APP_Client WHERE id = @clientId)
DECLARE @userId INT =ISNULL((SELECT @xmlRequest.value('(App_GetNFSShareReq/processinginstructioninfo/user/@userId)[1]','INT')),0)
-- Client ID is required for operations GetAssociatedObjectStore, GetObjectStoreStatus
IF (@operationType = 2 OR @operationType = 1) AND @clientId <= 0
BEGIN
	SET	@xmlResult =
				(SELECT
					(SELECT 1 as '@errorCode',
						    'Error: Client ID is required for the Operation: ' + CAST(@operationType AS NVARCHAR(3)) as '@errorMessage'
					FOR XML PATH('errorResp'), TYPE)
				FOR XML PATH('App_GetNFSShareResp'), TYPE)
	GOTO EXIT_PROCEDURE
END
IF(@userID<>0)
BEGIN
	EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
END
ELSE
BEGIN
	--For Objecstore CLI return all clients, visible clients are filter in CLI layer.
	INSERT INTO #userClients(t_clientId)
	SELECT id
	FROM APP_Client
END
CREATE TABLE #NFSObjectStores(clientId INT, subclientId INT, subclientName NVARCHAR(128),
								subclientStatus INT, is3dfsEnabled NVARCHAR(3), isInProcess NVARCHAR(3),
								NFSServers NVARCHAR(MAX), scPolicyId INT);
-- Collect All required Object Stores and it properties
WITH NFSObjectStoresAndProps(clientId, subclientId, subclientName, subclientStatus, attrName, attrVal)
AS
(
SELECT sc.clientId as clientId, sc.id as subclientId, sc.subclientName as subclientName,
			sc.subclientStatus as subclientStatus, scProp.attrName as attrName,
			scProp.attrVal as attrVal
		FROM APP_Application sc JOIN
		APP_SubClientProp scProp ON sc.id = scProp.componentNameId
									AND scProp.attrName IN ('3dfs Is NFS Share Enabled','3dfs config operation in process',
															'Associated subclient Policy', '3dfs NFS Servers')
									AND scProp.modified = 0
		WHERE @operationType <> 2 OR (@operationType = 2 AND (sc.clientId = @clientId OR sc.clientId = 2)) -- To get subclient policy as well .. which is associated commserv
)
INSERT INTO #NFSObjectStores
SELECT clientId, subclientId, subclientName,
		subclientStatus, [3dfs Is NFS Share Enabled] as is3dfsEnabled, ISNULL([3dfs config operation in process], 0) as isInProcess,
		[3dfs NFS Servers]  as NFSServers, [Associated subclient Policy] scPolicyId
FROM
	(
		SELECT clientId, subclientId, subclientName, subclientStatus, attrName, attrVal
		FROM NFSObjectStoresAndProps
	) as EdfsSCProp
	PIVOT
	(
		MAX(attrVal)
		FOR attrName IN ( [3dfs Is NFS Share Enabled], [3dfs config operation in process], [Associated subclient Policy], [3dfs NFS Servers])
	) AS PivotTable
-- Update NFS Servers field from subclient ppolicy to main table.
-- Old Object Store Command Line behaviour is handled in this query
-- Filter Out nfsServers which are not visible to userClients
UPDATE ObjectStore1
SET ObjectStore1.NFSServers = ObjectStore2.NFSServers
FROM [#NFSObjectStores] ObjectStore1
	JOIN [#NFSObjectStores] ObjectStore2 ON ObjectStore1.scPolicyId = ObjectStore2.subclientId
	JOIN APP_Client appC ON appC.name = ObjectStore2.NFSServers
	JOIN [#userClients] userC ON userC.t_clientId = appC.id
WHERE
	ObjectStore1.NFSServers IS NULL
	AND ObjectStore2.NFSServers IS NOT NULL
SET	@xmlResult =
				(SELECT
					(SELECT oStore.subclientId AS '@subclientId',
							oStore.clientId AS '@clientId',
							client.name '@clientName',
							oStore.subclientName AS '@subclientName',
							oStore.subclientStatus AS '@SubclientStatus',
							oStore.nfsServers AS '@nfsServerName',
							oStore.scPolicyId AS '@nfsSCPolicyId',
							oStore.isInProcess AS '@isInProcess'
					FROM [#NFSObjectStores] oStore
						INNER JOIN APP_Client client ON oStore.clientId = client.id
						INNER JOIN #userClients ucl ON oStore.clientId = ucl.t_clientId -- Filter client which are visible to users
					WHERE oStore.scPolicyId > 0 --Make sure that no sc policy is returned
					AND oStore.is3dfsEnabled = 1
					AND (@operationType <> 1
						OR (@operationType = 1
							AND (CAST(@clientId AS NVARCHAR(64)) = oStore.NFSServers
								OR oStore.NFSServers = @clientName)))
					FOR XML PATH('nfsShares'), TYPE)
				FOR XML PATH('App_GetNFSShareResp'), TYPE)
EXIT_PROCEDURE:
SELECT @xmlResult
IF object_id('temp.dbo.#NFSObjectStores') IS NOT null DROP TABLE #NFSObjectStores
IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNFSShare')
	delete from GxQscripts where name = 'AppGetNFSShare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNFSShare')
	delete from GXDBVersions where aliasname = 'AppGetNFSShare'
GO

insert into GXDBVersions values(2, 'AppGetNFSShare',  '00010001000200120000', 'AppGetNFSShare', '00010001000200120000')
GO

