

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNFSObjectStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNFSObjectStore.sp,v $ $Id: AppGetNFSObjectStore.sp,v 1.1.2.10.14.1 2021/05/15 17:49:05 sagarmd Exp $";
--	+=================================================================================================+
--	| AppGetNFSObjectStore - Get list of NFS object Stores or specific store
--	+=================================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetNFSObjectStore')
BEGIN
	print '>>> Drop Stored Procedure: AppGetNFSObjectStore <<<'
	drop procedure AppGetNFSObjectStore
END
IF EXISTS (select * from GxQscripts where name='AppGetNFSObjectStore')
	delete from GxQscripts where name = 'AppGetNFSObjectStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNFSObjectStore')
	delete from GXDBVersions where aliasname = 'AppGetNFSObjectStore'
GO
print '... Creating Procedure: AppGetNFSObjectStore'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetNFSObjectStore
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML ,
  @o_xmlResp NVARCHAR(MAX) OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
-----------------------------------------------------------
AS
  DECLARE @r_xmlString XML;
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @o_errCode = 0 -- BE OPTIMISTIC
	SET @o_errString = ''
	BEGIN TRY
	 DECLARE @i_userId INTEGER=0
     SET @i_userId = ISNULL((SELECT  ref.value('@userId', 'INT')
                              FROM    @xmlString.nodes('App_GetNFSStoreReq/processinginstructioninfo/user') R ( ref )),0)
	 DECLARE @localeId INT = 0
	 SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'INT')
                              FROM    @xmlString.nodes('App_GetNFSStoreReq/processinginstructioninfo/locale') R ( ref )),0)
	 DECLARE @opType INT= ISNULL((SELECT  ref.value('@opType', 'INT')
                              FROM    @xmlString.nodes('App_GetNFSStoreReq') R ( ref )),0)
	 DECLARE @propertyLevel INT= ISNULL((SELECT  ref.value('@propertyLevel', 'INT')
                              FROM    @xmlString.nodes('App_GetNFSStoreReq') R ( ref )),0)
	 DECLARE @clientId INT= ISNULL((SELECT  ref.value('@clientId', 'INT')
                              FROM    @xmlString.nodes('App_GetNFSStoreReq/nfsStorePseudoClient') R ( ref )),0)
	 DECLARE @subclientId INT= ISNULL((SELECT  ref.value('@subclientId', 'INT')
                              FROM    @xmlString.nodes('App_GetNFSStoreReq/nfsStoreSubclient') R ( ref )),0)
	 IF OBJECT_ID('tempdb.dbo.#subclientwithViewCapability') IS NOT NULL DROP TABLE #subclientwithViewCapability
	 CREATE TABLE #subclientwithViewCapability (client INT, apptype INT, instance INT, backupset INT, subclient INT)
	 IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
	 CREATE TABLE #clientList
			(
				storeClientId						INT,
				storeClientName						NVARCHAR(256),
				subclientId							INT,
				subclientName						NVARCHAR(128),
				isDefaultBackupSet					INT,
				subclientIdOfSubclientPolicy		INT,
				subclientNameOfSubclientPolicy		NVARCHAR(128),
				subclientPolicyId					INT,
				subclientPolicyName					NVARCHAR(128),
				storagePolicyId						INT,
				storagePolicyName					NVARCHAR(144),
				indexServerClientId					INT,
				indexServerClientName				NVARCHAR(512),
				solrNFSIndexPath					NVARCHAR(1024),
				status								INT,
				statusString						NVARCHAR(512),
				nfsClients							NVARCHAR(MAX),
				nfsServerClientName					NVARCHAR(128),
				nfsServerClientID					INT,
				nfsCachePath						NVARCHAR(1024),
				accessType							INT,
				useVersions							INT,
				squashType							INT,
				enableAcls							INT,
				anonUID								BIGINT,
				anonGID								BIGINT,
				nfsObjBackupFilter					NVARCHAR(512),
				dataAgingDays						INT,
				dataAgingVersions					INT,
				deletedItemDays						INT,
				webServerURL						NVARCHAR(1024),
				pitXML								NVARCHAR(MAX),
				planId								INT,
planName							NVARCHAR(255),
				protocols							XML,
				isCaseSensitive						INT,
				versionInterval						INT
			)
		IF OBJECT_ID('tempdb.dbo.#subClientPropDetails') IS NOT NULL DROP TABLE #subClientPropDetails
		CREATE TABLE #subClientPropDetails
			(
				subclientId							INT,
				status								int,
				statusString						NVARCHAR(512),
				nfsClients							NVARCHAR(MAX),
				nfsServerClientName					NVARCHAR(128),
				nfsServerClientID					INT,
				nfsCachePath						NVARCHAR(1024),
				accessType							INT,
				useVersions							INT,
				squashType							INT,
				enableAcls							INT,
				anonUID								BIGINT,
				anonGID								BIGINT,
				nfsObjBackupFilter					NVARCHAR(512),
				dataAgingDays						INT,
				dataAgingVersions					INT,
				deletedItemDays						INT,
				webServerURL						NVARCHAR(1024),
				pitXML								NVARCHAR(MAX),
				protocols							XML,
				isCaseSensitive						INT,
				versionInterval						INT
			)
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
			(     serverURL NVARCHAR(512),
					clientId INT,
					clientName NVARCHAR(256),
					cloudId INT,
					hostName NVARCHAR(256),
					basePort INT,
					engineName  NVARCHAR(256),
					serverType INT,
					indexServerClientId INT,
					internalCloudName NVARCHAR(256)
			)
		IF ((@opType = 1) AND (@clientId = 0))
		BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @localeId)
			SET @o_errString = REPLACE(@o_errString, '^1%s', 'Client Id')
			Goto OUTPUT
		END
		IF ((@opType = 2) AND (@subclientId = 0))
		BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @localeId)
			SET @o_errString = REPLACE(@o_errString, '^1%s', 'Subclient Id')
			Goto OUTPUT
		END
		-- Any permission
EXEC sec_getIdaObjectsForUser @i_userId, 7, 0, 0,  '#subclientwithViewCapability'
		INSERT INTO #clientList(storeClientId, storeClientName, subclientId, subclientName, isDefaultBackupSet, subclientIdOfSubclientPolicy, subclientNameOfSubclientPolicy, subclientPolicyId, subclientPolicyName, storagePolicyId, storagePolicyName, indexServerClientId, indexServerClientName, planId, planName)
		SELECT AC.id, AC.displayName, AAP.id, AAP.subclientName,(CASE WHEN ABP2.id IS NULL THEN 0 ELSE 1 END), AAP2.id, AAP2.subclientName, ABP.id, ABP.name, AAP2.dataArchGrpID, AG.name, AC2.id, AC2.displayName , AP.id, AP.name
		FROM #subclientwithViewCapability SC
		INNER JOIN APP_Application AAP
			ON AAP.id=SC.subclient
		INNER JOIN APP_Client AC
			ON AC.id=AAP.clientId
		INNER JOIN APP_ClientProp ACP1
ON ACP1.componentNameId=AC.id AND ACP1.attrName='System Drive Type' AND ACP1.attrVal='4' AND ACP1.modified=0
		INNER JOIN APP_SubClientProp ASCP
ON ASCP.componentNameId=AAP.id AND ASCP.attrName='Associated subclient Policy' AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
		INNER JOIN APP_Application AAP2
			ON CAST(AAP2.id AS NVARCHAR(32))=ASCP.attrval AND AAP2.appTypeId=1030
		INNER JOIN archGroup AG
			ON AG.id=AAP.dataArchGrpID
		INNER JOIN APP_BackupSetName ABP
			ON ABP.id=AAP2.backupSet
		LEFT OUTER JOIN App_EdgeDriveAssociation AEA
			ON AEA.clientId=AC.id AND AEA.entityType=3
		LEFT OUTER JOIN APP_Client AC2
			ON AC2.id=AEA.entityId
		LEFT OUTER JOIN APP_BackupSetName ABP2				-- don't include default backupset ever
ON ABP2.id=AAP.backupSet AND ABP2.status&0x00008=0x00008
		LEFT OUTER JOIN APP_ClientProp ACP2
ON ACP2.componentNameId=AC.id AND ACP2.attrName='Associated Plan' AND ACP2.modified=0
		LEFT OUTER JOIN APP_PLAN AP
ON CAST(AP.id AS NVARCHAR(32))=ACP2.attrVal AND (AP.flag & 0x00004 = 0) AND (AP.flag & 0x40000000 = 0)
		WHERE (((@opType = 0)) OR ((@opType = 1) AND (@clientId = AC.id)) OR ((@opType = 2) AND (@subclientId = AAP.id)))
		IF ((@opType = 1) OR (@opType = 2)) AND NOT EXISTS (SELECT 1 FROM #clientList)
		BEGIN
			SET @o_errCode=5
			SET @o_errString='Access Denied'
			Goto OUTPUT
		END
		IF ((@subclientId IS NULL)  OR (@subclientId=0))
		BEGIN
			DELETE CL
				FROM #clientList CL
				INNER JOIN #clientList CL2
					ON CL2.storeClientId=CL.storeClientId AND CL2.isDefaultBackupSet=0 AND CL.isDefaultBackupSet=1
		END
		INSERT INTO #subClientPropDetails (subclientId, status, statusString, nfsClients, nfsServerClientName, accessType, useVersions, squashType, enableAcls, anonUID, anonGID, nfsObjBackupFilter, dataAgingDays, dataAgingVersions, deletedItemDays, webServerURL, pitXML, protocols, isCaseSensitive, versionInterval)
        SELECT  componentNameId								AS subclientId,
                [3dfs config operation in process]			AS status,
				[3dfs Config status string]					AS statusString,
				[3dfs Allowed NFS Clients]					AS nfsClients,
                [3dfs NFS Servers]							AS nfsServerClientName,
                [3dfs Access Permission]					AS accessType,
                [3dfs version support needed]				AS useVersions,
                [3dfs Squash Type]							AS squashType,
                [3dfs ACL enable flag]						AS enableAcls,
                [3dfs Anonymous UID]						AS anonUID,
				[3dfs Anonymous GID]						AS anonGID,
                [3dfs Backup Filter]						AS nfsObjBackupFilter,
                [Grace Period For Versions]					AS dataAgingDays,
                [Versions in Drive]							AS dataAgingVersions,
                [Trash Can Retention]						AS deletedItemDays,
				[Edge Web Server URL]						AS webServerURL,
				[3dfs View Configuration]					AS pitXML,
				[3dfs Supported Protocols]					AS protocols,
				[3dfs Case Sensitive]						AS isCaseSensitive,
				[3dfs Version Interval Minutes]				AS versionInterval
        FROM (
                SELECT
                    componentNameId,
                    attrName,
                    attrVal
                FROM
                    APP_SubClientProp ASCP
                WHERE
                    ASCP.modified = 0
                    AND attrName IN (   '3dfs config operation in process',
										'3dfs Config status string',
										'3dfs Allowed NFS Clients',
                                        '3dfs NFS Servers',
                                        '3dfs Access Permission',
                                        '3dfs version support needed',
                                        '3dfs Squash Type',
                                        '3dfs ACL enable flag',
                                        '3dfs Anonymous UID',
                                        '3dfs Anonymous GID',
                                        '3dfs Backup Filter',
                                        'Grace Period For Versions',
                                        'Versions in Drive' ,
                                        'Trash Can Retention',
										'Edge Web Server URL',
										'3dfs View Configuration',
										'3dfs Supported Protocols',
										'3dfs Case Sensitive',
										'3dfs Version Interval Minutes'
                            )
					AND cs_attrName IN (    CHECKSUM(N'3dfs config operation in process'),
											CHECKSUM(N'3dfs Config status string'),
											CHECKSUM(N'3dfs Allowed NFS Clients'),
											CHECKSUM(N'3dfs NFS Servers'),
											CHECKSUM(N'3dfs Access Permission'),
											CHECKSUM(N'3dfs version support needed'),
											CHECKSUM(N'3dfs Squash Type'),
											CHECKSUM(N'3dfs ACL enable flag'),
											CHECKSUM(N'3dfs Anonymous UID'),
											CHECKSUM(N'3dfs Anonymous GID'),
											CHECKSUM(N'3dfs Backup Filter'),
											CHECKSUM(N'Grace Period For Versions'),
											CHECKSUM(N'Versions in Drive'),
											CHECKSUM(N'Trash Can Retention'),
											CHECKSUM(N'Edge Web Server URL'),
											CHECKSUM(N'3dfs View Configuration'),
											CHECKSUM(N'3dfs Supported Protocols'),
											CHECKSUM(N'3dfs Case Sensitive'),
											CHECKSUM(N'3dfs Version Interval Minutes')
                            )
					AND componentNameId in (SELECT subclientId from #clientList
											UNION
											SELECT subclientIdOfSubclientPolicy from #clientList )
            ) AS subclients
        PIVOT   (   MAX(attrVal) FOR attrName IN (  [3dfs config operation in process],
													[3dfs Config status string],
													[3dfs Allowed NFS Clients],
                                                    [3dfs NFS Servers],
                                                    [3dfs Access Permission],
                                                    [3dfs version support needed],
                                                    [3dfs Squash Type],
                                                    [3dfs ACL enable flag],
                                                    [3dfs Anonymous UID],
                                                    [3dfs Anonymous GID],
                                                    [3dfs Backup Filter],
                                                    [Grace Period For Versions],
                                                    [Versions in Drive] ,
                                                    [Trash Can Retention],
													[Edge Web Server URL],
													[3dfs View Configuration],
													[3dfs Supported Protocols],
													[3dfs Case Sensitive],
													[3dfs Version Interval Minutes]
                )
            ) AS P
			UPDATE #subClientPropDetails
			SET nfsServerClientID = (SELECT TOP 1 id  FROM APP_Client WHERE displayName=nfsServerClientName)
			UPDATE  SCPD
			SET SCPD.nfsCachePath=IDXA.Path
			FROM #subClientPropDetails SCPD
			INNER JOIN IdxAccessPath IDXA
				ON IDXA.ClientId=SCPD.nfsServerClientID
			INNER JOIN IdxCache IDXC
				ON IDXC.IdxCacheId = IDXA.IdxCacheId AND IDXC.IdxCacheType=3
			UPDATE CL
			SET
				CL.status=subclient.status,
				CL.statusString=subclient.statusString,
				CL.nfsClients=subclientPolicy.nfsClients,
				CL.nfsServerClientName=subclientPolicy.nfsServerClientName,
				CL.nfsServerClientID=subclientPolicy.nfsServerClientID,
				CL.nfsCachePath=subclientPolicy.nfsCachePath,
				CL.accessType=subclientPolicy.accessType,
				CL.useVersions=subclientPolicy.useVersions,
				CL.squashType=subclientPolicy.squashType,
				CL.enableAcls=subclientPolicy.enableAcls,
				CL.anonUID=subclientPolicy.anonUID,
				CL.anonGID=subclientPolicy.anonGID,
				CL.nfsObjBackupFilter=subclientPolicy.nfsObjBackupFilter,
				CL.dataAgingDays=subclientPolicy.dataAgingDays,
				CL.dataAgingVersions=subclientPolicy.dataAgingVersions,
				CL.deletedItemDays=subclientPolicy.deletedItemDays,
				CL.webServerURL=subclientPolicy.webServerURL,
				CL.pitXML=subclient.pitXML,
				CL.protocols=subclientPolicy.protocols,
				CL.isCaseSensitive=subclientPolicy.isCaseSensitive,
				CL.versionInterval=subclientPolicy.versionInterval
		FROM #clientList CL
		INNER JOIN #subClientPropDetails subclient
			ON subclient.subclientId=CL.subclientId
		LEFT OUTER JOIN #subClientPropDetails subclientPolicy
			ON subclientPolicy.subclientId=CL.subclientIdOfSubclientPolicy
		--Get All index server with NFS Index Role
		-- Will poppulate data in #getIndexServers
		EXEC DM2GetIndexServers 'NFS Index', 0/*i_indexServerClientId*/, 0 /*i_cloudId*/, 0 /*i_nodeClientId*/, 1 /*i_status*/
		UPDATE CL
			SET solrNFSIndexPath = Cache.nfsCacheLocation
		FROM #clientList CL
		INNER JOIN #getIndexServers GIS
			ON GIS.indexServerClientId=CL.indexServerClientId
		INNER JOIN (SELECT dm.cloudId AS cloudId,ref.value('@value', 'NVARCHAR(1024)') AS nfsCacheLocation
						FROM DM2Cloud DM
						CROSS APPLY (select CAST(DM.CloudProps AS xml)) as T(X)
						CROSS APPLY T.X.nodes('/CloudMetaProp/cloudMetaInfos') as R(ref)
						WHERE ref.value('@name', 'NVARCHAR(1024)')='INDEXLOCATION') Cache
			ON Cache.cloudId=GIS.cloudId
OUTPUT:
			SET @o_xmlResp =(SELECT
									(SELECT status '@status', statusString '@statusString', accessType '@accessType', useVersions '@useVersions', squashType '@squashType',
											enableAcls '@enableAcls', anonUID '@anonUID', anonGID '@anonGID', nfsObjBackupFilter '@nfsObjBackupFilter',
											nfsCachePath '@nfsCachePath', solrNFSIndexPath '@solrNFSIndexPath',
											dataAgingDays '@dataAgingDays', dataAgingVersions '@dataAgingVersions', deletedItemDays '@deletedItemDays',
											webServerURL '@webServerURL', pitXML '@pointInTimeViews', isCaseSensitive '@isCaseSensitive', versionInterval '@versionInterval',
											CASE
												WHEN deletedItemDays = -1 Then 1
												ELSE 0
											END as '@isIndefiniteRetention',
											CASE
												WHEN dataAgingVersions > 0 Then 1
												ELSE 0
											END as '@enableRetentionRulesForVersions',
										(SELECT
											(SELECT protocolTypeList.protocolTypes.value('@val', 'int')  '@val'
												FROM  protocols.nodes('/App_HybridFileStorageProtocols/protocolTypes') as protocolTypeList(protocolTypes)
												FOR XML PATH('protocolTypes'), TYPE
											)
										FOR XML PATH('protocols'), TYPE),
										(SELECT  _ID '@val' FROM dbo.SplitStringByDelimiter(nfsClients, ',') FOR XML PATH('nfsClients'), TYPE),
( SELECT storeClientId '@clientId', storeClientName '@clientName', 3 '@_type_' FOR XML PATH('nfsStorePseudoClient'), TYPE ),
( SELECT subclientIdOfSubclientPolicy '@subclientPolicyId', subclientNameOfSubclientPolicy '@subclientPolicyName', 65 '@_type_' FOR XML PATH('scPolicyEntity'), TYPE ),
( SELECT subclientId '@subclientId', subClientName '@subclientName', 7 '@_type_' FOR XML PATH('scEntity'), TYPE ),
( SELECT planId '@planId', planName '@planName', 158 '@_type_' FOR XML PATH('plan'), TYPE ),
( SELECT indexServerClientId '@clientId', indexServerClientName '@clientName', 3 '@_type_' FOR XML PATH('indexServer'), TYPE ),
( SELECT storagePolicyId '@storagePolicyId', storagePolicyName '@storagePolicyName', 17 '@_type_' FOR XML PATH('storagePolicy'), TYPE ),
( SELECT nfsServerClientID '@mediaAgentId', nfsServerClientName '@mediaAgentName', 11 '@_type_' FOR XML PATH('nfsServer'), TYPE )
									FROM #clientList cl FOR XML PATH('nfsStores'), TYPE
									),
									( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'FOR XML PATH('errorResp'), TYPE)
								FOR XML PATH('App_GetNFSStoreResp'))
		IF OBJECT_ID('tempdb.dbo.#subclientwithViewCapability')			IS NOT NULL DROP TABLE #subclientwithViewCapability
		IF OBJECT_ID('tempdb.dbo.#clientList')							IS NOT NULL DROP TABLE #clientList
		IF OBJECT_ID('tempdb.dbo.#subClientPropDetails')				IS NOT NULL DROP TABLE #subClientPropDetails
		IF OBJECT_ID('tempdb.dbo.#getIndexServers')						IS NOT NULL DROP TABLE #getIndexServers
	END TRY
	----=====================================================================
	----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
	----=====================================================================
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errCode    = ERROR_NUMBER()
		SET @o_errString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
			SET @o_xmlResp =
								(SELECT
									( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'FOR XML PATH('errorResp'), TYPE)
								FOR XML PATH('App_GetNFSStoreResp'))
	END CATCH
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNFSObjectStore')
	delete from GxQscripts where name = 'AppGetNFSObjectStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNFSObjectStore')
	delete from GXDBVersions where aliasname = 'AppGetNFSObjectStore'
GO

insert into GXDBVersions values(2, 'AppGetNFSObjectStore',  'v1.1.2.10.14.1', 'AppGetNFSObjectStore', 'v1.1.2.10.14.1')
GO

