

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMostAvailableMemberServer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMostAvailableMemberServer.sp,v $ $Id: AppGetMostAvailableMemberServer.sp,v 1.1.2.4 2020/12/23 13:27:15 nuppu Exp $"
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetMostAvailableMemberServer')
BEGIN
	print '>>> Drop Stored Procedure: AppGetMostAvailableMemberServer <<<'
	drop procedure AppGetMostAvailableMemberServer
END
IF EXISTS (select * from GxQscripts where name='AppGetMostAvailableMemberServer')
	delete from GxQscripts where name = 'AppGetMostAvailableMemberServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMostAvailableMemberServer')
	delete from GXDBVersions where aliasname = 'AppGetMostAvailableMemberServer'
GO
print '... Creating Procedure: AppGetMostAvailableMemberServer'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetMostAvailableMemberServer
  @inPkgId INT,
  @userId INT,
  @inClientGroupId INT
AS
  DECLARE @outMemberServerId INT    
  DECLARE @outMemberServerName nvarchar(40)
SET NOCOUNT ON
	SET @outMemberServerId = 0
	SET @outMemberServerName = ''
BEGIN
	--If there are no clients with installed inPkgId, return
	IF NOT EXISTS (SELECT TOP 1 ClientId FROM simInstalledPackages (NOLOCK) WHERE simPackageID = @inPkgId)
 	BEGIN
		SELECT @outMemberServerId, @outMemberServerName
		RETURN
	END
	--User access checks are not needed  as Tenant adnmins will not be given permissions on any access nodes.
	DECLARE @members table (id INT, assoc INT)
	DECLARE @V1Clients table (id INT, instance INT, member INT, ida INT)
IF(@inPkgId = 730)
	BEGIN
		--Get all OneDrive Pseudoclients
		INSERT INTO @V1Clients SELECT distinct App.clientId, APP.instance, 0,0
		FROM APP_Application (NOLOCK)  APP
		JOIN APP_InstanceProp (NOLOCK)  Prop ON APP.instance = Prop.componentNameId AND prop.attrName = 'Cloud Apps Instance Type' AND prop.attrVal = '7'
		--Filter out V2 OneDrive pseudoclients
		Delete @V1Clients
		WHERE id IN (SELECT distinct componentNameId FROM APP_ClientProp (NOLOCK) WHERE attrname = 'Office 365 Pseudo Client' AND attrVal = 1)
		-- Get member server client Ids
		UPDATE @V1Clients
		 SET member = ISNULL(a.value('@clientId', 'int'),0)
		FROM
		(
			SELECT  v1.id AS 'pseudoId', CAST(I.attrval AS XML) AS 'proxy' 	FROM @V1Clients v1
			JOIN APP_InstanceProp (NOLOCK) I ON  I.componentNameId = v1.instance AND I.attrName = 'Proxy Clients' AND modified = 0
		)P
		 CROSS APPLY P.proxy.nodes('App_GeneralCloudProperties/proxyServers') rc(a)
		 WHERE id = P.pseudoId AND
		 a.value('@clientId', 'int') IS NOT NULL
	       OR a.value('@clientGroupId', 'int') IS NOT NULL
		--Delete pseudoclients which do not have member server associated
		DELETE @V1Clients WHERE member = 0
		--Get association count per member server
		INSERT INTO @members (id, assoc) SELECT member, count(member) FROM @V1Clients GROUP BY member
	END
IF(@inPkgId = 703)
	BEGIN
		INSERT INTO @V1Clients
		SELECT I.clientid, 0, 0, I.id
		FROM App_Client (nolock) A
		JOIN App_IdaName (nolock) I ON A.id = I.clientId
WHERE I.apptypeid = 139
		Update 	@V1Clients
		set member= ISNULL(rc.a.value('(client/@clientId)[1]', 'int'), 0)
		FROM
		(
			SELECT  v1.id AS 'pseudoId', CAST(REPLACE(I.attrval, 'utf-8', 'utf-16') AS XML) AS 'proxy'
			FROM @V1Clients v1
			JOIN App_IdaProp (NOLOCK) I ON  I.componentNameId = v1.Ida AND I.attrName = 'Azure AD Member Servers' AND I.modified = 0
		)P
		 CROSS APPLY P.proxy.nodes('App_MemberServers/memberServers') rc(a)
		 WHERE id = P.pseudoId AND
		 (rc.a.value('(client/@clientId)[1]', 'int') IS NOT NULL   OR rc.a.value('(client/@clientGroupId)[1]', 'int') IS NOT NULL)
	--Delete pseudoclients which do not have member server associated
		DELETE @V1Clients WHERE member = 0
		--Get association count per member server
		INSERT INTO @members (id, assoc) SELECT member, count(member) FROM @V1Clients GROUP BY member
	END
	--Get unAssigned member servers
	INSERT INTO @members
	SELECT ClientId, 0
	FROM simInstalledPackages (NOLOCK) sim
	JOIN App_Client (NOLOCK) C ON C.id = sim.ClientId
	WHERE sim.simPackageID = @inPkgId AND sim.ClientId NOT IN (SELECT id FROM @members)
	--Return least associated member server id
	--If clientGroup is provided, find most available access node from the input clientGroup
	DECLARE @clGroup table (id INT, assoc INT)
	IF @inClientGroupId > 0
	BEGIN
		INSERT INTO @clGroup
	 	SELECT AC.id, 0
        FROM APP_ClientGroup CG (NOLOCK)
        JOIN APP_ClientGroupAssoc CGA (NOLOCK) ON CGA.clientGroupId = CG.id
        JOIN APP_Client AC (NOLOCK) ON AC.id = CGA.clientId
        JOIN simInstalledPackages  sim (NOLOCK) ON sim.ClientId = AC.id
WHERE sim.simPackageID = @inPkgId AND CG.id = @inClientGroupId AND (AC.status &  0x00002 != 0x00002 )/*UNINSTALLED*/
AND AC.status & 0x00004 != 0x00004 /*DELETE*/
AND AC.status  & 0x00020 != 0x00020 /*Hidden*/
		IF EXISTS (SELECT top 1 id from @clGroup)
		BEGIN
			--update association count
			Update @clGroup set Assoc = T.assoc
			FROM
			(
				select member as 'member', count(member) as 'assoc' FROM @V1Clients Group BY member
			)T
			WHERE id = T.member
			SELECT  Top 1 M.id, C.name
			FROM @clGroup M
			JOIN APP_Client (NOLOCK) C ON M.id = C.id
			ORDER BY assoc
			RETURN
		END
	END
	ELSE IF EXISTS (SELECT top 1 id from @members)
	BEGIN
		SELECT  Top 1 M.id, C.name
		FROM @members M
		JOIN APP_Client (NOLOCK) C ON M.id = C.id
		ORDER BY assoc
		RETURN
	END
END
	SELECT @outMemberServerId, @outMemberServerName
	RETURN
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMostAvailableMemberServer')
	delete from GxQscripts where name = 'AppGetMostAvailableMemberServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMostAvailableMemberServer')
	delete from GXDBVersions where aliasname = 'AppGetMostAvailableMemberServer'
GO

insert into GXDBVersions values(2, 'AppGetMostAvailableMemberServer',  '00010001000200040000', 'AppGetMostAvailableMemberServer', '00010001000200040000')
GO

