

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMonitoringPolicyProp.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMonitoringPolicyProp.sp,v $ $Id: AppGetMonitoringPolicyProp.sp,v 1.3.12.3 2019/05/20 13:17:47 vdevassy Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetMonitoringPolicyProp"
--	|		:if ALLEntities <>1 , return errorCode if user dont have right any of monitoringPolicy mentoined in monitoringPolicyList
--	|        else return all monitoringPolicy user had rights on..no secuirty errorCode
--	|         propertyLevel="30"   Return Properties of all monitoringPolicy
--  |                      ="10"  Return only List of monitoringPolicy user had associations.
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetMonitoringPolicyProp')
BEGIN
	print '>>> Drop Stored Procedure: AppGetMonitoringPolicyProp <<<'
	drop procedure AppGetMonitoringPolicyProp
END
IF EXISTS (select * from GxQscripts where name='AppGetMonitoringPolicyProp')
	delete from GxQscripts where name = 'AppGetMonitoringPolicyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMonitoringPolicyProp')
	delete from GXDBVersions where aliasname = 'AppGetMonitoringPolicyProp'
GO
print '... Creating Procedure: AppGetMonitoringPolicyProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMonitoringPolicyProp
-- Input arguments
  @inOutXmlReq XML OUTPUT,
  @isReturn INT=0
AS
  DECLARE @r_ReturnResult XML;
  DECLARE @i_monitoringPolicyId INTEGER
  DECLARE @monitoringPolicyIdList TABLE (monitoringPolicyId INT)
  DECLARE @returnSecurityError    INT =0
  DECLARE @listOnly INT
  DECLARE @userId INT
  DECLARE @localeId INT
  DECLARE @propertyLevel INT
  DECLARE @errorCode  INT
  DECLARE @errorString NVARCHAR(MAX)
  DECLARE @errorXML XML
  DECLARE @xmlQuery  XML
  DECLARE @monitorPolicyName nvarchar(Max)
  DECLARE  @ALLEntities INT
  DECLARE @two BIGINT =2
  DECLARE @FinalMonitoringPolicyList TABLE  (monitoringPolicyId INT,policySecurity xml)  --ADD more properties here
  SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @inOutXmlReq.nodes('LogMonitoring_GetMonitoringPolicyRequest/processinginstructioninfo/user') R ( ref )),0)
  SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS client
                            FROM    @inOutXmlReq.nodes('LogMonitoring_GetMonitoringPolicyRequest/processinginstructioninfo/locale') R ( ref )),0)
  SET @propertyLevel    =  ISNULL((SELECT ref.value('@propertyLevel','int')
                               FROM @inOutXmlReq.nodes('LogMonitoring_GetMonitoringPolicyRequest/filterOptions') R(ref)),10)
  SET @ALLEntities= ISNULL((SELECT  ref.value('@allEntities', 'int') AS client
                    FROM    @inOutXmlReq.nodes('LogMonitoring_GetMonitoringPolicyRequest/filterOptions') R ( ref )), 0)
  IF(@ALLEntities<>1)
  BEGIN
	INSERT INTO @monitoringPolicyIdList
				SELECT ref.value('@policyId','int') AS monitoringPolicyId
				FROM @inOutXmlReq.nodes('(LogMonitoring_GetMonitoringPolicyRequest/monitoringPolicyReqList/entity)') R ( ref )
	IF EXISTS(select monitoringPolicyId from @monitoringPolicyIdList)
       SET @returnSecurityError=1
  END
  ELSE
  BEGIN
    INSERT INTO @monitoringPolicyIdList
              SELECT MonitorPolicyId from APP_MonitoringPolicy where status<>3
  END
--GET monitoringPolicy assoicated with this user
DECLARE @capability BIGINT = 0
DECLARE @monitoringPolicyAssocUser TABLE (mpid integer)
IF dbo.isNewSecurity() = 0
BEGIN
SET @capability = (power(@two, 31  -1) | power(@two, 34  -1) | power(@two, 35 -1)|power(@two, 33 -1))
	IF object_id('tempdb.dbo.#AppGetMonitoringPolicy_UserObjects') is not null DROP TABLE #AppGetMonitoringPolicy_UserObjects
create table  #AppGetMonitoringPolicy_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 9646, 0, '#AppGetMonitoringPolicy_UserObjects'
	Delete from #AppGetMonitoringPolicy_UserObjects
	WHERE   (capabilities & @capability) = 0
	if exists(
		select 1 from #AppGetMonitoringPolicy_UserObjects sec
where (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
	)
	GOTO SECURITYCHECKDONE
	INSERT INTO @monitoringPolicyAssocUser
		SELECT logMonitoringPolicyId from #AppGetMonitoringPolicy_UserObjects where logMonitoringPolicyId<>0
END
ELSE
BEGIN
	--First let us see if we have got the permissions on commcell level.
	IF OBJECT_ID('tempdb.dbo.#commcellLevelAssociations') IS NOT NULL
		DROP TABLE #commcellLevelAssociations
	CREATE TABLE #commcellLevelAssociations (permissionId INT)
EXEC sec_getPermissionsOnEntity '#commcellLevelAssociations', @userId, 1, 2
IF EXISTS (SELECT 1 FROM #commcellLevelAssociations WHERE permissionId IN (31, 109, 110, 111))
		GOTO SECURITYCHECKDONE
	IF OBJECT_ID('tempdb.dbo.#MonitoringPolicyList') IS NOT NULL
		DROP TABLE #MonitoringPolicyList
	CREATE TABLE #MonitoringPolicyList (monitoringPolicyId INT)
	--can we optimize sec_getNonIdaObjectsForThisUser to accept a permission list as input so that all 4 will be done at a single shot ?
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 31, '#MonitoringPolicyList'
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 109, '#MonitoringPolicyList'
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 110, '#MonitoringPolicyList'
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 111, '#MonitoringPolicyList'
	INSERT INTO @monitoringPolicyAssocUser
		SELECT * FROM #MonitoringPolicyList
END
DECLARE @dontHaveRightsMP  TABLE ( mpid integer)
	INSERT INTO @dontHaveRightsMP
	   select  monitoringPolicyId from @monitoringPolicyIdList where monitoringPolicyId not in (select mpid from @monitoringPolicyAssocUser)
IF EXISTS(select top 1 mpid  from @dontHaveRightsMP)
BEGIN
     IF(@returnSecurityError=1)
     BEGIN
SET @errorCode=(462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	    DECLARE @userName nvarchar(max)
		SET @userName = IsNull((select Login from UMUsers where id = @userId),'')
	    DECLARE @montioriongPolicyName  nvarchar(max)
	    SET @monitorPolicyName=ISNULL((select MonitorPolicyName from App_MonitoringPolicy where monitorPolicyId=(select top 1 mpid  from @dontHaveRightsMP)),'')
SET @errorString=(select message from EvLocaleMsgs Where messageId=(462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and [localeId] = @localeId)
	    SET @errorString=REPLACE(@errorString,'^1%s',@userName)
		IF dbo.isNewSecurity() = 0
SET @errorString=REPLACE(@errorString,'^2%s', dbo.fn_EvFormatEventMsgText(0, @localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 31), 0,2))
		ELSE
SET @errorString=REPLACE(@errorString,'^2%s', dbo.fn_EvFormatEventMsgText(0, @localeId, (Select messageId from UMPermissions WITH (NOLOCK) where id = 31), 0,2))
	    SET @errorString=REPLACE(@errorString,'^3%s',@monitorPolicyName)
	    SET @errorXML=(SELECT @errorString as '@errorString',
	                            @errorCode as '@errorCode'
	                    FOR XML PATH('error'))
	    GOTO EXITPROCEDURE
	 END
	 ELSE
	 BEGIN
		--WE dont want to return Error in this case, just delete the monitoringPolicy on which user dont have rights.
		DELETE monitoringPolicyTBL
		FROM @monitoringPolicyIdList monitoringPolicyTBL inner join @dontHaveRightsMP on monitoringPolicyId=mpid
	 END
END
SECURITYCHECKDONE:
--Now check we want properties or list only
 if(@propertyLevel=1)
 BEGIN
	SET @xmlQuery=	(SELECT monitoringPolicyId as '@monitoringPolicyid' from @monitoringPolicyIdList
						  FOR XML PATH ('monitoringPolicies'),TYPE)
	SET @errorXML=(SELECT '' as '@errorString',
		                     0 as '@errorCode'FOR XML PATH('error'))
  END
  ELSE
  BEGIN
	 --GET Properities for each monitoringPolicy, For now only getting user groups Prop
	  SET @xmlQuery =(  SELECT DISTINCT monitoringPolicyId as '@monitoringPolicyid',
                      U.id as 'creator/@userId',
					  U.userGuid 'creator/@userGUID',
					  U.login 'creator/@userName'
					  FROM @monitoringPolicyIdList  inner join APP_MonitoringPolicyProp M   on M.monitorPolicyId=monitoringPolicyId and attrName='Creater User Id'
						inner join UMUsers U on CONVERT(INT,M.attrVal)=U.id
						FOR XML PATH ('monitoringPolicies'),TYPE)
	  SET @errorXML=(SELECT '' as '@errorString',  0 as '@errorCode'FOR XML PATH('error'))
END
DELETE @monitoringPolicyIdList
  EXITPROCEDURE:
    SET @inOutXmlReq=(SELECT @xmlQuery ,
                         @errorXML FOR XML PATH ('')
                        ,ROOT('LogMonitoring_GetMonitoringPolicyResponse'))
  if(@isReturn <>0)
	  select @inOutXmlReq
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMonitoringPolicyProp')
	delete from GxQscripts where name = 'AppGetMonitoringPolicyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMonitoringPolicyProp')
	delete from GXDBVersions where aliasname = 'AppGetMonitoringPolicyProp'
GO

insert into GXDBVersions values(2, 'AppGetMonitoringPolicyProp',  '00010003001200030000', 'AppGetMonitoringPolicyProp', '00010003001200030000')
GO

