

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMonitoringPolicyBasicProp.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetMonitoringPolicyBasicProp"
--	|
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetMonitoringPolicyBasicProp')
BEGIN
	print '>>> Drop Stored Procedure: AppGetMonitoringPolicyBasicProp <<<'
	drop procedure AppGetMonitoringPolicyBasicProp
END
IF EXISTS (select * from GxQscripts where name='AppGetMonitoringPolicyBasicProp')
	delete from GxQscripts where name = 'AppGetMonitoringPolicyBasicProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMonitoringPolicyBasicProp')
	delete from GXDBVersions where aliasname = 'AppGetMonitoringPolicyBasicProp'
GO
print '... Creating Procedure: AppGetMonitoringPolicyBasicProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMonitoringPolicyBasicProp
-- Input arguments
  @userId INT
AS
  DECLARE @policyId INT;
  DECLARE @policyName NVARCHAR(MAX); 
  DECLARE @description NVARCHAR(MAX); 
  DECLARE @status INT;
  DECLARE @monType INT;
  DECLARE @templateName NVARCHAR(MAX);
  DECLARE @iscontinous INT;
  DECLARE @enabled INT;
  DECLARE @cloudId INT;
  DECLARE @cloudName NVARCHAR(MAX);
  DECLARE @taskId INT;
  DECLARE @associations NVARCHAR(MAX);
  DECLARE @subClientName NVARCHAR(MAX);
DECLARE @monitoringPolicyIdList TABLE (monitoringPolicyId INT)
DECLARE @errorCode  INT
DECLARE @errorString NVARCHAR(MAX)
DECLARE @OemBramdId int
SET @oemBramdId = 1
IF EXISTS (SELECT value FROM GXGlobalParam WHERE name = 'MiniBrandId')
BEGIN
        SET @OemBramdId = (SELECT TOP 1 CONVERT(INT, CONVERT(NVARCHAR, value)) FROM GXGlobalParam WHERE name = 'MiniBrandId')
END
DECLARE @oemTemplateName NVARCHAR(MAX) = (SELECT top 1 OEMName from simOEM where OEMId in (SELECT OEMId from SimMiniBrand where MiniBrandId = @OemBramdId))
SET @oemTemplateName = @oemTemplateName + ' Logs'
INSERT @monitoringPolicyIdList
SELECT M.MonitorPolicyId
FROM APP_MonitoringPolicy M WITH (NOLOCK)
WHERE status <> 3
IF NOT EXISTS (  SELECT 1
				FROM GXGlobalParam WITH(NOLOCK)
				WHERE name = N'bShowCommcellConsoleHiddenMonitoringPolicy'
					AND value = N'true')
	BEGIN
		DELETE  MD
		FROM @monitoringPolicyIdList MD , APP_MonitoringPolicy AP WITH(NOLOCK)
		WHERE MD.monitoringPolicyId = AP.monitorPolicyId
			AND AP.status <> 3
			AND (AP.MonitorPolicyName = N'EdgeAudit' )
		-- Hide DB policies created for sending logs to Syslog
		DELETE  MD
		FROM @monitoringPolicyIdList MD , APP_MonitoringPolicyProp MPProp WITH(NOLOCK)
		WHERE MD.monitoringPolicyId = MPProp.monitorPolicyId
			AND (MPProp.attrName = N'Send to Syslog')
	END
--First let us see if we have got the permissions on commcell level.
IF OBJECT_ID('tempdb.dbo.#commcellLevelAssociations') IS NOT NULL DROP TABLE #commcellLevelAssociations
CREATE TABLE #commcellLevelAssociations (permissionId INT)
EXEC sec_getPermissionsOnEntity '#commcellLevelAssociations', @userId, 1, 2
IF EXISTS (SELECT 1
			FROM #commcellLevelAssociations
WHERE permissionId IN (31, 110))
	GOTO SECURITYCHECKDONE
IF OBJECT_ID('tempdb.dbo.#MonitoringPolicyList') IS NOT NULL DROP TABLE #MonitoringPolicyList
CREATE TABLE #MonitoringPolicyList (monitoringPolicyId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 31, '#MonitoringPolicyList'
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 109, '#MonitoringPolicyList'
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 110, '#MonitoringPolicyList'
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 111, '#MonitoringPolicyList'
DELETE monitoringPolicyTBL
FROM @monitoringPolicyIdList monitoringPolicyTBL
WHERE monitoringPolicyId NOT IN (SELECT  monitoringPolicyId
									FROM #MonitoringPolicyList)
SECURITYCHECKDONE:
DECLARE @policyProp TABLE(policyId INT, policyName NVARCHAR(MAX), description NVARCHAR(MAX), status INT, monType INT, templateId INT, templateName NVARCHAR(MAX), iscontinous INT, enabled INT, cloudId INT, cloudName NVARCHAR(MAX), taskId INT, associations XML, subClientName NVARCHAR(MAX) )
INSERT @policyProp (policyId, policyName, description, status, monType, templateName, iscontinous, enabled, cloudId, cloudName, taskId, associations, subClientName)
SELECT monitoringPolicyId, AP.MonitorPolicyName, description, AP.status,  0, ' ', 0, 0, 0, '', 0, '', ' '
FROM @monitoringPolicyIdList P, APP_MonitoringPolicy AP WITH (NOLOCK)
WHERE P.monitoringPolicyId = AP.monitorPolicyId
UPDATE P
SET templateName = ( SELECT (SELECT AT.templateId '@templateId' , (CASE WHEN AT.templateId = 1 THEN @oemTemplateName ELSE AT.templateName  END ) '@templateName'
FROM APP_Template AT, APP_MonitorTemplateAssoc AMT
WHERE AT.templateId = AMT.templateId AND AMt.monitorPolicyId = P.policyId
FOR   XML PATH('LMTemplates') ,TYPE )  FOR XML PATH('MonitoringPolicy'))
FROM @policyProp P
UPDATE P
SET monType = CONVERT(INT,ISNULL(attrVal,0))
FROM @policyProp P, APP_MonitoringPolicyProp AP WITH (NOLOCK)
WHERE P.policyId = AP.monitorPolicyId AND AP.attrName = 'Monitoring Type'
--cloud Template should not be visible in monitoring policy list
DELETE @policyProp
WHERE monType = 8
 UPDATE P
SET iscontinous = CONVERT(INT,ISNULL(attrVal,0))
FROM @policyProp P, APP_MonitoringPolicyProp AP WITH (NOLOCK)
WHERE P.policyId = AP.monitorPolicyId AND AP.attrName = 'Continuous monitoring'
UPDATE P
SET enabled = CONVERT(INT,ISNULL(attrVal,0))
FROM @policyProp P, APP_MonitoringPolicyProp AP WITH (NOLOCK)
WHERE P.policyId = AP.monitorPolicyId AND AP.attrName = 'Enable CI'
UPDATE P
SET cloudId = CONVERT(INT,ISNULL(attrVal,0))
FROM @policyProp P, APP_MonitoringPolicyProp AP WITH (NOLOCK)
WHERE P.policyId = AP.monitorPolicyId AND AP.attrName = 'Cloud Id'
UPDATE P
SET taskId = CONVERT(INT,ISNULL(attrVal,0))
FROM @policyProp P, APP_MonitoringPolicyProp AP WITH (NOLOCK)
WHERE P.policyId = AP.monitorPolicyId AND AP.attrName = 'lm task id'
 IF OBJECT_ID ('tempdb.dbo.#cloudIdNames') IS NOT NULL DROP TABLE #cloudIdNames
CREATE TABLE #cloudIdNames(id INT, name NVARCHAR(MAX),clientId INT)
INSERT #cloudIdNames
EXEC AppGetLMAnalyticsNodes 1
UPDATE P
SET cloudName = C.name
FROM @policyProp P, #cloudIdNames C
WHERE P.cloudId = C.id
UPDATE P
SET cloudName = N'Cloud'
FROM @policyProp P, APP_MonitoringPolicyProp AP WITH (NOLOCK)
WHERE P.policyId = AP.monitorPolicyId AND AP.attrName = 'Cloud Policy Id' AND CONVERT(INT, attrVal) > 0
UPDATE P
SET P.associations = (SELECT  (SELECT flags as '@_type_', clientGroupId '@clientGroupId', ISNULL((SELECT name FROM APP_ClientGroup WITH (NOLOCK) WHERE id = A.clientGroupId) ,'') '@clientGroupName',
 clientId '@clientId',
  ISNULL((SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = A.clientId) ,'') as '@clientName', 0 '@type' ,( SELECT exclude '@exclude' FOR XML PATH('flags'), TYPE)
FROM APP_MonitorAssocEntity A WITH (NOLOCK)
WHERE monitorPolicyId = P.policyId
FOR   XML PATH('associations'),TYPE )  FOR XML PATH('MonitoringPolicy'))
FROM @policyProp P
UPDATE P
SET subClientName = subClient.subclientName
FROM @policyProp P, APP_MonitoringPolicyProp AP WITH (NOLOCK), APP_Application subClient WITH (NOLOCK),DM2SearchServerCoreInfo cloudTbl WITH(NOLOCK)
WHERE P.policyId = AP.monitorPolicyId
	AND AP.attrName = 'SubClient Id'
	AND CONVERT(INT, AP.attrVal) > 0
	AND CONVERT(INT, AP.attrVal) = subClient.id
	AND (cloudTbl.CloudId = P.cloudId AND cloudTbl.ClientId = subClient.clientId)
IF OBJECT_ID ('tempdb.dbo.#cloudIdNames') IS NOT NULL DROP TABLE #cloudIdNames
SELECT policyId, policyName, description, status, monType, templateName, iscontinous, enabled, cloudId,cloudName, taskId, N'<?xml version=''1.0'' encoding=''UTF-8'' ?> '+CONVERT(NVARCHAR(MAX),associations), subClientName
FROM @policyProp
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMonitoringPolicyBasicProp')
	delete from GxQscripts where name = 'AppGetMonitoringPolicyBasicProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMonitoringPolicyBasicProp')
	delete from GXDBVersions where aliasname = 'AppGetMonitoringPolicyBasicProp'
GO

insert into GXDBVersions values(2, 'AppGetMonitoringPolicyBasicProp',  '00000000000000000000', 'AppGetMonitoringPolicyBasicProp', '00000000000000000000')
GO

