

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMonitoredNodesForAlert.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMonitoredNodesForAlert.sp,v $ $Id: AppGetMonitoredNodesForAlert.sp,v 1.2.42.3 2018/03/27 08:43:33 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: List specified no of entities of specified type to be listed in "Get Started" Page from GUI
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMonitoredNodesForAlert <<<'

IF EXISTS (select * from sysobjects where name='AppGetMonitoredNodesForAlert')
	drop procedure AppGetMonitoredNodesForAlert
IF EXISTS (select * from GxQscripts where name='AppGetMonitoredNodesForAlert')
	delete from GxQscripts where name = 'AppGetMonitoredNodesForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMonitoredNodesForAlert')
	delete from GXDBVersions where aliasname = 'AppGetMonitoredNodesForAlert'
GO
print '... Creating Procedure: AppGetMonitoredNodesForAlert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMonitoredNodesForAlert
  @notifId int,
  @xmlEntityList xml Output
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @xml xml
declare @isSubscriptionBasedAlert int = 0
IF EXISTS (select 1 from NTnotificationRule where [ID] = @notifId and (status & 128)>0)
	SET @isSubscriptionBasedAlert = 1
if @isSubscriptionBasedAlert = 0
begin
-- This request shld come only for subscription based alerts. In case it comes for normal alerts also, let us return xmlEntityList
	set @xml = (select XmlEntityList from NTNotificationRule
		where id=@notifId)
	if @xml is null
	begin
		set @xml = '<?xml version="1.0" encoding="UTF-16" standalone="no" ?><CVGui_CommCellTreeNode><clients includeAll="0"/><clientGroups includeAll="0"/><libraries includeAll="0"/><mediaAgents includeAll="0"/><storagePolcies includeAll="0"/><trackingPolicies includeAll="0"/><trackingSchedules/><trackingJobs/></CVGui_CommCellTreeNode>'
	end
	set @xmlEntityList = @xml
	return
end
-- Its a subscription based alert.
-- Now we return commcell tree node xml with all client ids that have been subscribed to by end user.
declare @ntAlertTypeId int = 0
select @ntAlertTypeId=alertTypeId from NTNotificationRule
where [ID] = @notifId
if (@ntAlertTypeId=3)
begin
	IF object_id('tempdb.dbo.#entitySelectionList') is not null
		DROP TABLE #entitySelectionList
	Create Table #entitySelectionList
	(
		userId int,
		clientId int ,
		escalationLevel int ,
		flags int
	)
	-- In case people have selected this alert globally we retrieve the clients they are owners of.
	Insert into #entitySelectionList
	select NTAlertSubscriptions.userid,owners.clientId,escalationlevel,flags
	from NTAlertSubscriptions
	inner join sec_getClientOwners(1) owners
	on NTAlertSubscriptions.userId = owners.userId
	where ntRuleId = @notifId
and ((NTAlertSubscriptions.flags & 1)>0)
	and NTAlertSubscriptions.entityId1 = 0
	-- Now we remove those entries from above list where user has not selected at client level.
	delete GloballySelectedEntities
	from #entitySelectionList GloballySelectedEntities
	inner join NTAlertSubscriptions on
	GloballySelectedEntities.userid = NTAlertSubscriptions.userid and
	GloballySelectedEntities.clientId = NTAlertSubscriptions.entityId1 and
	NTAlertSubscriptions.EntityType1 = 3 and
	GloballySelectedEntities.escalationLevel = NTAlertSubscriptions.escalationLevel and
((NTAlertSubscriptions.flags & 1)=0) and
	NTAlertSubscriptions.ntRuleId = @notifId
	-- Now add entries where user has selected at client level.
	Insert into #entitySelectionList
	select NTAlertSubscriptions.userid,NTAlertSubscriptions.entityId1,escalationlevel,flags
	from NTAlertSubscriptions
	inner join sec_getClientOwners (1) owners
	on NTAlertSubscriptions.userId = owners.userId
	and owners.clientId = NTAlertSubscriptions.entityId1
	and NTAlertSubscriptions.EntityType1 = 3
	where ntRuleId = @notifId
and ((NTAlertSubscriptions.flags & 1)>0)
	-- Now retrieve all client ids and put them in commcelltreenode correctly.
	set @xml = (select distinct clientId '@clientId',app_client.name '@clientName'
			from #entitySelectionList entities
			inner join App_client on entities.clientid = app_client.id
			for xml path('clients'))
	if @xml is null
	begin
		set @xml = '<CVGui_CommCellTreeNode><clients includeAll="0"/><clientGroups includeAll="0"/><libraries includeAll="0"/><mediaAgents includeAll="0"/><storagePolcies includeAll="0"/><trackingPolicies includeAll="0"/><trackingSchedules/><trackingJobs/></CVGui_CommCellTreeNode>'
	end
	else
	begin
		set @xml = (select @xml for xml path('CVGui_CommCellTreeNode'))
	end
	set @xmlEntityList = @xml
	IF object_id('tempdb.dbo.#entitySelectionList') is not null
		DROP TABLE #entitySelectionList
	return
end
else
begin
	IF object_id('tempdb.dbo.#tblGenericEntityList') is not null
		DROP TABLE #tblGenericEntityList
	Create table #tblGenericEntityList
	(
		associationData xml
	)
	Insert into #tblGenericEntityList
	select dbo.getGenericXMLFromEntityType(entityType1,entityId1,entityType2,entityId2, entityType3,entityId3, entityType4,entityId4, entityType5,entityId5, 0, 0, 'associations')
	from NTAlertsubscriptions
	where ntRuleId = @notifId
and ((NTAlertSubscriptions.flags & 1)=1)
	set @xml = ( select associationData.query('.')
	from #tblGenericEntityList
	for xml path(''),root('CVGui_CommCellTreeNode')
	)
	set @xmlEntityList = @xml
end
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'AppGetMonitoredNodesForAlert')
	delete from GxQscripts where name = 'AppGetMonitoredNodesForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMonitoredNodesForAlert')
	delete from GXDBVersions where aliasname = 'AppGetMonitoredNodesForAlert'
GO

insert into GXDBVersions values(2, 'AppGetMonitoredNodesForAlert',  '00010002004200030000', 'AppGetMonitoredNodesForAlert', '00010002004200030000')
GO

