

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMoblieAppsForSubscription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMoblieAppsForSubscription.sp,v $ $Id: AppGetMoblieAppsForSubscription.sp,v 1.1.2.4 2018/06/29 00:44:01 riyer Exp $";
-- ===========================================================================
-- Author:		Rohit Iyer
-- Create date: 10/31/2017
-- Description:	Get list of mobile application tokens based on subscription request
-- ===========================================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMoblieAppsForSubscription <<<'

IF EXISTS (select * from sysobjects where name='AppGetMoblieAppsForSubscription')
	drop procedure AppGetMoblieAppsForSubscription
IF EXISTS (select * from GxQscripts where name='AppGetMoblieAppsForSubscription')
	delete from GxQscripts where name = 'AppGetMoblieAppsForSubscription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMoblieAppsForSubscription')
	delete from GXDBVersions where aliasname = 'AppGetMoblieAppsForSubscription'
GO
print '... Creating Procedure: AppGetMoblieAppsForSubscription'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMoblieAppsForSubscription
  @in_Xml XML
AS
BEGIN TRY
SET NOCOUNT ON
declare @i_msgId				int
declare @i_subscriptionType		int
declare @i_appType				int
DECLARE @errorCode 		int
DECLARE @errorMessage 	VARCHAR(MAX)
DECLARE @xmlText 		XML
DECLARE @subscriptionList XML
DECLARE @r_errors XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 0
SET @errorMessage = ''
SET @xmlText = @in_xml
--Table to store list of all mobile app Ids.
IF object_id('tempdb.dbo.#MessageUserAppTbl') is not null
		DROP TABLE #MessageUserAppTbl
Create Table #MessageUserAppTbl
(
	msgId	nvarchar(100),
	userId	int,
	appId		int
)
--Table to store list of all message criterias.
IF object_id('tempdb.dbo.#MessageSubscriptionCriteria') is not null
		DROP TABLE #MessageSubscriptionCriteria
Create Table #MessageSubscriptionCriteria
(
	msgId					nvarchar(100),
	subscriptionType		int,
	appType					int
)
--Table to store list of all subscribers from input XML.
IF object_id('tempdb.dbo.#SubscribersTbl') is not null
		DROP TABLE #SubscribersTbl
Create Table #SubscribersTbl
(
	msgId					nvarchar(100),
	subscriberType			int,
	subscriberId			int
)
--Table to store list of all subscriberd users from all users and user groups in input.
IF object_id('tempdb.dbo.#TargetMobileUserTbl') is not null
		DROP TABLE #TargetMobileUserTbl
Create Table #TargetMobileUserTbl
(
	msgId					nvarchar(100),
	subscriberId			int
)
--Get the list of Message subscription criterias
insert into #MessageSubscriptionCriteria(msgId, subscriptionType, appType)
select 	ISNULL(ref.value('@msgId', 'nvarchar(100)'),0),
		ISNULL(ref.value('@subscriptionType', 'int'),0),
		ISNULL(ref.value('@appType', 'int'),0)
FROM    @xmlText.nodes('Api_GetInstalledMobileAppsForSubscriptionReq/msgSubscriptions') R ( ref )
--Get the list of all subscribers for the messages
insert into #SubscribersTbl(msgId, subscriberType, subscriberId)
select 	ISNULL(ref.value('../@msgId', 'nvarchar(100)'),0),
		13,
		ISNULL(ref.value('@userId', 'int'),'')
from    @xmlText.nodes('Api_GetInstalledMobileAppsForSubscriptionReq/msgSubscriptions/users') R ( ref )
union
select 	ISNULL(ref.value('../@msgId', 'nvarchar(100)'),0),
		15,
		ISNULL(ref.value('@userGroupId', 'int'),'')
FROM    @xmlText.nodes('Api_GetInstalledMobileAppsForSubscriptionReq/msgSubscriptions/userGroups') R ( ref )
union
select 	ISNULL(ref.value('../@msgId', 'nvarchar(100)'),0),
		62,
		ISNULL(ref.value('@groupId', 'int'),'')
FROM    @xmlText.nodes('Api_GetInstalledMobileAppsForSubscriptionReq/msgSubscriptions/externalGroups') R ( ref )
insert into #TargetMobileUserTbl(msgId, subscriberId)
select distinct msgId, subscriberId		--Individual User
from #SubscribersTbl
where subscriberType = 13
UNION
select distinct A.msgId, A.subscriberId		--Users from a user group
from #SubscribersTbl A inner join UMUserGroup B with(nolock) on A.subscriberId = B.groupId
where A.subscriberType in (15,62)
delete from #SubscribersTbl
insert into #MessageUserAppTbl(msgId, userId, appId)
select distinct TMS.msgId, A.activeUserId, A.Id		--Individual Installed Apps for Users
from MDM_InstalledApp A with(NOLOCK) join UMQSDKSessions UMQ with(NOLOCK) on A.activeUserId = UMQ.userId
inner join #TargetMobileUserTbl TMS on UMQ.userId = TMS.subscriberId
inner join #MessageSubscriptionCriteria MSC on TMS.msgId = MSC.msgId
where UMQ.consoleType in (3,10,23,24) and MSC.appType = A.appType
and UMQ.hostName = A.appUUID
--delete A
--from #TargetMobileUserTbl A left outer join #MessageUserAppTbl B on A.subscriberId = B.userId
--where B.userId is null
set @subscriptionList = (select A.msgId as 'msgId',
								(select A.subscriberId as '@userId'
								for xml path('users'),type),
								(select  M.attrVal as 'appFcmTokens'
								from MDM_InstalledAppProp M with(nolock) inner join #MessageUserAppTbl N on M.componentNameId = N.appId
								where  M.attrName = 'fcmToken' and N.userId = A.subscriberId and N.msgId = A.msgId
								for xml path(''),type)
						from #TargetMobileUserTbl A
						for xml path('msgFcmTokens')
						)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF @@TRANCOUNT > 0
        ROLLBACK TRANSACTION;
END CATCH
SEND_RESPONSE:
SET @r_errors = (SELECT @errorCode 	 AS '@errorCode',
						@errorMessage AS '@errorString'
					FOR xml PATH('error'))
SET @xmlText = ( SELECT  ISNULL(@r_errors,'') , ISNULL(@subscriptionList ,'')
                 FOR xml path(''),ROOT('Api_GetInstalledMobileAppsForSubscriptionResp')
               )
SET NOCOUNT OFF
SELECT @xmlText as out_xml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMoblieAppsForSubscription')
	delete from GxQscripts where name = 'AppGetMoblieAppsForSubscription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMoblieAppsForSubscription')
	delete from GXDBVersions where aliasname = 'AppGetMoblieAppsForSubscription'
GO

insert into GXDBVersions values(2, 'AppGetMoblieAppsForSubscription',  '00010001000200040000', 'AppGetMoblieAppsForSubscription', '00010001000200040000')
GO

