

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMobilePolicyDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMobilePolicyDetails.sp,v $ $Id: AppGetMobilePolicyDetails.sp,v 1.1.2.4 2018/03/22 01:38:27 jiechen Exp $";
--	+===================================================================+
--	|  					  AppGetMobilePolicyDetails							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMobilePolicyDetails <<<'

IF EXISTS (select * from sysobjects where name='AppGetMobilePolicyDetails')
	drop procedure AppGetMobilePolicyDetails
IF EXISTS (select * from GxQscripts where name='AppGetMobilePolicyDetails')
	delete from GxQscripts where name = 'AppGetMobilePolicyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMobilePolicyDetails')
	delete from GXDBVersions where aliasname = 'AppGetMobilePolicyDetails'
GO
print '... Creating Procedure: AppGetMobilePolicyDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMobilePolicyDetails
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	-- Read the XML
	DECLARE @policyId			INT				= ISNULL (( SELECT ref.value('@policyId', 'INT')
														FROM @inXml.nodes ('Api_GetMobilePolicyReq/policy') R(ref)), 0)
	BEGIN TRY
	IF NOT EXISTS (SELECT 1 FROM App_MobilePolicy WITH (NOLOCK) WHERE mobilePolicyId = @policyId) AND @policyId <> 0
	BEGIN
SET @errorCode = (3127 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
	END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
ERROR_EXIT:
		SET @outXml = (SELECT
						(SELECT
							MP.mobilePolicyId as '@policyId',
							MP.mobilePolicyName as '@policyName',
							MP.description as '@description',
							(SELECT
								MPP.attrName as '@name',
								MPP.stringVal as '@value'
								FROM App_MobilePolicyProp MPP WITH(NOLOCK) WHERE MP.mobilePolicyId = MPP.componentId
								FOR XML PATH ('properties'), TYPE
							)
							FROM App_MobilePolicy MP WITH(NOLOCK) WHERE (MP.mobilePolicyId = @policyId OR @policyId = 0)
							FOR XML PATH ('policies'), TYPE
						),
						CASE WHEN @errorCode > 0 THEN
								(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									FOR XML PATH('error'), TYPE
								)
						END
						FOR XML PATH('Api_MobilePolicyResp'), TYPE)
	SELECT @outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMobilePolicyDetails')
	delete from GxQscripts where name = 'AppGetMobilePolicyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMobilePolicyDetails')
	delete from GXDBVersions where aliasname = 'AppGetMobilePolicyDetails'
GO

insert into GXDBVersions values(2, 'AppGetMobilePolicyDetails',  '00010001000200040000', 'AppGetMobilePolicyDetails', '00010001000200040000')
GO

