

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMessageIdToSPMap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMessageIdToSPMap.sp,v $ $Id: AppGetMessageIdToSPMap.sp,v 1.1.2.1 2018/08/01 21:07:45 evolohov Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMessageIdToSPMap <<<'

IF EXISTS (select * from sysobjects where name='AppGetMessageIdToSPMap')
	drop procedure AppGetMessageIdToSPMap
IF EXISTS (select * from GxQscripts where name='AppGetMessageIdToSPMap')
	delete from GxQscripts where name = 'AppGetMessageIdToSPMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMessageIdToSPMap')
	delete from GXDBVersions where aliasname = 'AppGetMessageIdToSPMap'
GO
print '... Creating Procedure: AppGetMessageIdToSPMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMessageIdToSPMap
  @i_xml XML
AS
  DECLARE @o_xml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
-- if this value is 0 or not specified then all messages which have corresponded stored procedure will be returned
DECLARE @messageId      INT = ISNULL((SELECT ref.value('@messageId',      'INT') FROM @i_xml.nodes ('App_MessageIdToSpReq') R(ref)), 0)
-- if messageIdsOnly value is not set explicitly then return only ids when full list messages is requested and return sp name if info on specific message is requested.
DECLARE @messageIdsOnly INT = ISNULL((SELECT ref.value('@messageIdsOnly', 'INT') FROM @i_xml.nodes ('App_MessageIdToSpReq') R(ref)), IIF(@messageId = 0, 1, 0))
SET @o_xml = ISNULL
(
    (SELECT(
        SELECT CAST(messageId AS BIGINT) & 0xffffffff              AS '@id',
               IIF(@messageIdsOnly = 1, NULL, storedProcedureName) AS '@name'
        FROM AppMapXmlMsgToSP
        WHERE messageId = @messageId OR @messageId = 0
        FOR XML PATH('rows'), TYPE)
   FOR XML PATH('App_MessageIdToSpResp'), TYPE), '<App_MessageIdToSpResp />')
SELECT @o_xml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMessageIdToSPMap')
	delete from GxQscripts where name = 'AppGetMessageIdToSPMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMessageIdToSPMap')
	delete from GXDBVersions where aliasname = 'AppGetMessageIdToSPMap'
GO

insert into GXDBVersions values(2, 'AppGetMessageIdToSPMap',  '00010001000200010000', 'AppGetMessageIdToSPMap', '00010001000200010000')
GO

