

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMessageHandler.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- Sample input:
-- i_Messagename = 'TMMsg_CreateTaskReq',  i_Level = 'messageLevel', i_Type = 'preProcess',  i_executedby = 'evmgrs', i_FeatureVersion = 0
-- i_Messagename = 'TMMsg_CreateTaskReq',  i_Level = 'messageLevel', i_Type = 'postProcess', i_executedby = 'webserver', i_FeatureVersion = 0
-- Output:
-- o_errCode = 0, input message has workflow handler in table App_MessageHandler. Output variables has details of handler workflow.
-- o_errCode = 1, input message do not have workflow handler in App_MessageHandler.
-- o_errCode = 2, input message has workflow handler in App_MessageHandler, but client id is not correct. User should give correct clientid in table App_MessageHandler.
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMessageHandler <<<'

IF EXISTS (select * from sysobjects where name='AppGetMessageHandler')
	drop procedure AppGetMessageHandler
IF EXISTS (select * from GxQscripts where name='AppGetMessageHandler')
	delete from GxQscripts where name = 'AppGetMessageHandler'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMessageHandler')
	delete from GXDBVersions where aliasname = 'AppGetMessageHandler'
GO
print '... Creating Procedure: AppGetMessageHandler'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMessageHandler
  @i_Messagename NVARCHAR(512),
  @i_Level NVARCHAR(512),
  @i_Type NVARCHAR(512),
  @i_executedby NVARCHAR(512),
  @i_FeatureVersion INT
AS
  DECLARE @o_clientId INTEGER = 0
  DECLARE @o_timeout BIGINT = 0
  DECLARE @o_errCode INTEGER = 0
  DECLARE @o_workflowname NVARCHAR(MAX)
  DECLARE @o_clientName NVARCHAR(MAX) = ''
  DECLARE @o_errString NVARCHAR(MAX) = 'Success'
BEGIN TRY
	IF EXISTS(SELECT * FROM App_MessageHandler WHERE messagename = @i_Messagename AND level = @i_Level AND type = @i_Type AND enabled = 1 AND executedby like '%'+ @i_executedby +'%' AND featureVersion = @i_FeatureVersion)
	BEGIN
		SELECT @o_workflowname = workflowname, @o_clientId = clientId, @o_timeout = timeout
			FROM App_MessageHandler
			WHERE messagename = @i_Messagename AND level = @i_Level AND type = @i_Type AND enabled = 1 AND executedby like '%'+ @i_executedby +'%' AND featureVersion = @i_FeatureVersion
		IF @o_clientId = 0
			SET @o_clientId = 2
		IF EXISTS (SELECT name FROM APP_Client WHERE id = @o_clientId)
			SET @o_clientName = (SELECT name FROM APP_Client WHERE id = @o_clientId)
		ELSE
		BEGIN
			SET @o_errCode = 2
			SET @o_errString = 'Message (' + @i_Messagename + ') is mapped to workflow(' + @o_workflowname + '), but client id(' + CAST(@o_clientId AS NVARCHAR(MAX))  + ') is invalid, please add correct clientid in table App_MessageHandler.'
		END
	END
	ELSE
	BEGIN
		SET @o_errCode = 1
		SET @o_errString = 'Message (' + @i_Messagename + ') is not mapped to workflow.'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @o_errCode = ERROR_NUMBER()
	set @o_errString = 'Error executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(VARCHAR(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @o_clientId, @o_timeout, @o_errCode, @o_workflowname, @o_clientName, @o_errString

IF EXISTS (select * from GxQscripts where name = 'AppGetMessageHandler')
	delete from GxQscripts where name = 'AppGetMessageHandler'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMessageHandler')
	delete from GXDBVersions where aliasname = 'AppGetMessageHandler'
GO

insert into GXDBVersions values(2, 'AppGetMessageHandler',  '00000000000000000000', 'AppGetMessageHandler', '00000000000000000000')
GO

