

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMediaAgentList.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetMediaAgentList()
--  | Description:  Allows for GET MA List based on specified filters
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMediaAgentList.sp,v $ $Id: AppGetMediaAgentList.sp,v 1.1.2.4 2018/03/27 09:01:54 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMediaAgentList <<<'

IF EXISTS (select * from sysobjects where name='AppGetMediaAgentList')
	drop procedure AppGetMediaAgentList
IF EXISTS (select * from GxQscripts where name='AppGetMediaAgentList')
	delete from GxQscripts where name = 'AppGetMediaAgentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMediaAgentList')
	delete from GXDBVersions where aliasname = 'AppGetMediaAgentList'
GO
print '... Creating Procedure: AppGetMediaAgentList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMediaAgentList
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_includeExtendedInfo INTEGER,
  @i_excludeDeconfigured INTEGER,
  @i_includeOnlyWebserverMA INTEGER,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
SET @o_errCode = 0
SET @o_errString = ''
-- lookup all the Media Agent list
DECLARE @tmpMediaAgentList TABLE (
                                    clientId      integer,
clientName          nvarchar(255),
clientDisplayName   nvarchar(255),
clientNetworkName   nvarchar(255),
                                    hostType          integer,
                                    softState         integer,
                                    enabled           integer,
                                    MAOfflineReason   integer,
                                    ReleaseId         integer,
SoftWareRelease   nvarchar(255),
SoftWareBuildId   nvarchar(255),
SystemOsVersion   nvarchar(255),
SystemHardWare    nvarchar(255),
                                    SystemOsId        integer,
                                    numLibraries      integer,
                                    isCommServer      integer,
                                    isVirtualClient   integer,
                                    attribute         integer,
                                    IsUnlicensedMA    integer,
                                    isPreConfigured   integer,
                                    patchStatus       integer,
                                    isMACatalogServer integer,
                                    isEDCDiscovered   integer,
                                    MAMaxReservations integer,
                                    flags             integer,
                                    description       nvarchar(max),
                                    Capabilities      bigint,
									installedTime     integer )
    INSERT  @tmpMediaAgentList
    EXEC MMS2GetMediaAgentList @i_userId
    IF (@i_includeOnlyWebserverMA = 1)
    BEGIN
        -- WebServer Package Id is 252
        DELETE FROM @tmpMediaAgentList WHERE clientId NOT IN (SELECT ClientId FROM simInstalledPackages WHERE simPackageID=252)
    END
    IF (@i_includeExtendedInfo = 1)
    BEGIN
        SET @o_xmlText = (SELECT
			                (SELECT
                                clientId AS '@mediaAgentId', clientName AS '@mediaAgentName', SystemOsVersion AS '@osVersion',
                                SystemHardWare AS '@platform', CASE WHEN ((softState > 0) AND (enabled > 0)) THEN 1 ELSE 0 END AS '@status'
                                , description AS '@description'
                                    FROM @tmpMediaAgentList
                                    WHERE ((@i_excludeDeconfigured = 0) OR ((@i_excludeDeconfigured = 1) AND (IsUnlicensedMA = 0)))
			                    FOR XML PATH('mediaAgentList'), TYPE)
			                FOR XML PATH('EVGui_GetMediaAgentListWCResp'),TYPE)
    END
    ELSE
    BEGIN
        SET @o_xmlText = (SELECT
				            (SELECT
				                (SELECT
                                    clientId AS '@id', clientName AS '@name'
				                    FOR XML PATH('entityInfo'), TYPE)
                                FROM @tmpMediaAgentList
                                WHERE ((@i_excludeDeconfigured = 0) OR ((@i_excludeDeconfigured = 1) AND (IsUnlicensedMA = 0)))
				            FOR XML PATH('response'), TYPE)
			             FOR XML PATH('App_GenericEntityResp'),TYPE)
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errCode = ERROR_NUMBER()
    SET @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT
                        @o_errCode			     as '@errorCode',
		                @o_errString	         as '@errorMessage'
                            FOR XML PATH ('CVGui_GenericResp'),TYPE)
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMediaAgentList')
	delete from GxQscripts where name = 'AppGetMediaAgentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMediaAgentList')
	delete from GXDBVersions where aliasname = 'AppGetMediaAgentList'
GO

insert into GXDBVersions values(2, 'AppGetMediaAgentList',  '00010001000200040000', 'AppGetMediaAgentList', '00010001000200040000')
GO

