

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMaxDataStoreDiskSpace.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMaxDataStoreDiskSpace.sp,v $ $Id: AppGetMaxDataStoreDiskSpace.sp,v 1.9.50.1 2018/03/22 01:32:59 jiechen Exp $";
-- 	+-------------------------------------------------------------------------------------------------------------------------+
--	| 			Procedure : "AppGetMaxDataStoreDiskSpace"
--	|	This Procedure is used to get the maximum data store space present among the data stores present in the policy
-- 	+-------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMaxDataStoreDiskSpace <<<'

IF EXISTS (select * from sysobjects where name='AppGetMaxDataStoreDiskSpace')
	drop procedure AppGetMaxDataStoreDiskSpace
IF EXISTS (select * from GxQscripts where name='AppGetMaxDataStoreDiskSpace')
	delete from GxQscripts where name = 'AppGetMaxDataStoreDiskSpace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMaxDataStoreDiskSpace')
	delete from GXDBVersions where aliasname = 'AppGetMaxDataStoreDiskSpace'
GO
print '... Creating Procedure: AppGetMaxDataStoreDiskSpace'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMaxDataStoreDiskSpace
-- Input arguments
  @i_policyId integer 
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
DECLARE @max_storage bigint
DECLARE @storage_val bigint
DECLARE @datastoreId INT
DECLARE @AgentCount INT
DECLARE @allDataStoresSelected INT
DECLARE @dataStoreXML XML
DECLARE @mainStoreXML XML
SET @mainStoreXML = (SELECT vxml.query('/policy') from [dbo].APP_VMAllocationPolicy where id = @i_policyId)
--If all the datastores are selected, populate the datastores list dynamically from the selected esx servers
--If all esx servers are itself, generate them dynamically aswell from the datacenterId
SET @allDataStoresSelected = ISNULL (@mainStoreXML.value('(//./policy/@allDataStoresSelected)[1]', 'int'), 0)
IF object_id('tempdb.dbo.#tmpDataStoreIdTbl') is not null
	DROP TABLE #tmpDataStoreIdTbl
CREATE TABLE #tmpDataStoreIdTbl (t_DataStoreId integer)
IF (@allDataStoresSelected = '1')
BEGIN
		DECLARE @dataCenterId INT
		select @dataCenterId = vDataCenterId FROM APP_VMAllocationPolicy where id = @i_policyId
		IF object_id('tempdb.dbo.#tmpESXServerTbl') is not null
			DROP TABLE #tmpESXServerTbl
		CREATE TABLE #tmpESXServerTbl (t_esxServerId	integer)
		DECLARE @allESXServersSelected INT = ISNULL (@mainStoreXML.value('(//./policy/@allESXServersSelected)[1]', 'int'), 0)
		IF (@allESXServersSelected = '1')
		BEGIN
			INSERT INTO #tmpESXServerTbl SELECT id from [dbo].[App_VMHost] WHERE [dbo].[App_VMHost].vDataCenterId = @dataCenterId
		END
		ELSE
		BEGIN
			INSERT INTO #tmpESXServerTbl (t_esxServerId)
			--SELECT ref.value('@esxServerId', 'integer')
			--FROM  @mainStoreXML.nodes ('/policy/esxServers') R(ref)
			SELECT CAST(attrVal AS INT)
			FROM app_vmallocationpolicyprop WHERE attrName='esxserver' and componentNameId=@i_policyId
		END
		--get valid data stores
		INSERT INTO #tmpDataStoreIdTbl
		SELECT DISTINCT D.id
		FROM [dbo].App_VMDataStore D
		INNER JOIN VMHostToDataStores
		ON D.id = vDataStoreId
		AND D.removalTimeStamp IS NULL
		INNER JOIN #tmpESXServerTbl
		ON t_esxServerId = vHostId
		--get max value
		SET @max_storage = (SELECT MAX( vxml.value('(/datastores/@freeSpace)[1]', 'bigint')) FROM App_VMDataStore
								INNER JOIN #tmpDataStoreIdTbl ON App_VMDataStore.id = #tmpDataStoreIdTbl.t_DataStoreId)
END
ELSE
BEGIN
		INSERT INTO #tmpDataStoreIdTbl(t_DataStoreId)
		SELECT CAST(attrVal AS INT)
		FROM app_vmallocationpolicyprop WHERE attrName='datastore' and componentNameId=@i_policyId
		SET @max_storage = (SELECT MAX( vxml.value('(/datastores/@freeSpace)[1]', 'bigint')) FROM App_VMDataStore
								INNER JOIN #tmpDataStoreIdTbl ON App_VMDataStore.id = #tmpDataStoreIdTbl.t_DataStoreId)
END
SET @r_ReturnResult = (SELECT cast(@max_storage/(1024*1024) AS varchar(25)) AS '@maxdiskspace'  FOR XML PATH ('Ida_GetMaxDataStoreDiskSpaceResp'))
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMaxDataStoreDiskSpace')
	delete from GxQscripts where name = 'AppGetMaxDataStoreDiskSpace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMaxDataStoreDiskSpace')
	delete from GXDBVersions where aliasname = 'AppGetMaxDataStoreDiskSpace'
GO

insert into GXDBVersions values(2, 'AppGetMaxDataStoreDiskSpace',  '00010009005000010000', 'AppGetMaxDataStoreDiskSpace', '00010009005000010000')
GO

