

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMaskingPolicies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetMaskingPolicies')
BEGIN
	print '>>> Drop Stored Procedure: AppGetMaskingPolicies <<<'
	drop procedure AppGetMaskingPolicies
END
IF EXISTS (select * from GxQscripts where name='AppGetMaskingPolicies')
	delete from GxQscripts where name = 'AppGetMaskingPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMaskingPolicies')
	delete from GXDBVersions where aliasname = 'AppGetMaskingPolicies'
GO
print '... Creating Procedure: AppGetMaskingPolicies'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMaskingPolicies
  @i_xml XML
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg NVARCHAR(1024) = N''
	DECLARE @instanceId INTEGER = ISNULL((SELECT @i_xml.value('(/App_GetDataMaskingPoliciesReq/association/@instanceId)[1]','INT')), 0)
	DECLARE @backupsetId INTEGER = ISNULL((SELECT @i_xml.value('(/App_GetDataMaskingPoliciesReq/association/@backupsetId)[1]','INT')), 0)
	DECLARE @policyId INTEGER = ISNULL((SELECT @i_xml.value('(/App_GetDataMaskingPoliciesReq/policy/@policyId)[1]','INT')), 0)
	DECLARE @xmlResult						XML
	SET @xmlResult =
			(
				SELECT	MP.id as 'policy/@policyId',
						MP.name as 'policy/@policyName',
						MP.instanceId as 'association/@instanceId',
						B.name	as 'association/@backupsetName',
						MP.backupsetId as 'association/@backupsetId',
						MP.appTypeId as 'association/@applicationId',
						MP.maskingConfig.query('/config/tables') as 'config'
				FROM	APP_MaskingPolicy MP
					LEFT OUTER JOIN APP_BackupsetName B ON B.id = MP.backupsetId
				WHERE	(MP.instanceId = @instanceId OR @instanceId = 0 OR MP.instanceId = 0)
					AND	(MP.backupsetId = @backupsetId OR @backupsetId = 0 OR MP.backupsetId = 0)
					AND	(MP.id = @policyId OR @policyId = 0)
					AND	MP.modifiedTime = 0
				FOR XML PATH('policies')
			)
	SELECT	@xmlResult,
		(SELECT
			@errorCode as '@errorCode',
			@errorMsg as '@errorMessage'
			FOR XML PATH('response'), TYPE)
	FOR XML PATH('App_GetDataMaskingPoliciesResponse'), TYPE
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMaskingPolicies')
	delete from GxQscripts where name = 'AppGetMaskingPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMaskingPolicies')
	delete from GXDBVersions where aliasname = 'AppGetMaskingPolicies'
GO

insert into GXDBVersions values(2, 'AppGetMaskingPolicies',  '00000000000000000000', 'AppGetMaskingPolicies', '00000000000000000000')
GO

