

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMailboxUsages.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2013  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMailboxUsages.sp,v $ $Id: AppGetMailboxUsages.sp,v 1.9.12.2 2017/02/10 20:59:45 sjohnson Exp $";
-- =========================================================
-- Author: Jatin Sanghvi
-- Description: Get the mailbox usages
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMailboxUsages <<<'

IF EXISTS (select * from sysobjects where name='AppGetMailboxUsages')
	drop procedure AppGetMailboxUsages
IF EXISTS (select * from GxQscripts where name='AppGetMailboxUsages')
	delete from GxQscripts where name = 'AppGetMailboxUsages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMailboxUsages')
	delete from GXDBVersions where aliasname = 'AppGetMailboxUsages'
GO
print '... Creating Procedure: AppGetMailboxUsages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMailboxUsages
  @xmlText XML
AS
SET NOCOUNT ON;
--
BEGIN TRY
	--
	-- read subclient id and minimun quota percentage value from input xml
	DECLARE @inAppId int;
	SELECT @inAppId = N.value('@appId', 'int') FROM @xmlText.nodes ('App_MailboxUsageQuery') AS T(N);
	DECLARE @inMinQuota bigint;
	SELECT @inMinQuota = N.value('@minQuota', 'bigint') FROM @xmlText.nodes ('App_MailboxUsageQuery') AS T(N);
	--
	-- check whether quota is enabled on the subclient
	IF NOT EXISTS (SELECT S.id FROM APP_SubClientProp S WITH (NOLOCK)
	WHERE S.componentNameId = @inAppId AND S.attrName = 'Mailbox Quota Based On Disk Usage' AND S.attrVal = 1 AND S.modified = 0)
	BEGIN
		RAISERROR('Error fetching the quota limit for the subclient.', 16, 1);
	END
	--
	-- get the quota limit from subclient property table
	DECLARE @quotaLimit bigint = NULL;
	SELECT @quotaLimit = CAST(S.attrVal as bigint) * 1024 * 1024 FROM APP_SubClientProp S WITH (NOLOCK)
	WHERE S.componentNameId = @inAppId AND S.attrName = 'Size Of Mailbox Quota Based On Disk Usage' AND S.modified = 0;
	--
	IF @quotaLimit IS NULL OR @quotaLimit <= 0
SET @quotaLimit = CAST(10240 as bigint) * 1024 * 1024;
	--
	-- return the xml response
	SET @xmlText =
	(SELECT @inAppId AS '@appId', @quotaLimit AS '@quotaLimit',
		(SELECT M.userGuid AS '@userGuid',
		ISNULL(M.globalSpaceConsumed,
			(SELECT SUM(M1.localSpaceConsumed) FROM APP_MailboxUsages M1 WITH (NOLOCK)
			INNER JOIN APP_Application A WITH (NOLOCK) ON M1.appId = A.id
WHERE M1.userGuid = M.userGuid AND (A.subclientStatus & (CAST(0x00002 AS int) | CAST(0x00004 AS int) | CAST(0x00010 AS int) | CAST(0x00020 AS int) | CAST(0x10000 AS int))) = 0)
		) AS '@spaceConsumed'
		FROM APP_MailboxUsages M WITH (NOLOCK)
		INNER JOIN APP_SubClientProp S WITH (NOLOCK) ON M.appId = S.componentNameId AND M.userGuid = SUBSTRING(S.attrVal, CHARINDEX(' {', attrVal) + 1, 38)
		WHERE S.componentNameId = @inAppId AND S.attrType = 111 AND S.modified = 0
		AND (100 * ISNULL(M.globalSpaceConsumed,
			(SELECT SUM(M1.localSpaceConsumed) FROM APP_MailboxUsages M1 WITH (NOLOCK)
			INNER JOIN APP_Application A WITH (NOLOCK) ON M1.appId = A.id
WHERE M1.userGuid = M.userGuid AND (A.subclientStatus & (CAST(0x00002 AS int) | CAST(0x00004 AS int) | CAST(0x00010 AS int) | CAST(0x00020 AS int) | CAST(0x10000 AS int))) = 0))
			/ @quotaLimit) >= @inMinQuota
		FOR XML PATH('usageData'), TYPE)
	FOR XML PATH('App_MailboxUsages'), TYPE);
	--
	SELECT @xmlText;
--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	--
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
	SELECT @xmlText;
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMailboxUsages')
	delete from GxQscripts where name = 'AppGetMailboxUsages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMailboxUsages')
	delete from GXDBVersions where aliasname = 'AppGetMailboxUsages'
GO

insert into GXDBVersions values(2, 'AppGetMailboxUsages',  '00010009001200020000', 'AppGetMailboxUsages', '00010009001200020000')
GO

