

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMailboxInfo.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2013  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetMailboxInfo.sp,v $ $Id: AppGetMailboxInfo.sp,v 1.10.12.2 2017/02/10 20:59:45 sjohnson Exp $";
-- =========================================================
-- Author: Jatin Sanghvi
-- Description: Update the user mailbox usage
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMailboxInfo <<<'

IF EXISTS (select * from sysobjects where name='AppGetMailboxInfo')
	drop procedure AppGetMailboxInfo
IF EXISTS (select * from GxQscripts where name='AppGetMailboxInfo')
	delete from GxQscripts where name = 'AppGetMailboxInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMailboxInfo')
	delete from GXDBVersions where aliasname = 'AppGetMailboxInfo'
GO
print '... Creating Procedure: AppGetMailboxInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMailboxInfo
  @xmlText XML
AS
SET NOCOUNT ON;
--
BEGIN TRY
	--
	-- read user guid from input xml
	DECLARE @inUserGuid varchar(max);
	SELECT @inUserGuid = N.value('@userGuid', 'varchar(max)') FROM @xmlText.nodes ('App_MailboxInfoQuery') AS T(N);
	DECLARE @inAppId int;
	SELECT @inAppId = N.value('@appId', 'int') FROM @xmlText.nodes ('App_MailboxInfoQuery') AS T(N);
	--
	-- fetch global quota limit if available
	DECLARE @quotaLimit bigint = NULL;
	DECLARE @appId int = NULL;
	--
	SELECT TOP 1 @quotaLimit = CAST(M.globalQuotaLimitMB as bigint) * 1024 * 1024, @appId = M.appId
	FROM APP_MailboxUsages M WITH (NOLOCK)
	WHERE M.userGuid = @inUserGuid AND M.globalQuotaLimitMB IS NOT NULL
	ORDER BY M.lastUpdateTime DESC;
	--
	-- else look for subclient whose quota limit should be returned
	IF @quotaLimit IS NULL OR @quotaLimit <= 0
	BEGIN
		SET @appId = NULL;
		IF @inAppId IS NULL OR @inAppId <= 0
		BEGIN
			-- get id of subclient backing up the mailbox
			-- if there are multiple subclients backing up the mailbox, select the one whose quota usage is last updated
			SELECT TOP 1 @appId = M.appId
			FROM APP_MailboxUsages M WITH (NOLOCK)
			INNER JOIN APP_SubClientProp S1 WITH (NOLOCK) ON M.appId = S1.componentNameId AND M.userGuid = SUBSTRING(S1.attrVal, CHARINDEX(' {', attrVal) + 1, 38)
			INNER JOIN APP_SubClientProp S2 WITH (NOLOCK) ON M.appId = S2.componentNameId
			INNER JOIN APP_Application A WITH (NOLOCK) ON M.appId = A.id
			WHERE M.userGuid = @inUserGuid
			AND S1.attrType = 111 AND S1.modified = 0
			AND S2.attrName = 'Mailbox Quota Based On Disk Usage' AND S2.attrVal = '1' AND S2.modified = 0
AND (A.subclientStatus & (CAST(0x00002 AS int) | CAST(0x00004 AS int) | CAST(0x00010 AS int) | CAST(0x00020 AS int) | CAST(0x10000 AS int))) = 0
			ORDER by M.lastUpdateTime DESC;
		END
		ELSE
		BEGIN
			-- use input subclient id if mailbox is part of that subclient
			SELECT @appId = M.appId
			FROM APP_MailboxUsages M WITH (NOLOCK)
			INNER JOIN APP_SubClientProp S1 WITH (NOLOCK) ON M.appId = S1.componentNameId AND M.userGuid = SUBSTRING(S1.attrVal, CHARINDEX(' {', attrVal) + 1, 38)
			INNER JOIN APP_SubClientProp S2 WITH (NOLOCK) ON M.appId = S2.componentNameId
			WHERE M.userGuid = @inUserGuid AND M.appId = @inAppId
			AND S1.attrType = 111 AND S1.modified = 0
			AND S2.attrName = 'Mailbox Quota Based On Disk Usage' AND S2.attrVal = '1' AND S2.modified = 0;
		END
		--
		IF @appId IS NULL OR @appId <= 0
			RAISERROR('Error fetching the subclient for the user mailbox.', 16, 1);
		--
		-- get the quota limit from subclient property table
		SELECT @quotaLimit = CAST(S.attrVal as bigint) * 1024 * 1024 FROM APP_SubClientProp S WITH (NOLOCK)
		WHERE S.componentNameId = @appId AND S.attrName = 'Size Of Mailbox Quota Based On Disk Usage' AND S.modified = 0;
		--
		IF @quotaLimit IS NULL OR @quotaLimit <= 0
SET @quotaLimit = CAST(10240 as bigint) * 1024 * 1024;
	END
	--
	-- return the xml response
	SET @xmlText =
	(SELECT @appId AS '@appId', @quotaLimit AS '@quotaLimit',
		(SELECT @inUserGuid AS '@userGuid',
		ISNULL(M.globalSpaceConsumed,
			(SELECT SUM(M1.localSpaceConsumed) FROM APP_MailboxUsages M1 WITH (NOLOCK)
			 INNER JOIN APP_Application A WITH (NOLOCK) ON M1.appId = A.id
WHERE M1.userGuid = M.userGuid AND (A.subclientStatus & (CAST(0x00002 AS int) | CAST(0x00004 AS int) | CAST(0x00010 AS int) | CAST(0x00020 AS int) | CAST(0x10000 AS int))) = 0)
		) AS '@spaceConsumed'
		FROM APP_MailboxUsages M WITH (NOLOCK) WHERE M.appId = @appId AND M.userGuid = @inUserGuid
		FOR XML PATH('usageData'), TYPE)
	FOR XML PATH('App_MailboxUsages'), TYPE);
	--
	SELECT @xmlText;
--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	--
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
	SELECT @xmlText;
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMailboxInfo')
	delete from GxQscripts where name = 'AppGetMailboxInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMailboxInfo')
	delete from GXDBVersions where aliasname = 'AppGetMailboxInfo'
GO

insert into GXDBVersions values(2, 'AppGetMailboxInfo',  '00010010001200020000', 'AppGetMailboxInfo', '00010010001200020000')
GO

