

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMailboxByPreviewStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetMailboxByPreviewStatus')
BEGIN
	print '>>> Drop Stored Procedure: AppGetMailboxByPreviewStatus <<<'
	drop procedure AppGetMailboxByPreviewStatus
END
IF EXISTS (select * from GxQscripts where name='AppGetMailboxByPreviewStatus')
	delete from GxQscripts where name = 'AppGetMailboxByPreviewStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMailboxByPreviewStatus')
	delete from GXDBVersions where aliasname = 'AppGetMailboxByPreviewStatus'
GO
print '... Creating Procedure: AppGetMailboxByPreviewStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMailboxByPreviewStatus
  @i_subclientId INT,
  @i_mailboxGuids varchar(MAX)='',
  @i_previewEnabled INT = 0 --by default, get only disabled preview mailboxes
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	--input list
	IF OBJECT_ID('tempdb.dbo.#previewStatusMailboxGUIDs') IS NOT NULL
		DROP TABLE #previewStatusMailboxGUIDs
	CREATE TABLE #previewStatusMailboxGUIDs
    (
        mbxGUID varchar(2048)
    )
	CREATE INDEX Idx_previewStatusMailboxGUIDs_mbxGUID on #previewStatusMailboxGUIDs(mbxGUID)
	IF ( ISNULL(@i_mailboxGuids,'') <> '' )
	BEGIN
		insert into #previewStatusMailboxGUIDs select _ID from dbo.SplitIDString(@i_mailboxGuids)
	END
	SELECT  A.smtpAdrress, A.userGuid ,
	CASE
		WHEN D.detailType = 4/*Journal*/ THEN D.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/@enablePreviewGeneration)[1]', 'int')
		ELSE D.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enablePreviewGeneration)[1]', 'int')
	END
	FROM  APP_EmailConfigPolicyassoc A
	INNER JOIN APP_EmailConfigPolicies P ON P.componentNameId = A.assocId
	INNER JOIN APP_ConfigurationPolicyDetails D on D.componentNameId = P.policyId
	where A.modified = 0 and A.subClientId = @i_subclientid
	AND  ( ISNULL(@i_mailboxGuids,'') = '' OR A.userGuid in ( select mbxGuid from #previewStatusMailboxGUIDs ) )
	AND P.modified = 0 AND p.policyType IN (1,4)
	AND D.modified = 0 AND
		(
			(P.policyType = 1/*Archive*/ AND D.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enableContentIndex)[1]', 'int') = 1
			AND (@i_previewEnabled = -1 OR D.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enablePreviewGeneration)[1]', 'int') = @i_previewEnabled  )
			)
		OR
			(P.policyType = 4/*Journal*/ AND D.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/@enableContentIndex)[1]', 'int') = 1
			AND ( @i_previewEnabled = -1 OR D.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/@enablePreviewGeneration)[1]', 'int') = @i_previewEnabled  )
			)
		)
	IF OBJECT_ID('tempdb.dbo.#previewStatusMailboxGUIDs') IS NOT NULL
		DROP TABLE #previewStatusMailboxGUIDs
 END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMailboxByPreviewStatus')
	delete from GxQscripts where name = 'AppGetMailboxByPreviewStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMailboxByPreviewStatus')
	delete from GXDBVersions where aliasname = 'AppGetMailboxByPreviewStatus'
GO

insert into GXDBVersions values(2, 'AppGetMailboxByPreviewStatus',  '00000000000000000000', 'AppGetMailboxByPreviewStatus', '00000000000000000000')
GO

