

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMachineBrowseDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetMachineBrowseDetails <<<'

IF EXISTS (select * from sysobjects where name='AppGetMachineBrowseDetails')
	drop procedure AppGetMachineBrowseDetails
IF EXISTS (select * from GxQscripts where name='AppGetMachineBrowseDetails')
	delete from GxQscripts where name = 'AppGetMachineBrowseDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMachineBrowseDetails')
	delete from GXDBVersions where aliasname = 'AppGetMachineBrowseDetails'
GO
print '... Creating Procedure: AppGetMachineBrowseDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMachineBrowseDetails
  @iclientreq_xml XML
AS
  DECLARE @o_xmlstring XML
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @clientId INT = 0
	DECLARE @userId INT = 0
	SELECT @clientId = req.client.value('@clientID', 'INTEGER'), @userId = req.client.value('@userID', 'INTEGER')
	FROM @iclientreq_xml.nodes('App_ClientLiveBrowseDetailsReq') req(client)
	DECLARE @random_id INT
	DECLARE @clflags INT
	DECLARE @networkshare INT = 0
	DECLARE @proxydetails XML
	DECLARE @proxyuser NVARCHAR(255)
	DECLARE @proxymangled nvarchar(500)
	DECLARE @proxypassword NVARCHAR(500)
	DECLARE @clientname nvarchar(255)
	DECLARE @hostname nvarchar(255)
	DECLARE @cvd nvarchar(10)
	DECLARE @evmgrc nvarchar(10)
	DECLARE @networkShareHostName nvarchar(500)
	SELECT @clflags = cl.specialClientFlags FROM App_Client cl where cl.id = @clientId
	IF (@clflags & 2) <> 0
	BEGIN
		SET @networkshare = 1
		SELECT TOP 1  @random_id = appl.id from App_Client cl, APP_Application appl, APP_SubClientProp subcl, simOperatingSystem simOS
		WHERE appl.clientId = cl.id AND appl.id = subcl.componentNameId and cl.simOperatingSystemId = simOS.id and simOS.Type = 'Windows'
		and simOS.SubType <> 'Mobile'
		and subcl.cs_attrName in (CHECKSUM(N'UNCPath user name'), CHECKSUM(N'UNCPath password'))
		and LEN(subcl.attrVal) != 0
		DECLARE @backupConfigAttrName NVARCHAR(MAX) = N'Backup Configuration Nodes'
		SELECT @proxyuser = attrVal FROM APP_SubClientProp subcl WHERE subcl.componentNameId = @random_id AND subcl.cs_attrName = CHECKSUM(N'UNCPath user name')
		SELECT @proxypassword = attrVal FROM APP_SubClientProp subcl WHERE subcl.componentNameId = @random_id AND subcl.cs_attrName = CHECKSUM(N'UNCPath password')
		SELECT @proxydetails = attrVal FROM APP_SubClientProp subcl WHERE subcl.componentNameId = @random_id AND subcl.cs_attrName = CHECKSUM(@backupConfigAttrName) and attrVal <> '<App_BackupConfigurationNodes/>'
		DECLARE @proxy_clientid INT
		SELECT TOP 1 @proxy_clientid = T.X.value('@clientId', 'int') from @proxydetails.nodes('/App_BackupConfigurationNodes/backupDataAccessNodes') as T(X), App_Client cl, simOperatingSystem simOS
		WHERE T.X.value('@clientId', 'INT') = cl.id and cl.simOperatingSystemId = simOS.id and simOS.Type = 'Windows' and simOS.SubType <> 'Mobile'
		IF @proxy_clientid IS NULL
		BEGIN
			SELECT TOP 1 @proxydetails = prop.attrVal FROM APP_IDAName idaName, APP_IDAProp prop where idaName.clientId = @clientId and prop.attrName = @backupConfigAttrName
			and idaName.appTypeId in (SELECT type FROM APP_iDAType where ccpType = 33 or type = 13) and prop.attrVal <> '<App_BackupConfigurationNodes/>' and idaName.id = prop.componentNameId
			IF @proxydetails IS NOT NULL
			BEGIN
				SELECT TOP 1 @proxy_clientid = T.X.value('@clientId', 'int') from @proxydetails.nodes('/App_BackupConfigurationNodes/backupDataAccessNodes') as T(X), App_Client cl, simOperatingSystem simOS
				WHERE T.X.value('@clientId', 'INT') = cl.id and cl.simOperatingSystemId = simOS.id and simOS.Type = 'Windows' and simOS.SubType <> 'Mobile'
			END
		END
		IF @proxy_clientid IS NULL
		BEGIN
			SELECT TOP 1 @proxydetails = attrVal FROM APP_SubClientProp subClProp, APP_Application app, APP_Client cl WHERE cl.id = @clientId
			AND app.clientId = cl.id AND subClProp.componentNameId = app.id and subClProp.cs_attrName = CHECKSUM(@backupConfigAttrName)
			IF @proxydetails IS NOT NULL
			BEGIN
				SELECT TOP 1 @proxy_clientid = T.X.value('@clientId', 'int') from @proxydetails.nodes('/App_BackupConfigurationNodes/backupDataAccessNodes') as T(X), App_Client cl, simOperatingSystem simOS
				WHERE T.X.value('@clientId', 'INT') = cl.id and cl.simOperatingSystemId = simOS.id and simOS.Type = 'Windows' and simOS.SubType <> 'Mobile'
			END
		END
		SELECT @clientname = name, @hostname = net_hostname, @cvd = convert(nvarchar(10), cvdPort), @evmgrc = convert(nvarchar(10), evmgrcPort) FROM app_client WHERE id = @proxy_clientid
		SELECT @proxymangled = @hostname + '*' + @clientname + '*' + @cvd + '*' + @evmgrc
		SELECT @networkShareHostName = net_hostname from APP_Client cl WHERE cl.id = @clientId
	END
	ELSE
	BEGIN
		SET @networkshare = 0
		SELECT @clientname = name, @hostname = net_hostname, @cvd = convert(nvarchar(10), cvdPort), @evmgrc = convert(nvarchar(10), evmgrcPort) FROM App_Client WHERE id = @clientId
		SELECT @proxymangled = @hostname + '*' + @clientname + '*' + @cvd + '*' + @evmgrc
		IF @userId <> 0
		BEGIN
			SELECT @proxyUser = localUserLogin FROM UMClientUserMap WHERE clientId = @clientId AND umUserId = @userId
		END
	END
	SELECT o_xmlstring = (select @networkshare as '@networkShare',
							  @proxyuser as '@proxyUser',
							  @proxypassword as '@proxyPassword',
							  @proxymangled	as '@proxyMangled',
							  @networkShareHostName as '@networkShareHostName',
							  @proxydetails as 'proxyDetails'
						FOR XML PATH('App_ClientLiveBrowseDetailsResp'), TYPE)
ERROR_EXIT:
	IF @o_xmlstring IS NULL
	BEGIN
		SET @o_xmlstring = '<App_ClientLiveBrowseDetailsResp />'
		SELECT @o_xmlstring
	END
END
SET NOCOUNT OFF
GO
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMachineBrowseDetails')
	delete from GxQscripts where name = 'AppGetMachineBrowseDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMachineBrowseDetails')
	delete from GXDBVersions where aliasname = 'AppGetMachineBrowseDetails'
GO

insert into GXDBVersions values(2, 'AppGetMachineBrowseDetails',  '00000000000000000000', 'AppGetMachineBrowseDetails', '00000000000000000000')
GO

