

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMSSQLInstances.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		  Procedure Name :AppGetMSSQLInstances
--		  This procedure is used to perform following MS SQL ALways ON operations(operationType)
--
--		  MSSQLSPOperationType_GETINSTANCES= 0
--			  Return SQL Clients and Instances and proxy list
--		  MSSQLSPOperationType_VERIFYGUID= 1
--			 Verify if an Availability Group is already configured
--		  MSSQLSPOperationType_ISAGCONFIGURED= 2
--			 Verify if any Availability Group is configured on the commcell
--		  MSSQLSPOperationType_GETCLOUDPROXYLIST= 3
--			 Return SQL Proxy Clients list
--		  MSSQLSPOperationType_GETAGCLIENTSLIST= 4
--			 Return the list of SQL Availability Group Clients
--
-- ----------------------------------------------------------------------*/
 SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetMSSQLInstances')
BEGIN
	print '>>> Drop Stored Procedure: AppGetMSSQLInstances <<<'
	drop procedure AppGetMSSQLInstances
END
IF EXISTS (select * from GxQscripts where name='AppGetMSSQLInstances')
	delete from GxQscripts where name = 'AppGetMSSQLInstances'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMSSQLInstances')
	delete from GXDBVersions where aliasname = 'AppGetMSSQLInstances'
GO
print '... Creating Procedure: AppGetMSSQLInstances'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMSSQLInstances
  @xmlText XML
AS
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @opType INT
DECLARE @OSType INT
DECLARE @userId INTEGER =0
IF OBJECT_ID('tempdb.dbo.#tt_Clients') IS NOT NULL
	DROP TABLE #tt_Clients
CREATE TABLE #tt_Clients (Cid int primary key, Cname nvarchar(255))
IF OBJECT_ID('tempdb.dbo.#tt_ValidClients') IS NOT NULL
	DROP TABLE #tt_ValidClients
CREATE TABLE #tt_ValidClients (id int primary key)
-- User Permission
IF OBJECT_ID('tempdb.dbo.#tt_getAllIdaObjects') IS NOT NULL
	DROP TABLE #tt_getAllIdaObjects
CREATE TABLE #tt_getAllIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
-- SELECT ALL Instances
IF OBJECT_ID('tempdb.dbo.#tt_SqlInstances') IS NOT NULL
	DROP TABLE #tt_SqlInstances
CREATE TABLE #tt_SqlInstances(cid int, cname nvarchar(255), iid int, iname nvarchar(255), primary key (cid,iid))
SET @opType =    ISNULL((SELECT  ref.value('@operationType', 'int')
                         FROM    @xmlText.nodes('App_GetSqlClientAndInstanceReq') R ( ref )),0)
SET @OSType =    ISNULL((SELECT  ref.value('@osType', 'int')
                         FROM    @xmlText.nodes('App_GetSqlClientAndInstanceReq') R ( ref )),1)
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int')
                              FROM    @xmlText.nodes('App_GetSqlClientAndInstanceReq/processinginstructioninfo/user') R ( ref )),0)
if(@opType = 0)
BEGIN
DECLARE @tmpClient TABLE  ( Cid int primary key, Cname nvarchar(255) )
	DECLARE @validClients TABLE (id int primary key)
	INSERT INTO @validClients
		select distinct clientId from simInstalledPackages as SC WITH (NOLOCK)
		JOIN App_client as C WITH (NOLOCK)
		ON C.id = SC.clientid
AND ((@OSType = 0 AND SC.simPackageID in (353, 1212)) OR (@OSType = 1 AND SC.simPackageID in (353)))
		-- Exclude the clients which are marked uninstalled and deleted.
		AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
where C.releaseId >= 16 OR
(C.releaseId = 15 AND ( SC.HighestSP > 7 OR (SC.HighestSP = 7 and SC.SpMinorVersion > 0 ) ) )
	INSERT INTO @validClients
		select distinct VMClientId From APP_VMToPMMap where PMClientId in (select id from @validClients)
	IF @userId > 0
	BEGIN
		IF object_id('tempdb.dbo.#tempUserObjects') IS NOT Null DROP TABLE #tempUserObjects
create table  #tempUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @userId, 0, 0, '#tempUserObjects'
		delete #tempUserObjects
		WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0
			OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0  OR taskId <> 0
			OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
			OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
			OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
			OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
		INSERT INTO @tmpClient
		SELECT distinct c.id,c.name FROM  App_Client c
			JOIN #tempUserObjects T ON T.clientId in (0,c.id)
				where C.id <> 1
and (C.status & 0x20000000) <> 0x20000000
				-- Exclude the clients which are marked uninstalled and deleted.
				AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
				and EXISTS (select id from @validClients where id = c.id )
		IF object_id('tempdb.dbo.#tempUserObjects') IS NOT Null DROP TABLE #tempUserObjects
	END
	ELSE
	BEGIN
		INSERT INTO @tmpClient
			SELECT distinct C.id,C.name FROM  App_Client C
			where C.id <> 1
and (C.status & 0x20000000) <> 0x20000000
			-- Exclude the clients which are marked uninstalled and deleted.
			AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
			and EXISTS (select id from @validClients where id = c.id )
	END
	-- SELECT ALL SQLLAG Clients
	DECLARE @sqlInstances TABLE  ( cid int ,
cname nvarchar(255) ,
								   iid int,
iname nvarchar(255),
								   primary key (cid,iid))
	INSERT INTO @sqlInstances
		SELECT distinct C.cid,C.cname,Inst.id,Inst.name
		FROM  @tmpClient C
JOIN App_Application App ON (App.clientId = C.cid and App.appTypeId =  81)
		JOIN App_InstanceName Inst ON Inst.id = App.instance
		LEFT OUTER JOIN APP_InstanceProp Px ON Inst.id = Px.componentNameId AND Px.attrName = 'MSSQL Server Type'
where  (((Inst.status & 0x00010) != 0x00010) AND ((Inst.status & 0x00004 ) != 0x00004 )
				)
			AND   Inst.id in (SELECT componentNameId FROM App_InstanceProp where
						attrName = 'MSSQL Version' and SUBSTRING(attrVal,0,CHARINDEX('.', attrVal)) >=11 and modified=0)
			AND (isnull(Px.attrVal, 'DataBase Engine') = 'DataBase Engine') order by C.cname, Inst.name
DECLARE @proxySqlInstances TABLE  ( cid int primary key,cname nvarchar(255) )
		INSERT INTO @proxySqlInstances
		SELECT distinct C.cid,C.cname
		FROM  @tmpClient C
JOIN App_Application App ON (App.clientId = C.cid and App.appTypeId =  81)
		JOIN App_InstanceName Inst ON Inst.id = App.instance
where  (((Inst.status & 0x00010) != 0x00010) AND ((Inst.status & 0x00004 ) != 0x00004 )
				) order by C.cname
	DECLARE @xmlQuery XML
	SET @xmlQuery=	(SELECT
						(SELECT
						 		(SELECT  C.Cid AS '@clientId',
								C.Cname AS '@clientName'										FOR XML PATH('sqlClient'), TYPE),
							    (SELECT Inst.iid AS '@instanceId',
								Inst.iname AS '@instanceName'
								FROM @sqlInstances Inst
								WHERE Inst.cid =  C.cid
							    FOR XML PATH('sqlInstance'), TYPE)
						FROM (SELECT distinct cid, cname FROM @sqlInstances) as  C
						FOR XML PATH('sqlClientInstances'), TYPE),
						(SELECT cid AS '@clientId',
								cname AS '@clientName'
								FROM @proxySqlInstances
								FOR XML PATH('proxyClientsForSQL'), TYPE)
					FOR XML PATH('App_GetSqlClientAndInstanceResp'),TYPE)
END
ELSE IF (@opType=1)
BEGIN
DECLARE @guid nvarchar(max)
SET @guid =    ISNULL((SELECT  ref.value('@operationText', 'nvarchar(max)')
                         FROM    @xmlText.nodes('App_GetSqlClientAndInstanceReq') R ( ref )),'')
DECLARE @tempAG TABLE (AG XML)
IF EXISTS (SELECT 1 FROM APP_INSTANCEPROP WHERE ATTRNAME LIKE 'Availability Group')
BEGIN
	INSERT INTO @tempAG
	SELECT attrval FROM APP_INSTANCEPROP WHERE ATTRNAME LIKE 'Availability Group'
	IF(EXISTS (SELECT * FROM @tempAG WHERE
					(SELECT  ref.value('@uniqueId', 'nvarchar(max)')
	                         FROM  AG.nodes('App_SQLAvailabilityGroup') R ( ref )) = @guid))
	BEGIN
	SET @xmlQuery = (SELECT (SELECT -1 as '@errorCode',
							'Availability Group already exists.' as '@errorString'
							FOR XML PATH('error'),TYPE)
							FOR XML PATH('App_GetSqlClientAndInstanceResp'),TYPE)
	END
END
ELSE
BEGIN
	SET @xmlQuery = '<App_GetSqlClientAndInstanceResp/>'
END
END
ELSE IF(@opType=2)
BEGIN
IF(EXISTS(SELECT attrval FROM APP_INSTANCEPROP WHERE ATTRNAME LIKE 'Availability Group' ))
BEGIN
SET @xmlQuery = (SELECT (SELECT 0 as '@errorCode',
						'AT least one Availability Group exists.' as '@errorString'
						FOR XML PATH('error'),TYPE)
						FOR XML PATH('App_GetSqlClientAndInstanceResp'),TYPE)
END
ELSE
BEGIN
SET @xmlQuery = (SELECT (SELECT -1 as '@errorCode',
						'No Availability Group exists.' as '@errorString'
						FOR XML PATH('error'),TYPE)
						FOR XML PATH('App_GetSqlClientAndInstanceResp'),TYPE)
END
END
ELSE IF(@opType=3)
BEGIN
	INSERT INTO @validClients
	select distinct clientId from simInstalledPackages as SC WITH (NOLOCK)
	JOIN App_client as C WITH (NOLOCK)
ON C.id = SC.clientid and SC.simPackageID=353
		-- Exclude the clients which are marked uninstalled and deleted.
		AND (C.status & (2|4)) = 0 -- ((CV_STATUS_UNINSTALLED) | (CV_STATUS_DELETED))
where C.releaseId >= 16
	INSERT INTO @tmpClient
	SELECT distinct C.id,C.name FROM App_Client C WITH (NOLOCK)
	where C.id <> 1
and (C.status & 0x20000000) <> 0x20000000
		-- Exclude the clients which are marked uninstalled and deleted.
		AND (C.status & (2|4)) = 0 -- ((CV_STATUS_UNINSTALLED) | (CV_STATUS_DELETED))
	and EXISTS (select id from @validClients where id = c.id )
	SET @xmlQuery=	(SELECT
						(SELECT Cid AS '@clientId',
								Cname AS '@clientName'
								FROM @tmpClient
								FOR XML PATH('proxyClientsForSQL'), TYPE)
					FOR XML PATH('App_GetSqlClientAndInstanceResp'),TYPE)
END
ELSE IF(@opType=4)
BEGIN
	INSERT INTO @tmpClient
	SELECT distinct C.id,C.name FROM App_Client C WITH (NOLOCK)
	where C.id <> 1
and (C.status & 0x20000000) = 0x20000000
		-- Exclude the clients which are marked uninstalled and deleted.
		AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
	ORDER BY C.id
	SET @xmlQuery=	(SELECT
						(SELECT Cid AS '@clientId',
								Cname AS '@clientName'
								FROM @tmpClient
								FOR XML PATH('agClientsForSQL'), TYPE)
					FOR XML PATH('App_GetSqlClientAndInstanceResp'),TYPE)
END
-- Analysis Server Instances
ELSE if(@opType = 5)
BEGIN
	INSERT INTO #tt_ValidClients
		select distinct clientId from simInstalledPackages as SC WITH (NOLOCK)
			JOIN App_client as C WITH (NOLOCK)
ON C.id = SC.clientid AND ((@OSType = 0 AND SC.simPackageID in (353, 1212)) OR (@OSType = 1 AND SC.simPackageID in (353)))
				-- Exclude the clients which are marked uninstalled and deleted.
				AND (C.status & (2|4)) = 0 -- ((CV_STATUS_UNINSTALLED) | (CV_STATUS_DELETED))
where C.releaseId >= 16 OR
(C.releaseId = 15 AND (SC.HighestSP > 7 OR (SC.HighestSP = 7 and SC.SpMinorVersion > 0 )))
	INSERT INTO #tt_ValidClients
		select distinct VMClientId From APP_VMToPMMap where PMClientId in (select id from #tt_ValidClients)
	IF @userId > 0
	BEGIN
		-- User Permission Check Code Starts
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/, 0 /* Any Permission */, 1 /* Inherit from child */, N'#tt_getAllIdaObjects'
		INSERT INTO #tt_Clients
			SELECT distinct c.id,c.name FROM  App_Client c
				JOIN #tt_getAllIdaObjects T ON T.clientId in (0,c.id)
				where C.id <> 1
and (C.status & 0x20000000) <> 0x20000000
				-- Exclude the clients which are marked uninstalled and deleted.
				AND (C.status & (2|4)) = 0 -- ((CV_STATUS_UNINSTALLED) | (CV_STATUS_DELETED))
				and EXISTS (select id from #tt_ValidClients where id = c.id )
	END
	ELSE
	BEGIN
		INSERT INTO #tt_Clients
			SELECT distinct C.id,C.name FROM  App_Client C
				where C.id <> 1
and (C.status & 0x20000000) <> 0x20000000
				-- Exclude the clients which are marked uninstalled and deleted.
				AND (C.status & (2|4)) = 0 -- ((CV_STATUS_UNINSTALLED) | (CV_STATUS_DELETED))
				and EXISTS (select id from #tt_ValidClients where id = c.id )
	END
	-- SELECT ALL SQLAG Clients
	INSERT INTO #tt_SqlInstances
		SELECT distinct C.cid,C.cname,Inst.id,Inst.name
			FROM  #tt_Clients C JOIN App_Application App
ON (App.clientId = C.cid and App.appTypeId =  81)
			JOIN App_InstanceName Inst ON Inst.id = App.instance
			LEFT OUTER JOIN APP_InstanceProp Px ON Inst.id = Px.componentNameId AND Px.attrName = 'MSSQL Server Type'
where  (((Inst.status & 0x00010) != 0x00010) AND ((Inst.status & 0x00004 ) != 0x00004))
			AND   Inst.id in (SELECT componentNameId FROM App_InstanceProp where
					attrName = 'MSSQL Version' and SUBSTRING(attrVal,0,CHARINDEX('.', attrVal)) >=11 and modified=0)
			AND (isnull(Px.attrVal, 'Analysis Services') = 'Analysis Services')
	SET @xmlQuery=	(SELECT (SELECT (SELECT  C.Cid AS '@clientId',
								C.Cname AS '@clientName' FOR XML PATH('sqlClient'), TYPE),
							    (SELECT Inst.iid AS '@instanceId',
								Inst.iname AS '@instanceName'
								FROM #tt_SqlInstances Inst
								WHERE Inst.cid =  C.cid
							    FOR XML PATH('sqlInstance'), TYPE)
						FROM (SELECT distinct cid, cname FROM #tt_SqlInstances) as  C
						FOR XML PATH('sqlClientInstances'), TYPE)
						FOR XML PATH('App_GetSqlClientAndInstanceResp'),TYPE)
END
-- APPLESS: GET all clients which has SQLIDA
ELSE if(@opType = 6)
BEGIN
	INSERT INTO #tt_ValidClients
		select distinct clientId from simInstalledPackages as SC WITH (NOLOCK)
			JOIN App_client as C WITH (NOLOCK)
ON C.id = SC.clientid AND ((@OSType = 0 AND SC.simPackageID in (353, 1212)) OR (@OSType = 1 AND SC.simPackageID in (353)))
				-- Exclude the clients which are marked uninstalled and deleted.
				AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
where C.releaseId >= 16 OR
(C.releaseId = 15 AND (SC.HighestSP > 7 OR (SC.HighestSP = 7 and SC.SpMinorVersion > 0 )))
	INSERT INTO #tt_ValidClients
		select distinct VMClientId From APP_VMToPMMap where PMClientId in (select id from #tt_ValidClients)
	IF @userId > 0
	BEGIN
		-- User Permission Check Code Starts
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/, 0 /* Any Permission */, 1 /* Inherit from child */, N'#tt_getAllIdaObjects'
		INSERT INTO #tt_Clients
			SELECT distinct c.id,c.name FROM  App_Client c
				JOIN #tt_getAllIdaObjects T ON T.clientId in (0,c.id)
				where C.id <> 1
and (C.status & 0x20000000) <> 0x20000000
				-- Exclude the clients which are marked uninstalled and deleted.
				AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
				and EXISTS (select id from #tt_ValidClients where id = c.id )
	END
	ELSE
	BEGIN
		INSERT INTO #tt_Clients
			SELECT distinct C.id,C.name FROM  App_Client C
				where C.id <> 1
and (C.status & 0x20000000) <> 0x20000000
				-- Exclude the clients which are marked uninstalled and deleted.
				AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
				and EXISTS (select id from #tt_ValidClients where id = c.id )
	END
	SET @xmlQuery=	(SELECT (SELECT (SELECT  C.Cid AS '@clientId',
								C.Cname AS '@clientName' FOR XML PATH('sqlClient'), TYPE)
						FROM (SELECT distinct cid, cname FROM #tt_Clients) as  C
						FOR XML PATH('sqlClientInstances'), TYPE)
						FOR XML PATH('App_GetSqlClientAndInstanceResp'),TYPE)
END
-- CLOUD_APPS: GET all DB engine clients which is WINDOWS
ELSE if(@opType = 7)
BEGIN
	INSERT INTO #tt_ValidClients
		select distinct clientId from simInstalledPackages as SC WITH (NOLOCK)
			JOIN App_client as C WITH (NOLOCK)
ON C.id = SC.clientid AND ((@OSType = 0 AND SC.simPackageID in (353)) OR (@OSType = 1 AND SC.simPackageID in (353)))
				-- Exclude the clients which are marked uninstalled and deleted.
				AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
where C.releaseId >= 16 OR
(C.releaseId = 15 AND (SC.HighestSP > 7 OR (SC.HighestSP = 7 and SC.SpMinorVersion > 0 )))
	INSERT INTO #tt_ValidClients
		select distinct VMClientId From APP_VMToPMMap where PMClientId in (select id from #tt_ValidClients)
	IF @userId > 0
	BEGIN
		-- User Permission Check Code Starts
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/, 0 /* Any Permission */, 1 /* Inherit from child */, N'#tt_getAllIdaObjects'
		INSERT INTO #tt_Clients
			SELECT distinct c.id,c.name FROM  App_Client c
				JOIN #tt_getAllIdaObjects T ON T.clientId in (0,c.id)
				where C.id <> 1
and (C.status & 0x20000000) <> 0x20000000
				AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
				and EXISTS (select id from #tt_ValidClients where id = c.id )
	END
	ELSE
	BEGIN
		INSERT INTO #tt_Clients
			SELECT distinct C.id,C.name FROM  App_Client C
				where C.id <> 1
and (C.status & 0x20000000) <> 0x20000000
				AND (C.status & 4) = 0 -- (CV_STATUS_DELETED)
				and EXISTS (select id from #tt_ValidClients where id = c.id )
	END
	-- SELECT ALL SQL instances
	INSERT INTO #tt_SqlInstances
		SELECT distinct C.cid,C.cname,Inst.id,Inst.name
			FROM  #tt_Clients C JOIN App_Application App
ON (App.clientId = C.cid and App.appTypeId =  81)
			JOIN App_InstanceName Inst ON Inst.id = App.instance
			LEFT OUTER JOIN APP_InstanceProp Px ON Inst.id = Px.componentNameId AND Px.attrName = 'MSSQL Server Type'
where  (((Inst.status & 0x00010) != 0x00010) AND ((Inst.status & 0x00004 ) != 0x00004))
			AND   Inst.id in (SELECT componentNameId FROM App_InstanceProp where
					attrName = 'MSSQL Version' and SUBSTRING(attrVal,0,CHARINDEX('.', attrVal)) >=11 and modified=0)
			AND (isnull(Px.attrVal, 'Database Engine') = 'Database Engine')
	SET @xmlQuery=	(SELECT (SELECT (SELECT  C.Cid AS '@clientId',
								C.Cname AS '@clientName' FOR XML PATH('sqlClient'), TYPE),
							    (SELECT Inst.iid AS '@instanceId',
								Inst.iname AS '@instanceName'
								FROM #tt_SqlInstances Inst
								WHERE Inst.cid =  C.cid
							    FOR XML PATH('sqlInstance'), TYPE)
						FROM (SELECT distinct cid, cname FROM #tt_SqlInstances) as  C
						FOR XML PATH('sqlClientInstances'), TYPE)
						FOR XML PATH('App_GetSqlClientAndInstanceResp'),TYPE)
END
SELECT @xmlQuery AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMSSQLInstances')
	delete from GxQscripts where name = 'AppGetMSSQLInstances'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMSSQLInstances')
	delete from GXDBVersions where aliasname = 'AppGetMSSQLInstances'
GO

insert into GXDBVersions values(2, 'AppGetMSSQLInstances',  '00000000000000000000', 'AppGetMSSQLInstances', '00000000000000000000')
GO

