

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetMMPerformanceHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetMMPerformanceHistory')
BEGIN
	print '>>> Drop Stored Procedure: AppGetMMPerformanceHistory <<<'
	drop procedure AppGetMMPerformanceHistory
END
IF EXISTS (select * from GxQscripts where name='AppGetMMPerformanceHistory')
	delete from GxQscripts where name = 'AppGetMMPerformanceHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMMPerformanceHistory')
	delete from GXDBVersions where aliasname = 'AppGetMMPerformanceHistory'
GO
print '... Creating Procedure: AppGetMMPerformanceHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetMMPerformanceHistory
  @clientId INT,
  @daysToConsider INT,
  @hoursToConsider INT,
  @minutesToConsider INT
AS
  DECLARE @creationDate INT
  DECLARE @cpuUsage INT
  DECLARE @physicalMemoryKB BIGINT
  DECLARE @percentFreePhysicalMemory INT
  DECLARE @virtualMemoryKB BIGINT
  DECLARE @percentFreeVirtualMemory INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @startDate DATETIME
	IF @daysToConsider > 0
		SET @startDate = DATEADD(DAY, -1* @daysToConsider, GETDATE())
	ELSE IF @hoursToConsider > 0
		SET @startDate = DATEADD(HOUR, -1* @hoursToConsider, GETDATE())
	ELSE IF @minutesToConsider > 0
		SET @startDate = DATEADD(MINUTE, -1* @minutesToConsider, GETDATE())
	ELSE
		SET @startDate = DATEADD(MINUTE, -1* 90, GETDATE())
	SELECT [DBO].GetUnixTime(creationDate) AS creationDate, cpuUsage, physicalMemoryKB, percentFreePhysicalMemory, virtualMemoryKB, percentFreeVirtualMemory
		FROM [HistoryDB].[dbo].MMPerformanceHistory WHERE clientId = @clientId AND creationDate > @startDate ORDER BY creationDate
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetMMPerformanceHistory')
	delete from GxQscripts where name = 'AppGetMMPerformanceHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetMMPerformanceHistory')
	delete from GXDBVersions where aliasname = 'AppGetMMPerformanceHistory'
GO

insert into GXDBVersions values(2, 'AppGetMMPerformanceHistory',  '00000000000000000000', 'AppGetMMPerformanceHistory', '00000000000000000000')
GO

