

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLuceneIdxServerReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =================================================================================
-- Author:		Durgesh Kumar Gupta
-- Description:	Get the List of Lucene Index servers along with list of associated subclients and their app type.
--				If req type is ALL then all index servers are returned, if req type is RETENTION then only those index server whose subclient's users have rentention policy
--				else if req type is WEEKLYSTATS then only those index servers where we need to run computation for each mailbox's app size and no. of items.
-- =================================================================================
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetLuceneIdxServerReq.sp,v $ $Id: AppGetLuceneIdxServerReq.sp,v 1.1.2.7 2020/12/15 00:08:55 sjanakiraman Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetLuceneIdxServerReq')
BEGIN
	print '>>> Drop Stored Procedure: AppGetLuceneIdxServerReq <<<'
	drop procedure AppGetLuceneIdxServerReq
END
IF EXISTS (select * from GxQscripts where name='AppGetLuceneIdxServerReq')
	delete from GxQscripts where name = 'AppGetLuceneIdxServerReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLuceneIdxServerReq')
	delete from GXDBVersions where aliasname = 'AppGetLuceneIdxServerReq'
GO
print '... Creating Procedure: AppGetLuceneIdxServerReq'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetLuceneIdxServerReq
  @inXMl XML
AS
BEGIN
  DECLARE @outputXML XML 
DECLARE @inIndexServerId INT
DECLARE @reqType INT
SET @inIndexServerId	= ISNULL( (SELECT ref.value('@clientId', 'int') FROM @inXML.nodes('App_GetLuceneIdxServerReq') R(ref)), 0)
SET @reqType			= ISNULL( (SELECT ref.value('@reqType', 'int') FROM @inXML.nodes('App_GetLuceneIdxServerReq') R(ref)), 0)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @reqType = 0 /* GetLuceneIdxServerReqType_ALL */
BEGIN
	SET @outputXML = (
SELECT idxServerList.currentIdxServer AS idxServerId, idxServerList.type AS appType, subClientList.id AS subclientId, 7 AS _type_
		FROM App_IndexDbInfo idxServerList  WITH(NOLOCK) INNER JOIN APP_Application subClientList WITH(NOLOCK)
ON idxServerList.backupSetId = subClientList.backupSet AND idxServerList.type IN (78, 200118, 200127, 200128)
		AND idxServerList.idxDbEngineType = 2 /* LUCENE DB ONLY */
		ORDER BY idxServerList.currentIdxServer , idxServerList.type, subClientList.id
		FOR XML AUTO, ROOT('App_GetLuceneIdxServerResp')
	)
END
ELSE IF @reqType = 1 /* GetLuceneIdxServerReqType_RETENTION */
BEGIN
	SET @outputXML = (
		SELECT IDX.currentIdxServer AS '@idxServerId', IDX.type AS '@appType' FROM App_IndexDbInfo IDX  WITH(NOLOCK) INNER JOIN APP_Application APP WITH(NOLOCK)
ON IDX.backupSetId = APP.backupSet AND IDX.type IN (78, 200118,200127, 200128)
		AND IDX.idxDbEngineType = 2 /* LUCENE DB ONLY */ AND APP.id IN
		(
			SELECT DISTINCT(CAP.subClientId)
			FROM APP_CloudAppUserDetails CAP WITH(NOLOCK) INNER JOIN
			App_PlanProp PP WITH(NOLOCK) ON CAP.planId = PP.componentNameId
			WHERE CAP.modified = 0 AND PP.modified = 0 AND PP.attrName = 'Office 365 retention policy'
		)
		GROUP BY IDX.type , IDX.currentIdxServer
		FOR XML PATH('idxServerList'), ROOT('App_GetLuceneIdxServerResp')
	)
END
ELSE IF @reqType = 2 /* GetLuceneIdxServerReqType_WEEKLYSTATS */
BEGIN
	SET @outputXML = (
SELECT idxServerList.currentIdxServer AS idxServerId, idxServerList.type AS appType, subClientList.id AS subclientId, 7 AS _type_
		FROM App_IndexDbInfo idxServerList  WITH(NOLOCK) INNER JOIN APP_Application subClientList WITH(NOLOCK)
ON idxServerList.backupSetId = subClientList.backupSet AND idxServerList.type IN (200118, 200128, 78)
		AND idxServerList.idxDbEngineType = 2 /* LUCENE DB ONLY*/ AND subClientList.id IN
		(
			SELECT DISTINCT(CAP.subClientId)
			FROM APP_CloudAppUserDetails CAP WITH(NOLOCK)
			WHERE CAP.IdxCollectionTime IS NOT NULL AND CAP.IdxCollectionTime < DATEDIFF(SECOND,{d '1970-01-01'},DATEADD(WEEK,-1,GETDATE()))
		)
		ORDER BY idxServerList.currentIdxServer , idxServerList.type
		FOR XML AUTO, ROOT('App_GetLuceneIdxServerResp')
	)
END
ELSE IF @reqType = 3 --space reclamation
BEGIN
	DECLARE @c_spaceReclamationInterval  DECIMAL
	SET @c_spaceReclamationInterval = ISNULL( (SELECT value from MMConfigs WITH(NOLOCK) where name ='SPACE_RECLAMATION_PERIODIC_INTERVAL_IN_DAYS'),0)
	IF @c_spaceReclamationInterval > 0
	BEGIN
		DECLARE @c_supportedBackupsets INT
		SET @c_supportedBackupsets = ISNULL( (SELECT value from MMConfigs WITH(NOLOCK) where name ='SPACE_RECLAMATION_SUPPORTED_EXCH_BACKUPSETS'),0)
		IF OBJECT_ID('tempdb.dbo.#tempSubclientsToIndexServer') IS NOT NULL     DROP TABLE #tempSubclientsToIndexServer
			CREATE TABLE #tempSubclientsToIndexServer( indexServerClientId INT, appType INT, subclientID INT)
		IF @c_supportedBackupsets = 1
		BEGIN
			INSERT INTO #tempSubclientsToIndexServer
			SELECT DISTINCT 0, 137, conf.subclientId
			FROM APP_EmailConfigPolicyAssoc conf WITH(NOLOCK)
			JOIN APP_BackupSetName B WITH(NOLOCK) ON B.id = conf.backupsetId
			JOIN APP_BackupSetProp BP WITH(NOLOCK) ON BP.componentNameId = B.id
			WHERE conf.modified = 0 AND BP.modified = 0
			AND BP.attrName = 'Exchange OnePass BackupSet Type'
			AND BP.attrVal = N'1'
		END
		ELSE IF @c_supportedBackupsets = 2
		BEGIN
			INSERT INTO #tempSubclientsToIndexServer
			SELECT DISTINCT 0, 137, conf.subclientId
			FROM APP_EmailConfigPolicyAssoc conf WITH(NOLOCK)
			JOIN APP_BackupSetName B WITH(NOLOCK) ON B.id = conf.backupsetId
			JOIN APP_BackupSetProp BP WITH(NOLOCK) ON BP.componentNameId = B.id
			WHERE conf.modified = 0 AND BP.modified = 0
			AND BP.attrName = 'Exchange OnePass BackupSet Type'
			AND BP.attrVal in (N'2',N'3')
		END
		ELSE IF @c_supportedBackupsets = 3
		BEGIN
			INSERT INTO #tempSubclientsToIndexServer
			SELECT DISTINCT 0, 137, conf.subclientId
			FROM APP_EmailConfigPolicyAssoc conf WITH(NOLOCK)
			WHERE conf.modified = 0
		END
		UPDATE #tempSubclientsToIndexServer
		SET indexServerClientId = CAST(IdaProp.attrVal as INTEGER)
		FROM #tempSubclientsToIndexServer T
		JOIN APP_Application A WITH(NOLOCK) ON A.id = T.subclientID
		JOIN APP_IdaName Ida WITH(NOLOCK) ON Ida.clientId = A.clientId
		JOIN APP_IDAProp IdaProp WITH(NOLOCK) ON IdaProp.componentNameId = Ida.id
		WHERE IdaProp.attrname =  'OnePass Index Server'
		AND IdaProp.modified = 0
		SET @outputXML = (
			SELECT idxServerList.indexServerClientId AS idxServerId, idxServerList.appType AS appType, subClientList.subclientID AS subclientId, 7 AS _type_
			FROM #tempSubclientsToIndexServer idxServerList
			JOIN #tempSubclientsToIndexServer subClientList ON subClientList.subclientID = idxServerList.subclientID
			LEFT JOIN ( select *, ROW_NUMBER() OVER( PARTITION BY SubclientId order by CollectionTime Desc) AS R FROM IdxArchiveFile WITH(NOLOCK)
			) TMP ON  TMP.subclientId = idxserverList.subclientID AND TMP.R = 1 --join only 1 row per subclient to get max collectiontime
			Where  @c_spaceReclamationInterval > 0  AND
			(TMP.CollectionTime is NULL OR DATEDIFF(DAY, DATEADD(s,TMP.CollectionTime,'19700101'), GETUTCDATE()) > 			@c_spaceReclamationInterval )
			ORDER BY idxServerList.indexServerClientId , idxServerList.appType
			FOR XML AUTO, ROOT('App_GetLuceneIdxServerResp')
			)
	END
END
PROC_END:
IF @outputXML IS NULL
	SET @outputXML = '<App_GetLuceneIdxServerResp/>'
SELECT @outputXML
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLuceneIdxServerReq')
	delete from GxQscripts where name = 'AppGetLuceneIdxServerReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLuceneIdxServerReq')
	delete from GXDBVersions where aliasname = 'AppGetLuceneIdxServerReq'
GO

insert into GXDBVersions values(2, 'AppGetLuceneIdxServerReq',  '00010001000200070000', 'AppGetLuceneIdxServerReq', '00010001000200070000')
GO

