

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLocalizedMessages.sp] ---------- 

--  +==========================================================================================
--  | Stored Procedure: Get localized messages for the request
--  +==========================================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetLocalizedMessages')
BEGIN
	print '>>> Drop Stored Procedure: AppGetLocalizedMessages <<<'
	drop procedure AppGetLocalizedMessages
END
IF EXISTS (select * from GxQscripts where name='AppGetLocalizedMessages')
	delete from GxQscripts where name = 'AppGetLocalizedMessages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLocalizedMessages')
	delete from GXDBVersions where aliasname = 'AppGetLocalizedMessages'
GO
print '... Creating Procedure: AppGetLocalizedMessages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetLocalizedMessages
  @localizeMsgRequest XML
AS
    SET NOCOUNT ON
	DECLARE @error XML
	DECLARE @rowCount int
BEGIN TRY
	DECLARE @localeId INT = ISNULL((SELECT ref.value('@localeId', 'INT') FROM @localizeMsgRequest.nodes('App_LocalizeMessageRequest') R(ref)), 0)
	IF OBJECT_ID('tempdb.dbo.#localizeMessages') IS NOT NULL DROP TABLE #localizeMessages
	CREATE TABLE #localizeMessages (rowId INT,messageId varchar(256) , messageType INT, messageText nvarchar(2048))
	CREATE NONCLUSTERED INDEX localizeMessages_messageId_idx ON #localizeMessages(messageId) INCLUDE (messageText,rowId)
	CREATE NONCLUSTERED INDEX localizeMessages_messageType_idx ON #localizeMessages(messageType)
	INSERT INTO #localizeMessages(rowId,messageId,messageType)
        SELECT ref.value('@rowId', 'INT'), ref.value('@messageId','varchar(256)'), ref.value('@messageType', 'INT')
        FROM @localizeMsgRequest.nodes('App_LocalizeMessageRequest/messageList') R(ref)
	SET @rowCount = @@ROWCOUNT
	IF(@rowCount = 0)
	BEGIN
		RAISERROR ('Request is empty.', 16, 1 )
	END
	--enum LocalizeMessageType{EVENT = 0, JPR  = 1, SLACATEGORY =2}
	IF EXISTS (SELECT 1 FROM #localizeMessages WHERE messageType = 0) -- EVENT
	BEGIN
		UPDATE LM SET LM.messageText = evl.Message
		FROM	#localizeMessages LM
				INNER JOIN dbo.EvLocaleMsgs(nolock) evl ON LM.messageType = 0
				AND LM.messageId = CAST(evl.MessageID AS VARCHAR(256))
		WHERE evl.LocaleID = @localeId
	END
	IF EXISTS (SELECT 1 FROM #localizeMessages WHERE messageType = 1) -- JPR
	BEGIN
		UPDATE #localizeMessages SET messageText = DBO.JMGetLocalizedMessageFunc(@localeId,messageId) WHERE messageType = 1
	END
	IF EXISTS (SELECT 1 FROM #localizeMessages WHERE messageType = 2) --SLACATEGORY
	BEGIN
		UPDATE #localizeMessages SET messageText = dbo.WR_GetSLACategoryString(@localeId, CAST(messageId AS INT) ) WHERE messageType = 2
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @error = ( SELECT
			           ERROR_NUMBER() '@errorCode',
				        'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() '@errorMessage'
                        FOR XML PATH('error'), TYPE
                   )
END  CATCH
	SELECT
		@error,
		(SELECT	LM.rowId	   as '@rowId',
				LM.messageId   as '@messageId',
				LM.messageType as '@messageType',
				LM.messageText as '@messageText'
			FROM #localizeMessages LM
			FOR	XML PATH('messageList'), TYPE
		)
	FOR  XML PATH('App_LocalizeMessageResponse'),TYPE
    IF OBJECT_ID('tempdb.dbo.#localizeMessages') IS NOT NULL DROP TABLE #localizeMessages
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLocalizedMessages')
	delete from GxQscripts where name = 'AppGetLocalizedMessages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLocalizedMessages')
	delete from GXDBVersions where aliasname = 'AppGetLocalizedMessages'
GO

insert into GXDBVersions values(2, 'AppGetLocalizedMessages',  '00000000000000000000', 'AppGetLocalizedMessages', '00000000000000000000')
GO

