

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLiveUpdatesArchFileInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Example input <Indexing_GetLiveUpdatesArchFileInfo backupSetGuid="guid" dbGuid="guid" fromTime="unixtime"/>
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetLiveUpdatesArchFileInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetLiveUpdatesArchFileInfo <<<'
	drop procedure AppGetLiveUpdatesArchFileInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetLiveUpdatesArchFileInfo')
	delete from GxQscripts where name = 'AppGetLiveUpdatesArchFileInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLiveUpdatesArchFileInfo')
	delete from GXDBVersions where aliasname = 'AppGetLiveUpdatesArchFileInfo'
GO
print '... Creating Procedure: AppGetLiveUpdatesArchFileInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetLiveUpdatesArchFileInfo
  @xmlText XML
AS
DECLARE @outxmlText XML
DECLARE @fromTime       INTEGER         = ISNULL(@xmlText.value('(/Indexing_LiveUpdatesArchFileInfoReq/@fromTime)[1]', 'INTEGER'), 0)
DECLARE @dbGuid         VARCHAR(max)    = @xmlText.value('(/Indexing_LiveUpdatesArchFileInfoReq/@dbGuid)[1]', 'varchar(max)')
DECLARE @backupSetGuid  VARCHAR(max)    = @xmlText.value('(/Indexing_LiveUpdatesArchFileInfoReq/@backupSetGuid)[1]', 'varchar(max)')
DECLARE @bsId INT = 0
SELECT @bsId = id FROM App_BackupsetName WITH(NOLOCK) WHERE GUID = @backupSetGuid
DECLARE @temparchfileName TABLE(archfileName NVARCHAR(max))
INSERT INTO @temparchfileName
SELECT 'IdxLiveLogs_' + @backupsetGuid + ':' + @dbGuid
IF(SELECT dbo.isSubClientIndexEnabled(@bsId)) > 0
BEGIN
--For subclient index fetch from backupset also
	INSERT INTO @temparchfileName
	SELECT 'IdxLiveLogs_' + @backupsetGuid + ':' + @backupsetGuid
END
SET @outxmlText = (
SELECT DISTINCT
    id AS '@afileId', archGroupId AS '@archGroupId', commCellId AS '@commCellId', appId AS '@appId'
    FROM archfile  WITH (NOLOCK)
	JOIN @temparchfileName ON cs_afname = CHECKSUM(archfileName)  AND isValid = 1 AND cTime >= @fromTime AND name = archfileName
	FOR XML PATH('afiles'), ROOT('Indexing_LiveUpdatesArchFileInfoResp'))
SELECT  @outxmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLiveUpdatesArchFileInfo')
	delete from GxQscripts where name = 'AppGetLiveUpdatesArchFileInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLiveUpdatesArchFileInfo')
	delete from GXDBVersions where aliasname = 'AppGetLiveUpdatesArchFileInfo'
GO

insert into GXDBVersions values(2, 'AppGetLiveUpdatesArchFileInfo',  '00000000000000000000', 'AppGetLiveUpdatesArchFileInfo', '00000000000000000000')
GO

