

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLiveLogsDbDetails.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  AppGetLiveLogsDbDetails.sp                               */
/*                                                                            */
/*  Description :  Stored procedure that returns list of last index archive   */
/*		   file in each cycle for given appId(s) and a time range     		  */
/*		   followed by a list of all the index                        		  */
/*		   and data archive files in all those cycles		      			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetLiveLogsDbDetails.sp,v $ $Id: AppGetLiveLogsDbDetails.sp,v 1.1.2.3 2020/12/28 18:43:05 sbhukar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetLiveLogsDbDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetLiveLogsDbDetails <<<'
	drop procedure AppGetLiveLogsDbDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetLiveLogsDbDetails')
	delete from GxQscripts where name = 'AppGetLiveLogsDbDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLiveLogsDbDetails')
	delete from GXDBVersions where aliasname = 'AppGetLiveLogsDbDetails'
GO
print '... Creating Procedure: AppGetLiveLogsDbDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetLiveLogsDbDetails
  @i_appType INTEGER,
  @i_clientId INTEGER
AS
  DECLARE @r_backupsetId INTEGER;
  DECLARE @r_subclientId INTEGER;
  DECLARE @r_error VARCHAR(2048);
IF object_id('tempdb.dbo.#liveLogDbs') is not null
     DROP TABLE #liveLogDbs
CREATE TABLE #liveLogDbs(bsId INT, subclientID INT, MAHighestSP INT)
INSERT INTO #liveLogDbs
SELECT DISTINCT APP.backupSet, CASE WHEN Idx.backupSetGUID = Idx.dbName THEN -1 ELSE App.id END, SIM.HighestSP
FROM APP_Application APP WITH (NOLOCK)
JOIN App_IndexDBInfo IDX WITH (NOLOCK) ON APP.backupSet = IDX.backupSetId
JOIN simInstalledPackages SIM WITH (NOLOCK) ON SIM.ClientId = Idx.currentIdxServer AND simPackageID IN (51,1301)
WHERE APP.appTypeId = @i_appType AND APP.clientId = @i_clientId
AND (dbo.isSubClientIndexEnabled(IDX.backupSetId) = 0  OR App.GUID = Idx.dbName)
AND EXISTS(SELECT 1 FROM Archfile af WITH(NOLOCK) WHERE af.appid = APP.id AND af.isValid = 1)
IF EXISTS(SELECT 1 FROM #liveLogDbs WHERE MAHighestSP < 22)
	SELECT 0,0,'All Media Agent should be upgraded to SP22 for this operation to work'
ELSE
	SELECT DISTINCT bsId, subclientID, '' FROM #liveLogDbs
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLiveLogsDbDetails')
	delete from GxQscripts where name = 'AppGetLiveLogsDbDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLiveLogsDbDetails')
	delete from GXDBVersions where aliasname = 'AppGetLiveLogsDbDetails'
GO

insert into GXDBVersions values(2, 'AppGetLiveLogsDbDetails',  '00010001000200030000', 'AppGetLiveLogsDbDetails', '00010001000200030000')
GO

