

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLiveBrowseRecoveryPoints.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetLiveBrowseRecoveryPoints.sp,v $ $Id: AppGetLiveBrowseRecoveryPoints.sp,v 1.1.2.17 2019/12/27 12:57:58 shussain Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetLiveBrowseRecoveryPoints')
BEGIN
	print '>>> Drop Stored Procedure: APPGetLiveBrowseRecoveryPoints <<<'
	drop procedure APPGetLiveBrowseRecoveryPoints
END
IF EXISTS (select * from GxQscripts where name='APPGetLiveBrowseRecoveryPoints')
	delete from GxQscripts where name = 'APPGetLiveBrowseRecoveryPoints'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetLiveBrowseRecoveryPoints')
	delete from GXDBVersions where aliasname = 'APPGetLiveBrowseRecoveryPoints'
GO
print '... Creating Procedure: APPGetLiveBrowseRecoveryPoints'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetLiveBrowseRecoveryPoints
  @i_xml XML OUTPUT
AS
  DECLARE @outputXML XML
DECLARE @errorCode INTEGER = 0
DECLARE @errorString NVARCHAR(1024) = ''
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE		@id				INTEGER
DECLARE		@searchKey		NVARCHAR(2048)
DECLARE		@srcClientId	INTEGER
DECLARE		@srcInstanceId	INTEGER
DECLARE		@srcBkpSetId	INTEGER
DECLARE		@srcSubClientId	INTEGER
DECLARE		@mountHostId	INTEGER
DECLARE		@mountHostName	NVARCHAR(1024)
DECLARE		@bkpJobId		INTEGER
DECLARE		@recoveryTime	INTEGER
DECLARE		@rpJobId		INTEGER
DECLARE		@srcPath		NVARCHAR(1024)
DECLARE		@mountPath		NVARCHAR(1024)
DECLARE		@phase			VARCHAR(20)
DECLARE		@appType		INTEGER
DECLARE		@bkpType		INTEGER
DECLARE		@appData		NVARCHAR(MAX)
DECLARE		@expireTime		INTEGER
DECLARE		@userName		NVARCHAR(1024)
DECLARE		@initRequest	NVARCHAR(MAX)
DECLARE		@createTime		INTEGER
DECLARE		@userId			INTEGER = 1
DECLARE		@sort			INTEGER = 1
DECLARE		@order			INTEGER = 0
DECLARE		@propertyLevel	INTEGER = 0
DECLARE		@noPaging		INTEGER = 1
DECLARE		@startIndex		INTEGER = 0
DECLARE		@maxSize		INTEGER = 50
DECLARE		@search_term	NVARCHAR(256)
DECLARE		@cloneName  	NVARCHAR(256)
DECLARE		@databaseNameKey NVARCHAR(256)
DECLARE		@srcInstKey		NVARCHAR(256)
DECLARE		@destInstKey	NVARCHAR(256)
SELECT 		@id=ISNULL(( SELECT ref.value('@id','INTEGER')) ,0)
                ,@searchKey= ISNULL(( SELECT ref.value('@searchKey','NVARCHAR(2048)')), '')
				,@srcClientId= ISNULL(( SELECT ref.value('@srcClientId','INTEGER')), 0)
				,@srcInstanceId= ISNULL(( SELECT ref.value('@srcInstanceId','INTEGER')), 0)
				,@srcBkpSetId= ISNULL(( SELECT ref.value('@srcBkpSetId','INTEGER')), 0)
				,@srcSubClientId= ISNULL(( SELECT ref.value('@srcSubclientId','INTEGER')), 0)
				,@mountHostId= ISNULL(( SELECT ref.value('@mountHostId','INTEGER')),0)
				,@mountHostName= ISNULL(( SELECT ref.value('@mountHostName','NVARCHAR(1024)')),'')
				,@bkpJobId= ISNULL(( SELECT ref.value('@bkpJobId','INTEGER')),0)
				,@recoveryTime= ISNULL(( SELECT ref.value('@recoveryTime','INTEGER')),0)
				,@rpJobId= ISNULL(( SELECT ref.value('@rpJobId','INTEGER')),0)
				,@srcPath= ISNULL(( SELECT ref.value('@srcPath','NVARCHAR(1024)')), '')
				,@mountPath= ISNULL(( SELECT ref.value('@mountPath','NVARCHAR(1024)')), '')
				,@phase= ISNULL(( SELECT ref.value('@phase','VARCHAR(20)')), '')
				,@appType= ISNULL(( SELECT ref.value('@appType','INTEGER')),0)
				,@bkpType= ISNULL(( SELECT ref.value('@bkpType','INTEGER')),0)
				,@appData= ISNULL(( SELECT ref.value('@appData','NVARCHAR(MAX)')), '')
				,@expireTime= ISNULL(( SELECT ref.value('@expireTime','INTEGER')),0)
				,@userName= ISNULL(( SELECT ref.value('@userName','NVARCHAR(1024)')), '')
				,@initRequest= ISNULL(( SELECT ref.value('@initRequest','NVARCHAR(MAX)')), '')
				,@createTime= ISNULL(( SELECT ref.value('@createTime','INTEGER')),0)
FROM @i_xml.nodes('Ida_GetLiveBrowseRecoveryPointsReq/rpObject') R(ref)
SELECT @userId = ISNULL(( SELECT ref.value('@userId','INTEGER')), 1)
	FROM @i_xml.nodes('Ida_GetLiveBrowseRecoveryPointsReq') R(ref)
SELECT @sort = ISNULL(( SELECT ref.value('@sortIndex','INTEGER')), 1)
	FROM @i_xml.nodes('Ida_GetLiveBrowseRecoveryPointsReq') R(ref)
SELECT @order = ISNULL(( SELECT ref.value('@sortOrder','INTEGER')), 0)
	FROM @i_xml.nodes('Ida_GetLiveBrowseRecoveryPointsReq') R(ref)
SELECT @propertyLevel = ISNULL(( SELECT ref.value('@propertyLevel','INTEGER')), 0)
	FROM @i_xml.nodes('Ida_GetLiveBrowseRecoveryPointsReq') R(ref)
SELECT @noPaging = ISNULL(( SELECT ref.value('@noPaging','INTEGER')), 1)
	FROM @i_xml.nodes('Ida_GetLiveBrowseRecoveryPointsReq/paging') R(ref)
IF @noPaging = 0
BEGIN
	SELECT @startIndex	= ISNULL(( SELECT ref.value('@startIndex','INTEGER')), 1)
				FROM @i_xml.nodes('Ida_GetLiveBrowseRecoveryPointsReq/paging') R(ref)
	SELECT @maxSize	= ISNULL(( SELECT ref.value('@maxSize','INTEGER')), 1)
				FROM @i_xml.nodes('Ida_GetLiveBrowseRecoveryPointsReq/paging') R(ref)
END
SELECT @search_term	= N'%' + ISNULL((SELECT @i_xml.value('(/Ida_GetLiveBrowseRecoveryPointsReq/search/@searchKey)[1]','NVARCHAR(256)')), N'') + N'%'
SELECT @cloneName	= N'%' + ISNULL((SELECT @i_xml.value('(/Ida_GetLiveBrowseRecoveryPointsReq/search/@cloneNameKey)[1]','NVARCHAR(256)')), N'') + N'%'
SELECT @databaseNameKey	= N'%' + ISNULL((SELECT @i_xml.value('(/Ida_GetLiveBrowseRecoveryPointsReq/search/@databaseNamekey)[1]','NVARCHAR(256)')), N'') + N'%'
SELECT @srcInstKey	= N'%' + ISNULL((SELECT @i_xml.value('(/Ida_GetLiveBrowseRecoveryPointsReq/search/@srcInstanceNameKey)[1]','NVARCHAR(256)')), N'') + N'%'
SELECT @destInstKey	= N'%' + ISNULL((SELECT @i_xml.value('(/Ida_GetLiveBrowseRecoveryPointsReq/search/@instanceNameKey)[1]','NVARCHAR(256)')), N'') + N'%'
BEGIN TRY
IF @appType <> 81 /*CV_APPTYPE_MSSQL*/
	BEGIN
	SET @outputXML = (
		SELECT
			appRp.id as "@id",
			appRp.searchKey as "@searchKey",
			appRp.srcClientId as "@srcClientId",
			appRp.srcInstanceId as "@srcInstanceId",
			appRp.srcBkpSetId as "@srcBkpSetId",
			appRp.srcSubClientId as "@srcSubclientId",
			appRp.mountHostId as "@mountHostId",
			appRp.bkpJobId as "@bkpJobId",
			appRp.recoveryTime as "@recoveryTime",
			appRp.rpJobId as "@rpJobId",
			appRp.srcPath as "@srcPath",
			appRp.mountPath as "@mountPath",
			appRp.phase as "@phase",
			appRp.appType as "@appType",
			appRp.bkpType as "@bkpType",
			cast(appRp.appData as nvarchar(MAX)) as "@appData",
			appRp.expireTime as "@expireTime",
			appRp.userName as "@userName",
			cast(appRp.initRequest as nvarchar(MAX)) as "@initRequest",
			appRp.createTime as "@createTime",
			ac.name as mountHostName
			FROM
				APP_LiveBrowseRecoveryPoints appRp
					inner join
				APP_Client ac
			on ac.id = appRp.mountHostId
			WHERE
			( (@id = 0 				OR 		appRp.id = @id) 						AND
			(@searchKey = '' 		OR 		searchKey = @searchKey) 		AND
			(@srcClientId = 0 		OR 		srcClientId = @srcClientId) 	AND
			(@srcInstanceId = 0 	OR 		srcInstanceId = @srcInstanceId) AND
	((@srcBkpSetId = 0 		OR 		srcBkpSetId = @srcBkpSetId) OR (@appType = 81))	AND
			(@srcSubClientId = 0 	OR 		srcSubClientId = @srcSubclientId) AND
			(@mountHostId = 0 		OR 		mountHostId = @mountHostId) 	AND
			(@mountHostName = '' 	OR 		cast(ac.name as nvarchar(1024))= @mountHostName) 	AND
			(@bkpJobId = 0 			OR 		bkpJobId = @bkpJobId) 			AND
			(@recoveryTime = 0 		OR 		recoveryTime = @recoveryTime) 	AND
			(@rpJobId = 0 			OR 		rpJobId = @rpJobId) 			AND
			(@srcPath = '' 			OR 		srcPath = @srcPath) 			AND
			(@mountPath = '' 		OR 		mountPath = @mountPath ) 		AND
			(@phase = '' 			OR 		phase = @phase) 				AND
			(@appType = 0 			OR 		appType = @appType) 			AND
			(@bkpType = 0 			OR 		bkpType = @bkpType) 			AND
			(@appData = '' 			OR 		cast(appData as nvarchar(MAX)) = @appData) 			AND
			(@expireTime = 0 		OR 		expireTime = @expireTime) 		AND
			(@userName = '' 			OR 		userName = @userName) 					AND
			(@InitRequest = '' 		OR 		cast(initRequest as nvarchar(MAX)) = @initRequest) AND
			(@createTime = 0 		OR 		createTime = @createTime) 	)
		 FOR XML PATH('rpObjectList') , ELEMENTS, ROOT('Ida_GetLiveBrowseRecoveryPointsResp') ,TYPE)
	END
	ELSE
	BEGIN
		-- User Permission Check Code Starts
		IF OBJECT_ID('tempdb.dbo.#tt_getAllIdaObjects') IS NOT NULL DROP TABLE #tt_getAllIdaObjects
		CREATE TABLE #tt_getAllIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
		-- Param ref: @userId, 3 (CLIENT_ENTITY), 0 (Any Permission), 1 (Inherit from child), N'#tt_getAllIdaObjects'
EXEC sec_getIdaObjectsForUser @userId,  3 , 0, 1, N'#tt_getAllIdaObjects'
		-- Live browse RPs.
		IF OBJECT_ID('tempdb..#SqlLiveBrowseRps') IS NOT NULL DROP TABLE #SqlLiveBrowseRps
		CREATE TABLE #SqlLiveBrowseRps (rn int identity, id int, searchKey nvarchar(1024), srcBkpSetId int, srcSubclientId int, srcClientId int, srcInstanceId int, mountHostId int,
			mountHostName nvarchar(1024),   bkpJobId int, rpJobId int, appData  XML, srcPath nvarchar(1024), mountPath nvarchar(1024),
			phase int, bkpType int, recoveryTime int, expireTime int, appType int, userName nvarchar(1024), initRequest nvarchar(MAX), createTime int,
			sourceDatabaseId int, sourceDatabaseVersion nvarchar(1024), sourceDatabaseSize bigint, primary key(id, srcPath, mountPath))
		-- Get mount host instance ID.
		IF OBJECT_ID('tempdb..#SqlLiveBrowseMountInstance') IS NOT NULL DROP TABLE #SqlLiveBrowseMountInstance
		CREATE TABLE #SqlLiveBrowseMountInstance (id int, mountInstanceId int, mountversion nvarchar(1024), primary key(id))
		INSERT INTO #SqlLiveBrowseMountInstance
			SELECT jc.id, P.pc.value('@instanceId', 'INT') as instance, AIP.attrVal
				FROM APP_LiveBrowseRecoveryPoints jc
					CROSS APPLY jc.appData.nodes('/Ida_RPAppData/sqlAppData/mountInstance') P(pc)
					JOIN APP_InstanceProp AIP  ON AIP.componentNameId = P.pc.value('@instanceId', 'INT')
							AND AIP.attrName = 'MSSQL Version' AND AIP.modified = 0
		-- Insert basic information.
		IF @order = 0
		BEGIN
			INSERT INTO #SqlLiveBrowseRps
				SELECT appRp.id, appRp.searchKey, appRp.srcBkpSetId, appRp.srcSubClientId, appRp.srcClientId, appRp.srcInstanceId, appRp.mountHostId,
					ac.name as mountHostName, appRp.bkpJobId, appRp.rpJobId, CAST(appRp.appData AS XML) as appData, appRp.srcPath, appRp.mountPath, appRp.phase, appRp.bkpType,
					appRp.recoveryTime, appRp.expireTime, appRp.appType, appRp.userName, cast(appRp.initRequest as nvarchar(MAX)) as initRequest, appRp.createTime,
					SN.id as sourceDatabaseId, IP.attrVal as sourceDatabaseVersion, SDB.backup_size as sourceDatabaseSize
				FROM APP_LiveBrowseRecoveryPoints appRp
						JOIN APP_Client ac on ac.id = appRp.mountHostId
						JOIN APP_InstanceName AIN ON AIN.id = appRp.srcInstanceId
						JOIN APP_InstanceProp IP ON appRp.srcInstanceId = IP.componentNameId
							AND IP.attrName = 'MSSQL Version' AND IP.modified = 0
						JOIN sqlNames2 SN2 ON SN2.name = appRp.srcPath AND SN2.type = 1
						JOIN sqlNames SN ON SN.sqlId = SN2.id AND SN.type = 1
						JOIN sqlDbBackupInfo SDB ON SDB.instanceId = appRp.srcInstanceId
							AND SDB.sqlNameId = SN.id AND SDB.jobId = appRp.bkpJobId
						JOIN #SqlLiveBrowseMountInstance SMI ON SMI.id = appRp.id
						JOIN APP_InstanceName AIX ON AIX.id = SMI.mountInstanceId
				-- Based on operation, remove those clients for which current user does not have any permissions.
				WHERE appRp.srcClientId IN (SELECT DISTINCT clientID FROM #tt_getAllIdaObjects)
						AND (@srcClientId = 0 OR @srcClientId = appRp.srcClientId)
						AND (@srcInstanceId = 0 OR @srcInstanceId = appRp.srcInstanceId)
						AND (@id = 0 OR @id = appRp.id)
						-- Filters
						AND (appRp.mountPath LIKE @search_term OR appRp.srcPath LIKE @search_term
								OR AIX.name LIKE @search_term OR AIN.name LIKE @search_term)
						AND (appRp.mountPath LIKE @cloneName)
						AND (appRp.srcPath LIKE @databaseNameKey)
						AND (AIX.name LIKE @destInstKey)
						AND (AIN.name LIKE @srcInstKey)
				ORDER BY (CASE @sort
								WHEN 1 THEN appRp.mountPath
								WHEN 2 THEN appRp.srcPath
								WHEN 3 THEN AIX.name
								WHEN 4 THEN AIN.name
								ELSE NULL END) ASC
		END
		ELSE
		BEGIN
			INSERT INTO #SqlLiveBrowseRps
				SELECT appRp.id, appRp.searchKey, appRp.srcBkpSetId, appRp.srcSubClientId, appRp.srcClientId, appRp.srcInstanceId, appRp.mountHostId,
					ac.name as mountHostName, appRp.bkpJobId, appRp.rpJobId, CAST(appRp.appData AS XML) as appData, appRp.srcPath, appRp.mountPath, appRp.phase, appRp.bkpType,
					appRp.recoveryTime, appRp.expireTime, appRp.appType, appRp.userName, cast(appRp.initRequest as nvarchar(MAX)) as initRequest, appRp.createTime,
					SN.id as sourceDatabaseId, IP.attrVal as sourceDatabaseVersion, SDB.backup_size as sourceDatabaseSize
				FROM APP_LiveBrowseRecoveryPoints appRp
						JOIN APP_Client ac on ac.id = appRp.mountHostId
						JOIN APP_InstanceName AIN ON AIN.id = appRp.srcInstanceId
						JOIN APP_InstanceProp IP ON appRp.srcInstanceId = IP.componentNameId
							AND IP.attrName = 'MSSQL Version' AND IP.modified = 0
						JOIN sqlNames2 SN2 ON SN2.name = appRp.srcPath AND SN2.type = 1
						JOIN sqlNames SN ON SN.sqlId = SN2.id AND SN.type = 1
						JOIN sqlDbBackupInfo SDB ON SDB.instanceId = appRp.srcInstanceId
							AND SDB.sqlNameId = SN.id AND SDB.jobId = appRp.bkpJobId
						JOIN #SqlLiveBrowseMountInstance SMI ON SMI.id = appRp.id
						JOIN APP_InstanceName AIX ON AIX.id = SMI.mountInstanceId
				-- Based on operation, remove those clients for which current user does not have any permissions.
				WHERE appRp.srcClientId IN (SELECT DISTINCT clientID FROM #tt_getAllIdaObjects)
						AND (@srcClientId = 0 OR @srcClientId = appRp.srcClientId)
						AND (@srcInstanceId = 0 OR @srcInstanceId = appRp.srcInstanceId)
						AND (@id = 0 OR @id = appRp.id)
						-- Filters
						AND (appRp.mountPath LIKE @search_term OR appRp.srcPath LIKE @search_term
								OR AIX.name LIKE @search_term OR AIN.name LIKE @search_term)
						AND (appRp.mountPath LIKE @cloneName)
						AND (appRp.srcPath LIKE @databaseNameKey)
						AND (AIX.name LIKE @destInstKey)
						AND (AIN.name LIKE @srcInstKey)
				ORDER BY (CASE @sort WHEN 1 THEN appRp.mountPath
									WHEN 2 THEN appRp.srcPath
									WHEN 3 THEN AIX.name WHEN 4 THEN AIN.name
									ELSE NULL END) DESC
		END
		BEGIN
			-- Enumerate the clones created by Snap Manager framework.
			IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL DROP TABLE #tblSMVolume
			CREATE TABLE #tblSMVolume (SMVolumeId int, AppId int, CopyId int, ControlHostId int)
			INSERT INTO #tblSMVolume
				SELECT  DISTINCT VOL.SMVolumeId, VOL.AppId, VOL.CopyId, SNAP.ControlHostId
					FROM    SMMountVolume MVOL (NOLOCK)
							INNER JOIN SMVolume VOL (NOLOCK) ON MVOL.SMVolumeId = VOL.SMVolumeId
							INNER JOIN SMVolSnapMap MAP (NOLOCK) ON MAP.SMVolumeId = VOL.SMVolumeId
							INNER JOIN SMSnap SNAP (NOLOCK) ON SNAP.SMSnapId = MAP.SMSnapId
							INNER JOIN APP_Application APP (NOLOCK) ON VOL.AppId = APP.id AND APP.appTypeId = 81
					WHERE 	APP.clientId IN (SELECT DISTINCT clientID FROM #tt_getAllIdaObjects)
					-- MR: 221133 && TR: 191118-365 - Currently when the snap is aged, the corresponding clone is not listed and hence
					-- customer couldn't manage them - like changing the expiry time.
							-- AND VOL.pruneFlags = 1 /*MM_SM_PRUNEFLAGS_ACTIVE*/
			-- SQL Clones via SM framework.
			-- No sort support
			INSERT INTO #SqlLiveBrowseRps
				SELECT  DISTINCT B.MountJobId, N'', 0, 0, MAX(VOL.SourceClientId) AS SourceClientId, max(APP.instance) as InstanceId,  MAX(B.MountHostId) AS MountHostID,
							Y.tgtInstanceName AS mountInstanceName, MAX(VOL.JobId) AS BackupJobId, B.MountJobId, NULL, Y.sourceDB as DatabaseName, Y.cloneDB as MountDBName, MAX(B.MountStatus) As Status,
							1 /*SNAP*/, MAX(VOL.CreationTime) AS VolumeCreateTime, MAX(B.ExpireTime) AS MountExpiryTime, MAX(VOL.AppTypeId) AS appTypeID, N'', N'',
							MAX(B.CreationTime) AS CloneCreateTime, 0, 0, 0
				FROM    #tblSMVolume A INNER JOIN SMMountVolume B WITH (NOLOCK) ON A.SMVolumeId = B.SMVolumeId
					INNER JOIN SMVolume VOL (NOLOCK) ON A.SMVolumeId = VOL.SMVolumeId
					INNER JOIN APP_Application APP (NOLOCK) ON VOL.AppId = APP.id
					INNER JOIN APP_InstanceName INST (NOLOCK) ON INST.id = APP.instance
					INNER JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = VOL.CopyId
					INNER JOIN (
						SELECT  DISTINCT SQLiDA.databaseList.value('./@databaseName','nvarchar(max)') cloneDB,
								SQLiDA.databaseList.value('./@sourceDatabaseName','nvarchar(max)') sourceDB, Z.CloneJobId,
								SQLiDA.databaseList.value('(/SQLiDA_AttachDBMsg/@instanceName)[1]','nvarchar(max)') tgtInstanceName,
								ISNULL(SQLiDA.databaseList.value('(/SQLiDA_AttachDBMsg/recoveryPoint/@recoveryPointID)[1]','INT'), 0) tgtRecoveryID
						FROM    (
									SELECT  MVOL.MountJobId AS CloneJobId, CONVERT(xml,REPLACE(MD.Metadata, 'UTF-8', 'UTF-16')) as cloneMetaData
									FROM    #tblSMVolume X INNER JOIN SMMountVolume MVOL  (NOLOCK) ON X.SMVolumeId = MVOL.SMVolumeId
											INNER JOIN SMMetaData MD (NOLOCK) ON MVOL.Id=MD.RefId
									WHERE   MD.MetaDataType= 38 /*SM_MDT_TEST_ENV_APP_INFO*/
											AND MD.RefType= 10 /*SM_MRT_MOUNT_VOLUME*/
								) Z
						CROSS APPLY Z.cloneMetaData.nodes('/SQLiDA_AttachDBMsg/databaseList') SQLiDA(databaseList)
					) Y ON Y.CloneJobId = B.MountJobId
			WHERE B.MountStatus = 59 /*SM_VS_MNT_MOUNTED*/ AND
				B.MountFlags & 2048 = 2048 /*CVSM_VOLUMEFLAGS_TEST_CLONE_ENV_DB*/
				AND Y.tgtRecoveryID = 0 -- Don't list clones created via SQL recovery point.
			-- Filters
				AND (Y.cloneDB LIKE @search_term OR Y.tgtInstanceName LIKE @search_term OR INST.name LIKE @search_term)
				AND (Y.cloneDB LIKE @cloneName)
				AND (Y.tgtInstanceName LIKE @destInstKey)
				AND (INST.name LIKE @srcInstKey)
			GROUP BY B.MountJobId, y.cloneDB, Y.sourceDB, Y.tgtInstanceName
			-- Cook up the appData
			IF OBJECT_ID('tempdb.dbo.#tbl_appdata') IS NOT NULL DROP TABLE #tbl_appdata
			CREATE TABLE #tbl_appdata (mountJobId int, bkpJobId int, databaseName nvarchar(1024), appData xml)
			INSERT INTO #tbl_appdata
				SELECT SP.id, SP.bkpJobId, SP.srcPath,
					(SELECT 0 AS '@isClone', IP.srcPath AS '@sourceDatabase', IP.mountPath AS '@mountDatabase',
							(SELECT AC.name AS '@clientName', AC.id AS '@clientId'
									FROM APP_Client AC WHERE AC.id = IP.srcClientId
								FOR XML PATH('sourceClient'), TYPE),
							(SELECT AIN.name AS '@instanceName', AIN.id AS '@instanceId'
									FROM APP_InstanceName AIN WHERE AIN.id = IP.srcInstanceId
								FOR XML PATH('sourceInstance'), TYPE),
							(SELECT AC.name AS '@clientName', AC.id  AS '@clientId'
									FROM APP_Client AC WHERE AC.id = IP.mountHostId
								FOR XML PATH('mountClient'), TYPE),
							(SELECT AIN.name AS '@instanceName', AIN.id AS '@instanceId'
									FROM APP_InstanceName AIN WHERE AIN.name = IP.mountHostName AND AIN.status = 0
								FOR XML PATH('mountInstance'), TYPE)
						FROM #SqlLiveBrowseRps IP WHERE IP.id = SP.id AND IP.bkpJobId = SP.bkpJobId AND IP.srcPath = SP.srcPath
					FOR XML PATH('sqlAppData'), ROOT('Ida_RPAppData'))
				FROM #SqlLiveBrowseRps SP WHERE SP.appData IS NULL
			-- Update the cooked up data for the response.
			UPDATE SLV SET
				SLV.appData = APD.appData, SLV.mountHostName = CL.name
			FROM #SqlLiveBrowseRps SLV
				JOIN APP_Client CL ON SLV.mountHostId = CL.id
				JOIN  #tbl_appdata APD ON SLV.id = APD.mountJobId AND
				SLV.bkpJobId = APD.bkpJobId AND SLV.srcPath = APD.databaseName
			DROP TABLE #tbl_appdata
		END
		-- Total
		DECLARE @total INT = 0
		SELECT @total = count(*) FROM #SqlLiveBrowseRps
		-- Apply paging.
		DELETE FROM #SqlLiveBrowseRps WHERE @noPaging = 0 AND rn <= @startIndex
		DELETE FROM #SqlLiveBrowseRps WHERE @noPaging = 0 AND rn > @startIndex + @maxSize
		-- Output.
		IF @propertyLevel <> 10
		BEGIN
			SET @outputXML=(SELECT @total as "@total",
							(SELECT
								appRp.id as "@id",
								appRp.searchKey as "@searchKey",
								appRp.srcClientId as "@srcClientId",
								appRp.srcInstanceId as "@srcInstanceId",
								appRp.srcBkpSetId as "@srcBkpSetId",
								appRp.srcSubClientId as "@srcSubclientId",
								appRp.mountHostId as "@mountHostId",
								appRp.bkpJobId as "@bkpJobId",
								appRp.recoveryTime as "@recoveryTime",
								appRp.rpJobId as "@rpJobId",
								appRp.srcPath as "@srcPath",
								appRp.mountPath as "@mountPath",
								appRp.phase as "@phase",
								appRp.appType as "@appType",
								appRp.bkpType as "@bkpType",
								cast(appRp.appData as nvarchar(MAX)) as "@appData",
								appRp.expireTime as "@expireTime",
								appRp.userName as "@userName",
								cast(appRp.initRequest as nvarchar(MAX)) as "@initRequest",
								appRp.createTime as "@createTime",
								appRp.sourceDatabaseId as "@sourceDatabaseId",
								appRp.sourceDatabaseSize as "@sourceDatabaseSize",
								appRp.sourceDatabaseVersion as "@sourceDatabaseVersion",
								ISNULL(SM.mountInstanceId, 0) AS "@mountInstanceId",
								ISNULL(SM.mountversion, N'') AS "@mtVersion",
								appRp.mountHostName as mountHostName
							FROM #SqlLiveBrowseRps appRp LEFT JOIN #SqlLiveBrowseMountInstance SM ON appRp.id = SM.id
							ORDER BY rn
							 FOR XML PATH('rpObjectList'), TYPE )
							FOR XML PATH('Ida_GetLiveBrowseRecoveryPointsResp'),TYPE)
		END
		ELSE
		BEGIN
			SET @outputXML=(SELECT @total as "@total", (SELECT
								appRp.id as "@id",
								appRp.srcClientId as "@srcClientId",
								appRp.srcInstanceId as "@srcInstanceId",
								appRp.mountHostId as "@mountHostId",
								appRp.recoveryTime as "@recoveryTime",
								appRp.srcPath as "@srcPath",
								appRp.mountPath as "@mountPath",
								appRp.phase as "@phase",
								appRp.appType as "@appType",
								cast(appRp.appData as nvarchar(MAX)) as "@appData",
								appRp.expireTime as "@expireTime",
								cast(appRp.initRequest as nvarchar(MAX)) as "@initRequest",
								appRp.mountHostName as mountHostName
							FROM #SqlLiveBrowseRps appRp LEFT JOIN #SqlLiveBrowseMountInstance SM ON appRp.id = SM.id
							ORDER BY rn
							 FOR XML PATH('rpObjectList'), TYPE )
							FOR XML PATH('Ida_GetLiveBrowseRecoveryPointsResp'),TYPE)
		END
	END
	SELECT ISNULL(@outputXML, '<Ida_GetLiveBrowseRecoveryPointsResp/>')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
    SET @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
	SET @outputXML= (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH ('response') , ROOT('Ida_GetLiveBrowseRecoveryPointsResp') ,TYPE )
	SELECT @outputXML
END CATCH
set @i_xml = @outputXML
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLiveBrowseRecoveryPoints')
	delete from GxQscripts where name = 'AppGetLiveBrowseRecoveryPoints'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLiveBrowseRecoveryPoints')
	delete from GXDBVersions where aliasname = 'AppGetLiveBrowseRecoveryPoints'
GO

insert into GXDBVersions values(2, 'AppGetLiveBrowseRecoveryPoints',  '00010001000200170000', 'AppGetLiveBrowseRecoveryPoints', '00010001000200170000')
GO

