

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLicense.sp] ---------- 

-------------------------------------------------------------------------------
--   AppGetLicense -
-------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetLicense.sp,v $ $Id: AppGetLicense.sp,v 1.5.60.2 2018/03/22 01:43:46 jiechen Exp $";
-- :SET_QUOTED_IDENTIFIER_ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetLicense <<<'

IF EXISTS (select * from sysobjects where name='AppGetLicense')
	drop procedure AppGetLicense
IF EXISTS (select * from GxQscripts where name='AppGetLicense')
	delete from GxQscripts where name = 'AppGetLicense'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLicense')
	delete from GXDBVersions where aliasname = 'AppGetLicense'
GO
print '... Creating Procedure: AppGetLicense'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetLicense
---------------------------------------
--   PARAMETERS   &   OUTPUTS 		---
---------------------------------------
  @clientId integer,
  @license integer
AS
DECLARE @errCode as int = 0
DECLARE @errString as varchar(1024)=''
DECLARE @propVal  int
BEGIN TRY
		SET @propVal = CONVERT(int, ISNULL((SELECT attrVal from App_Clientprop
								where componentNameId = @clientId
								  AND AttrName  = dbo.GetLicensePropName(@license)
								  AND modified = 0), '0'))
IF dbo.GetLicensePropName(@license) = 'Installed '	-- 'CV_PROP_INSTALLED_NAME'
		BEGIN
			SET @propVal = 0
		END
END   TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @propVal = 0
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @propVal, @errCode, @errString
--exec AppGetLicense 2, 1014          -- For testing
--exec AppGetLicense 2, 1021

IF EXISTS (select * from GxQscripts where name = 'AppGetLicense')
	delete from GxQscripts where name = 'AppGetLicense'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLicense')
	delete from GXDBVersions where aliasname = 'AppGetLicense'
GO

insert into GXDBVersions values(2, 'AppGetLicense',  '00010005006000020000', 'AppGetLicense', '00010005006000020000')
GO

