

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLastSuccessfulDRBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetLastSuccessfulDRBackup.sp,v $ $Id: AppGetLastSuccessfulDRBackup.sp,v 1.4.46.12 2019/05/04 13:17:23 sbhukar Exp $";
-- =========================================================
-- Author:		Gokul Pattabiraman
-- Description:	Get the last successful DR backup job.
-- =========================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetLastSuccessfulDRBackup')
BEGIN
	print '>>> Drop Stored Procedure: AppGetLastSuccessfulDRBackup <<<'
	drop procedure AppGetLastSuccessfulDRBackup
END
IF EXISTS (select * from GxQscripts where name='AppGetLastSuccessfulDRBackup')
	delete from GxQscripts where name = 'AppGetLastSuccessfulDRBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLastSuccessfulDRBackup')
	delete from GXDBVersions where aliasname = 'AppGetLastSuccessfulDRBackup'
GO
print '... Creating Procedure: AppGetLastSuccessfulDRBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetLastSuccessfulDRBackup
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
DECLARE @o_xmlText XML
DECLARE @isIndexing INT = 0
SET @isIndexing = ISNULL(( SELECT ref.value('@isIndexing', 'int')
									FROM   @i_xmlText . nodes('App_GetLastSuccessfulDRBackupReq') R ( ref )
								), 0)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
IF @isIndexing = 1 -- One pass case with ever changing rules!
BEGIN
	DECLARE @nthDRBackup INT = 0
	DECLARE @nDaysBeforeStub INT = 0
	DECLARE @timeFactor INT = 0
	DECLARE @currentTime INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @minStubTime INT = 0
	DECLARE @subclientId INT = 0
	DECLARE @clientId INT = 0
	DECLARE @appTypeId INT = 0
	DECLARE @firstOnePassJobEndTime INT = 0
	DECLARE @firstOnePassJobId NVARCHAR(MAX) = ''
	DECLARE @clientName NVARCHAR(MAX) = ''
	DECLARE @agentName NVARCHAR(MAX) = ''
	DECLARE @eventMessageId INT = 0
	DECLARE @enableDelayStub INT = 1
	-- It is a combination rule of minimum last n backups and minimum last n time.
	SET @nthDRBackup = (ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'nMinDRBackupBeforeStubbing'), 0))
	SET @nDaysBeforeStub = (ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'nMinDaysBeforeStubbing'), 0))
	-- Enforcing defaults for 0, is no longer required. Removing it. 0 is now allowed essentialy turning delay stubbing off.
	--IF @nthDRBackup = 0
		--SET @nthDRBackup = 3 -- 3 default even if user sets as 0
	--IF @nDaysBeforeStub = 0
		--SET @nDaysBeforeStub = 2 -- 2 days default even if user sets as 0
	SET @timeFactor = (@nDaysBeforeStub * 24 * 60 * 60)
	SET @minStubTime = (@currentTime - @timeFactor)
	SELECT
        @subclientId = APP.id,
        @appTypeId = APP.appTypeId,
		@agentName = IDA.displayName,
        @clientId = APP.clientId,
		@clientName = CL.name
    FROM
        @i_xmlText.nodes('/App_GetLastSuccessfulDRBackupReq/subclient') doc(a)
		INNER JOIN APP_Application APP ON APP.id = a.value('@subclientId', 'INT')
		INNER JOIN APP_Client CL ON CL.id = APP.clientId
		INNER JOIN APP_iDAType IDA ON APP.appTypeId = IDA.type
	IF @clientId > 0 AND @appTypeId > 0
	BEGIN
		SET @firstOnePassJobEndTime = ISNULL((	SELECT MIN(created)
												FROM APP_Application APP
												INNER JOIN APP_SubClientProp SP ON APP.id = SP.componentNameId AND SP.modified = 0 AND SP.attrName = 'First Turbo Job Id'
												WHERE APP.clientId = @clientId AND APP.appTypeId = @appTypeId), 0)
		IF @firstOnePassJobEndTime > 0
			SET @firstOnePassJobId = (SELECT TOP 1 attrVal
													FROM APP_Application APP
													INNER JOIN APP_SubClientProp SP ON APP.id = SP.componentNameId AND SP.modified = 0 AND SP.attrName = 'First Turbo Job Id'
													WHERE APP.clientId = @clientId AND APP.appTypeId = @appTypeId)
	END
	-- Do this logic only if either of one option is configured.
	IF @enableDelayStub = 1 AND (@nthDRBackup > 0 OR @timeFactor > 0)
	BEGIN
		DECLARE @beginningTime INT = 1
		DECLARE @drBkpTbl TABLE(jobId INT, startTime INT, endTime INT)
		DECLARE @minBkpJobStartTime INT = 0
		select @minBkpJobStartTime = ISNULL(MIN(j.jobStartTime ), 0)
		from JMBkpJobInfo b
		inner join JMJobInfo j on j.jobId = b.jobId and j.commCellId = b.commcellId
		where applicationId = @subclientId
		INSERT INTO @drBkpTbl
		SELECT TOP 1 jobId, servStart, servEnd
		FROM
		(	SELECT jobId, servStart, servEnd, ROW_NUMBER() OVER (ORDER BY servEnd DESC) AS rowNumber
			FROM JMAdminJobStatsTable WITH (NOLOCK)
			WHERE opType = 11 /*CSDRBKP*/
			AND status IN (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)
			AND dataStatus = 0
			AND (@minBkpJobStartTime = 0 OR servEnd < @minBkpJobStartTime) -- If @minBkpJobStartTime is 0, it means we are not able to find a jobid.
																		   -- This can happen for V10 clients who dont pass subclientid in request. It is ok to skip this check for them.
		) TMP
		WHERE rowNumber >= @nthDRBackup
		AND servStart < @minStubTime
		-- Both n DR backups should have been done and it should be t days old.
		IF EXISTS(SELECT 1 FROM @drBkpTbl WHERE jobId IS NOT NULL AND jobId > 0)
		BEGIN
SET @eventMessageId = (2777 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_xmlText =	(
									SELECT jobId AS '@jobId',
									startTime AS '@jobStartTime',
									endTime AS '@jobEndTime',
									(
										SELECT	@eventMessageId AS '@eventMessageId',
												@firstOnePassJobId AS '@firstOnePassJobId',
												@nDaysBeforeStub AS '@daysBeforeStub',
												@nthDRBackup AS '@numberOfDRBackups',
												@subclientId AS 'subclient/@subclientId',
												@agentName AS 'subclient/@appName',
												@appTypeId AS 'subclient/@applicationId',
												@clientId AS 'subclient/@clientId',
												@clientName AS 'subclient/@clientName'
										FOR XML PATH('delayedStubInfo'), TYPE
									)
									FROM @drBkpTbl
									FOR XML PATH('App_GetLastSuccessfulDRBackupResp'), TYPE
								)
		END
		ELSE
		-- Else archiving should not be done. So return 1.
		BEGIN
SET @eventMessageId = (2776 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_xmlText = (
								SELECT	0 AS '@jobId',
								@beginningTime AS '@jobStartTime',
								@beginningTime AS '@jobEndTime',
								(
										SELECT	@eventMessageId AS '@eventMessageId',
												@firstOnePassJobId AS '@firstOnePassJobId',
												@nDaysBeforeStub AS '@daysBeforeStub',
												@nthDRBackup AS '@numberOfDRBackups',
												@subclientId AS 'subclient/@subclientId',
												@agentName AS 'subclient/@appName',
												@appTypeId AS 'subclient/@applicationId',
												@clientId AS 'subclient/@clientId',
												@clientName AS 'subclient/@clientName'
										FOR XML PATH('delayedStubInfo'), TYPE
									)
								FOR XML PATH('App_GetLastSuccessfulDRBackupResp'), TYPE
							)
		END
	END
	ELSE
	BEGIN
		SET @o_xmlText = (
								SELECT	0 AS '@jobId',
								0 AS '@jobStartTime',
								0 AS '@jobEndTime',
								(
										SELECT	@eventMessageId AS '@eventMessageId',
												@firstOnePassJobId AS '@firstOnePassJobId',
												@nDaysBeforeStub AS '@daysBeforeStub',
												@nthDRBackup AS '@numberOfDRBackups',
												@subclientId AS 'subclient/@subclientId',
												@agentName AS 'subclient/@appName',
												@appTypeId AS 'subclient/@applicationId',
												@clientId AS 'subclient/@clientId',
												@clientName AS 'subclient/@clientName'
										FOR XML PATH('delayedStubInfo'), TYPE
								)
								FOR XML PATH('App_GetLastSuccessfulDRBackupResp'), TYPE
							)
	END
END
ELSE
-- Good old regular Case. As per SP name, get last successfule DR backup info :)
BEGIN
	SET @o_xmlText = (
						SELECT TOP 1
									jobId AS '@jobId',
									servStart AS '@jobStartTime',
									servEnd AS '@jobEndTime'
						FROM JMAdminJobStatsTable WITH (NOLOCK)
						WHERE opType = 11 /*CSDRBKP*/
						AND status IN (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)
						ORDER BY servEnd DESC
						FOR XML PATH('App_GetLastSuccessfulDRBackupResp'), TYPE
					 )
END
IF @o_xmlText IS NULL
	SET @o_xmlText = '<App_GetLastSuccessfulDRBackupResp/>'
IF OBJECT_ID('tempdb..#AppGetLastSuccessfulDRBackupResp') IS NOT NULL
BEGIN
	INSERT #AppGetLastSuccessfulDRBackupResp
	SELECT @o_xmlText
END
ELSE
	SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLastSuccessfulDRBackup')
	delete from GxQscripts where name = 'AppGetLastSuccessfulDRBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLastSuccessfulDRBackup')
	delete from GXDBVersions where aliasname = 'AppGetLastSuccessfulDRBackup'
GO

insert into GXDBVersions values(2, 'AppGetLastSuccessfulDRBackup',  '00010004004600120000', 'AppGetLastSuccessfulDRBackup', '00010004004600120000')
GO

