

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLastActivePreviewPath.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetLastActivePreviewPath')
BEGIN
	print '>>> Drop Stored Procedure: APPGetLastActivePreviewPath <<<'
	drop procedure APPGetLastActivePreviewPath
END
IF EXISTS (select * from GxQscripts where name='APPGetLastActivePreviewPath')
	delete from GxQscripts where name = 'APPGetLastActivePreviewPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetLastActivePreviewPath')
	delete from GXDBVersions where aliasname = 'APPGetLastActivePreviewPath'
GO
print '... Creating Procedure: APPGetLastActivePreviewPath'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetLastActivePreviewPath
  @i_subclientId INT,
  @i_inputList varchar(MAX),
  @i_inputType INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	--input list
	IF OBJECT_ID('tempdb.dbo.#previewpathMailboxGUIDs') IS NOT NULL
		DROP TABLE #previewpathMailboxGUIDs
	CREATE TABLE #previewpathMailboxGUIDs
    (
        guid varchar(2048)
    )
	CREATE INDEX Idx_previewpathMailboxGUIDs_guid on #previewpathMailboxGUIDs(guid)
	-- output table matching user and their policy version to pick up in final output
	IF OBJECT_ID('tempdb.dbo.#previewpathMailboxPolicy') IS NOT NULL
        DROP TABLE #previewpathMailboxPolicy
    CREATE TABLE #previewpathMailboxPolicy
    (
        userGuid varchar(2048),
		smtp varchar(max),
		assocId int,
		versionId int,
		considerFound int,
		foundWhere varchar(100)
    )
	CREATE INDEX Idx_previewpathMailboxPolicy_versionId on #previewpathMailboxPolicy(versionId)
	CREATE INDEX Idx_previewpathMailboxPolicy_userGuid on #previewpathMailboxPolicy(userGuid)
	-- store all policies version where preview is enabled
	IF OBJECT_ID('tempdb.dbo.#previewpathPolicyVersion') IS NOT NULL
        DROP TABLE #previewpathPolicyVersion
    CREATE TABLE #previewpathPolicyVersion
    (
		policyId int,
		versionId int,
		versionTime int
    )
	CREATE INDEX Idx_previewpathPolicyVersion_policyId on #previewpathPolicyVersion(policyId)
	INSERT INTO #previewpathPolicyVersion
	select D.componentNameId, D.id, D.modified
	FROM APP_ConfigurationPolicyDetails D
	WHERE
		(D.detailType= 1/*Archive*/ AND D.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enableContentIndex)[1]', 'int') = 1 AND D.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enablePreviewGeneration)[1]', 'int') = 1 )
		OR
		(D.detailType= 4/*Journal*/ AND D.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/@enableContentIndex)[1]', 'int') = 1 AND D.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/@enablePreviewGeneration)[1]', 'int') = 1)
	-- fill userGuid using SMTP if needed
	if ( @i_inputType = 0 )
	BEGIN
		insert into #previewpathMailboxGUIDs select _ID from dbo.SplitIDString(@i_inputList)
	END
	ELSE
	BEGIN
		insert into #previewpathMailboxGUIDs
		SELECT distinct userGuid from APP_EmailConfigPolicyAssoc A
		INNER JOIN dbo.SplitStringByDelimiter(@i_inputList,',') T on T._ID = A.smtpAdrress
		where ISNULL(userGuid,'') <>''
		--where A.modified=0 --we want disabled users too..
	END
    --active association , active version
	INSERT INTO #previewpathMailboxPolicy
	SELECT A.userGuid, A.smtpAdrress, P.assocId, D.versionId , 1, '1:active policy active version'
	FROM  APP_EmailConfigPolicyassoc A
	INNER JOIN #previewpathMailboxGUIDs T ON A.userGuid  = T.guid
	INNER JOIN APP_EmailConfigPolicies P ON P.componentNameId = A.assocId
	INNER JOIN #previewpathPolicyVersion D on D.policyId = P.policyId
	WHERE A.subClientId = @i_subclientId AND P.policyType IN (1,4)
	AND P.modified =0 AND A.modified=0 AND D.versionTime = 0
	-- active association TOP deactive version
	;WITH CTE AS(
		SELECT A.userGuid, A.smtpAdrress as smtp, P.componentNameId as assocId, P.modified , D.versionId, D.versionTime, D.policyId as policyId,
		ROW_NUMBER()
		OVER (PARTITION by userGuid order by  D.versionId desc) as r
		FROM APP_EmailConfigPolicyAssoc A
		INNER JOIN #previewpathMailboxGUIDs T ON A.userGuid  = T.guid
		INNER JOIN APP_EmailConfigPolicies P ON P.componentNameId = A.assocId
		INNER JOIN #previewpathPolicyVersion D on D.policyId = P.policyId
		WHERE A.subClientId = @i_subclientId AND P.policyType IN (1,4)
		AND  p.modified =0 AND D.versionTime <> 0
		AND A.userGuid NOT in ( select userGuid from #previewpathMailboxPolicy where considerFound = 1 ) )
	INSERT INTO #previewpathMailboxPolicy
	SELECT userGuid, smtp, assocId, versionId , 0, '2:active assoc previous version'
	FROM CTE where r = 1
	-- TOP deactive association active version
	;WITH CTE AS (
		SELECT  A.userGuid, A.smtpAdrress as smtp, P.componentNameId as assocId, P.modified , D.versionId, D.versionTime, D.policyId as policyId,
		ROW_NUMBER()
		OVER  (PARTITION by userGuid order by P.modified desc) as r
		FROM APP_EmailConfigPolicyAssoc A
		INNER JOIN #previewpathMailboxGUIDs T ON A.userGuid  = T.guid
		INNER JOIN APP_EmailConfigPolicies P ON P.componentNameId = A.assocId
		INNER JOIN #previewpathPolicyVersion D on D.policyId = P.policyId
		WHERE A.subClientId = @i_subclientId AND P.policyType IN (1,4)
		AND  p.modified <>0 AND D.versionTime = 0
		AND A.userGuid NOT in ( select userGuid from #previewpathMailboxPolicy where considerFound = 1 ) )
	INSERT INTO #previewpathMailboxPolicy
	SELECT userGuid, smtp, assocId, versionId , 0, '3:previous assoc active version'
	FROM CTE where r = 1
	-- TOP deactive association TOP deactive version
	;WITH CTE AS(
		SELECT  A.userGuid, A.smtpAdrress as smtp, P.componentNameId as assocId, P.modified , D.versionId, D.versionTime, D.policyId as policyId,
		ROW_NUMBER()
		over (PARTITION by userGuid order by P.modified desc, D.versionId desc) as r
		FROM APP_EmailConfigPolicyAssoc A
		INNER JOIN #previewpathMailboxGUIDs T ON A.userGuid  = T.guid
		INNER JOIN APP_EmailConfigPolicies P ON P.componentNameId = A.assocId
		INNER JOIN #previewpathPolicyVersion D on D.policyId = P.policyId
		WHERE A.subClientId = @i_subclientId AND P.policyType IN (1,4)
		AND  p.modified <>0 AND D.versionTime <> 0
		AND A.userGuid NOT in ( select userGuid from #previewpathMailboxPolicy  where considerFound = 1 ) )
	INSERT INTO #previewpathMailboxPolicy
	SELECT userGuid, smtp, assocId, versionId, 0 ,'4:previous assoc previous version'
	FROM CTE where r = 1
	-- select output
	SELECT  userGuid, P.smtp, P.assocId,versionId,
	CASE
		WHEN D.detailType = 4/*Journal*/ THEN D.policyDetails.query('(/emailPolicy/journalPolicy/contentIndexProps/previewPathDir)')
		ELSE D.policyDetails.query('(/emailPolicy/archivePolicy/contentIndexProps/previewPathDir)')
	END as previewPath, P.foundWhere
	FROM #previewpathMailboxPolicy P
	INNER JOIN APP_ConfigurationPolicyDetails D ON P.versionId = D.id
	ORDER by userGuid asc, foundWhere asc
	IF OBJECT_ID('tempdb.dbo.#previewpathMailboxGUIDs') IS NOT NULL
		DROP TABLE #previewpathMailboxGUIDs
	IF OBJECT_ID('tempdb.dbo.#previewpathMailboxPolicy') IS NOT NULL
        DROP TABLE #previewpathMailboxPolicy
	IF OBJECT_ID('tempdb.dbo.#previewPolicyVersion') IS NOT NULL
        DROP TABLE #previewPolicyVersion
 END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLastActivePreviewPath')
	delete from GxQscripts where name = 'AppGetLastActivePreviewPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLastActivePreviewPath')
	delete from GXDBVersions where aliasname = 'AppGetLastActivePreviewPath'
GO

insert into GXDBVersions values(2, 'AppGetLastActivePreviewPath',  '00000000000000000000', 'AppGetLastActivePreviewPath', '00000000000000000000')
GO

