

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLaptopsForEdgeDriveClient.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetLaptopsForEdgeDriveClient.sp,v $ $Id: AppGetLaptopsForEdgeDriveClient.sp,v 1.1.2.3 2018/03/27 08:11:40 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetLaptopsForEdgeDriveClient"
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetLaptopsForEdgeDriveClient <<<'

IF EXISTS (select * from sysobjects where name='AppGetLaptopsForEdgeDriveClient')
	drop procedure AppGetLaptopsForEdgeDriveClient
IF EXISTS (select * from GxQscripts where name='AppGetLaptopsForEdgeDriveClient')
	delete from GxQscripts where name = 'AppGetLaptopsForEdgeDriveClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopsForEdgeDriveClient')
	delete from GXDBVersions where aliasname = 'AppGetLaptopsForEdgeDriveClient'
GO
print '... Creating Procedure: AppGetLaptopsForEdgeDriveClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetLaptopsForEdgeDriveClient
-- Input arguments
  @inEdgeClientId integer,
  @inEdgeSubclientPolicyAppId integer,
  @inFilterOptions integer = 0
AS
  DECLARE @laptopclientId integer
  DECLARE @edgeClientId integer
  DECLARE @edgeSubclientId integer
  DECLARE @syncWebFolderId integer
  DECLARE @syncType integer
  DECLARE @syncFlag integer
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @selectiveSyncMode INT = 0
	DECLARE @selectiveSyncDecoupled INT = (CAST(0x100 AS INT)) | (CAST(0x200 AS INT)) -- SYNC_IS_SELECTIVE_SYNC SYNC_DECOUPLED_SELECTIVE_SYNC
IF @inFilterOptions & 0x1 = 0x1
	BEGIN
		SET @selectiveSyncMode = 1
	END
	IF @inEdgeClientId > 0
	BEGIN
		SELECT SC.clientId AS laptopclientId, APP.clientId AS edgeClientId, APP.id AS edgeSubclientId, SC.syncWebFolderId AS syncWebFolderId, SC.syncType AS syncType, SC.flag AS syncFlag
		FROM App_SyncCloudFolder SF
		INNER JOIN App_SyncCloudConfig SC ON SF.syncWebFolderId = SC.syncWebFolderId AND SC.syncType = 3 -- Valid linked Laptops
		INNER JOIN APP_Application APP ON SC.subclientId = APP.id
WHERE SF.flag & 0x10 = 0x10 --  Edge Drive
		AND APP.clientId = @inEdgeClientId
AND (@selectiveSyncMode = 0 OR SC.flag & @selectiveSyncDecoupled = 0x100) -- Selective sync and not decoupled
	END
	ELSE IF @inEdgeSubclientPolicyAppId > 0
	BEGIN
		SELECT SC.clientId AS laptopclientId, APP.clientId AS edgeClientId, APP.id AS edgeSubclientId, SC.syncWebFolderId AS syncWebFolderId, SC.syncType AS syncType, SC.flag AS syncFlag
		FROM App_SyncCloudFolder SF
		INNER JOIN App_SyncCloudConfig SC ON SF.syncWebFolderId = SC.syncWebFolderId AND SC.syncType = 3 -- Valid linked Laptops
		INNER JOIN APP_Application APP ON SC.subclientId = APP.id
		INNER JOIN APP_SubClientProp SP ON SC.subclientId = SP.componentNameId AND SP.attrName = N'Associated subclient Policy' AND SP.cs_attrName = CHECKSUM(N'Associated subclient Policy') AND SP.modified = 0
WHERE SF.flag & 0x10 = 0x10 --  Edge Drive
AND (@selectiveSyncMode = 0 OR SC.flag & @selectiveSyncDecoupled = 0x100) -- Selective sync and not decoupled
		AND SP.attrVal = CAST(@inEdgeSubclientPolicyAppId AS NVARCHAR(32)) -- Associated with this policy
	END
	ELSE
		SELECT 0, 0, 0, 0, 0, 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLaptopsForEdgeDriveClient')
	delete from GxQscripts where name = 'AppGetLaptopsForEdgeDriveClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopsForEdgeDriveClient')
	delete from GXDBVersions where aliasname = 'AppGetLaptopsForEdgeDriveClient'
GO

insert into GXDBVersions values(2, 'AppGetLaptopsForEdgeDriveClient',  '00010001000200030000', 'AppGetLaptopsForEdgeDriveClient', '00010001000200030000')
GO

