

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLaptopsApplicableForMigration.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +=======================================================================================================================+
--  |   Procedure:  AppGetLaptopsApplicableForMigration()
--  |
--  | Description:  SP for fetching Laptops with provided users or user groups which will be added ot removed to/from plan
--  |
--  |       Input:  User or user group id's'
--  |      Output:  Details of laptop clients
--  |      Return:  xxx
--  |
--  |   Revisions  Author
--  |   ---------  Arvind Lakra
--  +=======================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetLaptopsApplicableForMigration')
BEGIN
	print '>>> Drop Stored Procedure: AppGetLaptopsApplicableForMigration <<<'
	drop procedure AppGetLaptopsApplicableForMigration
END
IF EXISTS (select * from GxQscripts where name='AppGetLaptopsApplicableForMigration')
	delete from GxQscripts where name = 'AppGetLaptopsApplicableForMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopsApplicableForMigration')
	delete from GXDBVersions where aliasname = 'AppGetLaptopsApplicableForMigration'
GO
print '... Creating Procedure: AppGetLaptopsApplicableForMigration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetLaptopsApplicableForMigration
  @i_userId INT,
  @i_localeId INT,
  @xmlString XML OUTPUT,
  @o_errorCode INTEGER OUTPUT,
  @o_errorString VARCHAR(1024) OUTPUT
AS
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(max)
-- Flow to be followed
-- Get user/user group from each request. Send it to AppGetLaptopAssociatedToUserAndUserGroup
-- Move the response to the relvant list and now send the response back again.
-- Sample XML
-- <App_GetLaptopsForMigrationReq>
--   <associatedUsersOrUserGroups>
--     <userGroup userGroupId="10" />
--     <userGroup userGroupId="11" />
--     <userGroup userGroupId="12" />
--     <users userId="1" />
--     <users userId="2" />
--     <users userId="3" />
--   </associatedUsersOrUserGroups>
--   <deassociatedUsersOrUserGroups>
--     <userGroup userGroupId="10" />
--     <userGroup userGroupId="11" />
--     <userGroup userGroupId="12" />
--     <users userId="1" />
--     <users userId="2" />
--     <users userId="3" />
--   </deassociatedUsersOrUserGroups>
-- </App_GetLaptopsForMigrationReq>
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
BEGIN TRY
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SET @errorCode = 0
    SET @errorString = N''
	IF OBJECT_ID('tempdb.dbo.#AssociatedClientTblList') IS NOT NULL DROP TABLE #AssociatedClientTblList
	CREATE TABLE #AssociatedClientTblList (clientId INT, clientName NVARCHAR(1024), userId INT, planId INT, planName NVARCHAR(1024), regionId INT DEFAULT(0), regionName NVARCHAR(255), isAssociatedEntity INT)
	-- Get Laptop associated with associatedUsersOrUserGroups list
	DECLARE @xmlReqAssociated XML = (SELECT @xmlString.query('App_GetLaptopsForMigrationReq/associatedUsersOrUserGroups/*')
                                                                    FOR XML PATH('App_LaptopActivatedByUserOrUserGroupReq'))
	EXEC AppGetLaptopAssociatedToUserAndUserGroup 1, 0, @xmlReqAssociated OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
	DECLARE @xmlReqDeassociated XML = (SELECT @xmlString.query('App_GetLaptopsForMigrationReq/deassociatedUsersOrUserGroups/*')
                                                                    FOR XML PATH('App_LaptopActivatedByUserOrUserGroupReq'))
	-- Get Laptop associated with deassociatedUsersOrUserGroups list
	EXEC AppGetLaptopAssociatedToUserAndUserGroup 1, 0, @xmlReqDeassociated OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
	-- Get all clients from both response
	-- First select shows the associate response and second one denotes deassociate response
	INSERT INTO #AssociatedClientTblList
	SELECT ref.value('(client/@clientId)[1]', 'INT'), ref.value('(client/@clientName)[1]', 'NVARCHAR(1024)') , ref.value('(user/@userId)[1]', 'INT'), ref.value('(plan/@planId)[1]', 'INT'),  ref.value('(plan/@planName)[1]', 'NVARCHAR(1024)'), ref.value('(region/@regionId)[1]', 'INT'), ref.value('(region/@regionName)[1]', 'NVARCHAR(1024)') , 1 FROM @xmlReqAssociated.nodes('App_LaptopActivatedByUserOrUserGroupResp/laptopDetails') R ( ref )
	UNION
	SELECT ref.value('(client/@clientId)[1]', 'INT'), ref.value('(client/@clientName)[1]', 'NVARCHAR(1024)') , ref.value('(user/@userId)[1]', 'INT'), ref.value('(plan/@planId)[1]', 'INT'),  ref.value('(plan/@planName)[1]', 'NVARCHAR(1024)'), ref.value('(region/@regionId)[1]', 'INT'), ref.value('(region/@regionName)[1]', 'NVARCHAR(1024)') ,0 FROM @xmlReqDeassociated.nodes('App_LaptopActivatedByUserOrUserGroupResp/laptopDetails') R ( ref )
	-- Now, since this code will be called from GUI, we don't want to send any laptop which is part of both response.
	-- For final implementation - In case of client being present in both response, we will keep the one in activate response as that what appplanupdate will honor after changes
	-- For first implementation - In case of client being present in both response, we will keep the one in deactivate response as that what appplanupdate currently honors
	DELETE ACTL1
	FROM #AssociatedClientTblList ACTL1
	INNER JOIN #AssociatedClientTblList ACTL2
		ON ACTL1.clientId=ACTL2.clientId AND ACTL2.isAssociatedEntity=0
	WHERE ACTL1.isAssociatedEntity=1
	-- Now, in case of overlapping laptops, we will keep the one in activated list.
	-- Compose the final response
	SET @xmlString =  (SELECT
						( SELECT
							clientId 'client/@clientId', clientName  'client/@clientName' ,
									userId 'user/@userId',
									planID  'plan/@planId', planName 'plan/@planName',
									regionId  'region/@regionId', regionName 'region/@regionName'
								 FROM #AssociatedClientTblList WHERE isAssociatedEntity=1 FOR XML PATH('laptopDetails'), ROOT('associatedUsersOrUserGroupsLaptops'), TYPE),
						(SELECT
							clientId 'client/@clientId', clientName  'client/@clientName' ,
							userId 'user/@userId',
							planID  'plan/@planId', planName 'plan/@planName',
							regionId  'region/@regionId', regionName 'region/@regionName'
							FROM #AssociatedClientTblList  WHERE isAssociatedEntity=0 FOR XML PATH('laptopDetails'), ROOT('deassociatedUsersOrUserGroupsLaptops'), TYPE),
						(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
				FOR XML PATH('App_GetLaptopsForMigrationResp'), TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
    SET @xmlString = (
                        SELECT @errorCode AS '@errorCode',
                                @errorString AS '@errorMessage'
                        FOR XML PATH ('error'), ROOT('App_GetLaptopsForMigrationResp')
                       )
END  CATCH
GENERATE_OUTPUT:
    SET @o_errorCode=@errorCode
    SET @o_errorString=@errorString
	SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLaptopsApplicableForMigration')
	delete from GxQscripts where name = 'AppGetLaptopsApplicableForMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopsApplicableForMigration')
	delete from GXDBVersions where aliasname = 'AppGetLaptopsApplicableForMigration'
GO

insert into GXDBVersions values(2, 'AppGetLaptopsApplicableForMigration',  '00000000000000000000', 'AppGetLaptopsApplicableForMigration', '00000000000000000000')
GO

