

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLaptopUserMailBox.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetLaptopUserMailBox.sp,v $ $Id: AppGetLaptopUserMailBox.sp,v 1.19.2.10.36.1 2021/01/13 14:35:49 mnatarajan Exp $";
--	+===================================================================+
--	| AppGetLaptopUserMailBox - Get Laptop user mail box				|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetLaptopUserMailBox')
BEGIN
	print '>>> Drop Stored Procedure: AppGetLaptopUserMailBox <<<'
	drop procedure AppGetLaptopUserMailBox
END
IF EXISTS (select * from GxQscripts where name='AppGetLaptopUserMailBox')
	delete from GxQscripts where name = 'AppGetLaptopUserMailBox'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopUserMailBox')
	delete from GXDBVersions where aliasname = 'AppGetLaptopUserMailBox'
GO
print '... Creating Procedure: AppGetLaptopUserMailBox'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetLaptopUserMailBox
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @mailboxGuid nvarchar(255) = '',
  @userId INT = 0,
  @outputXmlString XML OUTPUT
-----------------------------------------------------------
AS
DECLARE @excludeStatusMask int = (cast(0x00004  as int) | cast(0x00020 as int) |  cast(0x00002 as int))
DECLARE @formatedMailboxGuid as nvarchar(255)
SET  @formatedMailboxGuid = '{' +  REPLACE(@mailboxGuid,'-','X') + '}'
SET @formatedMailboxGuid = UPPER(@formatedMailboxGuid)
DECLARE @formatedIndexingMailboxGuid nvarchar(42) = REPLACE(@mailboxGuid,'-','X')
DECLARE @isCommcellLevelAssociation int = 0
--For 9.0 clients
DECLARE @formatedUserGuid9 as nvarchar(255)
set @formatedUserGuid9 =  Replace(substring(@mailboxGuid,7,2)+substring(@mailboxGuid,5,2)+substring(@mailboxGuid,3,2)+substring(@mailboxGuid,1,2)
+ substring(@mailboxGuid,12,2) + substring(@mailboxGuid,10,2)
+ substring(@mailboxGuid,17,2) + substring(@mailboxGuid,15,2)
+ substring(@mailboxGuid,19,18),'-','')
IF object_id('tempdb.dbo.#userMailBoxInfo') IS NOT null DROP TABLE #userMailBoxInfo
CREATE TABLE #userMailBoxInfo
(
    id      integer identity(1,1),
	mailBoxId				int ,
    appId				int,
    appName				nvarchar(255),
    cId				int,
    clientName				nvarchar(255),
    bsetId				int,
    backupSetName			nvarchar(128),
    subId				int,
    subClientName			nvarchar(128),
    displayName				nvarchar(512),
    aliasName				nvarchar(512),
    smtpName				nvarchar(512),
    mailboxGUID				nvarchar(1024),
    path					nvarchar(max),
    lastbkupTime			int,
    lastSuccessBackupTime	int,
    nextBackupTime			int,
    releaseId				int,
    instId				int,
	isPST					int
)
CREATE CLUSTERED INDEX userMailBoxInfo_mailBoxId_IDX on #userMailBoxInfo(mailBoxId);
IF OBJECT_ID('tempdb.dbo.#AccessibleSubclients') IS NOT Null DROP TABLE #AccessibleSubclients
create table #AccessibleSubclients
(
    subclientId INTEGER,
    appTypeId INTEGER,
    PRIMARY KEY(subclientId, appTypeId)
)
 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 SET NOCOUNT ON
	DECLARE @showCurrentContent INT = 0
	SET @showCurrentContent = ISNULL((SELECT VALUE FROM gxglobalparam WHERE NAME = 'ShowMBFromCurrentSubclient'), 0)
	IF object_id('tempdb.dbo.#clientListTmp') IS NOT null DROP TABLE #clientListTmp
	CREATE TABLE  #clientListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null, [clientGroupId] int	NOT null, [clientId]      int	NOT null, [appTypeId]     int	NOT null, [instanceId]    int	NOT null, [backupsetId]   int	NOT null, [subClientId]   int	NOT null, [mediaAgentId]  int	NOT null, [libraryId]     int	NOT null, [archGroupId]   int	NOT null, [vtContainerId] int	NOT null, [vtPolicyId]    int	NOT null, [vtShelfId]     int	NOT null, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2012, 0, '#clientListTmp'
DELETE FROM #clientListTmp WHERE capabilities & CONVERT(bigint, (POWER(2.0,  24   -1))) = 0   AND (capabilities & CONVERT(bigint, (POWER(2.0,  13  -1))) = 0 )
SELECT @isCommcellLevelAssociation=1 from #clientListTmp sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
	INSERT INTO #AccessibleSubclients
	SELECT A.id, A.appTypeId
	FROM APP_Application A
WHERE A.appTypeId IN (137, 54,  56 , 67)
	AND
		(	@isCommcellLevelAssociation=1 --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
		OR
			A.clientId in (select clientId from #clientListTmp sec  where sec.appTypeId=0 and sec.instanceId=0 and sec.backupsetId=0)
		OR
			A.clientId IN (select clientId from #clientListTmp sec  where sec.appTypeId=A.appTypeId and sec.instanceId=0 and sec.backupsetId=0)
		OR
			A.clientId IN (select clientId  from #clientListTmp sec where sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=0)
		OR
			A.clientId IN (select clientId  from #clientListTmp sec where sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=A.backupSet)
		)
	INSERT INTO #userMailBoxInfo
    SELECT distinct e.componentId,a.appTypeId, '',
 a.clientId, c.name, a.backupSet, '', a.id,a.subclientName, '','','',@formatedUserGuid9,'\MB\' + @formatedMailboxGuid,0,0,0,c.releaseId,a.instance,0
    FROM APP_Application a
    INNER JOIN APP_Client c ON c.id = a.clientId
	INNER JOIN APP_SubClientProp sp ON a.id = sp.componentNameId
	INNER JOIN APP_ComponentProp e ON e.componentId = sp.id  and propertyTypeId=1103 --this is for mailbox guid in one pass subclient content
	WHERE a.id IN ( SELECT subclientId FROM #AccessibleSubclients) AND
	(@showCurrentContent=0 or sp.modified=0) and e.modified = 0 AND (e.stringVal = @formatedMailboxGuid or e.stringVal =@formatedUserGuid9)-- AND (subclientStatus & @excludeStatusMask =0)
    --GET PST backupset(Merge the queries)
	 DECLARE @getPSTMailboxForAUser int =0
    IF EXISTS(SELECT * FROM gxglobalparam WHERE name = 'showPSTMailBoxByLoggedInUser' AND value=1  and modified=0)
		SET @getPSTMailboxForAUser=1
    IF(@getPSTMailboxForAUser=0)
	BEGIN
		INSERT INTO #userMailBoxInfo
		SELECT distinct null,a.appTypeId, '',
		a.clientId, c.name, a.backupSet, '', a.id,a.subclientName, '','','',@formatedUserGuid9,'\MB\' + @formatedMailboxGuid,0,0,0,c.releaseId,a.instance,1
		FROM APP_Application a
		INNER JOIN APP_Client c ON c.id = a.clientId
		INNER JOIN APP_SubClientProp sp ON a.id = sp.componentNameId
		WHERE a.id IN ( SELECT subclientId FROM #AccessibleSubclients) AND
		sp.modified =0
		--AND (subclientStatus & @excludeStatusMask = 0)
		AND sp.attrName='ReferenceCopy PST Archiving'--CV_REFERENCECOPY_PST_ARCHIVING
		AND a.backupSet not in (SELECT bsetId from #userMailBoxInfo)
	END
	ELSE
		INSERT INTO #userMailBoxInfo
		 SELECT  distinct null,a.appTypeId, '',
		a.clientId, c.name, a.backupSet, '', a.id,a.subclientName, '','','',@formatedUserGuid9,'\MB\' + @formatedMailboxGuid,0,0,0,c.releaseId,a.instance,1
		 FROM APP_Application a
		INNER JOIN APP_Client c on c.id = a.clientId
		INNER JOIN APP_SubClientProp sp on a.id = sp.componentNameId and sp.attrName='ReferenceCopy PST Archiving'--CV_REFERENCECOPY_PST_ARCHIVING
			AND sp.modified =0
		INNER JOIN APP_ComponentProp cp on cp.componentId=sp.componentNameId  and cp.modified=0 AND cp.propertyTypeId= 2300 and cp.stringVal= @formatedMailboxGuid
		--INNER JOIN UMUsers u on u.id = @userId
		WHERE a.id IN ( SELECT subclientId FROM #AccessibleSubclients) AND
		--(subclientStatus & @excludeStatusMask = 0) AND
		a.backupSet not in (select bsetId from #userMailBoxInfo)
	--new exchange agent
	INSERT INTO #userMailBoxInfo
	 SELECT  distinct null,a.appTypeId, '',
		e.clientId, c.name, e.backupsetId, '', a.id,a.subclientName, e.displayName,e.aliasName,e.smtpAdrress,@formatedUserGuid9,'\MB\' + @formatedMailboxGuid,0,0,0,c.releaseId,a.instance,0
		from APP_EmailConfigPolicyAssoc e
		INNER JOIN APP_Application a on a.backupSet=e.backupsetId
		INNER JOIN APP_Client c on c.id=a.clientId
WHERE a.id IN ( SELECT subclientId FROM #AccessibleSubclients) AND e.userGuid=@formatedIndexingMailboxGuid AND a.appTypeId=137  AND mailBoxType=1
	--AND e.status=0 we should always show in webconsole even mailbox association is removed
	UPDATE #userMailBoxInfo
    SET backupSetName=(select name from APP_BackupSetName where id=bsetId)
    UPDATE #userMailBoxInfo
    SET appName=(SELECT name FROM APP_iDAType where type=appId )
    UPDATE #userMailBoxInfo SET displayName=name, aliasName=login, smtpName = email
    FROM
    UMUSERS u WHERE u.id=@userid AND isPST=1
	UPDATE #userMailBoxInfo set path = dbo.EncodeInvalidXMLChar(attrName)
	FROM  App_ComponentProp cp
		INNER JOIN APP_SubClientProp sp ON sp.id = cp.componentId AND sp.modified = 0
		INNER JOIN UMUsers u ON u.userGuid = @mailboxGuid
	 WHERE  stringVal  = email AND cp.modified = 0 AND (releaseId < 15 or appId = 56)
	UPDATE #userMailBoxInfo set aliasName = cp.stringVal
	FROM App_ComponentProp cp WHERE mailBoxId = cp.componentId AND mailBoxId IS NOT NULL
	AND cp.propertyTypeId = 1101 --  1101
	UPDATE #userMailBoxInfo set displayName = cp.stringVal
	FROM App_ComponentProp cp WHERE mailBoxId = cp.componentId AND mailBoxId IS NOT NULL
	AND cp.propertyTypeId = 1102 --  1102
	UPDATE #userMailBoxInfo set smtpName = cp.stringVal
	FROM App_ComponentProp cp WHERE mailBoxId = cp.componentId AND mailBoxId IS NOT NULL
	and cp.propertyTypeId = 1100 -- 1100
	--Last backup time
	UPDATE	#userMailBoxInfo
			SET lastbkupTime = (SELECT ISNULL(max(servEndDate) ,0)
			FROM JMBkpStats  jstats
			WHERE subId = jstats.appId )
				--Last success backup time
	UPDATE	#userMailBoxInfo
			SET lastSuccessBackupTime = (SELECT ISNULL(max(servEndDate) ,0)
			FROM JMBkpStats  jstats
			WHERE subId = jstats.appId
			AND status in (1,3))
    UPDATE #userMailBoxInfo
            SET nextBackupTime = ISNULL((SELECT min(nextTime) from TM_RunTime WITH (NOLOCK) where patternId in (
            SELECT patternId from TM_PatternAssoc WITH (NOLOCK) where subTaskId in (
                SELECT st.subTaskId from TM_SubTask st WITH (NOLOCK) INNER JOIN TM_SubTaskOptions sto ON sto.subTaskId = st.subTaskId AND sto.optionId = 458405394 AND sto.value IN (1, 2)  where taskId in (
                        SELECT taskId from dbo.TM_Associations TM_AssocEntity (NOLOCK)
						WHERE
                        --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
                                                    (TM_AssocEntity.subclientId = T1.subId)
                                                    OR
                                                    (TM_AssocEntity.backupsetId = T1.bsetId AND TM_AssocEntity.subclientId =0 )
                                                                        OR
                                                    (TM_AssocEntity.apptypeId = T1.appId AND TM_AssocEntity.instanceId = 0 AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
                                                            OR
                                                    (TM_AssocEntity.clientId = T1.cId AND TM_AssocEntity.apptypeId = 0 AND TM_AssocEntity.instanceId = 0 AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
                                                            OR
                                                    (TM_AssocEntity.clientGroupId in (SELECT clientGroupId from APP_ClientGroupAssoc where clientId = t1.cId)
													AND   TM_AssocEntity.clientId = 0 AND TM_AssocEntity.apptypeId = 0 AND TM_AssocEntity.instanceId = 0 AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
                                                                                    ) and processed=0))), 0)
						FROM    #userMailBoxInfo T1 WHERE cId <> 0 AND subId = T1.subId
	  UPDATE #userMailBoxInfo
            SET nextBackupTime = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp
                                WHERE componentNameId=cId AND attrName='Next Run Time In'
                                AND (CAST(attrVal AS INT)<nextBackupTime OR nextBackupTime=0) AND modified=0 AND CAST(attrVal AS INT)>0
                                ), nextBackupTime)
	   --Return only one subclient for a backupset
		DELETE FROM #userMailBoxInfo WHERE id in (
		SELECT id FROM (
		SELECT id, ROW_NUMBER() OVER(PARTITION BY appId,cid, bsetid ORDER BY lastbkupTime desc) as RowNo FROM #userMailBoxInfo
		) d WHERE d.rowNo>1
		)
SET @outputXmlString =(
SELECT mailBoxId AS '@mailBoxId', smtpName AS '@mailBox', aliasName AS '@aliasName', displayName AS '@displayName', mailboxGUID AS '@mailBoxGuid',
path AS '@path',  (SELECT top 1 CAST(ISNULL(attrVal,0) AS INT) From APP_ClientProp where attrName = 'Content Indexing Enabled'
                         AND modified = 0 AND componentNameId = cId) as '@contentIndexingEnabled',
				(SELECT lastbkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastBackupTime'), TYPE),
				(SELECT lastSuccessBackupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastSuccessBackupTime'), TYPE),
                 (SELECT nextBackupTime AS '@time', 55 '@_type_' FOR XML PATH ('nextBackupTime'), TYPE),
(SELECT  cId AS '@clientId',clientName AS '@clientName',
       appId AS '@applicationId', appName AS '@appName',
       bsetId AS '@backupsetId', backupSetName AS '@backupsetName',
       subId AS '@subclientId', subclientName AS '@subclientName'
        FOR XML PATH('subClient'),TYPE)
FROM #userMailBoxInfo finalmb ORDER BY lastbkupTime desc, bsetId desc
FOR xml path('userMailBoxes'))
EXIT_ERROR:
DROP TABLE #userMailBoxInfo
DROP TABLE #clientListTmp
DROP TABLE #AccessibleSubclients
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLaptopUserMailBox')
	delete from GxQscripts where name = 'AppGetLaptopUserMailBox'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopUserMailBox')
	delete from GXDBVersions where aliasname = 'AppGetLaptopUserMailBox'
GO

insert into GXDBVersions values(2, 'AppGetLaptopUserMailBox',  'v1.19.2.10.36.1', 'AppGetLaptopUserMailBox', 'v1.19.2.10.36.1')
GO

