

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLaptopUserDelegatedMailBox.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetLaptopUserDelegatedMailBox.sp,v $ $Id: AppGetLaptopUserDelegatedMailBox.sp,v 1.7.40.21.16.1 2021/01/13 14:35:57 mnatarajan Exp $";
--	+===================================================================+
--	| AppGetLaptopUserDelegatedMailBox - Get Laptop user delegated mail box				|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetLaptopUserDelegatedMailBox')
BEGIN
	print '>>> Drop Stored Procedure: AppGetLaptopUserDelegatedMailBox <<<'
	drop procedure AppGetLaptopUserDelegatedMailBox
END
IF EXISTS (select * from GxQscripts where name='AppGetLaptopUserDelegatedMailBox')
	delete from GxQscripts where name = 'AppGetLaptopUserDelegatedMailBox'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopUserDelegatedMailBox')
	delete from GXDBVersions where aliasname = 'AppGetLaptopUserDelegatedMailBox'
GO
print '... Creating Procedure: AppGetLaptopUserDelegatedMailBox'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetLaptopUserDelegatedMailBox
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @in_userGroupGUIDs NVARCHAR(MAX) = '',
  @userId INT = 0,
  @outputXmlString XML OUTPUT
-----------------------------------------------------------
AS
DECLARE @excludeStatusMask int = (cast(0x00004  as int) | cast(0x00020 as int) |  cast(0x00002 as int))
DECLARE @isCommcellLevelAssociation int = 0
--Values from enum MailboxSharedByType in App.x
DECLARE @EXCHANGE_SHARE				INT = 1
DECLARE @COMMVAULT_SHARED_WITH_ME	INT = 2
DECLARE @COMMVAULT_SHARED_BY_ME		INT = 3
-- Constants from Edge drive share framework
DECLARE @EDGE_SHARED_BY_ME INT = 1
DECLARE @EDGE_SHARED_WITH_ME INT = 2
DECLARE @APPCLIENTTYPE_EXCHANGE INT = 25 --Value from Enum ClientType in App.x
IF object_id('tempdb.dbo.#userMailBoxInfo') IS NOT null DROP TABLE #userMailBoxInfo
CREATE TABLE #userMailBoxInfo
(
	mailBoxId     int ,
    appTypeId int,
appTypeName nvarchar(255),
    clientid int,
clientName nvarchar(255),
    backupSetId   int,
backupSetName nvarchar(128),
    subClientId   int,
subClientName nvarchar(128),
displayName   nvarchar(255),
aliasName     nvarchar(255),
smtpName      nvarchar(255),
mailboxGUID   nvarchar(40),
mbParentGuid   nvarchar(128),
    path nvarchar(max),
    folder nvarchar(max),
rights  nvarchar(255),
    lastbkupTime int,
    lastSuccessBackupTime int,
    nextBackupTime int,
    instanceId int,
	sharedType int default 1,
	shareCreated int default 0,
	syncWebFolderId  int default 0,
	syncWebFolderName nvarchar(max) default ''
)
CREATE CLUSTERED INDEX userMailBoxInfo_mailBoxId_IDX on #userMailBoxInfo(mailBoxId);
IF OBJECT_ID('tempdb.dbo.#GroupMailboxUserGUIDS') IS NOT Null DROP TABLE #GroupMailboxUserGUIDS
create table #GroupMailboxUserGUIDS
(
MailboxUserGUID VARCHAR(40),
	PRIMARY KEY(MailboxUserGUID)
)
INSERT INTO #GroupMailboxUserGUIDS SELECT DISTINCT '{'+ data + '}' FROM dbo.SplitString(@in_userGroupGUIDs,';')
IF OBJECT_ID('tempdb.dbo.#AccessibleSubclients') IS NOT Null DROP TABLE #AccessibleSubclients
create table #AccessibleSubclients
(
	subclientId INTEGER,
	appTypeId INTEGER,
	PRIMARY KEY(subclientId, appTypeId)
)
IF object_id('tempdb.dbo.#tmpUserDelegateInfo') IS NOT null DROP TABLE #tmpUserDelegateInfo
CREATE TABLE #tmpUserDelegateInfo
(
	clientid int,
	subClientId   int,
	mailboxGUID   nvarchar(40),
	mbParentGuid   nvarchar(128),
    path nvarchar(max),
    folder nvarchar(max),
	sharedType int default 1,
	shareCreated int default 0,
	syncWebFolderId  int default 0,
	syncWebFolderName nvarchar(max) default '',
	displayPath nvarchar(max) default ''
)
CREATE CLUSTERED INDEX tmpUserDelegateInfo_subClientId_mailBoxGUID_mbParentGUID_IDX on #tmpUserDelegateInfo(subClientId, mailboxGUID, mbParentGuid);
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
	DECLARE @showCurrentContent INT = 0
	SET @showCurrentContent = ISNULL((SELECT VALUE FROM Gxglobalparam WHERE NAME = 'ShowMBFromCurrentSubclient'), 0)
	IF object_id('tempdb.dbo.#clientListTmp') IS NOT null DROP TABLE #clientListTmp
create table  #clientListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2012, 0, '#clientListTmp'
	DELETE FROM #clientListTmp WHERE capabilities & CONVERT(bigint, (POWER(2.0,  24   -1))) = 0   AND (capabilities & CONVERT(bigint, (POWER(2.0, 13  -1))) = 0 )
SELECT @isCommcellLevelAssociation=1 from #clientListTmp sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
	INSERT INTO #AccessibleSubclients
	SELECT A.id, A.appTypeId
	FROM APP_Application A
WHERE A.appTypeId IN (137, 54,  56 , 67)
	AND
		(	@isCommcellLevelAssociation=1 --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
		OR
			A.clientId in (select clientId from #clientListTmp sec  where sec.appTypeId=0 and sec.instanceId=0 and sec.backupsetId=0)
		OR
			A.clientId IN (select clientId from #clientListTmp sec  where sec.appTypeId=A.appTypeId and sec.instanceId=0 and sec.backupsetId=0)
		OR
			A.clientId IN (select clientId  from #clientListTmp sec where sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=0)
		OR
			A.clientId IN (select clientId  from #clientListTmp sec where sec.appTypeId=A.appTypeId and sec.instanceId=A.instance and sec.backupsetId=A.backupSet)
		)
	--Exchange clasic agent
	INSERT INTO #userMailBoxInfo(mailBoxId, appTypeId, appTypeName, clientid, clientName, backupSetId, backupSetName, subClientId, subClientName, displayName,
		aliasName, smtpName, mailboxGUID, mbParentGuid, path, folder, rights, lastbkupTime, lastSuccessBackupTime, nextBackupTime, instanceId)
		SELECT distinct e.componentId,a.appTypeId, '',
		a.clientId, c.name, a.backupSet, '', a.id,a.subclientName, '','','',delegateUserGUID, ISNULL(delegateInfo.value('(/.//@folderGUID)[1]', 'nvarchar(max)'), ''), '\MB\' + REPLACE(md.delegateUserGUID,'-','X'), delegateInfo.value('(/.//@folder)[1]', 'nvarchar(max)') , delegateInfo.value('(/.//@rights)[1]', 'nvarchar(max)'),0,0,'',a.instance
        FROM APP_MailBoxDelegates md
INNER JOIN APP_ComponentProp e ON e.propertyTypeId = 1103 AND (e.stringVal = REPLACE(md.delegateUserGUID,'-','X'))
        INNER JOIN APP_SubClientProp sp ON e.componentId = sp.id
        INNER JOIN APP_Application a ON sp.componentNameId = a.id
INNER JOIN APP_Client c ON c.id = a.clientId AND c.releaseid > 14
		WHERE md.mailboxUserGUID IN ( SELECT MailboxUserGUID FROM #GroupMailboxUserGUIDS) AND (@showCurrentContent=0 or sp.modified=0)
			AND a.id IN ( SELECT subclientId FROM #AccessibleSubclients)
			AND  e.modified = 0
			AND (e.stringVal =  REPLACE(md.delegateUserGUID,'-','X'))-- and (subclientStatus & @excludeStatusMask  = 0)
	--Exchange new agent
	INSERT INTO #userMailBoxInfo(mailBoxId, appTypeId, appTypeName, clientid, clientName, backupSetId, backupSetName, subClientId, subClientName, displayName,
		aliasName, smtpName, mailboxGUID, mbParentGuid, path, folder, rights, lastbkupTime, lastSuccessBackupTime, nextBackupTime, instanceId)
		SELECT distinct EA.assocId, a.appTypeId, '',
		A.clientId, C.name, A.backupSet, '', A.id, A.subclientName, EA.displayName, EA.aliasName, EA.smtpAdrress, delegateUserGUID, ISNULL(delegateInfo.value('(/.//@folderGUID)[1]', 'nvarchar(max)'), EA.userGuid),'\MB\{' + EA.userGuid +'}', delegateInfo.value('(/.//@folder)[1]', 'nvarchar(max)') , delegateInfo.value('(/.//@rights)[1]', 'nvarchar(max)'),0,0,'', A.instance
		FROM APP_MailBoxDelegates md
		INNER JOIN APP_EmailConfigPolicyAssoc EA ON ('{' + EA.userGuid +'}'=  REPLACE(md.delegateUserGUID,'-','X'))
INNER JOIN APP_Client C ON  (C.releaseid > 14 AND C.id = EA.clientId)
INNER JOIN APP_Application A ON (A.appTypeId = 137 AND EA.subClientId = A.id)
		WHERE  (@showCurrentContent=0 )
		AND md.mailboxUserGUID IN ( SELECT MailboxUserGUID FROM #GroupMailboxUserGUIDS) AND EA.discoverByType=1 --EA.modified=0 AND EA.deleted=0  show removed mailbox content also if backedup
		AND a.id IN ( SELECT subclientId FROM #AccessibleSubclients)
--- CODE BELOW HERE IS FROM AppGetSharedMailboxes.spb STARTS -------
DECLARE @getSharedFoldersByMeReqest XML = '<App_GetSharedFoldersReq propertyLevel="20" getHiddenShares="1" > <shareInfo shareType="1"> <browseInfo clientType="25"/> </shareInfo> </App_GetSharedFoldersReq>'
DECLARE @getShareFoldersWithMeReqest XML = '<App_GetSharedFoldersReq propertyLevel="20" getHiddenShares="1" > <shareInfo shareType="2"> <browseInfo clientType="25"/> </shareInfo> </App_GetSharedFoldersReq>'
IF OBJECT_ID('tempdb.dbo.#OutputAppSharingGetSharedFolders') IS NULL
BEGIN
	CREATE TABLE #OutputAppSharingGetSharedFolders
	(
	outputXml XML
	)
END
--Get Shared by me folders
EXEC AppSharingGetSharedFolders @getSharedFoldersByMeReqest, @userId, 0
--Get Shared with me folders
EXEC AppSharingGetSharedFolders @getShareFoldersWithMeReqest, @userId, 0
--- CODE FROM AppGetSharedMailboxes.spb ENDS----------
	--Sharing feature
		/* Get shared with me*/
		INSERT INTO #tmpUserDelegateInfo (clientid, subClientId, mailboxGUID, mbParentGuid, path, folder, sharedType, shareCreated, syncWebFolderId, syncWebFolderName, displayPath)
					SELECT distinct SC.value('(client/@clientId)[1]', 'INT'),
					SC.value('(client/@subclientId)[1]', 'INT'),
ISNULL(SC.value('(browseInfo/paths/appInfo/@mailboxGuid)[1]', 'nvarchar(40)'),''),
					ISNULL(SC.value('(browseInfo/paths/@path)[1]', 'nvarchar(max)'),''),
'\MB\{'+ ISNULL(SC.value('(browseInfo/paths/appInfo/@mailboxGuid)[1]', 'nvarchar(40)'),'')+ '}',
					ISNULL(SC.value('(shareFolder/@syncWebFolderName)[1]', 'nvarchar(max)'),''),
					ISNULL(SC.value('(@shareType)[1]', 'INT'),0),
					SC.value('(created/@timeValue)[1]', 'INT'),
					SC.value('(shareFolder/@syncWebFolderId)[1]', 'INT'),
					SC.value('(shareFolder/@syncWebFolderName)[1]', 'NVARCHAR(MAX)'),
					ISNULL(SC.value('(browseInfo/paths/@displayPath)[1]', 'nvarchar(max)'),'')
			FROM #OutputAppSharingGetSharedFolders T
			CROSS APPLY T.outputXml.nodes('App_GetSharedFoldersResp/shares') DOC(SC)
			WHERE ISNULL(SC.value('(browseInfo/@clientType)[1]', 'INT'),0) = @APPCLIENTTYPE_EXCHANGE
		/*Don't use mailboxId (Classic agent needs mailboxId). All mailbox props are inserted in go here.
		Populating dummy 0 value to hide warning of NULL value over aggregate functions used later on this table*/
		INSERT INTO #userMailBoxInfo (mailBoxId, appTypeId, appTypeName, clientid, clientName, backupSetId, backupSetName, subClientId, subClientName, displayName,
		aliasName, smtpName, mailboxGUID, mbParentGuid, path, folder, rights, lastbkupTime, lastSuccessBackupTime, nextBackupTime, instanceId, sharedType, shareCreated, syncWebFolderId, syncWebFolderName)
				SELECT distinct 0, a.appTypeId, '', A.clientId, C.name, A.backupSet, '', A.id, A.subclientName, EA.displayName, EA.aliasName, EA.smtpAdrress,
			'{'+REPLACE(T.mailboxGUID,'X','-')+'}', T.mbParentGuid, T.path,
			(CASE WHEN T.sharedType = 1  THEN T.displayPath WHEN (T.sharedType = 2 AND T.mailboxGUID != T.mbParentGuid) THEN T.syncWebFolderName ELSE '\' END),
			'FullAccess', 0, 0,'', A.instance,
			 @COMMVAULT_SHARED_WITH_ME,
			T.shareCreated, T.syncWebFolderId, T.syncWebFolderName
			FROM #tmpUserDelegateInfo T
			INNER JOIN APP_EmailConfigPolicyAssoc EA ON EA.userGuid = T.mailboxGUID
INNER JOIN APP_Client C ON  (C.releaseid > 14 AND C.id = EA.clientId)
INNER JOIN APP_Application A ON (A.appTypeId = 137 AND EA.subClientId = A.id)
			WHERE a.id IN ( SELECT subclientId FROM #AccessibleSubclients) AND T.sharedType = @EDGE_SHARED_WITH_ME /* SHARED_WITH_ME */
		/* Get shared by me*/
		INSERT INTO #userMailBoxInfo (mailboxId, clientid, clientName, backupSetId, subClientId, appTypeId, mailboxGUID, mbParentGuid, path, folder, sharedType, shareCreated, syncWebFolderId, syncWebFolderName)
		SELECT distinct 0, A.clientId, C.name, A.backupset, A.id, A.appTypeId, '{'+REPLACE(T.mailboxGUID,'X','-')+'}', T.mbParentGuid, T.path,
					T.displayPath, @COMMVAULT_SHARED_BY_ME, T.shareCreated, T.syncWebFolderId, T.syncWebFolderName
					FROM #tmpUserDelegateInfo T
INNER JOIN APP_Application A ON (A.appTypeId = 137 AND T.subClientId = A.id)
INNER JOIN APP_Client C ON (C.releaseid > 14 AND C.id = T.clientId)
					WHERE T.sharedType = @EDGE_SHARED_BY_ME
	UPDATE #userMailBoxInfo
    SET backupSetName=(select name from APP_BackupSetName where id=backupSetId)
    UPDATE #userMailBoxInfo
    SET appTypeName=(SELECT name FROM APP_iDAType where type=appTypeId )
    --1)clear out the mailbox that has a  delegation at folder level but has rigths as None.
    --2)clear out the mailbox that has a delegation at folder level, when delegation is at mailbox level(folder='/')
    DELETE FROM #userMailBoxInfo WHERE folder<>'\' AND rights='none'
	DELETE FROM #userMailBoxInfo  WHERE mailboxGUID in
    (SELECT mailboxGUID FROM #userMailBoxInfo b WHERE folder = '\' ) AND folder<>'\'
	UPDATE #userMailBoxInfo set aliasName = cp.stringVal
FROM App_ComponentProp cp WHERE appTypeId != 137 AND mailBoxId = cp.componentId
AND cp.propertyTypeId = 1101 --  1101
	UPDATE #userMailBoxInfo set displayName = cp.stringVal
FROM App_ComponentProp cp WHERE appTypeId != 137 AND  mailBoxId = cp.componentId
AND cp.propertyTypeId = 1102 --  1102
	UPDATE #userMailBoxInfo set smtpName = cp.stringVal
FROM App_ComponentProp cp WHERE appTypeId != 137 AND mailBoxId = cp.componentId
and cp.propertyTypeId = 1100 -- 1100
	--  TR:190807-227 OutlookWebconsoleShortcut Opens Slow
	--  Populate aliasName, displayName, smtpAddress while inserting row in #userMailboxInfo
	--UPDATE #userMailBoxInfo SET aliasName = AEC.aliasName, displayName = AEC.displayName, smtpName = AEC.smtpAdrress
--FROM APP_EmailConfigPolicyAssoc AEC WHERE REPLACE('{'+AEC.userGuid+'}', 'x','-')= mailboxGUID and  appTypeId =137
	--Last backup time
	UPDATE	#userMailBoxInfo
			SET lastbkupTime = (select ISNULL(max(servEndDate) ,0)
			FROM JMBkpStats  jstats
			WHERE subClientId = jstats.appId )
	--Last backup time
	UPDATE	#userMailBoxInfo
			SET lastSuccessBackupTime = (select ISNULL(max(servEndDate) ,0)
			FROM JMBkpStats  jstats
			WHERE subClientId = jstats.appId
			AND status in (1,3))
	UPDATE #userMailBoxInfo
            SET nextBackupTime = ISNULL((select min(nextTime) from TM_RunTime WITH (NOLOCK) where patternId in (
            select patternId from TM_PatternAssoc WITH (NOLOCK) where subTaskId in (
                select st.subTaskId from TM_SubTask st WITH (NOLOCK) INNER JOIN TM_SubTaskOptions sto ON sto.subTaskId = st.subTaskId AND sto.optionId = 458405394 AND sto.value IN (1, 2)  where taskId in (
                        SELECT taskId FROM dbo.TM_Associations TM_AssocEntity (NOLOCK) where
                        --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
                                                    (TM_AssocEntity.subclientId = T1.subclientId)
                                                    OR
                                                    (TM_AssocEntity.backupsetId = T1.backupsetId AND TM_AssocEntity.subclientId =0 )
                                                                        OR
                                                    (TM_AssocEntity.apptypeId = T1.appTypeId AND TM_AssocEntity.instanceId = 0 AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
                                                            OR
                                                    (TM_AssocEntity.clientId = T1.clientId AND TM_AssocEntity.apptypeId = 0 AND TM_AssocEntity.instanceId = 0 AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
                                                            OR
                                                    (TM_AssocEntity.clientGroupId in (select clientGroupId from APP_ClientGroupAssoc where clientId = t1.clientId) and   TM_AssocEntity.clientId = 0 AND TM_AssocEntity.apptypeId = 0 AND TM_AssocEntity.instanceId = 0 AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
                                                                                    )and processed=0))), 0)
						FROM    #userMailBoxInfo T1 WHERE clientid <> 0 and subClientId = T1.subClientId
	  UPDATE #userMailBoxInfo
            SET nextBackupTime = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp
                                WHERE componentNameId=clientid AND attrName='Next Run Time In'
                                AND (CAST(attrVal AS INT)<nextBackupTime OR nextBackupTime=0) AND modified=0 AND CAST(attrVal AS INT)>0
                                ), nextBackupTime)
 --only show  one mailbox per backupset with latest lastbckup time
DELETE dup FROM
   (SELECT ROW_NUMBER() OVER (PARTITION BY backupSetId, mailboxGUID,
   (SELECT CASE WHEN (mbParentGuid NOT LIKE '%!%') THEN mbParentGuid ELSE RIGHT(mbParentGuid, CHARINDEX('!', REVERSE(mbParentGuid)) - 1) END)
   ORDER BY lastbkupTime DESC) cnt
   FROM #userMailBoxInfo WHERE sharedType <> @COMMVAULT_SHARED_BY_ME) dup WHERE dup.cnt > 1
SET @outputXmlString =(
		SELECT mailBoxId AS '@mailBoxId', smtpName AS '@mailBox', aliasName AS '@aliasName', displayName AS '@displayName', mailboxGUID AS '@mailBoxGuid', mbParentGuid as '@mbParentGuid',
			path AS '@path',  sharedType as '@sharedType',
			(select top 1 CAST(ISNULL(attrVal,0) AS INT) From APP_ClientProp where attrName = 'Content Indexing Enabled'
                 and modified = 0 and componentNameId = clientid) as '@contentIndexingEnabled',  folder as '@folder' ,(SELECT lastbkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastBackupTime'), TYPE),
			(select syncWebFolderId as '@syncWebFolderId', syncWebFolderName as '@syncWebFolderName' FOR XML PATH ('sharedFolder'), TYPE),
			shareCreated as 'shareCreated/@timeValue',
			(SELECT lastSuccessBackupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastSuccessBackupTime'), TYPE),
            (SELECT nextBackupTime AS '@time', 55 '@_type_' FOR XML PATH ('nextBackupTime'), TYPE),
			(SELECT  clientid AS '@clientId',clientName AS '@clientName',
				appTypeId AS '@applicationId', appTypeName AS '@appName',
				backupSetId AS '@backupsetId', backupSetName AS '@backupsetName',
				subClientId AS '@subclientId', subclientName AS '@subclientName'
			FOR XML PATH('subClient'),TYPE)
		FROM #userMailBoxInfo finalmb ORDER BY lastbkupTime desc, backupSetId desc
		FOR xml path('userDeletegatedMailBoxes'))
EXIT_ERROR:
IF OBJECT_ID('tempdb.dbo.#userMailBoxInfo') IS NOT NULL
	DROP TABLE #userMailBoxInfo
IF OBJECT_ID('tempdb.dbo.#clientListTmp') IS NOT NULL
	DROP TABLE #clientListTmp
IF OBJECT_ID('tempdb.dbo.#GroupMailboxUserGUIDS') IS NOT NULL
	DROP TABLE #GroupMailboxUserGUIDS
IF OBJECT_ID('tempdb.dbo.#AccessibleSubclients') IS NOT NULL
	DROP TABLE #AccessibleSubclients
IF OBJECT_ID('tempdb.dbo.#OutputAppSharingGetSharedFolders') IS NOT NULL
	DROP TABLE #OutputAppSharingGetSharedFolders
IF OBJECT_ID('tempdb.dbo.#tmpUserDelegateInfo') IS NOT NULL
	DROP TABLE #tmpUserDelegateInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLaptopUserDelegatedMailBox')
	delete from GxQscripts where name = 'AppGetLaptopUserDelegatedMailBox'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopUserDelegatedMailBox')
	delete from GXDBVersions where aliasname = 'AppGetLaptopUserDelegatedMailBox'
GO

insert into GXDBVersions values(2, 'AppGetLaptopUserDelegatedMailBox',  'v1.7.40.21.16.1', 'AppGetLaptopUserDelegatedMailBox', 'v1.7.40.21.16.1')
GO

