

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetLaptopAssociatedToUserAndUserGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +==============================================================================================================+
--  |   Procedure:  AppGetLaptopAssociatedToUserAndUserGroup()
--  |
--  | Description:  SP for fetching Laptops with provided users or user groups as onwer and with plans associated
--  |
--  |       Input:  User or user group id's'
--  |      Output:  Details of laptop clients
--  |      Return:  xxx
--  |
--  |   Revisions  Author
--  |   ---------  Arvind Lakra
--  +==============================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetLaptopAssociatedToUserAndUserGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppGetLaptopAssociatedToUserAndUserGroup <<<'
	drop procedure AppGetLaptopAssociatedToUserAndUserGroup
END
IF EXISTS (select * from GxQscripts where name='AppGetLaptopAssociatedToUserAndUserGroup')
	delete from GxQscripts where name = 'AppGetLaptopAssociatedToUserAndUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopAssociatedToUserAndUserGroup')
	delete from GXDBVersions where aliasname = 'AppGetLaptopAssociatedToUserAndUserGroup'
GO
print '... Creating Procedure: AppGetLaptopAssociatedToUserAndUserGroup'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetLaptopAssociatedToUserAndUserGroup
  @i_userId INT,
  @i_localeId INT,
  @xmlString XML OUTPUT,
  @o_errorCode INTEGER OUTPUT,
  @o_errorString VARCHAR(1024) OUTPUT
AS
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(max)
-- Flow to be followed
-- Get all users from request. Expand user group to fetch users from it.
-- Get all laptop clients for which above users are owner and have plan associated with them
-- Sample XML
-- <App_LaptopActivatedByUserOrUserGroupReq>
--   <userGroup userGroupId="10" />
--   <userGroup userGroupId="11" />
--   <userGroup userGroupId="12" />
--   <users userId="1" />
--   <users userId="2" />
--   <users userId="3" />
-- </App_LaptopActivatedByUserOrUserGroupReq>
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
BEGIN TRY
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SET @errorCode = 0
    SET @errorString = N''
    DECLARE @inputTbl TABLE(userId INT , groupId INT, isUser INT, IsPresentInReq INT, directlyAssociatedPlan INT)
    DECLARE @laptopTbl TABLE (id INTEGER NOT NULL IDENTITY (1,1), userId INT, clientId INT, clientName NVARCHAR(255), planID INT, planName NVARCHAR(255), isUserCentric INT DEFAULT(0), physicalClientId INT DEFAULT(0), regionId INT DEFAULT(0), regionName NVARCHAR(255))
	-- Get User and User Group From request
    INSERT INTO @inputTbl (userId, groupId,isUser, IsPresentInReq)
    SELECT ref.value('@userId', 'INT'), 0, 1,1
		    FROM   @xmlString.nodes('App_LaptopActivatedByUserOrUserGroupReq/users') R ( ref )
    UNION
    SELECT 0, ref.value('@userGroupId', 'INT'),0,1
		    FROM   @xmlString.nodes('App_LaptopActivatedByUserOrUserGroupReq/userGroup') R ( ref )
	-- Get All User's for the provided user group. We will mark there associations as indirect (as they haven't been asked to reassociate via request directly)
	INSERT INTO @inputTbl (userId, groupId, isUser, IsPresentInReq)
	SELECT UU.userId,UU.groupId,1,0 FROM UMUserGroup UU
		LEFT OUTER JOIN @inputTbl IT
			ON IT.userId=UU.userId AND IT.isUser=1
		WHERE UU.groupId IN (SELECT groupId FROM @inputTbl WHERE isUser=0)
				AND IT.userId IS NULL
	-- Get Plan for All User and User Groups
	-- We are getting plan directly associated to this user or user group. This will help us identify devices which needs to be migrated or not
	UPDATE UT
	SET
		UT.directlyAssociatedPlan= (CASE WHEN UT.isUser=1 THEN UUP.attrVal
									WHEN UT.isUser=0 THEN UGP.attrVal
									ELSE 0 END)
	FROM @inputTbl UT
	LEFT OUTER JOIN UMUsersProp UUP
		ON UUP.attrName='Associated Plan' and UT.isUser=1 AND UUP.componentNameId=UT.userId AND UUP.modified=0
	LEFT OUTER JOIN UMGroupsProp UGP
		ON UGP.attrName='Associated Plan' and UT.isUser=0 AND UGP.componentNameId=UT.groupId AND UGP.modified=0
	-- In case of indirect associations, means we were provided group id and we elaborated user id from it.
	-- If that elaborated user id don't have any direct plan, then we will use plan id from the group from which this user was identified
	UPDATE UT
	SET
		UT.directlyAssociatedPlan= UT1.directlyAssociatedPlan
	FROM @inputTbl UT
	INNER JOIN @inputTbl UT1
		ON UT1.groupId=UT.groupId AND UT.directlyAssociatedPlan IS NULL AND UT.isUser=1 AND UT1.isUser=0 AND UT1.directlyAssociatedPlan IS NOT NULL
    INSERT INTO @laptopTbl(userId , clientId , clientName , planID , planName, isUserCentric, physicalClientId)
    SELECT UM.userOrGroupId, AC.id, AC.displayName, AP.id, AP.name, ISNULL(ACP1.attrVal,0), IIF(ACP1.attrVal IS NULL, AC.id, 0)
		FROM APP_Client AC
    INNER JOIN APP_ClientProp ACP
ON ACP.componentNameId=AC.id AND ACP.attrName=N'Associated Plan'
    INNER JOIN App_Plan AP
ON CAST(AP.id AS NVARCHAR(16))=ACP.attrVal AND (AP.subtype=33554439) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
    INNER JOIN UMOwners UM
ON UM.entityType=3 AND UM.entityId=AC.id
	INNER JOIN @inputTbl IT
		ON (UM.isUser=1 AND IT.isUser=1 AND UM.userOrGroupId=IT.userId)
	LEFT OUTER JOIN APP_ClientProp ACP1
ON ACP1.componentNameId=AC.id AND ACP1.attrName='User Centric Client' and ACP1.modified=0 AND ACP1.attrVal=N'1'
WHERE AC.status&0x1000<>0
	-- Now remove all laptop clients for which users were not present directly in the request and there direct plan association which is different from the one associated to device
	-- Details of condition
	-- Laptop Owner User Id is not in request
	-- Plan used for Activation of Laptop is different than one currently associated to the user
	--	-- This means that User Group Id provided in the input request which gave use this user is not reffering to plan via this User Group and laptop was activated
	--	-- This can only means 2 things -
	--	--	--	Either machine has multiple owners and one who activated it is using some different plan. So, let's not touch it.
	--	--	--	In case of single owner, user when activated this laptop got its plan maping via some different route than 1 provided in the migration request.
	--	--	--	In both cases, lets just not migrate this laptop. If user does want to move this laptop, then he/she should explicitly move one of the owners to different plan
	DELETE LTBL
	FROM @laptopTbl LTBL
	INNER JOIN @inputTbl ITBL
	ON  ITBL.IsPresentInReq=0 AND ITBL.directlyAssociatedPlan<>LTBL.planID AND ITBL.userId=LTBL.userId AND ITBL.isUser=1
	-- If any client is user centric client, then it should have valid physical client
	-- If it doesn't have one, then remove the same from list
	UPDATE LTBL
		SET LTBL.physicalClientId=AC.id
	FROM @laptopTbl LTBL
								INNER JOIN APP_ClientProp ACP
ON ACP.componentNameId=LTBL.clientId AND LTBL.isUserCentric=1 AND ACP.attrName='Physical Client Id' AND ACP.modified=0
								INNER JOIN APP_Client AC
ON CAST(AC.id AS VARCHAR(64))=ACP.attrVal AND AC.status&0x1000<>0
	WHERE LTBL.isUserCentric=1
	DELETE
	FROM @laptopTbl
	WHERE isUserCentric=1 AND physicalClientId=0
	--
	--
	-- First try fetching region from direct client association
	UPDATE LTBL
		SET LTBL.regionId=IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), NULL),
		LTBL.regionName = AR.name
	FROM @laptopTbl LTBL
	LEFT OUTER JOIN APP_AdvanceSettings AAP
ON AAP.entityId = LTBL.physicalClientId AND AAP.entityType = 3 AND AAP.keyName = 'Region Id'
			AND AAP.sourceId = 0 AND AAP.enabled = 1 AND AAP.deleted = 0
	LEFT OUTER JOIN  App_Region AR
		ON AR.id=IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
	-- On second try, fetch region from client group level
	UPDATE LTBL
		SET LTBL.regionId=IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), NULL),
		LTBL.regionName = AR.name
	FROM @laptopTbl LTBL
	INNER JOIN APP_ClientGroupAssoc ACGA ON ACGA.clientId = LTBL.physicalClientId
LEFT OUTER JOIN APP_AdvanceSettings AAP ON AAP.entityId = LTBL.physicalClientId AND AAP.sourceId = ACGA.clientGroupId AND AAP.entityType = 3 AND AAP.sourceEntityType = 28
AND AAP.keyName = 'Region Id' AND AAP.enabled = 1 AND AAP.deleted = 0
	LEFT OUTER JOIN  App_Region AR ON AR.id=IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
	WHERE (LTBL.regionId IS NULL) OR (LTBL.regionId=0)
	--
	-- On third try, fetch region from client group level which is no longer associated to the client
	IF EXISTS (SELECT 1 FROM @laptopTbl WHERE regionId IS NULL OR regionId = 0)
	BEGIN
		UPDATE LTBL
		SET LTBL.regionId=IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), NULL),	LTBL.regionName = AR.name
		FROM @laptopTbl LTBL
LEFT OUTER JOIN APP_AdvanceSettings AAP ON AAP.entityId = LTBL.physicalClientId AND AAP.entityType = 3 AND AAP.keyName = 'Region Id' AND AAP.enabled = 1 AND AAP.deleted = 0
		LEFT OUTER JOIN  App_Region AR ON AR.id=IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
		WHERE (LTBL.regionId IS NULL) OR (LTBL.regionId=0)
	END
	--
	--
	-- For SP10, in case of list return single device for migration, in case elaborated list return same client for multiple users
	DELETE a FROM @laptopTbl A
		CROSS APPLY (
						SELECT  id,ROW_NUMBER()  over (partition  by clientid order by id ) idn FROM  @laptopTbl) b WHERE b.id=a.id AND b.idn>1
    -- Create Output
    SET @xmlString = (SELECT
                            (SELECT
						        (SELECT clientId AS '@clientId', clientName AS '@clientName' FOR XML PATH('client'), TYPE),
                                (SELECT userId AS '@userId' FOR XML PATH('user'), TYPE),
						        (SELECT planID AS '@planId', planName AS '@planName' FOR XML PATH('plan'), TYPE),
								(SELECT regionId AS '@regionId', regionName AS '@regionName' FOR XML PATH('region'), TYPE)
                             FROM @laptopTbl
                             FOR XML PATH('laptopDetails'), TYPE),
                             (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
                     FOR XML PATH('App_LaptopActivatedByUserOrUserGroupResp'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
    SET @xmlString = (
                        SELECT @errorCode AS '@errorCode',
                                @errorString AS '@errorMessage'
                        FOR XML PATH ('error'), ROOT('App_LaptopActivatedByUserOrUserGroupResp')
                       )
END  CATCH
GENERATE_OUTPUT:
    SET @o_errorCode=@errorCode
    SET @o_errorString=@errorString
	-- I don't think we are calling this from CPP.
	-- If ever syntax is changed, we will add variable that is it called from CPP or not. Then we will change syntax here to select only if that variable is set
	--SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetLaptopAssociatedToUserAndUserGroup')
	delete from GxQscripts where name = 'AppGetLaptopAssociatedToUserAndUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetLaptopAssociatedToUserAndUserGroup')
	delete from GXDBVersions where aliasname = 'AppGetLaptopAssociatedToUserAndUserGroup'
GO

insert into GXDBVersions values(2, 'AppGetLaptopAssociatedToUserAndUserGroup',  '00000000000000000000', 'AppGetLaptopAssociatedToUserAndUserGroup', '00000000000000000000')
GO

