

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetJobManagementSettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: GetCommCellProperties
--  |
--  | Description:
--  |  To get the job management settings
--  |
--  |   Revisions  Author					Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Mohammad Dilshad		To get the job management settings
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetJobManagementSettings <<<'

IF EXISTS (select * from sysobjects where name='AppGetJobManagementSettings')
	drop procedure AppGetJobManagementSettings
IF EXISTS (select * from GxQscripts where name='AppGetJobManagementSettings')
	delete from GxQscripts where name = 'AppGetJobManagementSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetJobManagementSettings')
	delete from GXDBVersions where aliasname = 'AppGetJobManagementSettings'
GO
print '... Creating Procedure: AppGetJobManagementSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetJobManagementSettings
AS
--This will turn off message: "xxx rows affected".
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
	DECLARE @outXML XML
	DECLARE @jobAliveCheckIntervalInMinutes INT
	DECLARE @jobStreamHighWaterMarkLevel INT
	DECLARE @queueJobsIfConflictingJobsActive INT
	DECLARE @queueJobsIfActivityDisabled INT
	DECLARE @allowRunningJobsToCompletePastOperationWindow INT
	DECLARE @queueScheduledJobs INT
	DECLARE @doNotStartBackupsOnDisabledClient INT
	DECLARE @enableMultiplexingForOracle INT
	DECLARE @enableJobThrottleAtClientLevel INT
	DECLARE @restorePreemptsOtherJobs INT
	DECLARE @backupsPreemptsOtherBackups INT
	DECLARE @backupsPreemptsAuxilaryCopy INT
	DECLARE @priorityPrecedence INT
	DECLARE @startPhaseRetryIntervalInMinutes INT
	DECLARE @stateUpdateIntervalForContinuousDataReplicator INT
	SET @jobAliveCheckIntervalInMinutes = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'JobAliveInterval' AND modified = 0), 300)
	SET @jobStreamHighWaterMarkLevel = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'JMJobActivityLevelHighWaterMark' AND modified = 0), 500)
	SET @queueJobsIfConflictingJobsActive = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'JobsQueuedIfJobsRunning' AND modified = 0), 0)
	SET @queueJobsIfActivityDisabled = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'JobsCompleteIfActivityDisabled' AND modified = 0), 0)
	SET @allowRunningJobsToCompletePastOperationWindow = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'JobsCompletePastOperationalWindow' AND modified = 0), 0)
	SET @queueScheduledJobs = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'RMQueueScheduledJob' AND modified = 0), 0)
	SET @doNotStartBackupsOnDisabledClient = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'JMDontStartBkpsOnDisabledAgents' AND modified = 0), 0)
	SET @enableMultiplexingForOracle = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'JMEnableMultiplexingForOracleAgents' AND modified = 0), 0)
	SET @enableJobThrottleAtClientLevel = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'ThrottleJobsFeature' AND modified = 0), 0)
	SET @restorePreemptsOtherJobs = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'RMRestoreInterruptOtherJobs' AND modified = 0), 1)
	SET @backupsPreemptsOtherBackups = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'RMBackupInterruptBackup' AND modified = 0), 0)
	SET @backupsPreemptsAuxilaryCopy = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'RMOtherJobsInterruptAuxCopy' AND modified = 0), 0)
	SET @priorityPrecedence = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'JobPriorityPrecedence' AND modified = 0), 1)
	SET @startPhaseRetryIntervalInMinutes = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'JMNetRetryPeriod' AND modified = 0), 600)
	SET @stateUpdateIntervalForContinuousDataReplicator = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'Data Replication Update Interval Minutes' AND modified = 0), 600)
	-- Generating root XML
	SET @outXML = (SELECT
					(SELECT
						(@jobAliveCheckIntervalInMinutes/60) AS '@jobAliveCheckIntervalInMinutes', -- Converting to minutes.
						@jobStreamHighWaterMarkLevel AS '@jobStreamHighWaterMarkLevel',
						@queueJobsIfConflictingJobsActive AS '@queueJobsIfConflictingJobsActive',
						@queueJobsIfActivityDisabled AS '@queueJobsIfActivityDisabled',
						@allowRunningJobsToCompletePastOperationWindow AS '@allowRunningJobsToCompletePastOperationWindow',
						@queueScheduledJobs AS '@queueScheduledJobs',
						@doNotStartBackupsOnDisabledClient AS '@doNotStartBackupsOnDisabledClient',
						CASE WHEN @enableMultiplexingForOracle & 1 = 1 THEN 1 ELSE 0 END AS '@enableMultiplexingForOracle',
						CASE WHEN @enableMultiplexingForOracle & 2 = 2 THEN 1 ELSE 0 END AS '@enableMultiplexingForDBAgents',
						@enableJobThrottleAtClientLevel AS '@enableJobThrottleAtClientLevel',
						@restorePreemptsOtherJobs AS '@restorePreemptsOtherJobs',
						@backupsPreemptsOtherBackups AS '@backupsPreemptsOtherBackups',
						@backupsPreemptsAuxilaryCopy AS '@backupsPreemptsAuxilaryCopy'
					FOR XML PATH('generalSettings'),TYPE),
					(SELECT
						@priorityPrecedence AS '@priorityPrecedence'
					FOR XML PATH('jobPrioritySettings'),TYPE),
					(SELECT
						(@startPhaseRetryIntervalInMinutes/60) AS '@startPhaseRetryIntervalInMinutes'
					FOR XML PATH('jobRestartSettings'),TYPE),
					(SELECT
						@stateUpdateIntervalForContinuousDataReplicator AS '@stateUpdateIntervalForContinuousDataReplicator'
					FOR XML PATH('jobUpdatesSettings'),TYPE)
				FOR XML PATH('jobManagementSettings'),
			ROOT('App_GetJobManagementSettingsResponse'))
	SELECT @outXML AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetJobManagementSettings')
	delete from GxQscripts where name = 'AppGetJobManagementSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetJobManagementSettings')
	delete from GXDBVersions where aliasname = 'AppGetJobManagementSettings'
GO

insert into GXDBVersions values(2, 'AppGetJobManagementSettings',  '00000000000000000000', 'AppGetJobManagementSettings', '00000000000000000000')
GO

