

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIsContentIndexingJobRunSuccessfully.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetIsContentIndexingJobRunSuccessfully <<<'

IF EXISTS (select * from sysobjects where name='AppGetIsContentIndexingJobRunSuccessfully')
	drop procedure AppGetIsContentIndexingJobRunSuccessfully
IF EXISTS (select * from GxQscripts where name='AppGetIsContentIndexingJobRunSuccessfully')
	delete from GxQscripts where name = 'AppGetIsContentIndexingJobRunSuccessfully'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIsContentIndexingJobRunSuccessfully')
	delete from GXDBVersions where aliasname = 'AppGetIsContentIndexingJobRunSuccessfully'
GO
print '... Creating Procedure: AppGetIsContentIndexingJobRunSuccessfully'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIsContentIndexingJobRunSuccessfully
  @i_subclientId integer,
  @i_backupSetId integer,
  @i_fromTime integer,
  @i_toTime integer,
  @i_getFromTime integer
AS
  DECLARE @o_isContentIndexingJobRun integer
  DECLARE @o_newFromTime integer
---please refer to JMGetJobsWithCIStatus.sp
DECLARE @defaultCCId INT = 2  --'DEFAULT_COMM_CELL_ID
SET @o_newFromTime = 0
IF EXISTS
(
SELECT     AF.jobId, AF.commCellId, MAX(AF.flags & 496 ) AS CIStatus, BKP.servEndDate
FROM       JMBkpStats AS BKP WITH (NOLOCK) INNER JOIN
           archFile AS AF WITH (NOLOCK) ON BKP.jobId = AF.jobId AND BKP.commCellId = AF.commCellId INNER JOIN
		   JMJobDataStats AS DATA WITH (NOLOCK) ON BKP.jobId = DATA.jobId AND BKP.commCellId = DATA.commCellId
		   INNER JOIN APP_Application app on ( (@i_subclientId <> 0 AND app.Id = @i_subclientId ) OR ( app.backupSet = @i_backupSetId))
WHERE
	(
		(@i_toTime =  0 AND BKP.servEndDate > @i_fromTime) OR
		(@i_toTime <>  0 AND BKP.servEndDate > @i_fromTime AND BKP.servEndDate <= @i_toTime)
	)
	AND	( (@i_subclientId <> 0 AND BKP.appId = @i_subclientId ) OR ( BKP.appId  = app.id))
	AND BKP.status IN (1, 3, 14) --typedef enum CVJobStatus{ JMSUCCESS=1, PARTIALSUCCESS=3, JMSUCCESSWITHWARNINGS = 14,
	AND DATA.disabled & 256 = 0 -- Non-Aged jobs
	AND AF.commCellId = app.origCCId
	AND AF.isValid = 1
GROUP BY AF.jobId, AF.commCellId, BKP.servEndDate
HAVING      (MAX(AF.flags & 496 ) & 64  <> 0) --'CVA_AF_CI_SUCCESS_FLAG: 64
)
	SET @o_isContentIndexingJobRun = 1
ELSE
	SET @o_isContentIndexingJobRun = 0
SET @o_isContentIndexingJobRun = ISNULL(@o_isContentIndexingJobRun, 0)
IF @i_getFromTime <> 0
BEGIN
	DECLARE @subClientTbl TABLE
	(subclientID INT, fromTime INT, synthFullExists INT, fullTime INT, synthFullTime INT, PRIMARY KEY(subclientID))
	DECLARE @jobsTbl TABLE
	(appID INT, bkpLevel INT, indexAfileCreationTime INT, isCISuccess INT)
	-- If To time is 0, it means till current time
	IF @i_toTime = 0
		SET @i_toTime = dbo.GetUnixTime(GETUTCDATE())
	IF @i_subclientId <> 0
	BEGIN
		INSERT INTO @subClientTbl
		VALUES(@i_subclientId, @i_fromTime, 0, 0, 0)
	END
	ELSE IF @i_backupSetId <> 0
	BEGIN
		INSERT INTO @subClientTbl
		SELECT id, @i_fromTime, 0, 0, 0
		FROM APP_Application APP WITH (NOLOCK)
		WHERE APP.backupSet = @i_backupSetId
		AND APP.subclientStatus & (2 | 4 | 16 | 32) = 0 -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
	END
	-- Get all valid jobs along with bkpLevel and Index ArchFile Creation time for subclients in given timeframe
	INSERT INTO @jobsTbl
	SELECT DISTINCT SUB.subclientID, BKP.bkpLevel, AF.cTime, --, dbo.GetDateTime(AF.cTime) "Time"
	ISNULL((SELECT MAX(flags & 496 & 64) FROM archFile AF2 WHERE AF2.jobId = BKP.jobId AND AF2.commCellId = BKP.commCellId), 0)
	FROM JMBkpStats BKP WITH (NOLOCK)
	INNER JOIN archFile AF WITH (NOLOCK) ON BKP.jobId = AF.jobId AND BKP.commCellId = AF.commCellId
	INNER JOIN @subClientTbl SUB ON BKP.appId = SUB.subclientID -- Only for Required Subclients
	INNEr JOIN JMJobDataStats DATA WITH (NOLOCK) ON BKP.jobId = DATA.jobId AND BKP.commCellId = DATA.commCellId
	WHERE  DATA.disabled & 256 = 0 -- Remove Aged jobs
	AND AF.isValid = 1 AND AF.fileType = 2 -- Valid Index Archive File
	AND AF.cTime >= @i_fromTime AND AF.cTime <= @i_toTime -- In the time range
	ORDER BY AF.cTime DESC
	IF @i_fromTime = 0
	BEGIN
		-- If from time is 0, Select the MAX(time of the latest REAL Full job before ToTime, latest SynthFull that is successfully CId)
		UPDATE @subClientTbl
		SET fullTime = ISNULL((SELECT TOP 1 indexAfileCreationTime -- Latest one
							   FROM @jobsTbl
							   WHERE appID = subclientID -- Same subclient
							   AND bkpLevel = 1 -- Full
							   AND indexAfileCreationTime <= @i_toTime -- Before the To Time
							   ORDER BY indexAfileCreationTime DESC -- Order by Latest
							   ), fromTime)
		UPDATE @subClientTbl
		SET synthFullTime = ISNULL((SELECT TOP 1 indexAfileCreationTime -- Latest one
							   FROM @jobsTbl
							   WHERE appID = subclientID -- Same subclient
							   AND bkpLevel IN(64, 128) -- SYNTHETIC_FULL, SYNTHETIC_FULL_AND_INCR
							   AND isCISuccess <> 0 -- Successfully CId
							   AND indexAfileCreationTime <= @i_toTime -- Before the To Time
							   ORDER BY indexAfileCreationTime DESC -- Order by Latest
							   ), 0)
			UPDATE @subClientTbl
			SET fromTime = CASE
							  WHEN fullTime >= synthFullTime THEN fullTime
							  ELSE synthFullTime
							  END
		END
	ELSE IF @i_fromTime > 0
	BEGIN
		-- First determine if synthFull ran in given time range
		UPDATE @subClientTbl
		SET synthFullExists = ISNULL((SELECT TOP(1) 1
									  FROM @jobsTbl JOB
									  WHERE JOB.appID = subclientID -- Same subclient
									  AND JOB.bkpLevel IN(64, 128) -- Synthetic Full jobs
									  ), 0)
		UPDATE @subClientTbl
		SET fullTime = CASE synthFullExists
						  WHEN 0 THEN fromTime -- If no synthFull then select from time as it is
						  -- Else select Latest REAL Full before the to time.
						  ELSE	ISNULL((SELECT TOP 1 AF.cTime-- Latest one
										FROM JMBkpStats JOB WITH (NOLOCK)
										INNER JOIN archFile AF WITH (NOLOCK) ON JOB.jobId = AF.jobId AND JOB.commCellId = AF.commCellId
										INNER JOIN JMJobDataStats DATA WITH (NOLOCK) ON JOB.jobId = DATA.jobId AND JOB.commCellId = DATA.commCellId
										WHERE DATA.disabled & 256 = 0 -- Remove aged
										AND JOB.appId = subclientID -- Same subclient
										AND JOB.bkpLevel = 1 -- Full
										AND AF.isValid = 1 AND AF.fileType = 2 -- Valid Index Archive File
										AND AF.cTime <= @i_toTime -- Before the To Time
										ORDER BY AF.cTime DESC -- Order by latest
										), fromTime)
						  END
		UPDATE @subClientTbl
		SET synthFullTime = CASE synthFullExists
								WHEN 0 THEN fromTime -- If no synthFull then select from time as it is
								-- Else select Latest synthFull before the to time that is successfully CId.
								ELSE	ISNULL((SELECT TOP 1 AF.cTime-- Latest one
											FROM JMBkpStats JOB WITH (NOLOCK)
											INNER JOIN archFile AF WITH (NOLOCK) ON JOB.jobId = AF.jobId AND JOB.commCellId = AF.commCellId
											INNER JOIN JMJobDataStats DATA WITH (NOLOCK) ON JOB.jobId = DATA.jobId AND JOB.commCellId = DATA.commCellId
											WHERE DATA.disabled & 256 = 0 -- Remove aged
											AND JOB.appId = subclientID -- Same subclient
											AND JOB.bkpLevel IN(64, 128) -- SYNTHETIC_FULL, SYNTHETIC_FULL_AND_INCR
											AND AF.isValid = 1 AND AF.fileType = 2 -- Valid Index Archive File
											AND AF.cTime <= @i_toTime -- Before the To Time
											AND EXISTS (SELECT 1
														FROM archFile AF2 WHERE AF2.jobId = JOB.jobId AND AF2.commCellId = JOB.commCellId
														AND (flags & 496 & 64) <> 0) -- Successfully CId
											ORDER BY AF.cTime DESC -- Order by latest
											), 0)
								END
		-- First set from time as MAX(Calculated Full time, SyntFull Time) when synthful exists
		UPDATE @subClientTbl
		SET fromTime = CASE
						  WHEN fullTime >= synthFullTime THEN fullTime
						  ELSE synthFullTime
						  END
		WHERE synthFullExists <> 0
		-- If synthFull exists, select MIN(newFromTime, given fromTime)
		UPDATE @subClientTbl
		SET fromTime = CASE
						  WHEN fromTime <= @i_fromTime THEN fromTime
						  ELSE @i_fromTime
						  END
		WHERE synthFullExists <> 0
	END
	-- As per manas, if AfCore is enabled, then use only fullTime as fromTime.
	IF NOT EXISTS(SELECT 1 FROM GXGlobalParam
			  WHERE name = 'Content Indexing Turbo Option' AND value = '0'
			  AND modified = 0)
	BEGIN
		UPDATE @subClientTbl
		SET fromTime = fullTime
	END
	SET @o_newFromTime = ISNULL((SELECT MIN(fromTime) "OutPut" FROM @subClientTbl), @i_fromTime)
END
SELECT  @o_isContentIndexingJobRun AS isContentIndexingJobRun, @o_newFromTime AS newFromTime
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIsContentIndexingJobRunSuccessfully')
	delete from GxQscripts where name = 'AppGetIsContentIndexingJobRunSuccessfully'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIsContentIndexingJobRunSuccessfully')
	delete from GXDBVersions where aliasname = 'AppGetIsContentIndexingJobRunSuccessfully'
GO

insert into GXDBVersions values(2, 'AppGetIsContentIndexingJobRunSuccessfully',  '00000000000000000000', 'AppGetIsContentIndexingJobRunSuccessfully', '00000000000000000000')
GO

