

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIsArchiveIndexDisabled.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetIsArchiveIndexDisabled')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIsArchiveIndexDisabled <<<'
	drop procedure AppGetIsArchiveIndexDisabled
END
IF EXISTS (select * from GxQscripts where name='AppGetIsArchiveIndexDisabled')
	delete from GxQscripts where name = 'AppGetIsArchiveIndexDisabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIsArchiveIndexDisabled')
	delete from GXDBVersions where aliasname = 'AppGetIsArchiveIndexDisabled'
GO
print '... Creating Procedure: AppGetIsArchiveIndexDisabled'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetIsArchiveIndexDisabled
  @xmlText XML
AS
DECLARE @outXml XML
DECLARE @i_backupSets TABLE(backupSetGUID VARCHAR(36), isDisabled INT)
INSERT INTO @i_backupSets
SELECT N.value('@guid','nvarchar(36)'), 0 FROM @xmlText.nodes('/Indexing_AppGetIsArchiveIndexDisabled/backupset') AS T(N)
UPDATE IB SET isDisabled = 1
FROM @i_backupSets AS IB
INNER JOIN APP_BackupSetName BKP WITH (NOLOCK) ON BKP.GUID = IB.backupSetGUID
INNER JOIN APP_Application SUB WITH (NOLOCK) on SUB.backupSet = BKP.id
INNER JOIN APP_SubClientProp SCP WITH (NOLOCK) on SCP.componentNameId = SUB.id
AND SCP.attrName = 'Cloud Mode Enabled'
	AND SCP.modified = 0
	AND SCP.attrVal = '1'
AND SCP.cs_attrName = CHECKSUM(N'Cloud Mode Enabled')
WHERE (BKP.status & 0x00008) = 0x00008
AND    (SUB.subclientStatus & 0x00008) = 0x00008
SET @outXml = (SELECT backupSetGUID AS '@guid', isDisabled AS '@status' FROM @i_backupSets FOR XML PATH ('backupset'),  ROOT('Indexing_AppGetIsArchiveIndexDisabled'))
SELECT @outXml;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIsArchiveIndexDisabled')
	delete from GxQscripts where name = 'AppGetIsArchiveIndexDisabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIsArchiveIndexDisabled')
	delete from GXDBVersions where aliasname = 'AppGetIsArchiveIndexDisabled'
GO

insert into GXDBVersions values(2, 'AppGetIsArchiveIndexDisabled',  '00000000000000000000', 'AppGetIsArchiveIndexDisabled', '00000000000000000000')
GO

