

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetInstanceProperties.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetInstanceProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetInstanceProperties <<<'
	drop procedure AppGetInstanceProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetInstanceProperties')
	delete from GxQscripts where name = 'AppGetInstanceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetInstanceProperties')
	delete from GXDBVersions where aliasname = 'AppGetInstanceProperties'
GO
print '... Creating Procedure: AppGetInstanceProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetInstanceProperties
  @xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId int
DECLARE @localeId int
DECLARE @errorCode int
DECLARE @errorString nvarchar(max)
DECLARE @errors TABLE (	instanceId INT,
								instanceName NVARCHAR(255),
								applicationId INT,
								appName NVARCHAR(255),
								clientId INT,
								clientName NVARCHAR(255),
								errorCode INT,
								errorString NVARCHAR(max))
DECLARE @r_capabilityId int
DECLARE @i_instanceList TABLE (
	clientId		int,
    clientName		nvarchar(510),
    appTypeId		int,
    appTypeName		nvarchar(255),
    instId		int,
    instanceName	nvarchar(255),
    clientGroupName nvarchar(255))
DECLARE @MSSQLInfo TABLE (	    proxyClientId INT,
								proxyClientName nvarchar(255),
     							instanceID INT,
								enableSQLTransLogStaging NVARCHAR(255),
								protectingSPDBs NVARCHAR(255),
								vDITimeOut NVARCHAR(255),
								serverType NVARCHAR(255),
								useVSS NVARCHAR(255),
								availabilityGroup XML,
								SQLAvailabilityReplicasList XML,
								azureTenantId NVARCHAR(255),
								azureClientId NVARCHAR(255),
								azureSubscriptionId NVARCHAR(255),
								azureStorageConnectionString NVARCHAR(255),
								azureAuthenticationMethod NVARCHAR(255),
								thumbprint NVARCHAR(255),
								azureUsername  NVARCHAR(255),
								azureSQLUsername  NVARCHAR(255),
								overrideHigherSettings INT,
								awsAccessKey NVARCHAR(255),
								awsSecretKey NVARCHAR(255),
								s3BucketName NVARCHAR(255),
								awsSqlInstanceUsername  NVARCHAR(255),
								overwriteAwsHigherLevelSettings INT,
								instanceStatus NVARCHAR(255),
								offloadFullBkpJobToSecondary INT
								)
DECLARE @MSSQLAccountsInfo TABLE (	instanceID INT,
								overrideGlobalAuthentication INT,
								useLocalSystemAccount	INT,
								userName NVARCHAR(255),
userPassword NVARCHAR(1024))
DECLARE @OracleInfo TABLE (	instanceID INT,
							DatabaseID NVARCHAR(255),
							OracleUserDomain NVARCHAR(255),
							OracleUserName NVARCHAR(255),
							OraclePassword NVARCHAR(255),
							OracleHome	NVARCHAR(255),
							sqlConnectUser NVARCHAR(255),
							sqlConnectPassword NVARCHAR(255),
							sqlConnectMachine NVARCHAR(255),
							useCatalogConnect INT,
							catalogConnectUser NVARCHAR(255),
							catalogConnectPassword NVARCHAR(255),
							catalogConnectMachine NVARCHAR(255),
							TNSAdminPath NVARCHAR(255),
							DisableRMANcrosscheck INT,
							CtrlFileAutoBackup INT,
							OracleBlockSize INT, --Fix me this needs to be long
							EncryptionFlag INT,
							IsOnDemand INT,
							OverrideDataPathsForCmdPolicy INT,
							OverrideDataPathsForLogPolicy INT,
							numberOfArchiveLogBackupStreams INT,
							DataBackupStoragePolicy INT,
							CommandLineStoragePolicyID  INT,
							CommandLineStoragePolicyName  NVARCHAR(255),
							LogBackupStoragePolicyID  INT,
							LogBackupStoragePolicyName  NVARCHAR(255),
							SoftwareCompression  INT,
							NetworkAgents  INT,
							ThrottleNetworkBandwidth  INT,
							Deduplication  INT,
							clientOSType INT,
							crossCheckTimeout BIGINT,
							isRMANEnableForTapeMovement INT,
							isCDBInstance	INT,
							overrideLocalSystemAccount INT,
							oracleWalletAuthentication INT,
							storageType INT,
							dbThinClientProxyList XML,
							dbName NVARCHAR(1024)
							)
DECLARE @SapHanaInfo TABLE (
							instanceID INT,
							databaseName NVARCHAR(255),
							SAPHANAUser NVARCHAR(255),
							hdbuserstorekey NVARCHAR(255),
							hdbsqlLocationDirectory NVARCHAR(255),
							libPaths NVARCHAR(25),
							cmdBackupPrefix NVARCHAR(25),
							logBackupPrefix NVARCHAR(25),
							cmdlineThresholdStreams NVARCHAR(25),
							enableCmdlineThreshold NVARCHAR(25),
							logDataThresholdStreams NVARCHAR(25),
							enableLogDataThreshold NVARCHAR(25),
							DisableRMANcrosscheck INT,
							EncryptionFlag INT,
							DataBackupStoragePolicy INT,
							CommandLineStoragePolicyID  INT,
							CommandLineStoragePolicyName  NVARCHAR(255),
							LogBackupStoragePolicyID  INT,
							LogBackupStoragePolicyName  NVARCHAR(255),
							SoftwareCompression  INT,
							NetworkAgents  INT,
							ThrottleNetworkBandwidth  INT,
							Deduplication  INT,
							clientOSType INT,
							crossCheckTimeout BIGINT,
							isRMANEnableForTapeMovement INT,
							dbInstanceNumber NVARCHAR(2),
							SAPHANADbUser NVARCHAR(255),
							SAPHANADbPassword NVARCHAR(255),
							SAPHANADbDomain NVARCHAR(255),
							isUsehdbStoreKey INT,
							containerMode INT,
							isolationLevel INT,
							hanaVersion NVARCHAR(255),
							spsVersion NVARCHAR(255),
							numberOfNodes INT,
							sslEnabled INT,
							sslProvider NVARCHAR(128),
							sslTrustStore NVARCHAR(128),
							logBackupFrequency INT
							)
DECLARE @OracleRACInfo TABLE (	useCatalogConnect INT,
							sqlConnectUser NVARCHAR(MAX),
							sqlConnectPassword NVARCHAR(MAX),
							sqlConnectMachine NVARCHAR(MAX),
							CtrlFileAutoBackup INT,
							OracleBlockSize INT,
							DisableRMANcrosscheck INT,
							DataBackupStoragePolicyID INT,
							DataBackupStoragePolicyName  NVARCHAR(255),
							LogBackupStoragePolicyID  INT,
							LogBackupStoragePolicyName  NVARCHAR(255),
							SoftwareCompression  INT,
							NetworkAgents  INT,
							ThrottleNetworkBandwidth  INT,
							generateSignature INT,
							isCDBInstance	INT,
							overrideLocalSystemAccount INT,
							oracleWalletAuthentication INT,
							storageType INT,
							EncryptionFlag INT,
							IsOnDemand INT,
							isRMANEnableForTapeMovement INT,
							dbName NVARCHAR(1024)
							)
DECLARE @OracleRACDBInfo TABLE ( oracleRACDBInstanceID INT,
							oracleInstanceID INT,
							instancePhysicalClient INT,
							clientName NVARCHAR(512),
							instanceOracleSID NVARCHAR(MAX),
							userAccount NVARCHAR(MAX),
							oracleHome NVARCHAR(MAX),
							sqlConnectUser NVARCHAR(MAX),
							sqlConnectPassword NVARCHAR(MAX),
							sqlConnectMachine NVARCHAR(MAX),
							tnsAdminFolder NVARCHAR(MAX),
							status INT
							)
DECLARE @oralceArhiveLogDest TABLE (instanceID INT,
									logDest nvarchar(max))
DECLARE @SAPOracleInfo TABLE (	instanceID INT,
							DatabaseID NVARCHAR(255),
							OracleUserDomain NVARCHAR(255),
							OracleUserName NVARCHAR(255),
							OraclePassword NVARCHAR(255),
							OracleHome	NVARCHAR(255),
							SAPDataPath NVARCHAR(255),
							SAPExeFolder  NVARCHAR(255),
							sqlConnectUser NVARCHAR(255),
							sqlConnectPassword NVARCHAR(255),
							sqlConnectMachine NVARCHAR(255),
							EncryptionFlag INT,
							IsOnDemand INT,
							OverrideDataPathsForCmdPolicy INT,
							OverrideDataPathsForLogPolicy INT,
							numberOfArchiveLogBackupStreams INT,
							OracleBlockSize INT, --Fix me this needs to be long
							UseSAPSecureStore INT,
							DataBackupStoragePolicy INT,
							CommandLineStoragePolicyID  INT,
							CommandLineStoragePolicyName  NVARCHAR(255),
							LogBackupStoragePolicyID  INT,
							LogBackupStoragePolicyName  NVARCHAR(255),
							SoftwareCompression  INT,
							NetworkAgents  INT,
							ThrottleNetworkBandwidth  INT,
							Deduplication  INT,
							clientOSType INT
							)
DECLARE @SAPMAXDBInfo TABLE (	instanceID INT,
							EncryptionFlag INT,
							OverrideDataPathsForCmdPolicy INT,
							OverrideDataPathsForLogPolicy INT,
							numberOfArchiveLogBackupStreams INT,
							DataBackupStoragePolicy INT,
							CommandLineStoragePolicyID  INT,
							CommandLineStoragePolicyName  NVARCHAR(255),
							LogBackupStoragePolicyID  INT,
							LogBackupStoragePolicyName  NVARCHAR(255),
							SoftwareCompression  INT,
							NetworkAgents  INT,
							ThrottleNetworkBandwidth  INT,
							Deduplication  INT,
							clientOSType INT,
							osUser NVARCHAR(1024),
							dbUser NVARCHAR(1024),
							binDir NVARCHAR(1024),
							dbmcliPath NVARCHAR(1024)
							)
DECLARE @VMWareInfo TABLE (	instanceID INT,
								VSInstanceType INT,
								esxServerToMount NVARCHAR(255),
								vmMemberServers XML)
DECLARE @ServerInfo TABLE (	instanceID INT,
								ServerHostName NVARCHAR(255),
								userName NVARCHAR(MAX),
								userPassword NVARCHAR(255))
DECLARE @ESXServerInfo TABLE (	instanceID INT,
								ServerHostName NVARCHAR(255),
								userName NVARCHAR(255),
								userPassword NVARCHAR(255))
DECLARE @XenServerInfo TABLE (	instanceID INT,
								ServerHostName NVARCHAR(255),
								userName NVARCHAR(255),
								userPassword NVARCHAR(255))
DECLARE @AmazonInstanceInfo TABLE (	instanceID INT,
									accessKey NVARCHAR(255),
									useIamRole NVARCHAR(255),
									enableAdminAccount NVARCHAR(255),
									adminInstanceID NVARCHAR(255))
DECLARE @VcloudInstanceInfo TABLE ( instanceID INT,
								   vOrgName NVARCHAR(255),
								   vOrgGuid NVARCHAR(1024))
DECLARE @DB2Info TABLE (	instanceID INT,
								homeDirectory NVARCHAR(255),
								ServerHostName NVARCHAR(255),
								userName NVARCHAR(255),
								userPassword NVARCHAR(255),
								DataBackupStoragePolicyID INT,
								DataBackupStoragePolicyName NVARCHAR(255),
								CommandLineStoragePolicyID  INT,
								CommandLineStoragePolicyName  NVARCHAR(255),
								LogBackupStoragePolicyID  INT,
								LogBackupStoragePolicyName  NVARCHAR(255),
								SoftwareCompression  INT,
								NetworkAgents  INT,
								ThrottleNetworkBandwidth  INT,
								Deduplication  INT,
								encryptionFlag	INT)
DECLARE @DB2Nodes TABLE (	instanceID INT,
							nodeNum	INT,
							clientId INT)
DECLARE @InformixInfo TABLE (	instanceID INT,
								homeDirectory NVARCHAR(255),
								domainName NVARCHAR(255),
								userName NVARCHAR(255),
								userPassword NVARCHAR(255),
								onConfigFile NVARCHAR(255),
								CommandLineStoragePolicyID  INT,
								CommandLineStoragePolicyName  NVARCHAR(255),
								LogBackupStoragePolicyID  INT,
								LogBackupStoragePolicyName  NVARCHAR(255),
								SoftwareCompression  INT,
								NetworkAgents  INT,
								ThrottleNetworkBandwidth  INT,
								Deduplication  INT,
								sqlHostfile nvarchar(500)
								)
DECLARE @SybaseInfo TABLE (	instanceID INT,
								BackupServer NVARCHAR(255),
								SybaseHome NVARCHAR(255),
								SybaseASE NVARCHAR(255),
								SybaseOCS NVARCHAR(255),
								ConfigFile NVARCHAR(255),
								SharedMemoryDir NVARCHAR(255),
								EnableAutoDiscovery INT,
								userName NVARCHAR(255),
								saUserName NVARCHAR(255),
								SybaseBlockSize INT)
DECLARE @MySQLInstanceInfo TABLE ( instanceID INT,
								BinaryDirectory NVARCHAR(255),
								LogDataDirectory NVARCHAR(255),
								ConfigFile NVARCHAR(255),
								port NVARCHAR(255),
								EnableAutoDiscovery	INT,
								SAUserName NVARCHAR(255),
								SAUserPassword NVARCHAR(255),
								logStoragePolicyId	INT,
								logStoragePolicyName NVARCHAR(255),
								commandLineStoragePolicyId	INT,
								commandLineStoragePolicyName NVARCHAR(255),
								NTUserName NVARCHAR(255),
								NTUserPwd NVARCHAR(255),
								archiveLogIndexFile NVARCHAR(255),
								unixUserName NVARCHAR(255),
								version NVARCHAR(255),
								dataDirectory NVARCHAR(MAX),
								lastLogNumber INT,
								isProxyEnabled INT,
								proxyInstanceId INT,
								isUseSSL INT,
								runBackupOnProxy INT,
								isXtraBackupEnabled INT,
								xtraBackupBinPath NVARCHAR(255),
								sslCaPath NVARCHAR(255),
								sslCert NVARCHAR(255),
								sslKey NVARCHAR(255),
								enableMEB INT,
								mebBinPath NVARCHAR(255),
								EnableNoLocking INT
								)
DECLARE @PostgreSQLInstanceInfo TABLE ( instanceID INT,
								MaintainenceDB NVARCHAR(255),
								BinaryDirectory NVARCHAR(255),
								LibDirectory NVARCHAR(255),
								ArchiveLogDirectory NVARCHAR(255),
								port NVARCHAR(255),
								SAUserName NVARCHAR(255),
								SAUserPassword NVARCHAR(255),
								ArchiveDelete	INT,
								logStoragePolicyId	INT,
								logStoragePolicyName NVARCHAR(255),
								version NVARCHAR(255),
								UNCUserName NVARCHAR(255),
								isStandBy	INT,
								standByEnabled	INT,
								standbyInstanceId	INT,
								useMasterForDataBkp INT,
								useMasterForLogBkp	INT,
								lastLogNumber NVARCHAR(1024))
DECLARE @InstanceInfo TABLE (	instanceID INT,
								instanceName NVARCHAR(255),
								appID INT,
								appName NVARCHAR(255),
								clientID INT,
								clientName NVARCHAR(255),
								instanceVersion NVARCHAR(255),
								instanceDescription NVARCHAR(MAX),
								errorCode INT, --added
								errorString NVARCHAR(max),
								guid uniqueidentifier,
								isDeleted int,
								clientAppType int NULL DEFAULT NULL,
								clientDisplayName NVARCHAR(255))
DECLARE @AdminInstanceInfo TABLE ( instanceID INT,
								   adminInstanceID NVARCHAR(255),
								   enableAdminAccount NVARCHAR(255))
DECLARE @PlanInfo TABLE			( instanceID INT,
								    planId                  INT NULL,
									planType                INT NULL,
									planSubType             INT NULL,
									planName                NVARCHAR(1024) NULL)
DECLARE @DistributedInstanceInfo TABLE (instanceID INT,
										instanceProps XML)
DECLARE @CloudAppsInstanceInfo TABLE (instanceID INT,
										instanceProps XML)
DECLARE @logAppToDataPath TABLE(InstanceID INT,
	dataType INT,
	dataPathId INT,
	precedence INT,
	flags INT,
	backupType INT)
DECLARE @cmdlineAppToDataPath TABLE(InstanceID INT,
	dataType INT,
	dataPathId INT,
	precedence INT,
	flags INT,
	backupType INT)
DECLARE @DBInstances Table
(  instanceId INT,
	clientId INT,
   clientName nvarchar(max))
DECLARE @IndexServerInfo TABLE (
	instanceId INT,
	backupSetId INT,
	indexServer XML,
	indexMAs 	XML,
	indexBkpSp 	XML,
	indexBkpEligibleSPs XML,
	indexPruning INT DEFAULT 0,
	retDays INT DEFAULT -1,
	retCycles INT DEFAULT -1,
	pruningType INT DEFAULT 0
)
   	IF OBJECT_ID('tempdb.dbo.#tempInstanceProperties') is not null DROP TABLE #tempInstanceProperties
   CREATE TABLE #tempInstanceProperties
(
	attrName NVARCHAR(1024) NOT NULL,
	attrVal	NVARCHAR(MAX) NOT NULL,
	created int
)
DECLARE @userGroups TABLE (	instanceID INT,	security XML, securityNew XML)
DECLARE @idoc int
DECLARE @InstanceCursor CURSOR
DECLARE @instId INT
DECLARE @appTypeID INT
DECLARE @clientID INT
DECLARE @instName NVARCHAR(MAX)
DECLARE @appName NVARCHAR(MAX)
DECLARE @clientName NVARCHAR(MAX)
DECLARE @overrideGlobalAuthentication INT
DECLARE @Index INT
DECLARE @InstanceXML XML
DECLARE @FilterOptionXML XML
DECLARE @propertyLevel INT
DECLARE @InstanceXMLWithId XML
DECLARE @tempString nvarchar(max)
DECLARE @backupSetId INT
DECLARE @vmMemberServers XML
DECLARE @vmMemberServersStr NVARCHAR(MAX)
DECLARE @distributedAgentProp XML
DECLARE @cloudAppsInstanceProp XML
DECLARE @overRideAccessNode INT = 0
DECLARE @dbVmMemberServers XML
DECLARE @dbVmMemberServersStr NVARCHAR(MAX)
DECLARE @ActivityControl TABLE (
								instanceID int,
								instanceActivityControl XML
								)
DECLARE @instanceActivityControl XML
 SET @r_capabilityId = ISNULL((SELECT  ref.value('@capabilityFlags', 'int') AS Agent
                              FROM    @xmlText.nodes('App_GetInstancePropertiesRequest/filterOptions') R ( ref )),0)
     if @r_capabilityId=6
     begin
     	set @r_capabilityId = 2
     end
			SET @Index = 1
			SET @InstanceXML = @xmlText.query('(//instance)[sql:variable("@Index")]')
			SET @FilterOptionXML = @xmlText.query('(//filterOptions)[sql:variable("@Index")]')
			IF 1 = (@InstanceXML.exist('(//./instance/@instanceId)[1]'))
			BEGIN
				SET @instId = @InstanceXML.value('(//./instance/@instanceId)[1]','INT')
				SET @instName = (SELECT name from APP_InstanceName where id = @instId)
			END
			IF 1 = (@FilterOptionXML.exist('(//./filterOptions/@propertyLevel)[1]'))
			BEGIN
				SET @propertyLevel = @FilterOptionXML.value('(//./filterOptions/@propertyLevel)[1]','INT')
			END
			SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
			FROM    @xmlText.nodes('App_GetInstancePropertiesRequest/processinginstructioninfo/user') R ( ref )),0)
			SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
			FROM    @xmlText.nodes('App_GetInstancePropertiesRequest/processinginstructioninfo/locale') R ( ref )),0)
	EXEC sp_xml_preparedocument @idoc OUTPUT, @xmlText
	INSERT  INTO @i_instanceList
    SELECT *
    FROM OPENXML(@idoc, '//App_GetInstancePropertiesRequest/association/entity', 0)
    WITH
    (
     	clientId		int				'@clientId',
     	clientName		nvarchar(510)	'@clientName',
     	appTypeId		int				'@applicationId',
     	appTypeName		varchar(255)	'@appName',
     	instanceId		int				'@instanceId',
     	instanceName	varchar(255)	'@instanceName',
     	clientGroupName varchar(255)   '@clientGroupName'
     )
	exec sp_xml_removedocument @idoc
 IF 1 = @xmlText.exist('//App_GetInstancePropertiesRequest/association/entity')
				BEGIN
						-- first send a request to GetAssociatedEntities
DECLARE @associatedEntitiesRequest xml
DECLARE @associatedEntitiesResponse xml
SELECT @associatedEntitiesRequest =ISNULL(@xmlText.query('App_GetInstancePropertiesRequest/association/entity'),'')
--if @associatedEntitiesRequest='<entity _type_="6" applicationId="16" clientId="3" instanceId="16"/>'
--begin
	--set @associatedEntitiesRequest='<entity _type_="6" applicationId="37" clientId="3" instanceId="16"/>'
--end
DECLARE @clusterType INT
DECLARE @associatedEntitiesFilter XML
SET @associatedEntitiesFilter = '<filter val="16"/>'
SELECT @associatedEntitiesRequest =CAST(( CAST(@associatedEntitiesRequest as nvarchar(max)) + CAST(@associatedEntitiesFilter as nvarchar(max)) ) as xml)
DECLARE @processinginstructioninfoXML XML
SET @processinginstructioninfoXML = (SELECT @userId '@userId' FOR XML PATH('user'), ROOT('processinginstructioninfo'))
SET @associatedEntitiesRequest = ( select 5 '@expandLevel', @associatedEntitiesRequest, @processinginstructioninfoXML
FOR xml path('App_GetAssociatedEntities'))
DECLARE @associatedEntitiesTable table
(
	xmlval xml
)
--select @associatedEntitiesRequest
INSERT INTO @associatedEntitiesTable
exec dbo.GetAssociatedEntities @associatedEntitiesRequest
set @associatedEntitiesResponse = ISNULL((select top 1 xmlval from @associatedEntitiesTable),'<App_GenericResponse/>')
EXEC sp_xml_preparedocument @idoc OUTPUT, @associatedEntitiesResponse
INSERT  INTO @InstanceInfo
SELECT *
FROM OPENXML(@idoc, '//App_GenericResponse/response', 0)
WITH
(
	instanceID		int				'entity/@instanceId',
	instanceName	varchar(255)	'entity/@instanceName',
	appID		int				'entity/@applicationId',
	appName		varchar(255)	'entity/@appName',
	clientId		int				'entity/@clientId',
	clientName		nvarchar(255)	'entity/@clientName',
	instanceVersion nvarchar(255) '@instanceVersion',
	instanceDescription nvarchar(MAX) '@instanceDescription',
	errorCode		int		'@errorCode',
	errorString		nvarchar(MAX)	'@errorString',
	guid nvarchar(40) 'entity/@instanceGUID',
	isDeleted int '@isDeleted',
	clientAppType int '@clientAppType',
	clientDisplayName nvarchar(255) 'entity/@displayName'
)
exec sp_xml_removedocument @idoc
END
			ELSE
				BEGIN
					INSERT INTO @InstanceInfo(instanceID) VALUES (@instId)
				END
update @InstanceInfo
set errorCode = 0
where errorCode is null
update @InstanceInfo
set errorString = ''
where errorString is null
				update @InstanceInfo
				set clientName = c.name,
				clientDisplayName = c.displayName
				from APP_Client c
				join @InstanceInfo inputList --MODIFIED
				on inputList.clientId = c.id
				where instanceId = inputList.instanceID
				-- Now update appType name.
				 update @InstanceInfo
				 set appName = app.displayName
				 from APP_iDAType app
				 join @InstanceInfo inputList
				 on inputList.appID = app.type
				 where instanceID = inputList.instanceID
				 -- Now update instance Name
				 update @InstanceInfo
				set instanceName = app.name,
isDeleted = CASE (app.status & 0x00002) WHEN 0 THEN 0 ELSE 1 END ,
				guid = app.guid
				from APP_InstanceName app
				join @InstanceInfo inputList
				on inputList.instanceID = app.id
				where instanceID = inputList.instanceID
				-- Update ClientAppType Flag --
				update @InstanceInfo
				set clientAppType = clientProp.attrVal
				from APP_ClientProp clientProp
				join @InstanceInfo inputList --MODIFIED
				on clientProp.componentNameId = inputList.clientID
				where attrName = 'Client App Type' AND modified = 0
DECLARE @instanceCur CURSOR
SET @instanceCur = CURSOR
FOR	(SELECT instanceID,instanceName ,appName , clientID, clientName,errorCode,errorString FROM @InstanceInfo)
	OPEN @instanceCur
		FETCH NEXT FROM @instanceCur INTO @instId, @instName,@appName, @clientID, @clientName,@errorCode,@errorString
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @appTypeID = (SELECT TOP 1 apptypeid from   APP_Application where APP_Application.instance = @instId)
			declare @associationEntity xml
		 	set @associationEntity = (select
    										@appName as '@appName',
											@appTypeID as '@applicationId',
											@clientID as '@clientId',
											@clientName as '@clientName',
											@instId as '@instanceId',
											dbo.encodeInvalidXMLChar(@instName) as '@instanceName'
										FOR xml path('entity'))
			IF ( (len(@errorString)>0) Or @errorCode>0)
			BEGIN
				-- Error instance lookup failed from GetAssociatedEntities. So log it in output xml and proceed to next entry
				INSERT INTO @errors
				VALUES (@instId,@instName,@appTypeID,@appName,@clientID,@clientName, @errorCode, @errorString)
				DELETE FROM @InstanceInfo WHERE instanceID = @instId
		GOTO CONTINUE_NEXT_INSTANCE
			END
			DECLARE @securityCheckError nvarchar(max)
			SET @securityCheckError = ''
			--exec [dbo].[Sec_DoesUserHaveRightsOnEntity] @associationEntity,@userId,@r_capabilityId,0,@localeId,@securityCheckError OUTPUT
			--if (len(@securityCheckError)>0)
			DECLARE @SecurityTbl TABLE (userId INT, nodeCapability BIGINT, childCapability BIGINT)
			DELETE @SecurityTbl
INSERT INTO @SecurityTbl EXEC	dbo.sec_iDaNodeAccess @userId, 2, @clientID, @appTypeId, @instId, 0, 0
			IF @userId != (select TOP 1 userId FROM @SecurityTbl)
			BEGIN
     		-- Error instance lookup failed
     			SET @securityCheckError = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
				SET @securityCheckError = REPLACE(@securityCheckError, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @userId))
				SET @securityCheckError = REPLACE(@securityCheckError, '^2%s', dbo.fn_EvFormatEventMsgText(0,@localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 31), 0,2))
				SET @securityCheckError = REPLACE(@securityCheckError, '^3%s', 'Instance')
	     		SET @errorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				INSERT into @errors
				VALUES (@instId,@instName,@appTypeID,@appName,@clientID,@clientName, @errorCode, @securityCheckError
			)
		DELETE FROM @InstanceInfo WHERE instanceID = @instId
     			GOTO CONTINUE_NEXT_INSTANCE
     		END
			--Gather generic propeties
			INSERT INTO #tempInstanceProperties
			SELECT DISTINCT a.attrName, a.attrVal, a.created FROM APP_InstanceProp a
			INNER JOIN (
				SELECT attrName, MAX(id) AS id FROM APP_InstanceProp WHERE componentNameId = @instId AND modified = 0
				GROUP BY attrName
			) b ON a.attrName = b.attrName AND a.id = b.id
			WHERE a.componentNameId = @instId
			IF @propertyLevel >= 10
			BEGIN
				UPDATE @InstanceInfo
				SET instanceDescription = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'User Description'),'')
				WHERE instanceID = @instId
			END
				IF @propertyLevel >= 20
				BEGIN
					DECLARE @InstanceSecurity XML
					DECLARE @InstanceSecuritynew XML
					SET @InstanceSecurity = '<entity clientId="' + STR(@clientId) + '" appTypeId="' + STR(@appTypeId) + '"' + ' instanceId="' +  STR(@instId) + '"/>'
					EXEC [dbo].[APPGetEntitySecurityXML]
					@xmlText = @InstanceSecurity OUTPUT
					EXEC sec_getSecurityForEntity @userId, @InstanceSecuritynew OUTPUT, 3, @clientId, 4, @appTypeId, 5, @instId
					INSERT INTO @userGroups VALUES (@instId, @InstanceSecurity, @InstanceSecuritynew)
				END
				--Gather Cloud DB Instance properties
				IF @propertyLevel >= 20
				BEGIN
					SET @dbVmMemberServersStr = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Vs Member Servers')
					SET @dbVmMemberServers = @dbVmMemberServersStr
				END
			--Add index server information for database type apps
			IF @appTypeId IN (
81,
125,
104,
22,
61,
79,
3,
37,
62,
103,
128,
5
				) AND @propertyLevel >= 10
			BEGIN
				INSERT INTO @IndexServerInfo(instanceId, backupSetId, indexServer, indexMAs, indexBkpSp, indexBkpEligibleSPs, indexPruning, retDays, retCycles, pruningType)
					SELECT TOP 1 @instId, entityId, curIdxServer, indexMAs, indexBkpSp, indexBkpEligibleSPs, indexPruning, retDays, retCycles, pruningType
					FROM dbo.GetIndexServerOptions (@clientId, @instId, @appTypeId, 0, 0, 0, @propertyLevel)
			END -- End index server info
			--Gather MSSQL properties
IF @appTypeID = 81
			BEGIN
				INSERT INTO @MSSQLInfo(instanceID) VALUES (@instId)
				IF @propertyLevel >= 10
				BEGIN
					UPDATE @InstanceInfo
					SET instanceVersion = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL Version'),'')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 10
				BEGIN
					UPDATE @MSSQLInfo
					SET serverType = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL Server Type'),'')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET vDITimeOut = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL VDI Timeout'), '')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 10
				BEGIN
					UPDATE @MSSQLInfo
					SET useVSS = NULLIF(NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL USE VSS'),''),0)
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET enableSQLTransLogStaging = NULLIF(NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL Enable TL Staging'),''),0)
					WHERE instanceID = @instId
					UPDATE @MSSQLInfo
					SET protectingSPDBs = NULLIF(NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL PROTECTING SPDBS'),''),0)
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					SET @tempString = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Availability Group'),'')
					UPDATE @MSSQLInfo
					SET availabilityGroup = CAST(@tempString  as XML)
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					SET @tempString =NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Availability Replicas'),'')
					UPDATE @MSSQLInfo
					SET SQLAvailabilityReplicasList = CAST(@tempString  as xml)
					WHERE instanceID = @instId
					DECLARE @offloadFullBkpJobToSecondary INT = 0
					IF @tempString <> ''
					BEGIN
						-- Use replica info to fetch SP version to populate offloadFullBkpJobToSecondary property
						-- This property is only applicable for AG client's with all replica client >= 11.0 and SP >= 21
						DECLARE @tempXml XML = @tempString
						IF OBJECT_ID('tempdb.dbo.#tempReplicaClient') IS NOT NULL
							DROP TABLE #tempReplicaClient
						CREATE TABLE #tempReplicaClient([clientId] INT, [PM] BIT)
						INSERT INTO #tempReplicaClient ([clientId], [PM])
						SELECT Tbl.Col.value('@clientId', 'INT'), 1
						FROM @tempXml.nodes('App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList/replicaClient') Tbl(Col)
						UPDATE TRC
						SET TRC.PM = 0
						FROM #tempReplicaClient TRC
						JOIN APP_VMToPMMap AVMTOPM on AVMTOPM.VMClientId = TRC.clientId
						INSERT INTO #tempReplicaClient ([clientId], [PM])
						SELECT AVMTOPM.PMClientId, 1
						FROM APP_VMToPMMap AVMTOPM
						JOIN #tempReplicaClient TRC ON TRC.clientId = AVMTOPM.VMClientId
						DECLARE @physicalClientCount INT = (SELECT COUNT(clientId) FROM #tempReplicaClient WHERE PM = 1)
						DECLARE @replicaClientCountWithReqSP INT = 0
						SELECT @replicaClientCountWithReqSP = COUNT(AC.id)
						FROM #tempReplicaClient TRC
						JOIN App_Client AC ON AC.id = TRC.clientId
						JOIN simInstalledPackages SIP ON SIP.ClientId = AC.id
						WHERE (AC.releaseId > 16 OR (AC.releaseId = 16 AND SIP.HighestSP >= 21)) AND SIP.SimPackageID in (353, 1212)
						IF @physicalClientCount = @replicaClientCountWithReqSP
						BEGIN
							SELECT @offloadFullBkpJobToSecondary = CAST(attrVal AS INT) from APP_InstanceProp WHERE componentNameId = @instId AND attrName = N'offloadFullBkpJobToSecondary' and modified = 0
							IF @offloadFullBkpJobToSecondary = 0
								SET @offloadFullBkpJobToSecondary = 1
						END
						DROP TABLE #tempReplicaClient
					END
					UPDATE @MSSQLInfo
						SET offloadFullBkpJobToSecondary = @offloadFullBkpJobToSecondary
						WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET proxyClientId = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Proxy Client Id'),'')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET proxyClientName = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Proxy Client Name'),'')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET azureTenantId = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Tenant Id'), '')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET azureClientId = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Client Id'), '')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET azureSubscriptionId = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Subscription Id'), '')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET azureStorageConnectionString = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Storage Connection String'), '')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET azureAuthenticationMethod = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Authentication Method'), '')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET thumbprint = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Certificate Thumbprint'), '')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET azureUsername = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Username'), '')
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					DECLARE @azureSQLUsername NVARCHAR(MAX)
					SET @azureSQLUsername = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure SQL Instance Username'), '')
					IF (@azureSQLUsername = N'') -- If SQL Authentication Credentials are missing, get it from AD Authentication
					BEGIN
						SET @azureSQLUsername = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL username'), '')
					END
					UPDATE @MSSQLInfo
					SET azureSQLUsername = @azureSQLUsername
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET overrideHigherSettings = NULLIF(NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Override Higher Level Settings'),''),0)
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET awsAccessKey = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Aws Access Key'), '')
					WHERE instanceID = @instId
					UPDATE @MSSQLInfo
					SET awsSecretKey = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Aws Secret Key'), '')
					WHERE instanceID = @instId
					UPDATE @MSSQLInfo
					SET s3BucketName = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'S3 Bucket Name'), '')
					WHERE instanceID = @instId
					UPDATE @MSSQLInfo
					SET awsSqlInstanceUsername = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Aws SQL Instance Username'), '')
					WHERE instanceID = @instId
					UPDATE @MSSQLInfo
					SET overwriteAwsHigherLevelSettings = NULLIF(NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Aws Overwrite Higher Level Settings'),''),0)
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					UPDATE @MSSQLInfo
					SET instanceStatus = NULLIF(NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Instance Status'),''),0)
					WHERE instanceID = @instId
				END
				IF @propertyLevel >= 20
				BEGIN
					SET @overrideGlobalAuthentication = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL Override Global Authentication')
					IF @overrideGlobalAuthentication >= 1
					BEGIN
						INSERT INTO @MSSQLAccountsInfo(instanceID) VALUES (@instId)
						IF @propertyLevel >= 20
						BEGIN
							UPDATE @MSSQLAccountsInfo
							SET overrideGlobalAuthentication = @overrideGlobalAuthentication
							WHERE instanceID = @instId
						END
						IF @propertyLevel >= 20
						BEGIN
							UPDATE @MSSQLAccountsInfo
							SET useLocalSystemAccount = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL Use Windows Authentication'),'')
							WHERE instanceID = @instId
						END
					--	IF (SELECT useLocalSystemAccount FROM @MSSQLAccountsInfo WHERE instanceID = @instId) = 0 or Exists (SELECT * FROM @MSSQLAccountsInfo WHERE instanceID = @instId and useLocalSystemAccount is null)
					--	BEGIN
							IF @propertyLevel >= 20
							BEGIN
								UPDATE @MSSQLAccountsInfo
								SET userName = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MSSQL username'),'')
								WHERE instanceID = @instId
							END
							IF @propertyLevel >= 20
							BEGIN
								UPDATE @MSSQLAccountsInfo
								SET userPassword = NULLIF((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WHERE attrName = 'MSSQL password'),'')
								WHERE instanceID = @instId
							END
					--	END
					END
				END
			END
			-- Fetch Plan Properties
			BEGIN
				INSERT INTO @PlanInfo
			    SELECT @instId, AP.id, AP.type, AP.subType, AP.name FROM #tempInstanceProperties TIP
				INNER JOIN App_Plan AP WITH(NOLOCK)
ON CAST(AP.id AS NVARCHAR(32))=TIP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE TIP.attrName = 'Associated Plan'
			END
			--Till here
			--Gather Oracle properties
IF (@appTypeID = 22)
			BEGIN
				INSERT INTO @OracleInfo(instanceID) VALUES (@instId)
				UPDATE @InstanceInfo
				SET instanceVersion = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle Version' ),'')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET DatabaseID = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle DB id' ),'')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET OracleUserDomain = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Domain Name' ),'')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET OracleUserName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle User' ),'')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET OracleHome = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle Home' ),'')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET sqlConnectUser = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SQL Connect' ),'')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET sqlConnectPassword = ISNULL((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WHERE attrName = 'SQL Connect Password' ),'')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET sqlConnectMachine = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SQL Connect Machine' ),'')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET useCatalogConnect = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'use Catalog Connect' ),'1')
				WHERE instanceID = @instId
				IF (SELECT useCatalogConnect FROM @OracleInfo WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @OracleInfo
					SET catalogConnectUser = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Catalog Connect' ),'')
					WHERE instanceID = @instId
					UPDATE @OracleInfo
					SET catalogConnectPassword = ISNULL((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WHERE attrName = 'Catalog Connect Password' ),'')
					WHERE instanceID = @instId
					UPDATE @OracleInfo
					SET catalogConnectMachine = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Catalog Connect Machine' ),'')
					WHERE instanceID = @instId
				END
				UPDATE @OracleInfo
				SET TNSAdminPath = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'TNS admin path' ),'')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET DisableRMANcrosscheck = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle RMAN Cross Check' ), 0)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET crossCheckTimeout= ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle CrossCheck Timeout' ), 600)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET CtrlFileAutoBackup = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Auto Backup Control File' ), 0)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET OracleBlockSize = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle block size' ), 262144)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET EncryptionFlag = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Encrypt: encryption' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET IsOnDemand = ISNULL((SELECT CASE (ISNULL(status,0) & 0x0800) WHEN 0x0800  THEN  1 ELSE 0 END from APP_InstanceName WHERE id =@instId),0)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET CommandLineStoragePolicyID = ISNULL((SELECT dataArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040), 1)
				WHERE instanceID = @instId
				--Get properties flags
				UPDATE @OracleInfo
				SET OverrideDataPathsForCmdPolicy = ISNULL((SELECT attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus & 0x0040 > 0 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Full Failover to SP dataPaths' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET OverrideDataPathsForLogPolicy = ISNULL((SELECT attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus & 0x00008 > 0 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Full Failover to SP dataPaths' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				--numberOfArchiveLogBackupStreams
				UPDATE @OracleInfo
				SET numberOfArchiveLogBackupStreams = ISNULL((SELECT attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Oracle Log backup streams' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				IF (SELECT CommandLineStoragePolicyID FROM @OracleInfo WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @OracleInfo
					SET CommandLineStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT CommandLineStoragePolicyID FROM @OracleInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @OracleInfo
				SET LogBackupStoragePolicyID = ISNULL((SELECT logArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040), 1)
				WHERE instanceID = @instId
				IF (SELECT LogBackupStoragePolicyID FROM @OracleInfo WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @OracleInfo
					SET LogBackupStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT LogBackupStoragePolicyID FROM @OracleInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @OracleInfo
				SET SoftwareCompression = isnull((SELECT compressWhere FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id),'2')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET NetworkAgents = ISNULL((SELECT NumNWAgents FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id), 0)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET ThrottleNetworkBandwidth = ISNULL((SELECT NWWriteSpeed FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id), 0)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET Deduplication = ISNULL((SELECT attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Single Instancing Option' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET clientOSType = ISNULL((SELECT simOperatingSystemId FROM APP_Client where id = @clientID),0)
				WHERE instanceID = @instId
				--isRMANEnableForTapeMovement
				UPDATE @OracleInfo
				SET isRMANEnableForTapeMovement = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Use RMAN for Tape Movement' ),0)
				WHERE instanceID = @instId
				--isCDBInstance
				UPDATE @OracleInfo
				SET isCDBInstance = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle CDB Instance' ), 0)
				WHERE instanceID = @instId
				--isLocalSyemOverride
				UPDATE @OracleInfo
				SET overrideLocalSystemAccount = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle User Impersonation Enabled' ), 1)
				WHERE instanceID = @instId
				-- wallet
				UPDATE @OracleInfo
				SET oracleWalletAuthentication = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle Wallet authentication' ), 0)
				WHERE instanceID = @instId
				-- storageType
				UPDATE @OracleInfo
				SET storageType = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle Storage Type' ), 0)
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET dbThinClientProxyList = ISNULL((SELECT attrVal from #tempInstanceProperties WHERE attrName = 'DB Thin Client Proxy Client List'), '')
				WHERE instanceID = @instId
				UPDATE @OracleInfo
				SET dbName = ISNULL((SELECT attrVal from #tempInstanceProperties WHERE attrName = 'Oracle DB Name'), '')
				WHERE instanceID = @instId
				--log dest
				DECLARE @maxFlag INT
				DECLARE @attrVal nvarchar(max) = ''
				SET @maxFlag = 1
				WHILE @maxFlag < 10 --CV_ORACLE_ARCH_DEST_MAX
				BEGIN
					set @attrVal = ''
					SELECT @attrVal = attrVal from #tempInstanceProperties where attrName = 'Archive dest'+ cast(@maxFlag as nvarchar(5))
					IF UPPER(@attrVal) = 'USE_DB_RECOVERY_FILE_DEST'
					BEGIN
						SELECT @attrVal = ISNULL((SELECT attrVal from #tempInstanceProperties WHERE attrName = 'Oracle FRA Location'), '')
					END
					IF(@attrVal != '')
					BEGIN
						INSERT INTO @oralceArhiveLogDest values (@instId, @attrval)
					END
					set @maxFlag = @maxFlag + 1
				END
				--datapath
				INSERT INTO @logAppToDataPath
				SELECT DISTINCT @instId,dataType,dataPathId, precedence,flags,backupType FROM APP_AppToDataPath where componentNameId IN (SELECT id FROM APP_Application WHERE instance = @instId  and subclientStatus & 0x0004 = 0) and dataType=4
				INSERT INTO @cmdlineAppToDataPath
				SELECT DISTINCT @instId,dataType,dataPathId, precedence,flags,backupType FROM APP_AppToDataPath where componentNameId IN (SELECT id FROM APP_Application WHERE instance = @instId  and subclientStatus & 0x0004 = 0 and subclientStatus & 0x0040 = 0x0040) and dataType=1
			END
			--Gather Oracle RAC properties
IF (@appTypeID = 80)
			BEGIN
				UPDATE @InstanceInfo
				SET instanceVersion = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle Version' ),'')
				INSERT INTO @OracleRACInfo (useCatalogConnect, sqlConnectUser, sqlConnectPassword, sqlConnectMachine, CtrlFileAutoBackup, OracleBlockSize, DisableRMANcrosscheck, DataBackupStoragePolicyID,
							LogBackupStoragePolicyID, SoftwareCompression, NetworkAgents, ThrottleNetworkBandwidth, generateSignature, isCDBInstance, overrideLocalSystemAccount, oracleWalletAuthentication,
							storageType, EncryptionFlag, IsOnDemand, isRMANEnableForTapeMovement, dbName)
				VALUES (
						ISNULL((SELECT attrVal FROM #tempInstanceProperties  WITH (NOLOCK) WHERE attrName = 'use Catalog Connect' ),'1'),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Catalog Connect' ), ''),
						ISNULL((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Catalog Connect Password' ),''),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Catalog Connect Machine' ),''),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Auto Backup Control File' ), 0),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle block size' ), 262144),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK)WHERE attrName = 'Oracle RMAN Cross Check' ), 0),
						(SELECT dataArchGrpID FROM APP_Application WITH (NOLOCK) WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040),
						(SELECT logArchGrpID FROM APP_Application WITH (NOLOCK) WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040),
						(SELECT compressWhere FROM archPipeConfig WITH (NOLOCK), APP_Application WITH (NOLOCK) WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id),
						(SELECT NumNWAgents FROM archPipeConfig WITH (NOLOCK), APP_Application WITH (NOLOCK) WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id),
						(SELECT NWWriteSpeed FROM archPipeConfig WITH (NOLOCK), APP_Application WITH (NOLOCK) WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id),
						(SELECT attrVal FROM APP_SubClientProp WITH (NOLOCK),  APP_Application WITH (NOLOCK) WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_Application.id = APP_SubClientProp.componentNameId AND APP_SubClientProp.attrName = 'Single Instancing Option' AND APP_SubClientProp.modified = 0),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle CDB Instance' ), 0),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle User Impersonation Enabled' ), 1),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle Wallet authentication' ), 0),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle Storage Type' ), 0),
						ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Encrypt: encryption' AND APP_SubClientProp.modified = 0), 0),
						ISNULL((SELECT CASE (ISNULL(status,0) & 0x0800) WHEN 0x0800  THEN  1 ELSE 0 END from APP_InstanceName WHERE id =@instId),0),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK)WHERE attrName = 'Use RMAN for Tape Movement'), 0),
						ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK)WHERE attrName = 'Oracle DB Name'), 0)
				)
				UPDATE	O
				SET		O.DataBackupStoragePolicyName = AG.name
				FROM	@OracleRACInfo O, archGroup AG
				WHERE	O.DataBackupStoragePolicyId = AG.id
				UPDATE	O
				SET		O.LogBackupStoragePolicyName = AG.name
				FROM	@OracleRACInfo O, archGroup AG
				WHERE	O.LogBackupStoragePolicyID = AG.id
				INSERT	INTO @OracleRACDBInfo (oracleRACDBInstanceID, oracleInstanceID, instancePhysicalClient, clientName, instanceOracleSID, userAccount, oracleHome, sqlConnectUser, sqlConnectPassword, sqlConnectMachine, tnsAdminFolder, status)
				SELECT	I.id, I.instaceId, I.clientId, C.name, I.name, I.oracleUser, I.oracleHome, I.InstanceOraUser, I.InstanceOraPasswd, I.InstanceOraService, I.tnsAdmin, I.status
				FROM	APP_OracleRacInstance I WITH (NOLOCK)
					INNER JOIN APP_Client C WITH (NOLOCK)
						ON I.clientId = C.id
				WHERE	I.instaceId = @instId
			END
IF(@appTypeID = 61)
			BEGIN
				INSERT INTO @SAPOracleInfo(instanceID) VALUES (@instId)
				UPDATE @InstanceInfo
				SET instanceVersion = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle Version' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET DatabaseID = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle DB id' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET OracleUserDomain = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Domain Name' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET OracleUserName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle User'),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET OracleHome = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle Home' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET SAPDataPath = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SAP Data Home' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET SAPExeFolder = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SAP Exe Folder' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET sqlConnectUser = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SQL Connect' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET sqlConnectPassword = ISNULL((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WHERE attrName = 'SQL Connect Password' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET sqlConnectMachine = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SQL Connect Machine' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET EncryptionFlag = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Encrypt: encryption' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET IsOnDemand = ISNULL((SELECT CASE (ISNULL(status,0) & 0x0800) WHEN 0x0800  THEN  1 ELSE 0 END from APP_InstanceName WHERE id =@instId),0)
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET CommandLineStoragePolicyID = ISNULL((SELECT dataArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040), 1)
				WHERE instanceID = @instId
				--Get properties flags
				UPDATE @SAPOracleInfo
				SET OverrideDataPathsForCmdPolicy = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus & 0x0040 > 0 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Full Failover to SP dataPaths' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET OverrideDataPathsForLogPolicy = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus & 0x00008 > 0 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Full Failover to SP dataPaths' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				--numberOfArchiveLogBackupStreams
				UPDATE @SAPOracleInfo
				SET numberOfArchiveLogBackupStreams = ISNULL((SELECT attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Oracle Log backup streams' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				--RmanBlockSize
				UPDATE @SAPOracleInfo
				SET OracleBlockSize = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle block size' ), 262144)
				WHERE instanceID = @instId
				--SAP secure store
				UPDATE @SAPOracleInfo
				SET UseSAPSecureStore = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Use SAP Secure Store' ),0)
				WHERE instanceID = @instId
				IF (SELECT CommandLineStoragePolicyID FROM @SAPOracleInfo WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @SAPOracleInfo
					SET CommandLineStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT CommandLineStoragePolicyID FROM @SAPOracleInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @SAPOracleInfo
				SET LogBackupStoragePolicyID = ISNULL((SELECT TOP 1 logArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040),1)
				WHERE instanceID = @instId
				IF (SELECT LogBackupStoragePolicyID FROM @SAPOracleInfo WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @SAPOracleInfo
					SET LogBackupStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT LogBackupStoragePolicyID FROM @SAPOracleInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @SAPOracleInfo
				SET SoftwareCompression = ISNULL((SELECT compressWhere FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id),'2')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET NetworkAgents = ISNULL((SELECT TOP 1 NumNWAgents FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id),0)
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET ThrottleNetworkBandwidth = ISNULL((SELECT TOP 1 NWWriteSpeed FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id),0)
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET Deduplication = ISNULL((SELECT attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Single Instancing Option' AND APP_SubClientProp.modified = 0),'')
				WHERE instanceID = @instId
				UPDATE @SAPOracleInfo
				SET clientOSType = ISNULL((SELECT simOperatingSystemId FROM APP_Client where id = @clientID),0)
				WHERE instanceID = @instId
				--snap
				IF @appTypeID = 61
				BEGIN
					DECLARE @allowMultipleDataReaders INT
					DECLARE @isSnapBackupEnabled INT
					DECLARE @useSourceProxyUnreachable INT
					DECLARE @proxyEngineId INT --snapSelectedEngine
					DECLARE @proxyEngineName NVARCHAR(MAX)
					DECLARE @proxyId INT --proxyToUse
					DECLARE @proxyName NVARCHAR(MAX)
					SET @allowMultipleDataReaders =ISNULL((SELECT attrval from #tempInstanceProperties where attrName = 'sys:UseMultipleStreamsWithinDriveSnapBackup'),0)
					SET @isSnapBackupEnabled = ISNULL((SELECT attrval from #tempInstanceProperties where  attrName = 'Enable Snap Backups'),0)
					SET @useSourceProxyUnreachable =  ISNULL((SELECT attrval from #tempInstanceProperties where  attrName = 'Snap copy : use source on missing proxy'),0)
					SET @proxyEngineId =  ISNULL((SELECT attrval from #tempInstanceProperties where attrName = 'Snap Engine'),0)
					SET @proxyEngineName =  ISNULL((SELECT snapenginename from smsnapshotengine WHERE snapshotengineId = @proxyEngineId),'')
					SET @proxyId =  ISNULL((SELECT attrval from #tempInstanceProperties where attrName = 'Snap copy : proxy to use'),0)
					SET @proxyName =  ISNULL((SELECT name from app_client where Id = @proxyId),'')
				END
				--end snap
			END
			-- SAP for MAX DB
IF @appTypeID = 79
			BEGIN
				INSERT INTO @SAPMAXDBInfo(instanceID) VALUES (@instId)
				UPDATE @SAPMAXDBInfo
				SET EncryptionFlag = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0048 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Encrypt: encryption' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				UPDATE @SAPMAXDBInfo
				SET CommandLineStoragePolicyID = ISNULL((SELECT TOP 1 dataArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0048), 1)
				WHERE instanceID = @instId
				--Get properties flags
				UPDATE @SAPMAXDBInfo
				SET OverrideDataPathsForCmdPolicy = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus & 0x0048 > 0 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Full Failover to SP dataPaths' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				UPDATE @SAPMAXDBInfo
				SET OverrideDataPathsForLogPolicy = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus & 0x00008 > 0 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Full Failover to SP dataPaths' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				--numberOfArchiveLogBackupStreams
				UPDATE @SAPMAXDBInfo
				SET numberOfArchiveLogBackupStreams = ISNULL((SELECT attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0048 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Oracle Log backup streams' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				IF (SELECT CommandLineStoragePolicyID FROM @SAPMAXDBInfo WHERE instanceID = @instId) IS NOT NULL
				BEGIN
					UPDATE @SAPMAXDBInfo
					SET CommandLineStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT CommandLineStoragePolicyID FROM @SAPMAXDBInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @SAPMAXDBInfo
				SET LogBackupStoragePolicyID = ISNULL((SELECT logArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0048), 1)
				WHERE instanceID = @instId
				IF (SELECT LogBackupStoragePolicyID FROM @SAPMAXDBInfo WHERE instanceID = @instId) IS NOT NULL
				BEGIN
					UPDATE @SAPMAXDBInfo
					SET LogBackupStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT LogBackupStoragePolicyID FROM @SAPMAXDBInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @SAPMAXDBInfo
				SET SoftwareCompression = ISNULL((SELECT compressWhere FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0048 AND archPipeConfig.appNumber = APP_Application.id),'2')
				WHERE instanceID = @instId
				UPDATE @SAPMAXDBInfo
				SET NetworkAgents = ISNULL((SELECT TOP 1 NumNWAgents FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0048 AND archPipeConfig.appNumber = APP_Application.id), 0)
				WHERE instanceID = @instId
				UPDATE @SAPMAXDBInfo
				SET ThrottleNetworkBandwidth = ISNULL((SELECT TOP 1 NWWriteSpeed FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0048 AND archPipeConfig.appNumber = APP_Application.id), 0)
				WHERE instanceID = @instId
				UPDATE @SAPMAXDBInfo
				SET Deduplication = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0048 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Single Instancing Option' AND APP_SubClientProp.modified = 0), 1)
				WHERE instanceID = @instId
				UPDATE @SAPMAXDBInfo
				SET osUser = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SAP MAXDB OS User' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPMAXDBInfo
				SET dbUser = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SAP MAXDB DB User' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPMAXDBInfo
				SET binDir = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SAP MAXDB Bin Dir' ),'')
				WHERE instanceID = @instId
				UPDATE @SAPMAXDBInfo
				SET dbmcliPath	 = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SAP MAXDB dbmcli path' ),'')
				WHERE instanceID = @instId
			END
			--Gather VMWare properties
IF @appTypeID = 106
			BEGIN
		        --SET @vmMemberServersStr = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Vs Member Servers')
				--SET @vmMemberServers = @vmMemberServersStr
				INSERT INTO @VMWareInfo(instanceID) VALUES (@instId)
				UPDATE @VMWareInfo
				SET VSInstanceType = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Virtual Server Instance Type'),''),
				esxServerToMount = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Snap Mount Proxy'),
				vmMemberServers = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Vs Member Servers')
				WHERE instanceID = @instId
				DECLARE @instanceType int
				SET @instanceType = (SELECT TOP 1 VSInstanceType FROM @VMWareInfo WHERE instanceID = @instId)
				IF @instanceType = 100
				BEGIN
					DECLARE @esxServers_xml XML
					SET @esxServers_xml = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'ESX Servers XML')
					INSERT INTO @ESXServerInfo(instanceID, ServerHostName, userName, userPassword)
					SELECT  @instId,
							ref.value('@serverName', 'NVARCHAR(255)'),
							ref.value('@userName', 'NVARCHAR(255)'),
							ref.value('@password', 'NVARCHAR(255)')
					FROM    @esxServers_xml.nodes('EVGui_ESXServerDBList/serverList') R ( ref )
				END
				ELSE IF @instanceType = 201
				BEGIN
					DECLARE @xenServers_xml XML
					SET @xenServers_xml = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'ESX Servers XML')
					INSERT INTO @XenServerInfo(instanceID, ServerHostName, userName, userPassword)
					SELECT  @instId,
							ref.value('@serverName', 'NVARCHAR(255)'),
							ref.value('@userName', 'NVARCHAR(255)'),
							ref.value('@password', 'NVARCHAR(255)')
					FROM    @xenServers_xml.nodes('EVGui_ESXServerDBList/serverList') R ( ref )
				END
				ELSE
				BEGIN
					INSERT INTO @ServerInfo(instanceID) VALUES (@instId)
					UPDATE @ServerInfo
					SET ServerHostName = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Virtual Server Host'),'')
					WHERE instanceID = @instId
					UPDATE @ServerInfo
					SET userName = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Virtual Server User'),'')
					WHERE instanceID = @instId
					UPDATE @ServerInfo
					SET userPassword = NULLIF((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WHERE attrName = 'Virtual Server Password'),'')
					WHERE instanceID = @instId
				END
				--Azure resource manager and Azure stack
				IF @instanceType = 402 OR @instanceType = 403
				BEGIN
					DECLARE @subscription NVARCHAR(1024)
					DECLARE @tenant NVARCHAR(1024)
					SET @subscription =  CONCAT(NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Subscription Id'),''),'\',
					NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Tenant Id'),''))
					UPDATE @ServerInfo
					SET ServerHostName = @subscription
					WHERE instanceID = @instId
				END
				IF @instanceType = 301
				BEGIN
				    UPDATE @ServerInfo
					SET userName = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Amazon Center Access Key'),'')
					WHERE instanceID = @instId
					UPDATE @ServerInfo
					SET userPassword = NULLIF((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WHERE attrName = 'Amazon Center Secret Key'),'')
					WHERE instanceID = @instId
					INSERT INTO @AmazonInstanceInfo(instanceID) VALUES (@instId)
					UPDATE @AmazonInstanceInfo
					SET accessKey = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Amazon Center Access Key'),'')
					WHERE instanceID = @instId
					UPDATE @AmazonInstanceInfo
					SET  useIamRole = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Amazon Use IAM Role'),'')
					WHERE instanceID = @instId
					UPDATE @AmazonInstanceInfo
					SET  enableAdminAccount = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Amazon Enable Admin Account'),'')
					WHERE instanceID = @instId
					UPDATE @AmazonInstanceInfo
					SET  adminInstanceID = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Amazon Admin Instance Id'),'')
					WHERE instanceID = @instId
				END
				IF @instanceType = 103
				BEGIN
					INSERT INTO @AdminInstanceInfo(instanceID) VALUES (@instId)
				    UPDATE @AdminInstanceInfo
					SET  enableAdminAccount = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Amazon Enable Admin Account'),'')
					WHERE instanceID = @instId
					UPDATE @AdminInstanceInfo
					SET  adminInstanceID = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Amazon Admin Instance Id'),'')
					WHERE instanceID = @instId
					INSERT INTO @VcloudInstanceInfo(instanceID) VALUES (@instId)
					UPDATE @VcloudInstanceInfo
					SET  vOrgName = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Virtual Server vCloud Org Name'),'')
					WHERE instanceID = @instId
					UPDATE @VcloudInstanceInfo
					SET  vOrgGuid = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Virtual Server vCloud Org Guid'),'')
					WHERE instanceID = @instId
				END
				IF @instanceType = 1401
				BEGIN
				    UPDATE @ServerInfo
					SET userName = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Alibaba Cloud Access Key'),'')
					WHERE instanceID = @instId
					UPDATE @ServerInfo
					SET userPassword = NULLIF((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WHERE attrName = 'Alibaba Cloud Secret Key'),'')
					WHERE instanceID = @instId
				END
			END
			--Gather DB2 properties
IF @appTypeID = 37 OR @appTypeID = 62 OR @appTypeID = 103
			BEGIN
				INSERT INTO @DB2Info(instanceID) VALUES (@instId)
				UPDATE @InstanceInfo
				SET instanceVersion = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB2 Version'),'')
				WHERE instanceID = @instId
				UPDATE @InstanceInfo
				SET instanceVersion = instanceVersion + ISNULL((SELECT ' ' + attrVal + 'bit' FROM #tempInstanceProperties WHERE attrName = 'DB2 Word Width'),'')
				WHERE instanceID = @instId
				UPDATE @DB2Info
				SET DataBackupStoragePolicyID = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB2 Default Data SP'), 1)
				WHERE instanceID = @instId
				IF (SELECT DataBackupStoragePolicyID FROM @DB2Info WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @DB2Info
					SET DataBackupStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT DataBackupStoragePolicyID FROM @DB2Info WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @DB2Info
				SET CommandLineStoragePolicyID = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB2 Default Command Line SP'), 1)
				WHERE instanceID = @instId
				IF (SELECT CommandLineStoragePolicyID FROM @DB2Info WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @DB2Info
					SET CommandLineStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT CommandLineStoragePolicyID FROM @DB2Info WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @DB2Info
				SET LogBackupStoragePolicyID = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB2 Default Index SP'), 1)
				WHERE instanceID = @instId
				IF (SELECT LogBackupStoragePolicyID FROM @DB2Info WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @DB2Info
					SET LogBackupStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT LogBackupStoragePolicyID FROM @DB2Info WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @DB2Info
				SET homeDirectory = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB2 Home'),'')
				WHERE instanceID = @instId
				UPDATE @DB2Info
				SET ServerHostName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB2 Domain'),'')
				WHERE instanceID = @instId
				UPDATE @DB2Info
				SET userName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB2 User Id'),'')
				WHERE instanceID = @instId
				UPDATE @DB2Info
				SET userPassword = ISNULL((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WHERE attrName = 'DB2 Domain Password'),'')
				WHERE instanceID = @instId
				IF EXISTS (SELECT * FROM APP_ClientProp WHERE componentNameId = @clientID AND attrName = 'Encrypt: encryption' AND attrVal = '1' AND modified = 0)
				UPDATE @DB2Info
				SET encryptionFlag = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB2 Default Command Line SC Enc Flag'), 0)
				WHERE instanceID = @instId
				UPDATE @DB2Info
				SET Deduplication = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Single Instancing Option' AND APP_SubClientProp.modified = 0), 1)
				WHERE instanceID = @instId
				UPDATE @DB2Info
				--SET SoftwareCompression = NULLIF((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB2 Default Command Line SC SW Compression'),'2')
				SET SoftwareCompression = isnull((SELECT TOP 1 compressWhere FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id),'2')
				WHERE instanceID = @instId
				UPDATE @DB2Info
				SET NetworkAgents = ISNULL((SELECT TOP 1 NumNWAgents FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id), 0)
				WHERE instanceID = @instId
				UPDATE @DB2Info
				SET ThrottleNetworkBandwidth = ISNULL((SELECT TOP 1 NWWriteSpeed FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id), 0)
				WHERE instanceID = @instId
				INSERT INTO @DB2Nodes (instanceID, nodeNum, clientID)
				SELECT	IP.componentNameId, substring(T1.Data, 1, CHARINDEX(',', T1.Data)-1), substring(T1.Data, CHARINDEX(',', T1.Data)+1, LEN(T1.Data))
				FROM	APP_InstanceProp IP
					CROSS APPLY dbo.SplitString(attrVal, ' ') T1
				WHERE	IP.componentNameID = @instId
					AND	attrName = 'DB2 Partition Clients' AND IP.modified = 0
			END
			--Gather Informix properties
IF @appTypeID = 3
			BEGIN
				INSERT INTO @InformixInfo(instanceID) VALUES (@instId)
				UPDATE @InstanceInfo
				SET instanceVersion = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Informix Version'),'')
				WHERE instanceID = @instId
				UPDATE @InformixInfo
				SET homeDirectory = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Informix Dir'),'')
				WHERE instanceID = @instId
				UPDATE @InformixInfo
				SET userName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Informix UserId'),'')
				WHERE instanceID = @instId
				UPDATE @InformixInfo
				SET domainName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Domain Name'),'')
				WHERE instanceID = @instId
				UPDATE @InformixInfo
				SET userPassword = ISNULL((SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WHERE attrName = 'Informix Password'),'')
				WHERE instanceID = @instId
				UPDATE @InformixInfo
				SET onConfigFile = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Informix Onconfig'),'')
				WHERE instanceID = @instId
				UPDATE @InformixInfo
				SET sqlHostfile = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Informix SQL Host File path'),'')
				WHERE instanceID = @instId
				UPDATE @InformixInfo
SET CommandLineStoragePolicyID = ISNULL((SELECT dataArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040), 1)
				WHERE instanceID = @instId
				IF (SELECT CommandLineStoragePolicyID FROM @InformixInfo WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @InformixInfo
					SET CommandLineStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT CommandLineStoragePolicyID FROM @InformixInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @InformixInfo
SET LogBackupStoragePolicyID = ISNULL((SELECT logArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040) ,1)
				WHERE instanceID = @instId
				IF (SELECT LogBackupStoragePolicyID FROM @InformixInfo WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @InformixInfo
					SET LogBackupStoragePolicyName = (SELECT name FROM archGroup WHERE archGroup.id = (SELECT LogBackupStoragePolicyID FROM @InformixInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @InformixInfo
SET SoftwareCompression = ISNULL((SELECT TOP 1 compressWhere FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id), 2)
				WHERE instanceID = @instId
				UPDATE @InformixInfo
SET Deduplication = ISNULL((SELECT attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Single Instancing Option' AND APP_SubClientProp.modified = 0), 1)
				WHERE instanceID = @instId
			END
			--Gather Sybase properties
IF @appTypeID = 5
			BEGIN
				INSERT INTO @SybaseInfo(instanceID) VALUES (@instId)
				UPDATE @InstanceInfo
				SET instanceVersion = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE version'),'')
				WHERE instanceID = @instId
				DECLARE @backupServerName nvarchar(128)
				DECLARE @backupServerID NVARCHAR(16)
				SET @backupServerID = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE backup server id'), '')
				DECLARE @BackupServers TABLE (instID int, FileID int, backupserverid nvarchar(16), status nvarchar(16), name nvarchar(128), serverclass nvarchar(32), netName nvarchar(128), serverPname nvarchar(128))
				INSERT INTO @BackupServers
				SELECT @instID, * FROM
				(
					SELECT I.id as FileID, TOKENS.*  FROM APP_InstFilterFile I
					cross apply dbo.SplitString(I.fileName, ' ') TOKENS
					WHERE componentNameId = @instId AND type = 14 AND modified = 0 -- /*CV_SYBASE_BACKUP_SERVER - 14*/
				) A
				Pivot(
					MAX(Data)
					For ID IN ([1], [2], [3], [4], [5], [6])
				)
				AS PivotTable
				SELECT @backupServerName = netName FROM @BackupServers WHERE backupserverid = @backupServerID
				UPDATE @SybaseInfo SET BackupServer=@backupServerName WHERE instanceID = @instId
				UPDATE @SybaseInfo
				SET SybaseHome = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE home'),'')
				WHERE instanceID = @instId
				UPDATE @SybaseInfo
				SET SybaseASE = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE ASE'),'')
				WHERE instanceID = @instId
				UPDATE @SybaseInfo
				SET SybaseOCS = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE OCS'),'')
				WHERE instanceID = @instId
				UPDATE @SybaseInfo
				SET ConfigFile = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE config file path'),'')
				WHERE instanceID = @instId
				UPDATE @SybaseInfo
				SET SharedMemoryDir = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE shared memory repos directory'),'')
				WHERE instanceID = @instId
				UPDATE @SybaseInfo
				SET EnableAutoDiscovery = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE auto discovery'),0)
				WHERE instanceID = @instId
				UPDATE @SybaseInfo
				SET userName = ISNULL((SELECT MAX(attrVal) FROM #tempInstanceProperties WHERE attrName IN ('SYBASE NT user', 'SYBASE Unix user')),'')
				WHERE instanceID = @instId
				UPDATE @SybaseInfo
				SET saUserName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE user'),'')
				WHERE instanceID = @instId
				UPDATE @SybaseInfo
				SET SybaseBlockSize = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SYBASE Block Size'),'0')
				WHERE instanceID = @instId
			END
IF (@appTypeID = 135)
			BEGIN
				INSERT INTO @SapHanaInfo(instanceID) VALUES (@instId)
				UPDATE @InstanceInfo
				SET instanceVersion = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SAP HANA Version' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET databaseName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Database Name' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET SAPHANAUser =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'User Name' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET hdbuserstorekey = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'HDB User Store Key' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET hdbsqlLocationDirectory = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'HDB SQL Location Directory' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET libPaths = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Lib Paths' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET  cmdBackupPrefix = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Command Line Backup Prefix' AND APP_SubClientProp.modified = 0),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET  cmdlineThresholdStreams = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Command Line Backup Streams' AND APP_SubClientProp.modified = 0),'0')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET  enableCmdlineThreshold = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Command Line Backup Streams Enabled' AND APP_SubClientProp.modified = 0),'0')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET  logBackupPrefix = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x1000 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Log Backup Prefix' AND APP_SubClientProp.modified = 0),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET  logDataThresholdStreams = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x1000 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Log Backup Streams' AND APP_SubClientProp.modified = 0),'0')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET  enableLogDataThreshold = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x1000 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Log Backup Streams Enabled' AND APP_SubClientProp.modified = 0),'0')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET EncryptionFlag = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Encrypt: encryption' AND APP_SubClientProp.modified = 0), 0)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET CommandLineStoragePolicyID = ISNULL((SELECT TOP 1 dataArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040), 1)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET dbInstanceNumber =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB Instance Number' ),'00')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET SAPHANADbUser =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB User Name' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET SAPHANADbDomain =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB Domain Name' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET  isUsehdbStoreKey =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Is Using HDB Store Key' ), 0)
				WHERE instanceID = @instId
				--Get properties flags
				IF (SELECT CommandLineStoragePolicyID FROM @SapHanaInfo WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @SapHanaINfo
					SET CommandLineStoragePolicyName = (SELECT TOP 1 name FROM archGroup WHERE archGroup.id = (SELECT CommandLineStoragePolicyID FROM @SapHanaInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @SapHanaInfo
				SET LogBackupStoragePolicyID = ISNULL((SELECT TOP 1 logArchGrpID FROM APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x1000), 1)
				WHERE instanceID = @instId
				IF (SELECT LogBackupStoragePolicyID FROM @SapHanaInfo WHERE instanceID = @instId) IS NOT null
				BEGIN
					UPDATE @SapHanaInfo
					SET LogBackupStoragePolicyName = (SELECT TOP 1 name FROM archGroup WHERE archGroup.id = (SELECT LogBackupStoragePolicyID FROM @SapHanaInfo WHERE instanceID = @instId))
					WHERE instanceID = @instId
				END
				UPDATE @SapHanaInfo
				SET SoftwareCompression = ISNULL((SELECT TOP 1 compressWhere FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id),'2')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET NetworkAgents = ISNULL((SELECT TOP 1 NumNWAgents FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id), 0)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET ThrottleNetworkBandwidth = ISNULL((SELECT TOP 1 NWWriteSpeed FROM archPipeConfig, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND archPipeConfig.appNumber = APP_Application.id), 0)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET Deduplication = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp, APP_Application WHERE APP_Application.instance = @instId AND APP_Application.subclientStatus = 0x0040 AND APP_SubClientProp.componentNameId = APP_Application.id AND APP_SubClientProp.attrName = 'Single Instancing Option' AND APP_SubClientProp.modified = 0), 1)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET clientOSType = ISNULL((SELECT simOperatingSystemId FROM APP_Client where id = @clientID),0)
				WHERE instanceID = @instId
				--isRMANEnableForTapeMovement
				UPDATE @SapHanaInfo
				SET isRMANEnableForTapeMovement = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Use RMAN for Tape Movement'), 0)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET containerMode =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB Container Mode' ), 0)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET isolationLevel =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'DB Isolation Level' ), 0)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET hanaVersion =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'HANA Version' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET spsVersion =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'SPS Version' ),'')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET numberOfNodes =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Number of Nodes' ), 0)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET sslEnabled =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Enable SSL' ), 0)
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET sslProvider =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'HANA SSL Provider' ), N'commoncrypto')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET sslTrustStore =ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'HANA SSL Trust Store' ), N'sapcli.pse')
				WHERE instanceID = @instId
				UPDATE @SapHanaInfo
				SET logBackupFrequency = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'HANA Log Backup Interval' ), 900)
				WHERE instanceID = @instId
				Declare @clientList nvarchar(max)= ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Database Clients'),'')
				Declare @startindex int=1
				Declare @pos int
				WHILE @startindex > 0
				BEGIN
					set @pos=CHARINDEX('+',@clientList,@startindex)
					IF(@pos<>0)
						BEGIN
						insert Into @DBInstances
						   values(@instId, CONVERT(INT,SUBSTRING(@clientList,@startindex,@pos-@startindex)),ISNULL((select name from app_client where id=CONVERT(INT,SUBSTRING(@clientList,@startindex,@pos-@startindex))),''))
						SET @startindex=@pos+1
						END
					ELSE
						BEGIN
						Insert into @DBInstances
							  values(@instId, CONVERT(INT,SUBSTRING(@clientList,@startindex,LEN(@clientList)- @startindex+1)),ISNULL((select name from app_client where id=CONVERT(INT,SUBSTRING(@clientList,@startindex,LEN(@clientList)-@startindex+1))),''))
						SET    @startindex=0
						END
					END
				END
			--Gather PostgreSQL properties
IF @appTypeId = 125
			BEGIN
				INSERT INTO @PostgreSQLInstanceInfo(instanceId)
					VALUES(@instId)
				UPDATE @InstanceInfo
				SET instanceVersion = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL version' ),N'')
				WHERE instanceID = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET MaintainenceDB = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'PosgreSQL config file' ),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET BinaryDirectory = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL binary file path' ),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET LibDirectory = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL data file path' ),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET ArchiveLogDirectory = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL write ahead archive log index file' ),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET port = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL Port' ),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET SAUserName = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL SA user' ),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET SAUserPassword = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL SA password' ),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET ArchiveDelete = ISNULL((SELECT CONVERT(int,attrval) FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL Delete Archive Log' ),0)
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET logStoragePolicyId = ISNULL((SELECT DISTINCT TOP 1 logArchGrpId FROM APP_BackupsetProp B, APP_Application A WHERE A.instance = @instId AND A.backupset = B.componentNameId AND B.attrName = 'FS BackupSet' AND B.attrVal = '1' AND B.modified = 0), 1)
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET logStoragePolicyName = ISNULL((SELECT name FROM ArchGroup WHERE id = (SELECT logStoragePolicyId FROM @PostgreSQLInstanceInfo WHERE instanceId = @instid)),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET version = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL version' ),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET UNCUserName = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL UNC User' ),N'')
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET isStandBy = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL is Standby Instance' ),0)
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET standByEnabled = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL Enable Standby Backup' ),0)
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET standbyInstanceId = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL Standby Instance' ),1)
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET useMasterForDataBkp = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL Use master for data backup' ),0)
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET useMasterForLogBkp = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL Use master for log backup' ),0)
				WHERE instanceId = @instId
				UPDATE @PostgreSQLInstanceInfo
				SET lastLogNumber = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'PostgreSQL last backup log number' ),N'')
				WHERE instanceId = @instId
			END
			--Gather MySQL properties
IF @appTypeId = 104
			BEGIN
				INSERT INTO @MySQLInstanceInfo(instanceId)
					VALUES(@instId)
				UPDATE @MySQLInstanceInfo
				SET BinaryDirectory = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MySQL binary file path' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET LogDataDirectory = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MySQL data file path' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET ConfigFile = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'MySQL config file' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET port = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'MySQL socket file' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET EnableAutoDiscovery = ISNULL((SELECT CONVERT(int,attrval) FROM #tempInstanceProperties WHERE attrName = 'MySQL auto discovery' ),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET SAUserName = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'MySQL SA user' ),N'')
				WHERE instanceId = @instId
				/*
				For MySQL we don't set log storage policy for '(command line)' subclient. It's used only for data.
				For that reason we need to exclude '(command line)' subclient in the below query to get log storage policy.
				*/
				UPDATE @MySQLInstanceInfo
SET logStoragePolicyId = ISNULL((SELECT logArchGrpId FROM APP_Application WHERE APP_Application.instance = @instId AND (APP_Application.subclientStatus & 0x00008) <> 0),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET logStoragePolicyName = ISNULL((SELECT name FROM ArchGroup WHERE id = (SELECT logStoragePolicyId FROM @MySQLInstanceInfo WHERE instanceId = @instid)),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET commandLineStoragePolicyId = ISNULL((SELECT dataArchGrpId FROM APP_Application WHERE instance = @instId AND subclientName='(command line)'),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET commandLineStoragePolicyName = ISNULL((SELECT name FROM ArchGroup WHERE id = (SELECT commandLineStoragePolicyId FROM @MySQLInstanceInfo WHERE instanceId = @instid)),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET NTUserName = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'MySQL NT user' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET archiveLogIndexFile = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'MySQL archive log index file' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET unixUserName = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'MySQL Unix user' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET version = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'MySQL version' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET dataDirectory = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'dataDir' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET lastLogNumber = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'MySQL last backup log number' ),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
SET isProxyEnabled = ISNULL((SELECT CAST(attrval AS INT) FROM #tempInstanceProperties WHERE attrName = 'MySQL enable proxy'),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
SET proxyInstanceId = ISNULL((SELECT CAST(attrval AS INT) FROM #tempInstanceProperties WHERE attrName = 'MySQL proxy instance id '),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
SET isUseSSL = ISNULL((SELECT CAST(attrval AS INT) FROM #tempInstanceProperties WHERE attrName = 'MySQL enable ssl for proxy'),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
SET runBackupOnProxy = ISNULL((SELECT CAST(attrval AS INT) FROM #tempInstanceProperties WHERE attrName = 'MySQL run log backup on proxy'),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET isXtraBackupEnabled = ISNULL((SELECT CAST(attrval AS INT) FROM #tempInstanceProperties WHERE attrName = 'Enable Xtra Backup'),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET xtraBackupBinPath = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'MySQL Xtra backup bin path'),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET enableMEB = ISNULL((SELECT CAST(attrval AS INT) FROM #tempInstanceProperties WHERE attrName = 'Enable MEB'),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET EnableNoLocking = ISNULL((SELECT CAST(attrval AS INT) FROM #tempInstanceProperties WHERE attrName = 'MySQL enable no locking'),0)
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
				SET mebBinPath = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'MySQL MEB bin path'),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
SET sslCaPath = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'SSL CA Path'),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
SET sslKey = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'SSL Client Key'),N'')
				WHERE instanceId = @instId
				UPDATE @MySQLInstanceInfo
SET sslCert = ISNULL((SELECT attrval FROM #tempInstanceProperties WHERE attrName = 'SSL Client Cetrtificate'),N'')
				WHERE instanceId = @instId
			END
			--Gather Distributed Apps properties
IF @appTypeID = 64
			BEGIN
				DECLARE @masterNodeName 				VARCHAR(MAX)
				DECLARE @masterPort 					INT
				DECLARE @masterDirectory				VARCHAR(MAX)
				DECLARE @initVersion					VARCHAR(MAX)
				DECLARE @currentVersion					VARCHAR(MAX)
				DECLARE @postgresVersion				VARCHAR(MAX)
				DECLARE @masterRole 					SMALLINT
				DECLARE @masterStandbyNode 				VARCHAR(MAX)
				DECLARE @standbyState 					SMALLINT
				DECLARE @greenplumHome					VARCHAR(MAX)
				DECLARE @adminUser						VARCHAR(MAX)
				DECLARE @defaultDatabase				VARCHAR(MAX)
				DECLARE @isAgentless					INT
				DECLARE @masterClientId                 INT
				DECLARE @hadoopConfig 					XML
				DECLARE @coordinatorNode				XML
				DECLARE @hadoopSites					XML
				DECLARE @coordinatorNodeId				INT
				DECLARE @pit INTEGER = dbo.GetUnixTime(GETUTCDATE())
				SET @clusterType = (ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Distributed Cluster Type'), 0))
				DECLARE @instanceName NVARCHAR(MAX) = (ISNULL((SELECT name FROM APP_InstanceName WHERE id = @instId),'Unknown'))
				IF @clusterType = 1
				BEGIN
					SET @masterNodeName = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Master Node Name' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @masterPort = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Master Port Number' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @masterDirectory = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Master Diretory' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @initVersion = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Initial Version' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @currentVersion = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Current Version' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @postgresVersion = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Postgres Version' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @masterRole = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Master Role' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @masterStandbyNode = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Master Standby Node' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @standbyState = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'State of standby node' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @greenplumHome = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Greenplum Home' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @adminUser = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Greenplum Admin User' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @defaultDatabase = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Greenplum Default Database' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @masterClientId = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Greenplum Master Client Id' AND created <= @pit AND (modified = 0 OR modified > @pit))
					SET @isAgentless = ISNULL((SELECT TOP 1 attrVal FROM APP_InstanceProp  WHERE componentNameID = @instId AND attrName = 'Greenplum Agentless' AND created <= @pit AND (modified = 0 OR modified > @pit)), 0)
					SET @distributedAgentProp =
							(SELECT
								@clusterType as '@clusterType',
								(SELECT
									@instId as '@instanceId',
									dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
								FOR XML PATH('instance'), TYPE),
								(SELECT
									(SELECT
										@masterNodeName as '@masterNodeName',
										@masterPort as '@masterPort',
										@masterDirectory as '@masterDirectory',
										@initVersion as '@initVersion',
										@currentVersion as '@currentVersion',
										@postgresVersion as '@postgresVersion',
										@masterRole as '@masterRole',
										@masterStandbyNode as '@masterStandbyNode',
										@standbyState  as '@standbyState',
										@greenplumHome as '@greenplumHome',
										@adminUser as '@adminUser',
										@defaultDatabase as '@defaultDatabase',
										@isAgentless as '@isAgentless',
										(SELECT
											@masterClientId as '@clientId'
										FOR XML PATH('masterClient'), TYPE),
										(SELECT
											gp.address as '@address',
											gp.currentRole as '@currentRole',
											gp.mirrorStatus as '@mirrorStatus',
											gp.port as '@port',
											gp.preferredRole as '@preferredRole',
											gp.presentStatus as '@presentStatus',
											gp.DataDirectory as '@segmentDataDirectory',
											gp.dbId as '@dbId',
											gp.segmentContent as '@segmentContent',
											(SELECT
												gp.hostName as '@hostName',
												(SELECT
													gp.clientId as '@clientId'
												FOR XML PATH('client'), TYPE)
											FOR XML PATH ('node'), TYPE)
										FROM APP_GreenPlumAssociation gp
										WHERE instanceId = @instId AND created <= @pit AND (modified = 0 OR modified > @pit)
										FOR XML PATH('segments'), TYPE)
									FOR XML PATH('gpConfig'), TYPE)
								FOR XML PATH('clusterConfig'), TYPE)
							FOR XML PATH('distributedClusterInstance'), TYPE)
				END
				ELSE IF @clusterType = 2
				BEGIN
					DECLARE @hadoopApps TABLE(value XML)
					DECLARE @hBaseConfig XML = (SELECT CAST(attrVal AS XML) FROM #tempInstanceProperties WHERE attrName = 'HBase Configurations')
					SET @hadoopConfig = ISNULL((SELECT CAST(attrVal AS XML) FROM #tempInstanceProperties WHERE attrName = 'Hadoop Config'), '<App_HadoopConfig/>')
					SET @coordinatorNode = @hadoopConfig.query('/App_HadoopConfig/coordinatorNode')
					SET @hadoopSites = @hadoopConfig.query('/App_HadoopConfig/hadoopSites')
					IF(@hBaseConfig IS NOT NULL)
					BEGIN
						DECLARE @hBaseConfigXML XML = (SELECT 1 as '@hadoopAppType', (SELECT
													@hbaseConfig.value('(/App_HBaseConfig/@hbaseuser)[1]', 'NVARCHAR(1024)') as '@hbaseuser',
													@hbaseConfig.value('(/App_HBaseConfig/@configFile)[1]', 'NVARCHAR(1024)') as '@configFile',
													@hbaseConfig.value('(/App_HBaseConfig/@javaPath)[1]', 'NVARCHAR(1024)') as '@javaPath',
													@hbaseConfig.value('(/App_HBaseConfig/@hbaseHomeDir)[1]', 'NVARCHAR(1024)') as '@hbaseHomeDir',
													@hbaseConfig.value('(/App_HBaseConfig/@oldWalDir)[1]', 'NVARCHAR(1024)') as '@oldWalDir',
													@hbaseConfig.value('(/App_HBaseConfig/@backupRootDir)[1]', 'NVARCHAR(1024)') as '@backupRootDir',
													@hBaseConfig.query('/App_HBaseConfig/*')
												FOR XML PATH('hBaseConfig'), TYPE)
											FOR XML PATH('appConfigs'), TYPE)
						INSERT INTO @hadoopApps(value) VALUES(@hBaseConfigXML)
					END
					SET @distributedAgentProp =
							(SELECT
								@clusterType as '@clusterType',
								(SELECT
									@instId as '@instanceId',
									dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
								FOR XML PATH('instance'), TYPE),
								(SELECT
									(SELECT
										@hadoopSites,
										@coordinatorNode,
										(SELECT
											(SELECT value.query('*')
												FROM @hadoopApps
											FOR XML PATH(''), TYPE)
										FOR XML PATH('hadoopApps'), TYPE)
									FOR XML PATH('hadoopConfig'), TYPE)
								FOR XML PATH('clusterConfig'), TYPE)
							FOR XML PATH('distributedClusterInstance'), TYPE)
				END
				ELSE IF @clusterType = 3 OR @clusterType = 4 OR @clusterType = 5 OR @clusterType = 11 OR @clusterType = 13
				BEGIN
				DECLARE @daNodesXml XML
				SET @coordinatorNodeId = ISNULL((SELECT CAST(attrVal AS INT) FROM #tempInstanceProperties WHERE attrName = 'Coordinator Node'), 0)
				SET @daNodesXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Data Access Nodes'), '<App_DataAccessNodes />')
				SET @distributedAgentProp =
						(SELECT
							@clusterType as '@clusterType',
							(SELECT
								@instId as '@instanceId',
								dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
							FOR XML PATH('instance'), TYPE),
							(SELECT
								(SELECT
									(SELECT
										@coordinatorNodeId as '@clientId'
									FOR XML PATH ('coordinatorNode'), TYPE)
								FOR XML PATH('uxfsConfig'), TYPE)
							FOR XML PATH('clusterConfig'), TYPE),
							(SELECT @daNodesXml.query('/App_DataAccessNodes/*')
								FOR XML PATH('dataAccessNodes'), TYPE)
						FOR XML PATH('distributedClusterInstance'), TYPE)
				END
				ELSE IF @clusterType IN (6,10)
				BEGIN
					SET @distributedAgentProp =
							(SELECT
								@clusterType as '@clusterType',
								(SELECT
									@instId as '@instanceId',
									dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
								FOR XML PATH('instance'), TYPE)
							FOR XML PATH('distributedClusterInstance'), TYPE)
				END
				ELSE IF @clusterType = 9 OR @clusterType = 8 OR @clusterType=16  -- CASSANDRA OR MONGODB_IDA OR SPLUNK
				BEGIN
					DECLARE @distributedProps TABLE(outVals XML)
					DECLARE @handlereq XML;
					-- Handle for multiple instances
					DELETE FROM @distributedProps
					--Create handleReq
					SET @handlereq =
					(SELECT
						(SELECT
							1 as '@opType', --Get Properties
							(SELECT
								@instId as '@instanceId',
								dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
							FOR XML PATH('instance'), TYPE)
						FOR XML PATH('dcInstance'), TYPE)
					FOR XML PATH('App_DistributedClusterInstanceReq'), TYPE)
					INSERT INTO @distributedProps
					EXEC DistributedClusterInstanceInfo @handlereq
					SET @errorCode = (SELECT outVals.value('(/App_DistributedClusterInstanceResp/error/@errorCode)[1]','INTEGER') FROM @distributedProps)
					IF @errorCode > 0
					BEGIN
						SET @errorString = (SELECT outVals.value('(/App_DistributedClusterInstanceResp/error/@errorMessage)[1]','NVARCHAR(MAX)') FROM @distributedProps)
						INSERT into @errors
						VALUES (@instId,@instName,@appTypeID,@appName,@clientID,@clientName, @errorCode, @errorString)
						DELETE FROM @InstanceInfo WHERE instanceID = @instId
     					GOTO CONTINUE_NEXT_INSTANCE
					END
					SET @distributedAgentProp =
						(SELECT
							outVals.value('(/App_DistributedClusterInstanceResp/dcInstance/@clusterType)[1]', 'INTEGER') as '@clusterType',
							outVals.query('/App_DistributedClusterInstanceResp/dcInstance/*')
						FROM @distributedProps
						FOR XML PATH('distributedClusterInstance'), TYPE)
				END
				INSERT INTO @DistributedInstanceInfo VALUES (@instId, @distributedAgentProp)
			END
			--Gather Cloud Apps properties
IF @appTypeID = 134
			BEGIN
				DECLARE @cloudInstType	INT
				DECLARE @cloudInstName	NVARCHAR(1024)
				DECLARE @endPoint		NVARCHAR(1024)
				DECLARE @apiToken		NVARCHAR(1024)
				DECLARE @enableREST		NVARCHAR(1024)
				DECLARE @consumerId		NVARCHAR(1024)
				DECLARE @backupClId		NVARCHAR(1024)
				DECLARE @backupClName	NVARCHAR(1024)
				DECLARE @userName		NVARCHAR(1024)
				DECLARE @gProxyServersXml	XML
				DECLARE @gAutoDisc		INTEGER
				DECLARE @gEnterprise	INTEGER
				DECLARE	@gDomainName	NVARCHAR(1024)
				DECLARE @gAssocUser		NVARCHAR(1024)
				DECLARE @gEmailID		NVARCHAR(1024)
				DECLARE @gAppClientID	NVARCHAR(1024)
				DECLARE @gAppEmailID	NVARCHAR(1024)
				DECLARE @gAppKey		NVARCHAR(1024)
				DECLARE @gUser			NVARCHAR(1024)
				DECLARE @aHostURL   	NVARCHAR(1024)
				DECLARE @aAccountName	NVARCHAR(1024)
				DECLARE @aAccessKey		NVARCHAR(1024)
				DECLARE @aAccessKeyId	NVARCHAR(1024)
				DECLARE @sfOrgID		NVARCHAR(1024)
				DECLARE @gAutoDiscMode	INTEGER
				DECLARE @gAutoManageContent	INTEGER
				DECLARE @oCallbackUrl	NVARCHAR(1024)
				DECLARE @otenant		NVARCHAR(1024)
				DECLARE	@otenantId		NVARCHAR(1024)
				--DECLARE	@oaccessToken	NVARCHAR(4000)
				--DECLARE @orefreshToken	NVARCHAR(4000)
				DECLARE @ocollAdminId	NVARCHAR(1024)
				DECLARE @ocollAdminPass NVARCHAR(1024)
				DECLARE @sfOrgType      INTEGER
				DECLARE @sfFilesPerBackup	INTEGER
				DECLARE @sfNumOfUsers	INTEGER
				DECLARE @vsCloudVendorType	INT
				DECLARE @RegExSubclientsEnabled INTEGER
				DECLARE @MsCloudRegion INTEGER
				DECLARE @numberOfBackupStreams INTEGER
				DECLARE @AzureAppsXml XML
				DECLARE @ServiceAccountsXml XML
				DECLARE @storagePolicyId INT
				DECLARE @storagePolicyName NVARCHAR(256)
				DECLARE	@userCount  INT
				DECLARE @DiscoverStateXml XML
				DECLARE @discoveryProgress INT
				DECLARE @discoveryStatus INT
				DECLARE @totalDiscoveredGroups INT
				DECLARE @totalDiscoveredUsers INT
				DECLARE @lastCacheUpdateTime VARCHAR(128)
				DECLARE @lastCacheUsersCount INT
				DECLARE @lastCacheGroupsCount INT
				DECLARE @gitApp_HostUrl NVARCHAR(1024)
				DECLARE @gitApp_AccessTokenName NVARCHAR(1024)
				DECLARE @gitApp_AccessTokenKey  NVARCHAR(1024)
				DECLARE @gitApp_StagingPathDetails XML
				DECLARE @gitApp_StagingPath nvarchar(max)
				DECLARE @gitApp_ImpersonationType INT
				DECLARE @cloudCredId INT
				DECLARE @cloudCredType	INT
				SET @cloudInstType = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Cloud Apps Instance Type'), 0)
				SET @vsCloudVendorType = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Virtual Server Instance Type'), 0)
				SET @cloudInstName = ISNULL((SELECT name FROM APP_InstanceName WITH (NOLOCK) WHERE id = @instId),'Unknown')
				SET @cloudCredId = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Cloud Credential ID'),0)
				SET @cloudCredType = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Cloud Credential Type'),0)
				IF @cloudInstType = 3
				BEGIN
					SET @endPoint = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Salesforce endpoint')
					SET @apiToken = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Salesforce API token')
					SET @enableREST = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Salesforce Enable REST')
					SET @consumerId = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Salesforce consumer ID')
					SET @backupClId = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Salesforce backup client')
					SET @backupClName = (SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = CAST(@backupClId AS INT))
					SET @sfOrgID = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Salesforce Organization ID')
					SET @sfOrgType = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Salesforce Organization Type')
					SET @sfFilesPerBackup = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Salesforce files per backup'), 50)
					SET @sfNumOfUsers = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Salesforce number of users')
					SET @vmMemberServers = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Vs Member Servers')
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								(SELECT
									@sfFilesPerBackup as '@filesPerBackup',
									@sfNumOfUsers as '@numberOfUsers',
									@sfOrgID as '@sfOrgID',
									@sfOrgType as '@sfOrgType',
									@endPoint as '@endpoint',
									@apiToken as '@token',
									@enableREST as '@enableREST',
									@consumerId as '@consumerId'
								FOR XML PATH('salesforceInstance'), TYPE),
								(SELECT
									(SELECT @vmMemberServers.query('/App_MemberServers/*')
										FOR XML PATH('accessNodes'), TYPE),
									(SELECT
											@backupClId as '@clientId',
											@backupClName as '@clientName'
										FOR XML PATH('proxyServers'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF (@cloudInstType = 1 OR @cloudInstType = 2)
				BEGIN
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @gAutoDisc = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Cloud Connector Auto Discovery')
					SET @gEnterprise = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Cloud Connector Enterprise')
					SET @gDomainName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Enterprise Domain Name')
					SET @gAssocUser = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Enterprise Associated User')
					SET @gEmailID = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Enterprise email Id')
					SET @gAppClientID = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Enterprise App client Id')
					SET @gAppEmailID = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Enterprise App Email Id')
					SET @gAppKey = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Enterprise App Key')
					SET @userName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Enterprise User Id')
					SET @gAutoDiscMode = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Auto Discovery Mode'), 0)
					SET @gAutoManageContent = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Auto Manage Content')
					SET @RegExSubclientsEnabled = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'RegEx Subclients Enabled'), 0)
					Select TOP 1 @storagePolicyId = APP.dataArchGrpID  , @storagePolicyName = ARCH.name
					FROM APP_Application APP (NOLOCK) JOIN archGroup ARCH (NOLOCK) on APP.dataArchGrpID = ARCH.id
					WHERE APP.instance = @instId and APP.subclientStatus <> 32
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								(SELECT
									@gAutoDisc as '@isAutoDiscoveryEnabled',
									@gEnterprise as '@isEnterprise',
									@gDomainName as '@domainName',
									@gAssocUser as '@associatedUsername',
									@gEmailID as '@emailId',
									@gAppClientID as '@appClientId',
									@gAppEmailID as '@appEmailId',
									@gAppKey as '@appKey',
									@gAutoDiscMode as '@autoDiscoveryMode',
									@gAutoManageContent as '@manageContentAutomatically',
									@RegExSubclientsEnabled as '@additionalSubclientscreated',
									(SELECT
										@gUser as '@userName'
									FOR XML PATH('userPassword'), TYPE)
								FOR XML PATH('gInstance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*'),
								(SELECT [dataBackupStoragePolicy/@storagePolicyId] = @storagePolicyId,
								[dataBackupStoragePolicy/@storagePolicyName] = @storagePolicyName
								FOR XML PATH('storageDevice'), TYPE)
									FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF (@cloudInstType = 4 OR @cloudInstType = 22 OR @cloudInstType = 26 OR @cloudInstType = 27)
				BEGIN
					DECLARE @accessKey NVARCHAR(1024) = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Amazon Center Access Key')
					DECLARE @secretKey NVARCHAR(1024) = (SELECT dbo.pswConvertV5ToV3(attrVal) FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Amazon Center Secret Key')
					DECLARE @arrayId NVARCHAR(1024) = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Array ID')
					DECLARE @regionEndPoints NVARCHAR(255) = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Virtual Server Host')
					SET @vmMemberServers = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Vs Member Servers')
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								@vsCloudVendorType as '@vsCloudVendor',
								(SELECT
									@accessKey as '@accessKey',
									@secretKey as '@secretKey',
									@regionEndPoints as '@regionEndPoints',
									(SELECT
										@arrayId as '@arrayId'
									FOR XML PATH('arrayEntity'), TYPE)
								FOR XML PATH('rdsInstance'), TYPE),
								(SELECT
									@regionEndPoints as '@regionEndPoints',
									(SELECT @vmMemberServers.query('/App_MemberServers/*')
										FOR XML PATH('accessNodes'), TYPE),
									(SELECT
										@accessKey as '@accessKey',
										@secretKey as '@secretkey'
									FOR XML PATH('amazonInstanceInfo'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE),
								(Select
									@accessKey as '@accessKey',
									@secretKey as '@secretkey',
									@regionEndPoints as '@hostURL'
								FOR XML PATH('alibabaInstance'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF (@cloudInstType = 23 OR @cloudInstType = 32)
				BEGIN
					DECLARE @azureSubscriptionId NVARCHAR(1024) = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Azure Subscription Id')
					DECLARE @azureTenantId NVARCHAR(1024) = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Azure Tenant Id'), '')
					DECLARE @azureUser NVARCHAR(1024) = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Virtual Server User'), '')
					DECLARE @azureCloudAccName NVARCHAR(255) = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Virtual Server Host')
					SET @vmMemberServers = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Vs Member Servers')
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								@vsCloudVendorType as '@vsCloudVendor',
								(SELECT
									(SELECT @vmMemberServers.query('/App_MemberServers/*')
										FOR XML PATH('accessNodes'), TYPE),
									(SELECT
										@azureSubscriptionId as '@subscriptionId',
										@azureTenantId as '@tenantId',
										@azureCloudAccName as '@serverName',
										(SELECT @azureUser as '@userName'
											FOR XML PATH('credentials'), TYPE)
									FOR XML PATH('azureResourceManager'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 5
				BEGIN
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Amazon S3 Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @aHostURL = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Amazon S3 Host URL')
					SET @aAccessKeyId = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Amazon S3 Access Key Id')
					DECLARE @aS3IamRole INTEGER = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Amazon Use IAM Role')
					SET @cloudCredId = (SELECT TOP 1 credentialId FROM APP_CredentialAssoc WHERE assocId = @cloudCredId)
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								@cloudCredType as '@credentialType',
								(SELECT
									@aHostURL as '@hostURL',
									@aAccessKeyId as '@accessKeyId',
									@aS3IamRole as '@useIamRole'
								FOR XML PATH('s3Instance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*'),
									(SELECT
										@cloudCredId as '@credentialId',
										(SELECT credentialName
										FROM APP_Credentials
										WHERE credentialId = @cloudCredId) as '@credentialName'
									FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 6
				BEGIN
					DECLARE @azAdAccountName NVARCHAR(1024)
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @aHostURL = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Azure Host URL')
					SET @aAccountName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Azure Account Name')
					SET @aAccessKey = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Azure Access Key')
					SET @azAdAccountName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Azure AD Account Name')
					SET @cloudCredId = (SELECT TOP 1 credentialId FROM APP_CredentialAssoc WHERE assocId = @cloudCredId)
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								@cloudCredType as '@credentialType',
								(SELECT
									@aHostURL as '@hostURL',
									@aAccountName as '@accountName',
									@aAccessKey as '@accessKey',
									@azAdAccountName as '@adAccountName'
								FOR XML PATH('azureInstance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*'),
									(SELECT
										@cloudCredId as '@credentialId',
										(SELECT credentialName
										FROM APP_Credentials
										WHERE credentialId = @cloudCredId) as '@credentialName'
									FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 7
				BEGIN
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @gAutoDisc = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Cloud Connector Auto Discovery')
					SET @gEnterprise = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Cloud Connector Enterprise')
					SET @gEmailID = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Enterprise email Id')
					SET @gAppClientID = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Enterprise App client Id')
					SET @oCallbackUrl = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'OneDrive Callback Url')
					SET @gAutoDiscMode = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Auto Discovery Mode'), 0)
					SET @gAutoManageContent = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Auto Manage Content')
					SET @otenant = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'OneDrive Tenant')
					SET @otenantId = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'OneDrive Tenant Id')
					SET @gDomainName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'OneDrive Domain Name'),'')
					--SET @oaccessToken = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'OneDrive Access Token')
					--SET @orefreshToken = (SELECT attrVal FROM #tempInstanceProperties  WHERE attrName = 'OneDrive Refresh Token')
					SET @ocollAdminId = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'OneDrive Collection Admin Id')
					SET @ocollAdminPass = (SELECT attrVal FROM #tempInstanceProperties  WHERE attrName = 'OneDrive Collection Admin Password')
					SET @RegExSubclientsEnabled = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'RegEx Subclients Enabled'), 0)
					SET @MsCloudRegion = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK)  WHERE attrName ='MSCloud Region Type'), 1)
SET @numberOfBackupStreams = ISNULL((SELECT attrVal FROM APP_SubClientProp S, APP_Application A WHERE A.instance = @instId AND (A.subclientStatus & 0x00008 = 0x00008)  AND S.componentNameId = A.id AND S.attrName = 'sys:nStreams' AND S.modified = 0), 1)
					SET @userCount = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp S, APP_Application A WHERE A.instance = @instId AND S.componentNameId = A.id AND S.attrName = 'User Accounts Count' AND S.modified = 0), 0)
					SET @DiscoverStateXml = ISNULL((SELECT CONVERT(varchar(MAX),attrVal) FROM #tempInstanceProperties WITH (NOLOCK) where attrName= 'Discovery State'),'<App_Office365DiscoverState />')
					SET @discoveryStatus = ISNULL((SELECT  ref.value('@discoveryStatus', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @discoveryProgress = ISNULL((SELECT  ref.value('@discoveryProgress', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @lastCacheUsersCount = ISNULL((SELECT  ref.value('@lastCacheUsersCount', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @lastCacheGroupsCount = ISNULL((SELECT  ref.value('@lastCacheGroupsCount', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @lastCacheUpdateTime = ISNULL((SELECT  ref.value('@lastCacheUpdateTime', 'VARCHAR(125)') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),'')
					SET @totalDiscoveredUsers = ISNULL((SELECT  ref.value('@totalDiscoveredUsers', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @totalDiscoveredGroups = ISNULL((SELECT  ref.value('@totalDiscoveredGroups', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @ServiceAccountsXml = (SELECT (
												SELECT po.query('.')
												FROM
												(
													SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
													FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName=N'OneDrive Service Accounts'
												) PROP
												CROSS APPLY PROP.attrVal.nodes('./App_OneDriveServiceAccounts/accounts') P(po)
												FOR XML PATH(''),TYPE))
					--ADD DUMMY DATA WHEN ACCOUNTS IS EMPTY TO PREVENT ERROR IN XML MODIFY
					IF @ServiceAccountsXml.exist('/accounts') > 0
						BEGIN
							SET @ServiceAccountsXml.modify('delete //@password')
						END
					ELSE
						BEGIN
 							SET @ServiceAccountsXml = '<App_OneDriveServiceAccounts></App_OneDriveServiceAccounts>'
						END
					SET @AzureAppsXml = (SELECT (
												SELECT po.query('.')
												FROM
												(
													SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
													FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName=N'OneDrive Azure Connections'
												) PROP
												CROSS APPLY PROP.attrVal.nodes('./App_Office365AzureConnections/azureApps') P(po)
												FOR XML PATH(''),TYPE))
					IF @AzureAppsXml.exist('/azureApps') > 0
						BEGIN
							SET @AzureAppsXml.modify('delete //@azureAppKeyValue')
						END
					ELSE
						BEGIN
 							SET @AzureAppsXml =  '<App_Office365AzureConnections></App_Office365AzureConnections>'
						END
					Select TOP 1 @storagePolicyId = APP.dataArchGrpID  , @storagePolicyName = ARCH.name
					FROM APP_Application APP (NOLOCK) JOIN archGroup ARCH (NOLOCK) on APP.dataArchGrpID = ARCH.id
					WHERE APP.instance = @instId and APP.subclientStatus <> 32
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								(SELECT
									@gAutoDisc as '@isAutoDiscoveryEnabled',
									@gEnterprise as '@isEnterprise',
									@gEmailID as '@emailId',
									@gAppClientID as '@clientId',
									@oCallbackUrl as '@callbackUrl',
									@gAutoDiscMode as '@autoDiscoveryMode',
									@gAutoManageContent as '@manageContentAutomatically',
									@otenant as '@tenant',
									@otenantId as '@tenantId',
									@gDomainName as '@domainName',
									--@oaccessToken as '@accessToken',
									--@orefreshToken as '@refreshToken',
									@ocollAdminId as '@collectAdminId',
									@ocollAdminPass as '@collectAdminPasswd',
									@RegExSubclientsEnabled as '@additionalSubclientscreated',
									@MsCloudRegion as '@cloudRegion',
									( SELECT @ServiceAccountsXml
										FOR XML PATH('serviceAccounts'),TYPE),
									(SELECT @AzureAppsXml
										FOR XML PATH('azureAppList'),TYPE),
									(SELECT @discoveryStatus as 'discoveryStatus',
											@discoveryProgress as 'discoveryProgress',
											@lastCacheUpdateTime as 'lastCacheUpdateTime',
											@lastCacheUsersCount as 'lastCacheUsersCount',
											@lastCacheGroupsCount as 'lastCacheGroupsCount',
											@totalDiscoveredUsers as 'totalDiscoveredUsers',
											@totalDiscoveredGroups as 'totalDiscoveredGroups'
										FOR XML PATH('discoverState'),TYPE)
								FOR XML PATH('oneDriveInstance'), TYPE),
								(SELECT @numberOfBackupStreams as '@numberOfBackupStreams',
								@userCount as '@userAccountsCount',
								@gProxyServersXml.query('/App_GeneralCloudProperties/*'),
								(SELECT [dataBackupStoragePolicy/@storagePolicyId] = @storagePolicyId,
								[dataBackupStoragePolicy/@storagePolicyName] = @storagePolicyName
								FOR XML PATH('storageDevice'), TYPE),
								(SELECT
									C.id AS '@clientId',
									C.displayName AS '@clientName',
3 as '@_type_'
									FROM #tempInstanceProperties  T
									JOIN APP_Client C (NOLOCK) ON C.id = T.attrVal
										WHERE T.attrName = 'OneDrive Index Server'
									FOR XML PATH('indexServer') , TYPE)
									FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF (@cloudInstType = 8 OR @cloudInstType = 9 OR @cloudInstType = 10 OR @cloudInstType = 11 OR @cloudInstType = 13 OR @cloudInstType = 14)
				BEGIN
					DECLARE @oraEndpointURL NVARCHAR(1024) = N''
					DECLARE @oraUserName NVARCHAR(1024) = N''
					DECLARE @cloudAppsIndexServer INT
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle Cloud Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @oraEndpointURL = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle Cloud Endpoint URL')
					SET @oraUserName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle Cloud User')
					SET @cloudAppsIndexServer = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Cloud Index Server')
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								(SELECT
									@oraEndpointURL as '@endpointURL',
									(SELECT @oraUserName AS '@userName'
										FOR XML PATH('user'), TYPE)
								FOR XML PATH('oraCloudInstance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*'),
									(SELECT @cloudAppsIndexServer as '@clientId'
									FOR XML PATH('indexServer'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 15 --OPENSTACK
				BEGIN
					DECLARE @osEndpointURL NVARCHAR(1024) = N''
					DECLARE @osUserName NVARCHAR(1024) = N''
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Openstack Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @osEndpointURL = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Openstack Cloud Endpoint URL')
					SET @osUserName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Openstack Cloud User')
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								(SELECT
									@osEndpointURL as '@serverName',
									(SELECT @osUserName AS '@userName'
										FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('openStackInstance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*')
									FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF (@cloudInstType = 19) -- OCI_DATABASE
				BEGIN
					DECLARE @tenancyOCId NVARCHAR(1024)
					DECLARE @userOCId NVARCHAR(1024)
					DECLARE @fingerPrint NVARCHAR(1024)
					DECLARE @privateKeyFileName NVARCHAR(1024)
					DECLARE @regionName NVARCHAR(1024)
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Oracle Cloud Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @tenancyOCId = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle Cloud Infrastructure Tenancy Id')
					SET @userOCId = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle Cloud Infrastructure User Id')
					SET @fingerPrint = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle Cloud Infrastructure Finger Print')
					SET @privateKeyFileName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle Cloud Infrastructure Private File Name')
					SET @regionName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Oracle Cloud Infrastructure Region Name')
					SET @cloudAppsIndexServer = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Cloud Index Server')
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								(SELECT
									@tenancyOCId as '@tenancyOCId',
									@userOCId as '@userOCId',
									@fingerPrint as '@fingerPrint',
									@privateKeyFileName as '@privateKeyFileName',
									@regionName as '@regionName'
								FOR XML PATH('oracleCloudInfra'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*'),
									(SELECT @cloudAppsIndexServer as '@clientId'
									FOR XML PATH('indexServer'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 20 --GOOGLE_CLOUD
				BEGIN
					DECLARE @gcEndpointURL NVARCHAR(1024) = N''
					DECLARE @gcUserName NVARCHAR(1024) = N''
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Google Cloud Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @gcEndpointURL = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Google Cloud Cloud Endpoint URL')
					SET @gcUserName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Google Cloud Cloud User')
					SET @cloudCredId = (SELECT TOP 1 credentialId FROM APP_CredentialAssoc WHERE assocId = @cloudCredId)
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								@cloudCredType as '@credentialType',
								(SELECT
									@gcEndpointURL as '@serverName',
									(SELECT @gcUserName AS '@userName'
										FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('googleCloudInstance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*'),
									(SELECT
										@cloudCredId as '@credentialId',
										(SELECT credentialName
										FROM APP_Credentials
										WHERE credentialId = @cloudCredId) as '@credentialName'
									FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 21 --AZURE_DATA_LAKE
				BEGIN
					DECLARE @adlEndpointURL NVARCHAR(1024) = N''
					DECLARE @adlUserName NVARCHAR(1024) = N''
					DECLARE @adlAdAccountName NVARCHAR(1024) = N''
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Azure DL Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @adlEndpointURL = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Azure DL Cloud Endpoint URL')
					SET @adlUserName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Azure DL Cloud User')
					SET @adlAdAccountName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Azure AD Account Name')
					SET @cloudCredId = (SELECT TOP 1 credentialId FROM APP_CredentialAssoc WHERE assocId = @cloudCredId)
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								@cloudCredType as '@credentialType',
								(SELECT
									@adlEndpointURL as '@serverName',
									@adlAdAccountName as '@adAccountName',
									(SELECT @adlUserName AS '@userName'
										FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('azureDataLakeInstance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*'),
									(SELECT
										@cloudCredId as '@credentialId',
										(SELECT credentialName
										FROM APP_Credentials
										WHERE credentialId = @cloudCredId) as '@credentialName'
									FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 24 --IBM_COS
				BEGIN
					DECLARE @ibmEndpointURL NVARCHAR(1024) = N''
					DECLARE @ibmUserName NVARCHAR(1024) = N''
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'IBM COS Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @ibmEndpointURL = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'IBM COS Cloud Endpoint URL')
					SET @ibmUserName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'IBM COS Cloud User')
					SET @cloudCredId = (SELECT TOP 1 credentialId FROM APP_CredentialAssoc WHERE assocId = @cloudCredId)
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								@cloudCredType as '@credentialType',
								(SELECT
									@ibmEndpointURL as '@hostURL',
									(SELECT @ibmUserName AS '@userName'
										FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('ibmCosInstance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*'),
									(SELECT
										@cloudCredId as '@credentialId',
										(SELECT credentialName
										FROM APP_Credentials
										WHERE credentialId = @cloudCredId) as '@credentialName'
									FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 25 --ALIBABA_OSS
				BEGIN
					DECLARE @aliEndpointURL NVARCHAR(1024) = N''
					DECLARE @aliUserName NVARCHAR(1024) = N''
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Ali OSS Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @aliEndpointURL = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Ali OSS Cloud Endpoint URL')
					SET @aliUserName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Ali OSS Cloud User')
					SET @cloudCredId = (SELECT TOP 1 credentialId FROM APP_CredentialAssoc WHERE assocId = @cloudCredId)
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								@cloudCredType as '@credentialType',
								(SELECT
									@aliEndpointURL as '@hostURL',
									@aliUserName AS '@accessKey'
								FOR XML PATH('alibabaInstance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*'),
									(SELECT
										@cloudCredId as '@credentialId',
										(SELECT credentialName
										FROM APP_Credentials
										WHERE credentialId = @cloudCredId) as '@credentialName'
									FOR XML PATH('credentials'), TYPE)
								FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 33-- GitHub.
				BEGIN
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Git App Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @gitApp_HostUrl = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Git App Host URL')
					SET @gitApp_AccessTokenName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Git App User Name')
					SET @gitApp_AccessTokenKey = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Git App Access Token')
					SET @gitApp_StagingPathDetails = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName= 'Git App Staging Path Details'),'<App_StagingPathDetails />')
					SET @gitApp_ImpersonationType = (SELECT ISNULL(@gitApp_StagingPathDetails.value('(/App_StagingPathDetails/@impersonationType)[1]', 'nvarchar(2)'),'0') ) -- as 'impersonationType'
					SET @gitApp_StagingPath = (SELECT ISNULL(@gitApp_StagingPathDetails.value('(/App_StagingPathDetails/@stagingPath)[1]', 'nvarchar(max)'),'')) -- as 'stagingPath'
					SET @cloudAppsInstanceProp =
						(SELECT
							@cloudInstType as '@instanceType',
							(SELECT
								@gitApp_HostUrl as '@hostURL',
								(SELECT @gitApp_AccessTokenName as '@userName',
									@gitApp_AccessTokenKey as '@password'
									FOR XML PATH('credentials'), TYPE),
								(SELECT
									@gitApp_ImpersonationType as '@impersonationType',
									@gitApp_StagingPath as '@stagingPath',
									@gitApp_StagingPathDetails.query('/App_StagingPathDetails/*')
									FOR XML PATH('stagingPathDetails'),TYPE)
							FOR XML PATH('gitHubInstance'), TYPE),
							(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*')
								FOR XML PATH('generalCloudProperties'), TYPE)
						FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType = 34 -- Azure devOps.
				BEGIN
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Git App Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @gitApp_HostUrl = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Git App Host URL')
					SET @gitApp_AccessTokenName = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Git App User Name')
					SET @gitApp_AccessTokenKey = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Git App Access Token')
					SET @gitApp_StagingPathDetails = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName= 'Git App Staging Path Details'),'<App_StagingPathDetails />')
					SET @gitApp_ImpersonationType = (SELECT ISNULL(@gitApp_StagingPathDetails.value('(/App_StagingPathDetails/@impersonationType)[1]', 'nvarchar(2)'),'0') ) -- as 'impersonationType'
					SET @gitApp_StagingPath = (SELECT ISNULL(@gitApp_StagingPathDetails.value('(/App_StagingPathDetails/@stagingPath)[1]', 'nvarchar(max)'),'')) -- as 'stagingPath'
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								(SELECT
									@gitApp_HostUrl as '@hostURL',
									(SELECT @gitApp_AccessTokenName as '@userName',
										@gitApp_AccessTokenKey as '@password'
									FOR XML PATH('credentials'), TYPE),
									(SELECT
									@gitApp_ImpersonationType as '@impersonationType',
									@gitApp_StagingPath as '@stagingPath',
									@gitApp_StagingPathDetails.query('/App_StagingPathDetails/*')
									FOR XML PATH('stagingPathDetails'),TYPE)
								FOR XML PATH('azureDevopsInstance'), TYPE),
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*')
									FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType IN ( 35, 36)
				BEGIN
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @gAutoDisc = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Cloud Connector Auto Discovery')
					SET @gEnterprise = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Cloud Connector Enterprise')
					SET @gEmailID = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Enterprise email Id')
					SET @gAppClientID = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Enterprise App client Id')
					SET @gAutoDiscMode = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Auto Discovery Mode'), 0)
					SET @gAutoManageContent = (SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Auto Manage Content')
					SET @gDomainName = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'V2CloudApps Domain Name'),'')
					SET @RegExSubclientsEnabled = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'RegEx Subclients Enabled'), 0)
					SET @MsCloudRegion = ISNULL((SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK)  WHERE attrName ='MSCloud Region Type'), 1)
SET @numberOfBackupStreams = ISNULL((SELECT attrVal FROM APP_SubClientProp S, APP_Application A WHERE A.instance = @instId AND (A.subclientStatus & 0x00008 = 0x00008)  AND S.componentNameId = A.id AND S.attrName = 'sys:nStreams' AND S.modified = 0), 1)
					--SET @userCount = ISNULL((SELECT attrVal FROM APP_SubClientProp S, APP_Application A WHERE A.instance = @instId AND S.componentNameId = A.id AND S.attrName = 'User Accounts Count' AND S.modified = 0), 0)
					SET @DiscoverStateXml = ISNULL((SELECT CONVERT(varchar(MAX),attrVal) FROM #tempInstanceProperties WITH (NOLOCK) where attrName= 'V2CloudApps Discovery State'),'<App_Office365DiscoverState />')
					SET @discoveryStatus = ISNULL((SELECT  ref.value('@discoveryStatus', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @discoveryProgress = ISNULL((SELECT  ref.value('@discoveryProgress', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @lastCacheUsersCount = ISNULL((SELECT  ref.value('@lastCacheUsersCount', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @lastCacheGroupsCount = ISNULL((SELECT  ref.value('@lastCacheGroupsCount', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @lastCacheUpdateTime = ISNULL((SELECT  ref.value('@lastCacheUpdateTime', 'VARCHAR(125)') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),'')
					SET @totalDiscoveredUsers = ISNULL((SELECT  ref.value('@totalDiscoveredUsers', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @totalDiscoveredGroups = ISNULL((SELECT  ref.value('@totalDiscoveredGroups', 'int') AS Agent FROM    @DiscoverStateXml.nodes('App_Office365DiscoverState') R ( ref )),0)
					SET @ServiceAccountsXml = (SELECT (
												SELECT po.query('.')
												FROM
												(
													SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
													FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName=N'V2CloudApps Service Accounts'
												) PROP
												CROSS APPLY PROP.attrVal.nodes('./App_V2CloudAppsServiceAccounts/accounts') P(po)
												FOR XML PATH(''),TYPE))
					--ADD DUMMY DATA WHEN ACCOUNTS IS EMPTY TO PREVENT ERROR IN XML MODIFY
					IF @ServiceAccountsXml.exist('/accounts') > 0
						BEGIN
							SET @ServiceAccountsXml.modify('delete //@password')
						END
					ELSE
						BEGIN
 							SET @ServiceAccountsXml = '<App_V2CloudAppsServiceAccounts></App_V2CloudAppsServiceAccounts>'
						END
					SET @AzureAppsXml = (SELECT (
												SELECT po.query('.')
												FROM
												(
													SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
													FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName=N'V2CloudApps Azure Connections'
												) PROP
												CROSS APPLY PROP.attrVal.nodes('./App_Office365AzureConnections/azureApps') P(po)
												FOR XML PATH(''),TYPE))
					IF @AzureAppsXml.exist('/azureApps') > 0
						BEGIN
							SET @AzureAppsXml.modify('delete //@azureAppKeyValue')
						END
					ELSE
						BEGIN
 							SET @AzureAppsXml =  '<App_Office365AzureConnections></App_Office365AzureConnections>'
						END
					Select TOP 1 @storagePolicyId = APP.dataArchGrpID  , @storagePolicyName = ARCH.name
					FROM APP_Application APP (NOLOCK) JOIN archGroup ARCH (NOLOCK) on APP.dataArchGrpID = ARCH.id
					WHERE APP.instance = @instId and APP.subclientStatus <> 32
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								(SELECT
									@gAutoDisc as '@isAutoDiscoveryEnabled',
									@gEnterprise as '@isEnterprise',
									@gAutoDiscMode as '@autoDiscoveryMode',
									@gAutoManageContent as '@manageContentAutomatically',
									@gDomainName as '@domainName',
									@RegExSubclientsEnabled as '@additionalSubclientscreated',
									@MsCloudRegion as '@cloudRegion',
									( SELECT @ServiceAccountsXml
										FOR XML PATH('serviceAccounts'),TYPE),
									(SELECT @AzureAppsXml
										FOR XML PATH('azureAppList'),TYPE),
									(SELECT @discoveryStatus as 'discoveryStatus',
											@discoveryProgress as 'discoveryProgress',
											@lastCacheUpdateTime as 'lastCacheUpdateTime',
											@lastCacheUsersCount as 'lastCacheUsersCount',
											@lastCacheGroupsCount as 'lastCacheGroupsCount',
											@totalDiscoveredUsers as 'totalDiscoveredUsers',
											@totalDiscoveredGroups as 'totalDiscoveredGroups'
										FOR XML PATH('discoverState'),TYPE)
								FOR XML PATH('v2CloudAppsInstance'), TYPE),
								(SELECT @numberOfBackupStreams as '@numberOfBackupStreams',
								@userCount as '@userAccountsCount',
								@gProxyServersXml.query('/App_GeneralCloudProperties/*'),
								(SELECT [dataBackupStoragePolicy/@storagePolicyId] = @storagePolicyId,
								[dataBackupStoragePolicy/@storagePolicyName] = @storagePolicyName
								FOR XML PATH('storageDevice'), TYPE),
								(SELECT
									C.id AS '@clientId',
									C.displayName AS '@clientName',
3 as '@_type_'
									FROM #tempInstanceProperties  T
									JOIN APP_Client C (NOLOCK) ON C.id = T.attrVal
										WHERE T.attrName = 'V2CloudApps Index Server'
									FOR XML PATH('indexServer') , TYPE)
									FOR XML PATH('generalCloudProperties'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE IF @cloudInstType  = 37 -- Google Spanner
				BEGIN
					DECLARE @projectId NVARCHAR(1024) = N''
					DECLARE @instanceId NVARCHAR(1024) = N''
					DECLARE @cloudStagingPath NVARCHAR(1024) = N''
					SET @gProxyServersXml = ISNULL((SELECT attrVal FROM #tempInstanceProperties WHERE attrName = 'Google Cloud Proxy Clients'), '<App_GeneralCloudProperties />')
					SET @projectId = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Google Cloud Spanner Project')
					SET @instanceId = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Google Cloud Spanner Instance')
					SET @cloudStagingPath = (SELECT attrVal FROM #tempInstanceProperties WITH (NOLOCK) WHERE attrName = 'Google Cloud Spanner Staging Path')
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType',
								(SELECT @gProxyServersXml.query('/App_GeneralCloudProperties/*')
								FOR XML PATH('generalCloudProperties'), TYPE),
								(SELECT
									@projectId as '@projectId',
									@instanceId as '@instanceId',
									@cloudStagingPath as '@cloudStagingPath'
								FOR XML PATH('cloudSpannerInstance'), TYPE)
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				ELSE
				BEGIN
					SET @cloudAppsInstanceProp =
							(SELECT
								@cloudInstType as '@instanceType'
							FOR XML PATH('cloudAppsInstance'), TYPE)
				END
				INSERT INTO @CloudAppsInstanceInfo VALUES (@instId, @cloudAppsInstanceProp)
			END
			SET @instanceActivityControl = '<entity instanceId="' + STR(@instId) + '"/>'
			EXEC [dbo].[APPGetActivityControlXML]
			@xmlText = @instanceActivityControl OUTPUT
			INSERT INTO @ActivityControl values(@instId,@instanceActivityControl)
			TRUNCATE  table  #tempInstanceProperties -- Delete all the records before inserting properties for next instance
		--	FETCH NEXT FROM @instanceCur INTO @instId
CONTINUE_NEXT_INSTANCE:
			FETCH NEXT FROM @instanceCur INTO @instId, @instName,@appName, @clientID, @clientName,@errorCode,@errorString
		END--END cursor fetch loop
		DEALLOCATE @instanceCur
DECLARE @scIdxEnabled INT = ISNULL((SELECT 1 FROM APP_IDAName IDA WITH (NOLOCK) JOIN APP_IDAProp IDAP WITH (NOLOCK)
	ON IDA.id = IDAP.componentNameId AND IDA.clientId = @clientId AND IDA.appTypeId = @appTypeId AND IDAP.attrName = 'Subclient Index' and IDAP.attrVal = '1' and IDAP.modified = 0),0)
--application size of an Instance
DECLARE @applicationSize BIGINT = ISNULL((SELECT SUM(AppSizeMB)*1024*1024 -- to bytes
											FROM
												(
													SELECT InstanceId, AppsizeMB,
													ROW_NUMBER() OVER(PARTITION BY SubclientId ORDER BY rankOrder ASC) AS rownum
													FROM(
															SELECT
																LC.InstanceId,
																LC.AppsizeMB,
																LC.SubclientId,
																(CASE LC.UsageType WHEN 1 THEN 1 WHEN 2 THEN 2 WHEN 4 THEN 3 WHEN 3 THEN 4 END) as rankOrder
															FROM Lic_CurrentUsage LC WITH(NOLOCK)
															WHERE LC.InstanceId = @instId AND LC.UsageType in (1,2,3,4)
													) TMP
												)LIC
											WHERE LIC.rownum=1
											GROUP BY InstanceId	),0)
DECLARE @xmlQuery XML
SET @xmlQuery =  (SELECT
								instanceVersion AS '@version',
								instanceDescription AS '@description',
								@scIdxEnabled AS '@scIdxEnabled',
								@applicationSize AS '@applicationSize',
								isDeleted as '@isDeleted',
								clientAppType as '@clientAppType',
									(select security  FROM @userGroups AS ug --modified
									WHERE ug.instanceID = InstInfoMain.instanceID
											FOR XML PATH (''),TYPE),
									(select securitynew AS 'securityAssociations'
									FROM @userGroups AS ug
									WHERE ug.instanceID = InstInfoMain.instanceId
									FOR XML PATH(''), TYPE),
								--START:MSSQL Instance Info
								(SELECT instanceID AS '@instanceId',
										dbo.encodeInvalidXMLChar(instanceName) AS '@instanceName',
										appID AS '@applicationId',
										appname AS '@appName',
										clientID AS '@clientId',
										clientName AS '@clientName',
										clientDisplayName AS '@displayName',
										guid AS '@instanceGUID'
										FROM @InstanceInfo AS InstInfo
										WHERE InstInfo.instanceID = InstInfoMain.instanceID  AND InstInfo.appID=InstInfoMain.appID
								FOR XML PATH('instance'), TYPE),
								(SELECT vDITimeOut AS '@vDITimeOut',
										serverType AS '@serverType',
										useVSS AS '@useVss',
										enableSQLTransLogStaging AS '@enableSQLTransLogStaging',
										protectingSPDBs AS '@protectingSPDBs',
										overrideHigherSettings	AS '@overrideHigherSettings',
										overwriteAwsHigherLevelSettings AS '@overwriteAwsHigherLevelSettings',
										instanceStatus AS '@instanceStatus',
											(SELECT mssqlInfo.offloadFullBkpJobToSecondary AS '@offloadFullBkpJobToSecondary',
											(SELECT availabilityGroup.value('(/App_SQLAvailabilityGroup/@name)[1]','nvarchar(max)')as '@name',
													availabilityGroup.value('(/App_SQLAvailabilityGroup/@primaryReplicaServerName)[1]','nvarchar(max)')as '@primaryReplicaServerName',
													availabilityGroup.value('(/App_SQLAvailabilityGroup/@uniqueId)[1]','nvarchar(max)')as '@uniqueId',
													availabilityGroup.value('(/App_SQLAvailabilityGroup/@backupPreference)[1]','int')as '@backupPreference',
													availabilityGroup.query('//App_SQLAvailabilityGroup/SQLAvailabilityGroupListenerList')
											FOR XML PATH ('availabilityGroup'),TYPE),
											(SELECT
											SQLAvailabilityReplicasList.query('//App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList')
											FOR XML PATH ('SQLAvailabilityReplicasList'),TYPE),
											(SELECT mssqlInfo.proxyClientId AS '@clientId',
													mssqlInfo.proxyClientName AS '@clientName'
													FOR XML PATH ('proxyClient'),TYPE)
											FOR XML PATH('agProperties'),TYPE),
											(SELECT overrideGlobalAuthentication AS '@overrideGlobalAuthentication',
													useLocalSystemAccount AS '@useLocalSystemAccount',
													(SELECT userName AS '@userName'
														--userPassword AS '@password'
														FROM @MSSQLAccountsInfo AS mssqlInfo2
														WHERE mssqlInfo2.instanceID = mssqlInfo.instanceID
														FOR XML PATH('userAccount'), TYPE)
													FROM @MSSQLAccountsInfo AS mssqlaccountInfo
													WHERE mssqlaccountInfo.instanceID = mssqlInfo.instanceID
													FOR XML PATH('overrideHigherLevelSettings'), TYPE),
											(SELECT	azureTenantId	'@azureTenantId',
													azureClientId	'@azureClientId',
													azureSubscriptionId	'@azureSubscriptionId',
													azureStorageConnectionString	'@azureStorageConnectionString',
													azureAuthenticationMethod	'@azureAuthenticationMethod',
													thumbprint	'@thumbprint',
													(SELECT azureUsername as '@userName'
															--azurePassword as '@password'
															FOR XML PATH('azureCredentials'),TYPE),
													(SELECT azureSQLUsername as '@userName'
															--azureSQLPassword as '@password'
															FOR XML PATH('azureSqlInstanceCredentials'),TYPE)
													FOR XML PATH('azureInfo'),TYPE),
											(SELECT awsAccessKey   '@accessKey',
													awsSecretKey   '@secretKey',
													s3BucketName     '@s3BucketName',
													(SELECT awsSqlInstanceUsername as '@userName'
														--awsSqlInstancePassword as '@password'
														FOR XML PATH('sqlInstanceCredentials'),TYPE)
													FOR XML PATH('awsSqlInfo'),TYPE),
											(SELECT @dbVmMemberServers.query('/App_MemberServers/*')
											FOR XML PATH('proxies'), TYPE)
										FROM @MSSQLInfo AS mssqlInfo
										WHERE mssqlInfo.instanceID = InstInfoMain.instanceID
								FOR XML PATH('mssqlInstance'), TYPE),
								--END:MSSQL Instance Info
								(SELECT DatabaseID AS '@DBID',
										OracleHome AS '@oracleHome',
										useCatalogConnect AS '@useCatalogConnect',
										TNSAdminPath AS '@TNSAdminPath',
										DisableRMANcrosscheck AS '@disableRMANcrosscheck',
										crossCheckTimeout AS '@crossCheckTimeout',
										CtrlFileAutoBackup AS '@ctrlFileAutoBackup',
										OracleBlockSize AS '@blockSize',
										EncryptionFlag AS '@encryptionFlag',
										IsOnDemand AS '@isOnDemand',
										clientOSType AS '@clientOSType',
										isRMANEnableForTapeMovement as '@isRMANEnableForTapeMovement',
										OverrideDataPathsForCmdPolicy AS '@overrideDataPathsForCmdPolicy',
										OverrideDataPathsForLogPolicy AS '@overrideDataPathsForLogPolicy',
										numberOfArchiveLogBackupStreams AS '@numberOfArchiveLogBackupStreams',
										isCDBInstance AS '@isCDBInstance',
										overrideLocalSystemAccount AS '@overrideLocalSystemAccount',
										oracleWalletAuthentication AS '@oracleWalletAuthentication',
										storageType AS '@storageType',
										dbName AS '@dbname',
										(SELECT oracleInfo.dbThinClientProxyList.query('/App_BackupConfigurationNodes/*')
											FOR XML PATH('proxyClients'), TYPE),
										 (SELECT OracleUserDomain AS '@domainName', OracleUserName AS '@userName'
												--OraclePassword AS '@password'
												FROM @OracleInfo AS oracleInfo1
												WHERE oracleInfo1.instanceID = oracleInfo.instanceID
												FOR XML PATH('oracleUser'), TYPE),
										(SELECT sqlConnectMachine AS '@domainName',
												sqlConnectUser AS '@userName'
												--sqlConnectPassword AS '@password'
												FROM @OracleInfo AS oracleInfo2
												WHERE oracleInfo2.instanceID = oracleInfo.instanceID
												FOR XML PATH('sqlConnect'), TYPE),
										(SELECT catalogConnectMachine AS '@domainName',
												catalogConnectUser AS '@userName'
												--catalogConnectPassword AS '@password'
												FROM @OracleInfo AS oracleInfo2
												WHERE oracleInfo2.instanceID = oracleInfo.instanceID
												FOR XML PATH('catalogConnect'), TYPE),
										(SELECT SoftwareCompression AS '@softwareCompression',
												NetworkAgents AS '@networkAgents',
												ThrottleNetworkBandwidth AS '@throttleNetworkBandwidth',
												(SELECT CommandLineStoragePolicyID AS '@storagePolicyId',
														CommandLineStoragePolicyName AS '@storagePolicyName'
														FROM @OracleInfo AS oracleInfo3
														WHERE oracleInfo3.instanceID = oracleInfo.instanceID
														FOR XML PATH('commandLineStoragePolicy'), TYPE),
												(SELECT LogBackupStoragePolicyID AS '@storagePolicyId',
														LogBackupStoragePolicyName AS '@storagePolicyName'
														FROM @OracleInfo AS oracleInfo3
														WHERE oracleInfo3.instanceID = oracleInfo.instanceID
														FOR XML PATH('logBackupStoragePolicy'), TYPE),
												(SELECT Deduplication AS '@generateSignature'
														FROM @OracleInfo AS oracleInfo3
														WHERE oracleInfo3.instanceID = oracleInfo.instanceID
														FOR XML PATH('deDuplicationOptions'), TYPE)
												FROM @OracleInfo AS oracleInfo2
												WHERE oracleInfo2.instanceID = oracleInfo.instanceID
												FOR XML PATH('oracleStorageDevice'), TYPE),
									(SELECT logDest AS '@val'
									FROM	@oralceArhiveLogDest WHERE instanceID = InstInfoMain.instanceID FOR XML PATH('archiveLogDest'), TYPE),
									(SELECT dataPathId AS '@dataPathId', dataType as '@dataType', backupType as '@backupType', precedence as '@precedence',flags as '@flags'
									FROM	@logAppToDataPath
									WHERE instanceID = InstInfoMain.instanceID FOR XML PATH('logDataPaths'), TYPE),
									(SELECT dataPathId AS '@dataPathId', 2 as '@dataType', backupType as '@backupType', precedence as '@precedence',flags as '@flags'
									FROM	@cmdlineAppToDataPath
									WHERE instanceID = InstInfoMain.instanceID FOR XML PATH('cmdLinePaths'), TYPE)
										FROM @OracleInfo AS oracleInfo
										WHERE oracleInfo.instanceID = InstInfoMain.instanceID
								FOR XML PATH('oracleInstance'), TYPE),
								(SELECT databaseName AS '@databaseName',
										hdbuserstorekey AS '@hdbuserstorekey',
										hdbsqlLocationDirectory AS '@hdbsqlLocationDirectory',
										libPaths AS '@libPaths',
										cmdBackupPrefix AS '@cmdBackupPrefix',
										cmdlineThresholdStreams AS '@cmdlineThresholdStreams',
										enableCmdlineThreshold AS '@enableCmdlineThreshold',
										logBackupPrefix AS '@logBackupPrefix',
										logDataThresholdStreams AS '@logDataThresholdStreams',
										enableLogDataThreshold AS '@enableLogDataThreshold',
										clientOSType AS '@clientOSType',
										isRMANEnableForTapeMovement as '@isRMANEnableForTapeMovement',
										dbInstanceNumber AS '@dbInstanceNumber',
										isUsehdbStoreKey AS '@isUsehdbStoreKey',
										containerMode AS '@containerMode',
										isolationLevel AS '@isolationLevel',
										hanaVersion AS '@hanaVersion',
										spsVersion AS '@spsVersion',
										numberOfNodes AS '@numberOfNodes',
										sslEnabled AS '@sslEnabled',
										sslProvider AS '@sslProvider',
										sslTrustStore AS '@sslTrustStore',
										logBackupFrequency AS '@logBackupFrequency',
										(SELECT	SAPHANAUser AS '@userName'
												FROM @SapHanaInfo
										FOR XML PATH('SAPHANAUser'), TYPE),
										(SELECT	SAPHANADbUser AS '@userName',
												SAPHANADbDomain AS '@domainName'
												FROM @SapHanaInfo
												FOR XML PATH('dbUser'), TYPE),
										(Select D.clientID as '@clientId',
										        D.clientName as '@clientName'
										        FROM @DBInstances D
												WHERE D.instanceId = InstInfoMain.instanceID
										        FOR XML PATH ('DBInstances'),TYPE),
										(SELECT SoftwareCompression AS '@softwareCompression',
												NetworkAgents AS '@networkAgents',
												ThrottleNetworkBandwidth AS '@throttleNetworkBandwidth',
												(SELECT CommandLineStoragePolicyID AS '@storagePolicyId',
														CommandLineStoragePolicyName AS '@storagePolicyName'
														FROM @SapHanaInfo AS SapHanaInfo3
														WHERE SapHanaInfo3.instanceID = SapHanaInfo.instanceID
														FOR XML PATH('commandLineStoragePolicy'), TYPE),
												(SELECT LogBackupStoragePolicyID AS '@storagePolicyId',
														LogBackupStoragePolicyName AS '@storagePolicyName'
														FROM @SapHanaInfo AS SapHanaInfo3
														WHERE SapHanaInfo3.instanceID = SapHanaInfo.instanceID
														FOR XML PATH('logBackupStoragePolicy'), TYPE),
												(SELECT Deduplication AS '@generateSignature'
														FROM @SapHanaInfo AS SapHanaInfo3
														WHERE SapHanaInfo3.instanceID = SapHanaInfo.instanceID
														FOR XML PATH('deDuplicationOptions'), TYPE)
												FROM @SapHanaInfo AS SapHanaInfo2
												WHERE SapHanaInfo2.instanceID = SapHanaInfo.instanceID
												FOR XML PATH('saphanaStorageDevice'), TYPE)
										FROM @SapHanaInfo AS SapHanaInfo
										WHERE SapHanaInfo.instanceID = InstInfoMain.instanceID
								FOR XML PATH('saphanaInstance'), TYPE),
								(SELECT
										useCatalogConnect AS '@useCatalogConnect',
										CtrlFileAutoBackup AS '@ctrlFileAutoBackupType',
										OracleBlockSize AS '@blockSize',
										EncryptionFlag AS '@encryptionFlag',
										DisableRMANcrosscheck AS '@disableRMAN',
										isCDBInstance AS '@isCDBInstance',
										oracleWalletAuthentication AS '@oracleWalletAuthentication',
										storageType AS '@storageType',
										IsOnDemand AS '@isOnDemand',
										(SELECT sqlConnectMachine AS '@domainName',
												sqlConnectUser AS '@userName'
												FROM @OracleRACInfo
										FOR XML PATH('connectString'), TYPE),
										(SELECT SoftwareCompression AS '@softwareCompression',
												NetworkAgents AS '@networkAgents',
												ThrottleNetworkBandwidth AS '@throttleNetworkBandwidth',
												(SELECT DataBackupStoragePolicyID AS '@storagePolicyId',
														DataBackupStoragePolicyName AS '@storagePolicyName',
														17 AS '@_type_'
													FOR XML PATH('commandLineStoragePolicy'), TYPE),
												(SELECT DataBackupStoragePolicyID AS '@storagePolicyId',
														DataBackupStoragePolicyName AS '@storagePolicyName',
														17 AS '@_type_'
													FOR XML PATH('dataBackupStoragePolicy'), TYPE),
												(SELECT LogBackupStoragePolicyID AS '@storagePolicyId',
														LogBackupStoragePolicyName AS '@storagePolicyName',
														17 AS '@_type_'
													FOR XML PATH('logBackupStoragePolicy'), TYPE),
												(SELECT (CASE WHEN generateSignature >= 1 THEN 1 ELSE 0 END) AS '@enableDeduplication',
														generateSignature AS '@generateSignature'
													FOR XML PATH('deDuplicationOptions'), TYPE)
												FROM @OracleRACInfo
										FOR XML PATH('storageDevice'), TYPE),
										(SELECT instanceOracleSID AS '@instanceOracleSID',
												oracleHome AS '@oracleHome',
												tnsAdminFolder AS '@tnsAdminFolder',
												status AS '@oracleRacDBStatus',
												oracleRACDBInstanceID AS '@racDbInstanceId',
												(SELECT sqlConnectMachine AS '@serviceName',
														sqlConnectUser AS '@userName'
												FROM @OracleRACDBInfo AS oracleRACInfo1
												WHERE oracleRACInfo1.oracleRACDBInstanceID = oracleRACInfo.oracleRACDBInstanceID
												FOR XML PATH('connectString'), TYPE),
												(SELECT userAccount AS '@userName'
												FROM @OracleRACDBInfo AS oracleRACInfo1
												WHERE oracleRACInfo1.oracleRACDBInstanceID = oracleRACInfo.oracleRACDBInstanceID
												FOR XML PATH('userAccount'), TYPE),
												(SELECT instancePhysicalClient AS '@clientId', clientName AS '@clientName',
														3 AS '@_type_'
												FROM @OracleRACDBInfo AS oracleRACInfo1
												WHERE oracleRACInfo1.oracleRACDBInstanceID = oracleRACInfo.oracleRACDBInstanceID
												FOR XML PATH('instancePhysicalClient'),TYPE)
												FROM @OracleRACDBInfo AS oracleRACInfo
												WHERE oracleRACInfo.oracleInstanceID = InstInfoMain.instanceID
										FOR XML PATH('racDBInstance'), TYPE)
								FROM @OracleRACInfo
								FOR XML PATH('oracleRACInstance'), TYPE),
								(SELECT O.isRMANEnableForTapeMovement as '@isRMANEnableForTapeMovement',
										O.dbName as '@dbname'
									FROM @OracleRACInfo AS O
								FOR XML PATH('oracleInstance'), TYPE),
								(SELECT DatabaseID AS '@DBID',
										OracleHome AS '@oracleHome',
										SAPDataPath AS '@sapDataPath',
										SAPExeFolder AS '@sapExeFolder',
										EncryptionFlag AS '@encryptionFlag',
										IsOnDemand AS '@isOnDemand',
										clientOSType AS '@clientOSType',
										OverrideDataPathsForCmdPolicy AS '@overrideDataPathsForCmdPolicy',
										OverrideDataPathsForLogPolicy AS '@overrideDataPathsForLogPolicy',
										numberOfArchiveLogBackupStreams AS '@numberOfArchiveLogBackupStreams',
										OracleBlockSize AS '@blockSize',
										UseSAPSecureStore AS '@useSAPSecureStore',
										(SELECT OracleUserDomain AS '@domainName', OracleUserName AS '@userName'
												--OraclePassword AS '@password'
												FROM @SAPOracleInfo AS oracleInfo1
												WHERE oracleInfo1.instanceID = oracleInfo.instanceID
												FOR XML PATH('oracleUser'), TYPE),
										(SELECT sqlConnectMachine AS '@domainName',
												sqlConnectUser AS '@userName'
												--sqlConnectPassword AS '@password'
												FROM @SAPOracleInfo AS oracleInfo2
												WHERE oracleInfo2.instanceID = oracleInfo.instanceID
												FOR XML PATH('sqlConnect'), TYPE),
										(SELECT SoftwareCompression AS '@softwareCompression',
												NetworkAgents AS '@networkAgents',
												ThrottleNetworkBandwidth AS '@throttleNetworkBandwidth',
												(SELECT CommandLineStoragePolicyID AS '@storagePolicyId',
														CommandLineStoragePolicyName AS '@storagePolicyName'
														FROM @SAPOracleInfo AS oracleInfo3
														WHERE oracleInfo3.instanceID = oracleInfo.instanceID
														FOR XML PATH('commandLineStoragePolicy'), TYPE),
												(SELECT LogBackupStoragePolicyID AS '@storagePolicyId',
														LogBackupStoragePolicyName AS '@storagePolicyName'
														FROM @SAPOracleInfo AS oracleInfo3
														WHERE oracleInfo3.instanceID = oracleInfo.instanceID
														FOR XML PATH('logBackupStoragePolicy'), TYPE),
												(SELECT Deduplication AS '@generateSignature'
														FROM @SAPOracleInfo AS oracleInfo3
														WHERE oracleInfo3.instanceID = oracleInfo.instanceID
														FOR XML PATH('deDuplicationOptions'), TYPE)
												FROM @SAPOracleInfo AS oracleInfo2
												WHERE oracleInfo2.instanceID = oracleInfo.instanceID
												FOR XML PATH('oracleStorageDevice'), TYPE)
												--SNAP
												,(SELECT @isSnapBackupEnabled '@isSnapBackupEnabled',
													@useSourceProxyUnreachable '@useSourceProxyUnreachable',
													@allowMultipleDataReaders   '@allowMultipleDataReaders',
													(SELECT @proxyEngineId '@snapShotEngineId', @proxyEngineName '@snapShotEngineName' FOR XML PATH('snapSelectedEngine'), TYPE),
													(SELECT @proxyId '@clientId', @proxyName '@clientName' FOR XML PATH('proxyToUse'), TYPE)
													FOR XML PATH('snapProtectInfo'), TYPE)
												--END SNAP
										FROM @SAPOracleInfo AS oracleInfo
										WHERE oracleInfo.instanceID = InstInfoMain.instanceID
								FOR XML PATH('sapOracleInstance'), TYPE),
								(SELECT EncryptionFlag AS '@encryptionFlag',
										OverrideDataPathsForCmdPolicy AS '@overrideDataPathsForCmdPolicy',
										OverrideDataPathsForLogPolicy AS '@overrideDataPathsForLogPolicy',
										binDir AS '@binDir',
										dbmcliPath AS '@dbmcliPath',
										(SELECT osUser AS '@userName'
											FOR XML PATH ('osUser'), TYPE),
										(SELECT dbUser AS '@userName'
											FOR XML PATH ('dbUser'), TYPE),
										(SELECT SoftwareCompression AS '@softwareCompression',
												NetworkAgents AS '@networkAgents',
												ThrottleNetworkBandwidth AS '@throttleNetworkBandwidth',
												(SELECT CommandLineStoragePolicyID AS '@storagePolicyId',
														CommandLineStoragePolicyName AS '@storagePolicyName'
														FROM @SAPMAXDBInfo AS oracleInfo3
														WHERE oracleInfo3.instanceID = sapMAXDBInfo.instanceID
														FOR XML PATH('commandLineStoragePolicy'), TYPE),
												(SELECT LogBackupStoragePolicyID AS '@storagePolicyId',
														LogBackupStoragePolicyName AS '@storagePolicyName'
														FROM @SAPMAXDBInfo AS oracleInfo3
														WHERE oracleInfo3.instanceID = sapMAXDBInfo.instanceID
														FOR XML PATH('logBackupStoragePolicy'), TYPE),
												(SELECT Deduplication AS '@generateSignature'
														FROM @SAPMAXDBInfo AS oracleInfo3
														WHERE oracleInfo3.instanceID = sapMAXDBInfo.instanceID
														FOR XML PATH('deDuplicationOptions'), TYPE)
												FROM @SAPMAXDBInfo AS oracleInfo2
												WHERE oracleInfo2.instanceID = sapMAXDBInfo.instanceID
												FOR XML PATH('sapMAXDBStorageDevice'), TYPE)
										FROM @SAPMAXDBInfo AS sapMAXDBInfo
										WHERE sapMAXDBInfo.instanceID = InstInfoMain.instanceID
								FOR XML PATH('sapMAXDBInstance'), TYPE),
								(SELECT VSInstanceType AS '@vsInstanceType',
										esxServerToMount AS '@esxServerToMount',
										(SELECT
													(SELECT userName AS '@userName',
														--userPassword AS '@password',
														ServerHostName AS '@domainName'
													FROM @ServerInfo AS serverInfo
													WHERE serverInfo.instanceID = vmwareInfo.instanceID
													FOR XML PATH('virtualCenter'), TYPE),
													(SELECT userName AS '@userName',
															--userPassword AS '@password',
															ServerHostName AS '@domainName'
															FROM @ESXServerInfo AS esxserverInfo1
													WHERE esxserverInfo1.instanceID = vmwareInfo.instanceID
													FOR XML PATH('esxServers'), TYPE)
										FROM @VMWareInfo AS vmwareInfo1
										WHERE vmwareInfo1.instanceID = vmwareInfo.instanceID
										FOR XML PATH('vmwareVendor'), TYPE),
										-- MemberServers associatedClients
										(SELECT vmwareInfo2.vmMemberServers.query('/App_MemberServers/*')
										FROM @VMWareInfo AS vmwareInfo2
										WHERE vmwareInfo2.instanceID = vmwareInfo.instanceID
										FOR XML PATH('associatedClients'), TYPE),
										(SELECT
											(SELECT userName AS '@userName',
													--userPassword AS '@password',
													ServerHostName AS '@domainName'
													FROM @XenServerInfo AS xenserverInfo
											WHERE xenserverInfo.instanceID = vmwareInfo.instanceID
											FOR XML PATH('xenServers'), TYPE)
										FOR XML PATH('xenServer'), TYPE),
										(SELECT accessKey AS '@accessKey',
												useIamRole AS '@useIamRole',
												enableAdminAccount AS '@enableAdminAccount',
												adminInstanceID AS '@adminInstanceId'
										FROM @AmazonInstanceInfo as amazonInstanceInfo
										WHERE amazonInstanceInfo.instanceID = vmwareInfo.instanceID
										FOR XML PATH('amazonInstanceInfo'), TYPE),
										(SELECT enableAdminAccount AS '@enableAdminAccount',
												adminInstanceID AS '@adminInstanceId'
										FROM @AdminInstanceInfo as adminInstanceInfo
										WHERE adminInstanceInfo.instanceID = vmwareInfo.instanceID
										FOR XML PATH('adminInstanceInfo'), TYPE),
										(SELECT  vOrgName AS '@vOrgName',
												 vOrgGuid AS '@vOrgGuid'
										FROM @VcloudInstanceInfo as vCloudInstanceInfo
										WHERE vCloudInstanceInfo.instanceID = vmwareInfo.instanceID
										FOR XML PATH('vCloudInstanceInfo'), TYPE)
								FROM @VMWareInfo AS vmwareInfo
								WHERE vmwareInfo.instanceID = InstInfoMain.instanceID
								FOR XML PATH('virtualServerInstance'), TYPE),
								(SELECT homeDirectory AS '@homeDirectory',
										encryptionFlag AS '@encryptionFlag',
										(SELECT ServerHostName AS '@domainName',
												userName AS '@userName'
												--userPassword AS '@password'
												FROM @DB2Info AS db2Info1
												WHERE db2Info1.instanceID = db2Info.instanceID
												FOR XML PATH('userAccount'), TYPE),
										(SELECT	D.nodeNum AS '@nodenum',
												D.clientID AS 'nodeClient/@clientId',
												C.name AS 'nodeClient/@clientName',
												C.displayName AS 'nodeClient/@displayName',
												C.net_hostName AS 'nodeClient/@hostName'
										FROM	@DB2Nodes D
											INNER JOIN APP_Client C
												ON D.clientId = C.id
										WHERE	D.instanceId = InstInfoMain.instanceID
										FOR XML PATH('dpfpartitionclients'), TYPE),
										(SELECT SoftwareCompression AS '@softwareCompression',
												NetworkAgents AS '@networkAgents',
												ThrottleNetworkBandwidth AS '@throttleNetworkBandwidth',
												(SELECT DataBackupStoragePolicyID AS '@storagePolicyId',
														DataBackupStoragePolicyName AS '@storagePolicyName'
														FROM @DB2Info AS db2Info3
														WHERE db2Info3.instanceID = db2Info.instanceID
														FOR XML PATH('dataBackupStoragePolicy'), TYPE),
												(SELECT CommandLineStoragePolicyID AS '@storagePolicyId',
														CommandLineStoragePolicyName AS '@storagePolicyName'
														FROM @DB2Info AS db2Info3
														WHERE db2Info3.instanceID = db2Info.instanceID
														FOR XML PATH('commandLineStoragePolicy'), TYPE),
												(SELECT LogBackupStoragePolicyID AS '@storagePolicyId',
														LogBackupStoragePolicyName AS '@storagePolicyName'
														FROM @DB2Info AS db2Info3
														WHERE db2Info3.instanceID = db2Info.instanceID
														FOR XML PATH('logBackupStoragePolicy'), TYPE),
												(SELECT (CASE WHEN Deduplication >= 1 THEN 1 ELSE 0 END) AS '@enableDeduplication',
														Deduplication AS '@generateSignature'
														FROM @DB2Info AS db2Info3
														WHERE db2Info3.instanceID = db2Info.instanceID
														FOR XML PATH('deDuplicationOptions'), TYPE)
												FROM @DB2Info AS db2Info2
												WHERE db2Info2.instanceID = db2Info.instanceID
												FOR XML PATH('DB2StorageDevice'), TYPE)
										FROM @DB2Info AS db2Info
										WHERE db2Info.instanceID = InstInfoMain.instanceID
								FOR XML PATH('db2Instance'), TYPE),
								(SELECT homeDirectory AS '@informixDir',
										onConfigFile AS '@onConfigFile',
										sqlHostfile AS '@sqlHostfile',
										(SELECT userName AS '@userName',domainName AS '@domainName'
												--userPassword AS '@password'
												FROM @InformixInfo AS informixInfo1
												WHERE informixInfo1.instanceID = informixInfo.instanceID
												FOR XML PATH('informixUser'), TYPE),
										(SELECT SoftwareCompression AS '@softwareCompression',
												(SELECT CommandLineStoragePolicyID AS '@storagePolicyId',
														CommandLineStoragePolicyName AS '@storagePolicyName'
														FROM @InformixInfo AS informixInfo3
														WHERE informixInfo3.instanceID = informixInfo.instanceID
														FOR XML PATH('commandLineStoragePolicy'), TYPE),
												(SELECT LogBackupStoragePolicyID AS '@storagePolicyId',
														LogBackupStoragePolicyName AS '@storagePolicyName'
														FROM @InformixInfo AS informixInfo3
														WHERE informixInfo3.instanceID = informixInfo.instanceID
														FOR XML PATH('logBackupStoragePolicy'), TYPE),
												(SELECT Deduplication AS '@generateSignature'
														FROM @InformixInfo AS informixInfo3
														WHERE informixInfo3.instanceID = informixInfo.instanceID
														FOR XML PATH('deDuplicationOptions'), TYPE)
												FROM @InformixInfo AS informixInfo2
												WHERE informixInfo2.instanceID = informixInfo.instanceID
												FOR XML PATH('informixStorageDevice'), TYPE)
										FROM @InformixInfo AS informixInfo
										WHERE informixInfo.instanceID = InstInfoMain.instanceID
								FOR XML PATH('informixInstance'), TYPE),
								(SELECT SybaseHome AS '@sybaseHome',
										SybaseASE AS '@sybaseASE',
										SybaseOCS AS '@sybaseOCS',
										ConfigFile AS '@configFile',
										SharedMemoryDir AS '@sharedMemoryDirectory',
										EnableAutoDiscovery AS '@enableAutoDiscovery',
										sybaseBlockSize AS '@sybaseBlockSize',
										BackupServer as '@backupServer',
										(SELECT userName AS '@userName'
												FROM @SybaseInfo AS sybaseInfo1
												WHERE sybaseInfo1.instanceID = sybaseInfo.instanceID
												FOR XML PATH('localAdministrator'), TYPE),
										(SELECT saUserName AS '@userName'
												FROM @SybaseInfo AS sybaseInfo1
												WHERE sybaseInfo1.instanceID = sybaseInfo.instanceID
												FOR XML PATH('saUser'), TYPE),
										(SELECT	backupserverid AS '@serverId',
												status AS '@serverStatus',
												name AS '@serverName',
												serverclass AS '@serverClass',
												netName AS '@serverNetName',
												serverPname AS '@serverPName'
												FROM @BackupServers B
												WHERE B.instId = sybaseInfo.instanceID
												FOR XML PATH('backupServers'), TYPE)
										FROM @SybaseInfo AS sybaseInfo
										WHERE sybaseInfo.instanceID = InstInfoMain.instanceID
								FOR XML PATH('sybaseInstance'), TYPE),
								(SELECT MaintainenceDB AS '@MaintainenceDB',
										BinaryDirectory AS '@BinaryDirectory',
										LibDirectory AS '@LibDirectory',
										ArchiveLogDirectory AS '@ArchiveLogDirectory',
										port AS '@port',
										ArchiveDelete AS '@ArchiveDelete',
										version AS '@version',
										isStandBy AS '@isStandBy',
										lastLogNumber AS '@lastLogNumber',
										(SELECT SAUserName AS '@userName'
										FOR XML PATH('SAUser'), TYPE),
										(SELECT UNCUserName AS '@userName'
										FOR XML PATH('UNCUser'), TYPE),
										(SELECT logStoragePolicyId AS '@storagePolicyId',
												logStoragePolicyName AS '@storagePolicyName'
										FOR XML PATH('logStoragePolicy'),TYPE),
										(SELECT standByEnabled AS '@isStandbyEnabled',
												useMasterForDataBkp AS '@useMasterForDataBkp',
												useMasterForLogBkp AS '@useMasterForLogBkp',
												(SELECT standbyInstanceId AS '@instanceId',
														ISNULL((SELECT name FROM App_InstanceName WHERE id = standbyInstanceId),'') AS '@instanceName'
												FOR XML PATH('standbyInstance'), TYPE)
										FOR XML PATH('standbyOptions'), TYPE)
								FROM @PostgreSQLInstanceInfo AS PostgreSQLInstanceInfo
								WHERE PostgreSQLInstanceInfo.instanceId = InstInfoMain.instanceId
								FOR XML PATH('postGreSQLInstance'),TYPE),
								(SELECT BinaryDirectory AS '@BinaryDirectory',
										LogDataDirectory AS '@LogDataDirectory',
										ConfigFile AS '@ConfigFile',
										port AS '@port',
										EnableAutoDiscovery AS '@EnableAutoDiscovery',
										archiveLogIndexFile AS '@archiveLogIndexFile',
										version AS '@version',
										dataDirectory AS '@dataDirectory',
										lastLogNumber AS '@lastLogNumber',
										sslCaPath AS '@sslCa',
										sslCert as '@sslCert',
										sslKey as '@sslKey',
										EnableNoLocking AS '@EnableNoLocking',
											(SELECT SAUserName AS '@userName'
										FOR XML PATH('SAUser'), TYPE),
											(SELECT logStoragePolicyId AS '@storagePolicyId',
													logStoragePolicyName AS '@storagePolicyName'
										FOR XML PATH('logStoragePolicy'),TYPE),
											(SELECT
												(SELECT logStoragePolicyId AS '@storagePolicyId',
													logStoragePolicyName AS '@storagePolicyName'
												FOR XML PATH('logBackupStoragePolicy'),TYPE),
												(SELECT commandLineStoragePolicyId AS '@storagePolicyId',
													commandLineStoragePolicyName AS '@storagePolicyName'
												FOR XML PATH('commandLineStoragePolicy'),TYPE)
										FOR XML PATH('mysqlStorageDevice'),TYPE),
											(SELECT NTUserName AS '@userName'
										FOR XML PATH('NTUser'),TYPE),
											(SELECT unixUserName AS '@userName'
										FOR XML PATH('unixUser'),TYPE),
										(SELECT isProxyEnabled AS '@isProxyEnabled',
												isUseSSL AS '@isUseSSL',
												runBackupOnProxy AS '@runBackupOnProxy',
												(SELECT proxyInstanceId AS '@instanceId',
														(SELECT name FROM App_InstanceName WHERE id = proxyInstanceId) AS '@instanceName',
														(SELECT TOP 1 clientId FROM App_Application WHERE instance = proxyInstanceId) AS '@clientId',
														(SELECT TOP 1 name FROM App_Application aa JOIN APP_Client ac ON aa.clientId=ac.id AND aa.instance = proxyInstanceId) AS '@clientName'
												FOR XML PATH('proxyInstance'), TYPE)
										FOR XML PATH('proxySettings'), TYPE),
										(SELECT isXtraBackupEnabled AS '@enableXtraBackup',
												xtraBackupBinPath AS '@xtraBackupBinPath'
										FOR XML PATH('xtraBackupSettings'), TYPE),
										(SELECT enableMEB AS '@enableMEB',
											mebBinPath AS '@mebBinPath'
										FOR XML PATH('mebSettings'), TYPE)
								FROM @MySQLInstanceInfo AS mySQLInstanceProperties
								WHERE mySQLInstanceProperties.instanceId = InstInfoMain.instanceId
								FOR XML PATH('mySqlInstance'),TYPE),
								(SELECT instanceProps
								FROM @DistributedInstanceInfo AS distInstProp
								WHERE distInstProp.instanceID = InstInfoMain.instanceId),
								(SELECT instanceProps
								FROM @CloudAppsInstanceInfo AS cloudAppsInstProp
								WHERE cloudAppsInstProp.instanceID = InstInfoMain.instanceId),
								(SELECT instanceActivityControl
								FROM @ActivityControl AS instActivityControl
								WHERE instActivityControl.instanceID = InstInfoMain.instanceId
								FOR XML PATH (''),TYPE),
								(SELECT		planInfo.planId AS '@planId',
                                            planInfo.planType AS '@planType',
                                            planInfo.planSubType AS '@planSubtype',
                                            planInfo.planName AS '@planName'
								FROM @PlanInfo AS planInfo
								WHERE planInfo.instanceID = InstInfoMain.instanceId
								FOR XML PATH('planEntity'),TYPE),
								(SELECT @overRideAccessNode as '@overRideAccessNode',
										(SELECT @dbVmMemberServers.query('/App_MemberServers/*')
											FOR XML PATH('accessNodes'), TYPE)
								FOR XML PATH('cloudDBInstance'), TYPE),
								(SELECT	IDX.indexPruning AS '@overrideIndexPruning',
										IDX.retDays AS '@indexRetDays',
										IDX.retCycles AS '@indexRetCycle',
										IDX.pruningType AS '@indexPruningType',
										IDX.indexServer.query('/currentIndexServer'),
										IDX.indexMAs.query('/indexMAs/qualifyingIndexServers'),
										IDX.indexBkpSp.query('/currentIndexBackupSP'),
										IDX.indexBkpEligibleSPs.query('/indexBackupSPs/eligibleIndexBackupSP')
								FROM @IndexServerInfo AS IDX
								WHERE IDX.instanceId = InstInfoMain.instanceId
								FOR XML PATH('indexSettings'), TYPE)
						FROM @InstanceInfo AS InstInfoMain
						ORDER BY InstInfoMain.clientName, InstInfoMain.appName, InstInfoMain.instanceName
				FOR XML PATH('instanceProperties'), TYPE)
DECLARE @xmlerrors xml
SET @xmlerrors = (SELECT errorString as '@errorString',
errorCode as '@errorCode',
(SELECT instanceId as '@instanceId', dbo.encodeInvalidXMLChar(instanceName) as '@instanceName', applicationId as '@applicationId',
appName as '@appName', clientid as '@clientId',
		clientName as '@clientName'
		FOR XML PATH('entity'),TYPE)
FROM @errors
FOR XML PATH('errors'),TYPE)
DROP TABLE #tempInstanceProperties
SET @xmlQuery = (SELECT @xmlQuery , @xmlerrors FOR XML PATH('') , ROOT('App_GetInstancePropertiesResponse'))
SELECT @xmlQuery AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetInstanceProperties')
	delete from GxQscripts where name = 'AppGetInstanceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetInstanceProperties')
	delete from GXDBVersions where aliasname = 'AppGetInstanceProperties'
GO

insert into GXDBVersions values(2, 'AppGetInstanceProperties',  '00000000000000000000', 'AppGetInstanceProperties', '00000000000000000000')
GO

