

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetInstalledZookeeperClients.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetInstalledZookeeperClients.sp,v $ $Id: AppGetInstalledZookeeperClients.sp,v 1.1.4.7 2020/07/06 16:49:29 pankajkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetInstalledZookeeperClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetInstalledZookeeperClients <<<'
	drop procedure AppGetInstalledZookeeperClients
END
IF EXISTS (select * from GxQscripts where name='AppGetInstalledZookeeperClients')
	delete from GxQscripts where name = 'AppGetInstalledZookeeperClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetInstalledZookeeperClients')
	delete from GXDBVersions where aliasname = 'AppGetInstalledZookeeperClients'
GO
print '... Creating Procedure: AppGetInstalledZookeeperClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetInstalledZookeeperClients
  @i_clientId INT =0
AS
  DECLARE @o_cloudInfoXML XML
IF object_id('tempdb.dbo.#zkNodeInfo') IS NOT NULL drop table #zkNodeInfo
create table #zkNodeInfo(
					t_nodeClientId    INT,
					t_nodeClientName NVARCHAR(255),
					t_nodeHostName NVARCHAR(255),
					t_zkNodeMetaInfo XML DEFAULT N'<NodeMetaProp><nodeMetaInfos name="zkServerId" value="0" /><nodeMetaInfos name="zkListenerPort" value="8090" /> <nodeMetaInfos name="zkElectionPort" value="8097" /> <nodeMetaInfos name="zkDataPort" value="8091" /><nodeMetaInfos name="zkServerInfo" value="" /><nodeMetaInfos name="zkDataDir" value="" /></NodeMetaProp>',
					t_ListenerPort INT DEFAULT 8090,
					t_ElectionPort INT DEFAULT 8097,
					t_DataPort INT  DEFAULT 8091,
					t_ServerId INT  DEFAULT 0,
					t_instanceNo INT  DEFAULT 0,
					t_serverInfo NVARCHAR(2048) DEFAULT N'',
					t_zkDataDir NVARCHAR(1024) DEFAULT N''
				)
--get all clients with HAC package installed
	INSERT INTO #zkNodeInfo (t_nodeClientId)
	SELECT DISTINCT clientId
	FROM dbo.scgV2CheckPackageInstalled('=', N'<App_AdvanceKeyInfo><packages val="725"/></App_AdvanceKeyInfo>', 0, 0 /*inSCGId*/)
	WHERE @i_clientId =0 OR @i_clientId = clientId
--delete existing clients where HAC is already configured
DELETE Z
FROM #zkNodeInfo Z
JOIN DM2SearchServerCoreInfo S (NOLOCK) ON Z.t_nodeClientId = S.clientId
WHERE S.cloudType = 6
--Get node client instance
UPDATE  #zkNodeInfo
SET t_instanceNo = SUBSTRING (attrVal, LEN(ATTRVAL), LEN(ATTRVAL)) - 1
FROM APP_ClientProp CP (NOLOCK)
INNER JOIN #zkNodeInfo T ON  T.t_nodeClientId = CP.componentNameId AND attrName = 'Galaxy Instance name'
--Get list of hyperscale clients.
DECLARE @hyperscaleClientList TABLE( t_clientId INT)
INSERT INTO @hyperscaleClientList
SELECT DISTINCT C.id
FROM APP_Client C (nolock)
JOIN MMHost H (nolock) ON C.id = H.ClientId
JOIN MMEntityProp E(nolock) ON H.ClientId = E.EntityId
JOIN #zkNodeInfo Z ON Z.t_nodeClientId = H.ClientId
WHERE  E.EntityType = 10 -- Media Agent
AND E.propertyName = 'MediaAgentApplianceType' -- MM_ENTITY_PROP_MEDIAAGENT_APPLIANCE_TYPE
AND E.intVal  IN (2, 1)
--in case of multi instancing portNo + 10 * instanceNum
UPDATE  #zkNodeInfo
SET t_ListenerPort = 8097 + 10 * t_instanceNo,
t_ElectionPort = 8090 + 10 * t_instanceNo,
t_DataPort = 8091 + 10 * t_instanceNo
WHERE t_instanceNo > 0
--update default port no by 10 in case of hyperscale client
UPDATE  Z
SET t_ListenerPort = t_ListenerPort + 10,
t_ElectionPort = t_ElectionPort + 10,
t_DataPort = t_DataPort + 10
FROM #zkNodeInfo Z
JOIN @hyperscaleClientList H ON Z.t_nodeClientId = H.t_clientId
--node client name, hostname
UPDATE #zkNodeInfo
SET t_nodeClientName = C.name,
	t_nodeHostName = C.net_hostName,
t_zkDataDir = REPLACE (C.jobResultDir,'\','/')  +'/' + 'ZKData'
FROM APP_Client C (NOLOCK)
WHERE C.id= t_nodeClientId
SET @o_cloudInfoXML = ISNULL(( SELECT  (SELECT
											(select 1 AS '@opType',
												(SELECT
												  S.t_nodeClientId AS '@clientId',
												  S.t_nodeClientName AS '@clientName',
												  S.t_nodeHostName AS '@hostName'
												  FOR XML PATH ('nodeClientEntity'), TYPE),
												(SELECT
													'zkDataPort' AS '@name',
													S.t_DataPort AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkElectionPort' AS '@name',
													S.t_ElectionPort AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkListenerPort' AS '@name',
													S.t_ListenerPort AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkServerId' AS '@name',
													S.t_ServerId AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkDataDir' AS '@name',
													S.t_zkDataDir AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE),
												(SELECT
													'zkServerInfo' AS '@name',
													S.t_serverInfo AS '@value'
												FOR XML PATH ('nodeMetaInfos'), TYPE)
												FROM #zkNodeInfo S
												ORDER BY S.t_ServerId
                                                FOR XML PATH('cloudNodes'), TYPE)
										FOR XML PATH ('App_CloudInfo'), TYPE)
								 ),'<App_CloudInfo/>')
--OUTPUT
SELECT @o_cloudInfoXML
IF object_id('tempdb.dbo.#zkNodeInfo') IS NOT NULL drop table #zkNodeInfo
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetInstalledZookeeperClients')
	delete from GxQscripts where name = 'AppGetInstalledZookeeperClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetInstalledZookeeperClients')
	delete from GXDBVersions where aliasname = 'AppGetInstalledZookeeperClients'
GO

insert into GXDBVersions values(2, 'AppGetInstalledZookeeperClients',  '00010001000400070000', 'AppGetInstalledZookeeperClients', '00010001000400070000')
GO

