

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexingVersionForThisClient.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2014  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexingVersionForThisClient.sp,v $ $Id: AppGetIndexingVersionForThisClient.sp,v 1.1.2.44 2020/12/16 16:27:41 mmohan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetIndexingVersionForThisClient')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexingVersionForThisClient <<<'
	drop procedure AppGetIndexingVersionForThisClient
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexingVersionForThisClient')
	delete from GxQscripts where name = 'AppGetIndexingVersionForThisClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexingVersionForThisClient')
	delete from GXDBVersions where aliasname = 'AppGetIndexingVersionForThisClient'
GO
print '... Creating Procedure: AppGetIndexingVersionForThisClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetIndexingVersionForThisClient
  @xmlText XML,
  @o_xmlText XML 	OUTPUT
AS
SET NOCOUNT ON;
--
DECLARE @appId int = (SELECT TOP(1) A.id
	FROM APP_Application A WITH (NOLOCK)
	WHERE A.id = (SELECT @xmlText.value('(/Indexing_GetIndexingVersionReq/@appId)[1]', 'int')));
--
DECLARE @clientId int = (SELECT TOP(1) C.id
	FROM APP_Client C WITH (NOLOCK)
	WHERE C.id = (SELECT @xmlText.value('(/Indexing_GetIndexingVersionReq/@clientId)[1]', 'int')));
--
DECLARE @backupsetId int = (SELECT TOP(1) B.id
	FROM APP_BackupSetName B WITH (NOLOCK)
	WHERE B.id = (SELECT @xmlText.value('(/Indexing_GetIndexingVersionReq/@backupsetId)[1]', 'int')));
--
DECLARE @appTypeOverride int = @xmlText.value('(/Indexing_GetIndexingVersionReq/@appTypeOverride)[1]', 'int');
DECLARE @forceV2AfterUpgrade bigint = (SELECT ISNULL(@xmlText.value('(/Indexing_GetIndexingVersionReq/@forceUpgradeTime)[1]', 'bigint'), 0) );
DECLARE @errorCode int = 0;
DECLARE @errorString nvarchar(max) = '';
--
IF @appTypeOverride IS NULL OR @appTypeOverride = 0
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Invalid arguments: AppType is not passed in input xml';
	GOTO ARGS_ERROR;
END
DECLARE @instanceId INT = 0
IF @appId IS NOT NULL
	SELECT @clientId = A.clientId, @instanceId = A.instance,  @backupsetId = A.backupset FROM APP_Application A WITH (NOLOCK) WHERE A.id = @appId;
ELSE IF @backupsetId IS NOT NULL
	SELECT @clientId = A.clientId, @appId = A.id, @instanceId = A.instance
	FROM APP_Application A WITH (NOLOCK) INNER JOIN APP_BackupSetName B ON A.backupSet = B.id
WHERE B.id = @backupsetId AND  (A.subclientStatus & 0x00008) != 0;
ELSE
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Invalid arguments: AppId or BackupSet Id should be passed in the input xml';
	GOTO ARGS_ERROR;
END
--
-- Get the IndexingAppType from input CvAppType
DECLARE @idxAppType int
BEGIN
	EXEC appgetindexingapptype @appTypeOverride, @appId, @idxAppType OUTPUT, @errorCode OUTPUT
	IF @errorCode IS NOT NULL AND @errorCode <> 0
	BEGIN
		SET @errorString = 'Failed to do IdxAppType conversion.';
		GOTO ARGS_ERROR;
	END
END
--
DECLARE @indexingV2AttrName nvarchar(512) = dbo.GetIndexingV2PropNameByAppType(@idxAppType);
DECLARE @enableV2ForNewClient int
--Add the AppTypes for which IndexingV2 (CAUTION) NEED NOT be enabled by default for new clients
SET @enableV2ForNewClient = IIF ((@idxAppType in (200103,22,80,106,81,135, 200107, 200108, 62, 103, 37, 125, 200111, 104, 200112, 61, 200114, 128, 200113, 38, 78, 200118, 3, 5, 200122, 200123, 53)),0,1);
DECLARE @indexingVersion int = 1;
IF @indexingV2AttrName = 'IndexingV1'
GOTO ARGS_ERROR;
DECLARE @releaseId int
DECLARE @specialClientFlag int
DECLARE @clientStatus int
select @clientStatus=status, @releaseId=releaseId, @specialClientFlag=specialClientFlags from app_client WITH (NOLOCK) where id=@clientId
-- if edge client
--or if the client has gmail or gdrive instance ( refered the instancetype from app.x CloudAppsInstanceType)
IF (@clientStatus & 0x10000000 > 0) or (select attrVal from app_instanceprop where componentnameid  in( select top 1 instance from app_application where clientid = @clientId) and attrName like 'Cloud Apps Instance Type') in (1,2)
BEGIN
	-- force V1
	SET @releaseId=0
	IF exists (SELECT 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE CP.attrName = @indexingV2AttrName AND CP.componentNameId = @clientId and cp.attrVal='1')
	BEGIN
		delete from APP_ClientProp where attrName = @indexingV2AttrName AND componentNameId = @clientId and attrVal='1'
	END
    INSERT INTO APP_ClientProp SELECT @clientId, @indexingV2AttrName, 2, IIF( ISNULL(@releaseId, 0) < 16, '0', '1'),
    	dbo.GetUnixTime(GETUTCDATE()), 0, 0 FROM app_client WHERE id=@clientId AND NOT EXISTS (SELECT 1 FROM APP_ClientProp CP WHERE CP.attrName = @indexingV2AttrName AND CP.componentNameId = @clientId)
END
IF  @idxAppType in (200103,22,
80,135,
3,  200122)
		AND @forceV2AfterUpgrade <> 0
BEGIN
	DECLARE @sweepEnabled int = 0
	-- If sweep has been enabled at any point of time and there are log backups to
	-- MA datapaths which have to be swept, therfore here check should be more of
	-- whether sweep is enabled at any point of time
	-- For Oracle it is instanceProperty and HANA it is backupset property
	IF EXISTS (SELECT 1 FROM App_InstanceProp with (NOLOCK)
  					where attrName = N'Dump Sweep Schedule' AND componentNameId = @instanceId and attrVal = '1'
				UNION
				SELECT 1 FROM App_BackupSetProp with (NOLOCK)
					where attrName = N'Dump Sweep Schedule' AND componentNameId = @backupsetId and attrVal = '1')
 		SET @sweepEnabled = 1
	IF @sweepEnabled  = 1
		SET @enableV2ForNewClient = 1
	ELSE
		--we will reset the forceUpgrade flag so that there are no side effects
		SET @forceV2AfterUpgrade = 0
END
ELSE
BEGIN
	--reset the flag so that it does not affect SQL or IDAs that do not use Indexing for archive offset
	SET @forceV2AfterUpgrade = 0
END
-- 11.0 or later
IF @releaseId>15
BEGIN
	-- verify that we have postponed V2 enabling
	DECLARE @indexingV2AttrName10 nvarchar(512)
	SET @indexingV2AttrName10 = @indexingV2AttrName + '_postponed'
	IF exists (SELECT 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE CP.attrName = @indexingV2AttrName10 AND CP.componentNameId = @clientId and cp.attrVal='1')
	BEGIN
		delete from APP_ClientProp where attrName = @indexingV2AttrName10 AND componentNameId = @clientId and attrVal='1'
		delete from APP_ClientProp where attrName = @indexingV2AttrName AND componentNameId = @clientId and attrVal='0'
		SET @forceV2AfterUpgrade=dbo.GetUnixTime(GETUTCDATE())
	END
END
IF @forceV2AfterUpgrade <> 0 OR
	NOT EXISTS (SELECT 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE CP.attrName = @indexingV2AttrName AND CP.componentNameId = @clientId)
BEGIN
	IF @forceV2AfterUpgrade=0
	BEGIN
		DECLARE @releaseId0 int
		DECLARE @releaseId1 int
		--if we have V2 backup then somebody deleted the property manually - it should be re-created, so skip the checks
		IF NOT exists (select 1 from archFile WITH (NOLOCK) where appId in (select id from app_application WITH (NOLOCK) where apptypeid =@appTypeOverride and clientId=@clientId) and filetype in (2,6) and name like 'IdxLogs_%')
		BEGIN
			--if there are only V1 backups for the client
			--    skip DR backups from the check
			IF exists (select 1 from archFile WITH (NOLOCK) where appId<>1 and appId in (select id from app_application WITH (NOLOCK) where apptypeid =@appTypeOverride and clientId=@clientId) and filetype in (2,6) and name in ('', 'N/A', 'Not Named'))
			BEGIN
				-- force V1
				SET @releaseId=0
			END
			ELSE
			BEGIN
				--is special client
				if @specialClientFlag=2
				BEGIN
					-- if exists at least one NAS sub-client then it is NAS client
					IF exists (select 1 from APP_Application WITH (NOLOCK) where clientId=@clientId and appTypeId=13)
					BEGIN
						select @releaseId0=min(ISNULL(dbo.GetNASProxyVersion(a.id,0), @releaseId)) from app_application a WITH (NOLOCK)
							where a.clientId=@clientId and dbo.GetNASProxyVersion(a.id,0)>0
						select @releaseId1=min(ISNULL(dbo.GetNASProxyVersion(a.id,1), @releaseId)) from app_application a WITH (NOLOCK)
							where a.clientId=@clientId and dbo.GetNASProxyVersion(a.id,1)>0
						SET @releaseId0=ISNULL(@releaseId0, @releaseId)
						SET @releaseId1=ISNULL(@releaseId1, @releaseId)
						IF @releaseId>@releaseId0
							SET @releaseId=@releaseId0
						IF @releaseId>@releaseId1
							SET @releaseId=@releaseId1
					END
				END
			END
		END
	END
	IF @forceV2AfterUpgrade<>0
	BEGIN
		--Indexing layer  only checks for attrName and does not check whether attrVal is 1. Also it does not check for modified value = 0. Hence making a change to modify attrName as attrName+'Upgraded'
		UPDATE APP_ClientProp SET attrName = attrName + '_upgraded', modified=(@forceV2AfterUpgrade - 2) WHERE attrName = @indexingV2AttrName AND componentNameId = @clientId and attrVal='0' and modified=0
	END
	ELSE
	BEGIN
		SET @forceV2AfterUpgrade = dbo.GetUnixTime(GETUTCDATE())
	END
	DECLARE @isUpgradeAllowed INT = 1
	-- we will set the indexingV2 createTime to jobStartTime -1
	SET @forceV2AfterUpgrade = @forceV2AfterUpgrade - 1
	IF @enableV2ForNewClient = 1
    BEGIN
        INSERT INTO APP_ClientProp SELECT @clientId, @indexingV2AttrName, 2, IIF( ISNULL(@releaseId, 0) < 16, '0', IIF(@isUpgradeAllowed = 1, '1', '0')),
		  @forceV2AfterUpgrade, 0, 0 FROM app_client WHERE id=@clientId AND NOT EXISTS (SELECT 1 FROM APP_ClientProp CP WHERE CP.attrName = @indexingV2AttrName AND CP.componentNameId = @clientId and modified=0)
		if @indexingV2AttrName = 'IndexingV2' AND ISNULL(@releaseId, 0) > 15
		BEGIN
			DECLARE @m_xmlText XML
			SET @m_xmlText =    (SELECT
									(SELECT @clientId AS '@clientId'
										FOR XML PATH('client'), TYPE)
								FOR XML PATH('App_UpgradeRetentionPropertiesReq'), TYPE )
			/*
			   APPGetBackupSetProperties SP was giving 2 outputs when following sp is executed. To solve this issue and to keep
			   remote execute framework intact, creating a temporary table and accessing it in AppUpgradeRetentionProperties SP.
			*/
			IF OBJECT_ID('tempdb.dbo.#tblAppUpgradeRetentionProperties') IS NOT NULL DROP TABLE dbo.#tblAppUpgradeRetentionProperties
			CREATE TABLE #tblAppUpgradeRetentionProperties(xmlText XML)
			exec dbo.AppUpgradeRetentionProperties @m_xmlText
			DROP TABLE #tblAppUpgradeRetentionProperties
		END
    END
    INSERT INTO APP_ClientProp SELECT @clientId, @indexingV2AttrName, 2, IIF( ISNULL(@releaseId, 0) < 16, '0', IIF(@enableV2ForNewClient = 1, IIF(@isUpgradeAllowed = 1, '1', '0'), '0')),
		@forceV2AfterUpgrade, 0, 0 FROM app_client WHERE id=@clientId AND NOT EXISTS (SELECT 1 FROM APP_ClientProp CP (NOLOCK)
		WHERE CP.attrName = @indexingV2AttrName AND CP.componentNameId = @clientId and modified=0)
END
DECLARE @v2PropcTime bigint = 0;
IF @releaseId>=16  OR @indexingV2AttrName = 'IndexingV2_VSA' --VM entities do not have a release id. We must look only into IndexingV2_VSA property
BEGIN
	SELECT top 1 @v2PropcTime = CP.created FROM APP_ClientProp CP WITH (NOLOCK)	WHERE CP.componentNameId=@clientId AND CP.attrName = @indexingV2AttrName AND CP.attrVal = '1' AND CP.modified = 0;
	IF @v2PropcTime <> 0
	BEGIN
		SET @indexingVersion = 2;
	END
END
DECLARE @wasLastJobV2 int = 0
IF @indexingVersion>1
BEGIN
	IF @appId IS NOT NULL
	BEGIN
		IF exists (select 1 from archFile WITH (NOLOCK) where appId=@appId and filetype in (2,6) and name like 'IdxLogs_%' and isValid=1)
		BEGIN
			SET @wasLastJobV2 = 1
		END
	END
	ELSE
	BEGIN
		IF exists (select 1 from archFile WITH (NOLOCK) where appId in (select id from app_application WITH (NOLOCK) where clientId=@clientId) and filetype in (2,6) and name like 'IdxLogs_%' and isValid=1)
		BEGIN
			SET @wasLastJobV2 = 1
		END
	END
END
--
ARGS_ERROR:
SET @o_xmlText =
	(SELECT @indexingVersion AS '@indexingVersionId',
		@errorCode AS '@errorCode',
		@errorString AS '@errorString',
		@wasLastJobV2 AS '@wasLastJobV2',
		@v2PropcTime AS '@v2PropcTime',
		@idxAppType AS '@idxAppType'
	FOR XML PATH('Indexing_GetIndexingVersionResp'), TYPE);
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexingVersionForThisClient')
	delete from GxQscripts where name = 'AppGetIndexingVersionForThisClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexingVersionForThisClient')
	delete from GXDBVersions where aliasname = 'AppGetIndexingVersionForThisClient'
GO

insert into GXDBVersions values(2, 'AppGetIndexingVersionForThisClient',  '00010001000200440000', 'AppGetIndexingVersionForThisClient', '00010001000200440000')
GO

