

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexingV2BackupSets.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexingV2BackupSets.sp,v $ $Id: AppGetIndexingV2BackupSets.sp,v 1.2 2015/06/08 09:01:17 jsanghvi Exp $";
-- =========================================================
-- Author: Ganesh Kumar Subramanian
-- Description: Get the backup sets containing indexing v2 backup jobs
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetIndexingV2BackupSets <<<'

IF EXISTS (select * from sysobjects where name='AppGetIndexingV2BackupSets')
	drop procedure AppGetIndexingV2BackupSets
IF EXISTS (select * from GxQscripts where name='AppGetIndexingV2BackupSets')
	delete from GxQscripts where name = 'AppGetIndexingV2BackupSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexingV2BackupSets')
	delete from GXDBVersions where aliasname = 'AppGetIndexingV2BackupSets'
GO
print '... Creating Procedure: AppGetIndexingV2BackupSets'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIndexingV2BackupSets
  @xmlText XML
AS
--
SET NOCOUNT ON;
--
BEGIN TRY
	--
	DECLARE @tempResultSet TABLE (backupSet int, applicationId int, clientId int, commCellId int);
	DECLARE @indexingV2AttrName nvarchar(32) = 'IndexingV2';
	--
	DECLARE @inputJobId int = (SELECT TOP(1) @xmlText.value('(/Indexing_GetIndexingV2BackupSetsReq/@jobId)[1]', 'int'));
	DECLARE @inputClientId int = (SELECT TOP(1) @xmlText.value('(/Indexing_GetIndexingV2BackupSetsReq/@clientId)[1]', 'int'));
	--
	IF @inputJobId IS NOT NULL
	BEGIN
		INSERT INTO @tempResultSet
		SELECT DISTINCT A.backupSet AS '@backupSet', A.appTypeId AS '@applicationId', A.clientId AS '@clientId', J.commCellId AS '@commCellId'
		FROM JMBkpStats J WITH (NOLOCK)
		INNER JOIN APP_Application A WITH (NOLOCK) ON J.appId = A.id
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON A.clientId = CP.componentNameId
		WHERE CP.attrName = @indexingV2AttrName AND CP.attrVal = '1' -- indexing-v2 should be enabled on the backup client
		AND J.servStartDate >= CP.created AND J.jobId = @inputJobId; -- job should have started after enabling indexing-v2 client property
	END
	--
	ELSE IF @inputClientId IS NOT NULL
	BEGIN
		INSERT INTO @tempResultSet
		SELECT DISTINCT A.backupSet AS '@backupSet', A.appTypeId AS '@applicationId', A.clientId AS '@clientId', AF.commCellId AS '@commCellId'
		FROM APP_Application A WITH (NOLOCK)
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON A.clientId = CP.componentNameId
		INNER JOIN archFile AF WITH (NOLOCK) ON A.id = AF.appId
		WHERE CP.attrName = @indexingV2AttrName AND CP.attrVal = '1' -- indexing-v2 should be enabled on the backup client
		AND (AF.fileType = 1 OR (AF.fileType IN (2, 6) AND AF.name <> 'Not named')) AND AF.cTime >= CP.created -- data/log archive created after enabling indexing-v2 client property
		AND A.clientId = @inputClientId;
	END
	--
	ELSE
		RAISERROR('Error fetching the client/job information.', 16, 1);
	--
	-- return the xml response
	IF NOT EXISTS (SELECT 1 FROM @tempResultSet)
	BEGIN
		DECLARE @isIndexingV2 int = 0;
		-- if result set is empty and client-id was passed, still set isIndexingV2 to 1 if
		-- no backup jobs ran on the client before setting indexing-v2 client property
		IF @inputClientId IS NOT NULL
			AND NOT EXISTS (SELECT 1 FROM archFile AF WITH (NOLOCK)
				INNER JOIN APP_Application A WITH (NOLOCK) ON A.id = AF.appId
				INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = A.clientId
				WHERE CP.attrName = @indexingV2AttrName AND CP.attrVal = '1'
				AND AF.fileType IN (1, 2, 6)  AND AF.cTime < CP.created
				AND A.clientId = @inputClientId)
		BEGIN
			SET @isIndexingV2 = 1;
		END
		SET @xmlText = (SELECT @isIndexingV2 AS '@isIndexingV2' FOR XML PATH ('GetIndexingV2BackupSetsResp'),TYPE);
	END
	ELSE
	SET @xmlText = (
		SELECT (SELECT TOP(1) TR.clientId from @tempResultSet TR) AS '@clientId',
		1 AS '@isIndexingV2', (
			SELECT TR.backupSet AS '@backupsetId', TR.applicationId AS '@applicationId', TR.commCellId AS '@commCellId'
			FROM @tempResultSet TR
			FOR	XML PATH ('backupSet'), TYPE)
		FOR XML PATH ('GetIndexingV2BackupSetsResp'), TYPE);
	--
	SELECT @xmlText;
--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
		
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
;
	--
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
	SELECT @xmlText;
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexingV2BackupSets')
	delete from GxQscripts where name = 'AppGetIndexingV2BackupSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexingV2BackupSets')
	delete from GXDBVersions where aliasname = 'AppGetIndexingV2BackupSets'
GO

insert into GXDBVersions values(2, 'AppGetIndexingV2BackupSets',  '00010002000000000000', 'AppGetIndexingV2BackupSets', '00010002000000000000')
GO

