

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexingAppType.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2014  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexingAppType.sp,v $ $Id: AppGetIndexingAppType.sp,v 1.1.2.29 2020/12/02 16:49:39 bsenthilkumar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetIndexingAppType')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexingAppType <<<'
	drop procedure AppGetIndexingAppType
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexingAppType')
	delete from GxQscripts where name = 'AppGetIndexingAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexingAppType')
	delete from GXDBVersions where aliasname = 'AppGetIndexingAppType'
GO
print '... Creating Procedure: AppGetIndexingAppType'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetIndexingAppType
  @appType INT,
  @appId INT,
  @idxAppType INT OUTPUT,
  @errorCode INT OUTPUT
AS
SET NOCOUNT ON;
SET @errorCode  = 0;
IF @appType IS NULL OR @appId IS NULL
BEGIN
	SET @errorCode = 1;
	RETURN
END
--NOTE:
--Do Not Create New IdxAppType for already existing(released to customer) Idas.
-- by default CvAppType and Indexing AppType is same.
SET @idxAppType =  @appType
IF  @appType = 134 -- CV_APPTYPE_CLOUD_APPS_
BEGIN
	SELECT @idxAppType = CASE I.attrVal
WHEN 3  THEN 200101 -- IDX_APPTYPE_SALESFORCE_
WHEN 5  THEN 200104 -- IDX_APPTYPE_AZURE
WHEN 6  THEN 200105 -- IDX_APPTYPE_S3
WHEN 7 THEN 200118 --OneDrive APP
WHEN 8  THEN 200115 --CLOUD PAAS APP (ORACLE DB)
WHEN 9  THEN 200115 --CLOUD PAAS APP (ORACLE JAVA)
WHEN 10 THEN 200115 --CLOUD PAAS APP (ORACLE MySQL)
WHEN 14 THEN 200109 -- IDX_APPTYPE_ORACLE_STORAGE_SERVICE
WHEN 15 THEN 200110 -- IDX_APPTYPE_OPEN_STACK
WHEN 19 THEN 200115 --CLOUD PAAS APP (ORACLE CLOUD INFRA DB)
WHEN 20 THEN 200116 --GOOGLE CLOUD APP
WHEN 21 THEN 200117 --AZURE DATA LAKE APP
WHEN 22	THEN 200121 --AMAZON DYNAMO DB
WHEN 23	THEN 200129 --AZURE COSMOS DB SQL
WHEN 24 THEN 200119 --IBM_COS
WHEN 25 THEN 200120 --ALIBABA_OSS
WHEN 32	THEN 200124 --AZURE TABLE STORAGE
WHEN 33 THEN 200125 --GitHub
WHEN 34 THEN 200130 --Azure DevOps
WHEN 35	THEN 200127 --DYNAMIC 365
WHEN 36	THEN 200128 --TEAMS
WHEN 37 THEN 200131 --GCP Spanner
		ELSE @appType END
	FROM APP_InstanceProp I WITH (NOLOCK) INNER JOIN APP_Application A WITH (NOLOCK) ON I.componentNameId = A.Instance
	WHERE A.id = @appId AND attrName like 'Cloud Apps Instance Type' AND I.modified = 0;
END
ELSE IF @appType = 64 -- CV_APPTYPE_SGI_FS_ Distributed AppTypes
BEGIN
	SELECT @idxAppType = CASE
WHEN I.attrVal=5 THEN 200102 --IDX_APPTYPE_DFS_WIN_
WHEN I.attrVal=6 AND OS.Type = 'Windows' THEN 200106 --IDX_APPTYPE_DFS_SOLR
WHEN I.attrVal=6 AND OS.Type = 'Unix' THEN 200126 --IDX_APPTYPE_DFS_SOLR_UNIX
		ELSE @appType END --if not windows platform use the default apptype
	FROM APP_InstanceProp I WITH (NOLOCK)
	JOIN APP_Application A WITH (NOLOCK) ON I.componentNameId = A.instance
	JOIN APP_Client C WITH (NOLOCK) ON A.ClientId = C.id
	JOIN simOperatingSystem OS WITH (NOLOCK) ON OS.id = C.simOperatingSystemId
	WHERE A.id = @appId AND I.attrName = 'Distributed Cluster Type' AND I.modified = 0;
END
ELSE IF @appType = 22
BEGIN
	SELECT @idxAppType = CASE OS.Type
WHEN 'Windows' THEN 200103 --IDX_APPTYPE_ORACLE_WIN_
		ELSE @appType --For UNIX use the default apptype
		END
	FROM simOperatingSystem OS WITH (NOLOCK)
	INNER JOIN APP_Client C WITH (NOLOCK) ON OS.id = C.simOperatingSystemId
	INNER JOIN APP_Application A WITH (NOLOCK) ON C.id = A.clientId AND A.id = @appId;
END
ELSE IF @appType = 80
BEGIN
	SELECT @idxAppType = CASE OS.Type
WHEN 'Windows' THEN 200103 --IDX_APPTYPE_ORACLE_WIN_
		ELSE @appType --For UNIX use the default apptype
		END
	FROM simOperatingSystem OS WITH (NOLOCK)
	INNER JOIN APP_Client C WITH (NOLOCK) ON OS.id = C.simOperatingSystemId
	INNER JOIN APP_OracleRacInstance RI WITH (NOLOCK) ON C.id = RI.clientId
	INNER JOIN APP_Application A WITH (NOLOCK) ON RI.instaceId = A.instance AND A.id = @appId
END
ELSE IF @appType = 106
BEGIN
	IF EXISTS(select TOP 1 vmbset.ParentBackupSetId from app_application appl WITH (NOLOCK) INNER JOIN APP_VMBackupSet vmbset WITH (NOLOCK)
		ON appl.id = @appId AND appl.backupset = vmbset.ParentBackupSetId)
	BEGIN
SELECT @idxAppType = 200107
	END
	ELSE
	BEGIN
SELECT @idxAppType = 200108
	END
END
ELSE IF @appType = 125
BEGIN
	SELECT @idxAppType = CASE OS.Type
WHEN 'Windows' THEN 200111 --IDX_APPTYPE_POSTGRESS_WIN
		ELSE @appType --For UNIX use the default apptype
		END
	FROM simOperatingSystem OS WITH (NOLOCK)
	INNER JOIN APP_Client C WITH (NOLOCK) ON OS.id = C.simOperatingSystemId
	INNER JOIN APP_Application A WITH (NOLOCK) ON A.clientId = C.id AND A.id = @appId
END
ELSE IF @appType = 104
BEGIN
	SELECT @idxAppType = CASE OS.Type
WHEN 'Windows' THEN 200112 --IDX_APPTYPE_MYSQL_WIN
		ELSE @appType --For UNIX use the default apptype
		END
	FROM simOperatingSystem OS WITH (NOLOCK)
	INNER JOIN APP_Client C WITH (NOLOCK) ON OS.id = C.simOperatingSystemId
	INNER JOIN APP_Application A WITH (NOLOCK) ON A.clientId = C.id AND A.id = @appId
END
ELSE IF @appType = 128
BEGIN
	SELECT @idxAppType = CASE OS.Type
WHEN 'Windows' THEN 200113 --IDX_APPTYPE_DOCUMENTUM_WIN
		ELSE @appType --For UNIX use the default apptype
		END
	FROM simOperatingSystem OS WITH (NOLOCK)
	INNER JOIN APP_Client C WITH (NOLOCK) ON OS.id = C.simOperatingSystemId
	INNER JOIN APP_Application A WITH (NOLOCK) ON A.clientId = C.id AND A.id = @appId
END
ELSE IF @appType = 61
BEGIN
	SELECT @idxAppType = CASE OS.Type
WHEN 'Windows' THEN 200114 --IDX_APPTYPE_SAP_FOR_ORACLE_WIN
		ELSE @appType --For UNIX use the default apptype
		END
	FROM simOperatingSystem OS WITH (NOLOCK)
	INNER JOIN APP_Client C WITH (NOLOCK) ON OS.id = C.simOperatingSystemId
	INNER JOIN APP_Application A WITH (NOLOCK) ON A.clientId = C.id AND A.id = @appId
END
ELSE IF @appType = 3
BEGIN
	SELECT @idxAppType = CASE OS.Type
WHEN 'Windows' THEN 200122 --IDX_APPTYPE_INFORMIX_WIN
		ELSE @appType --For UNIX use the default apptype
		END
	FROM simOperatingSystem OS WITH (NOLOCK)
	INNER JOIN APP_Client C WITH (NOLOCK) ON OS.id = C.simOperatingSystemId
	INNER JOIN APP_Application A WITH (NOLOCK) ON C.id = A.clientId AND A.id = @appId;
END
ELSE IF @appType = 5
BEGIN
	SELECT @idxAppType = CASE OS.Type
WHEN 'Windows' THEN 200123 --IDX_APPTYPE_SYBASE_WIN
		ELSE @appType --For UNIX use the default apptype
		END
	FROM simOperatingSystem OS WITH (NOLOCK)
	INNER JOIN APP_Client C WITH (NOLOCK) ON OS.id = C.simOperatingSystemId
	INNER JOIN APP_Application A WITH (NOLOCK) ON C.id = A.clientId AND A.id = @appId;
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexingAppType')
	delete from GxQscripts where name = 'AppGetIndexingAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexingAppType')
	delete from GXDBVersions where aliasname = 'AppGetIndexingAppType'
GO

insert into GXDBVersions values(2, 'AppGetIndexingAppType',  '00010001000200290000', 'AppGetIndexingAppType', '00010001000200290000')
GO

